package io.strimzi.api.kafka.model;

import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.strimzi.api.kafka.model.status.KafkaConnectorStatusFluentImpl;
import io.strimzi.api.kafka.model.status.KafkaConnectorStatusBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.strimzi.api.kafka.model.status.KafkaConnectorStatus;
import java.lang.StringBuffer;
import java.lang.Object;

public class KafkaConnectorFluentImpl<A extends KafkaConnectorFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaConnectorFluent<A>{

    private KafkaConnectorSpecBuilder spec;
    private KafkaConnectorStatusBuilder status;
    private ObjectMetaBuilder metadata;
    private String apiVersion;

    public KafkaConnectorFluentImpl(){
    }
    public KafkaConnectorFluentImpl(KafkaConnector instance){
            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.withMetadata(instance.getMetadata());

            this.withApiVersion(instance.getApiVersion());

    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public KafkaConnectorSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public KafkaConnectorSpec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(KafkaConnectorSpec spec){
            _visitables.get("spec").remove(this.spec);
            if (spec!=null){ this.spec= new KafkaConnectorSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public KafkaConnectorFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public KafkaConnectorFluent.SpecNested<A> withNewSpecLike(KafkaConnectorSpec item){
            return new SpecNestedImpl(item);
    }

    public KafkaConnectorFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public KafkaConnectorFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new KafkaConnectorSpecBuilder().build());
    }

    public KafkaConnectorFluent.SpecNested<A> editOrNewSpecLike(KafkaConnectorSpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public KafkaConnectorStatus getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public KafkaConnectorStatus buildStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(KafkaConnectorStatus status){
            _visitables.get("status").remove(this.status);
            if (status!=null){ this.status= new KafkaConnectorStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public KafkaConnectorFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public KafkaConnectorFluent.StatusNested<A> withNewStatusLike(KafkaConnectorStatus item){
            return new StatusNestedImpl(item);
    }

    public KafkaConnectorFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public KafkaConnectorFluent.StatusNested<A> editOrNewStatus(){
            return withNewStatusLike(getStatus() != null ? getStatus(): new KafkaConnectorStatusBuilder().build());
    }

    public KafkaConnectorFluent.StatusNested<A> editOrNewStatusLike(KafkaConnectorStatus item){
            return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.get("metadata").remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public KafkaConnectorFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public KafkaConnectorFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public KafkaConnectorFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public KafkaConnectorFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public KafkaConnectorFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            KafkaConnectorFluentImpl that = (KafkaConnectorFluentImpl) o;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            return true;
    }


    public class SpecNestedImpl<N> extends KafkaConnectorSpecFluentImpl<KafkaConnectorFluent.SpecNested<N>> implements KafkaConnectorFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaConnectorSpecBuilder builder;
    
            SpecNestedImpl(KafkaConnectorSpec item){
                    this.builder = new KafkaConnectorSpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new KafkaConnectorSpecBuilder(this);
            }
    
    public N and(){
            return (N) KafkaConnectorFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}
    public class StatusNestedImpl<N> extends KafkaConnectorStatusFluentImpl<KafkaConnectorFluent.StatusNested<N>> implements KafkaConnectorFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaConnectorStatusBuilder builder;
    
            StatusNestedImpl(KafkaConnectorStatus item){
                    this.builder = new KafkaConnectorStatusBuilder(this, item);
            }
            StatusNestedImpl(){
                    this.builder = new KafkaConnectorStatusBuilder(this);
            }
    
    public N and(){
            return (N) KafkaConnectorFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<KafkaConnectorFluent.MetadataNested<N>> implements KafkaConnectorFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) KafkaConnectorFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
