package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.util.List;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.connect.ExternalConfigurationFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent;
import io.strimzi.api.kafka.model.connect.ExternalConfigurationBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication;
import io.strimzi.api.kafka.model.tracing.JaegerTracingFluent;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import java.lang.Object;
import io.strimzi.api.kafka.model.tracing.Tracing;
import java.util.Map;
import io.strimzi.api.kafka.model.template.KafkaConnectTemplateBuilder;
import io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.template.KafkaConnectTemplate;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512;
import io.strimzi.api.kafka.model.tracing.JaegerTracing;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent;
import io.strimzi.api.kafka.model.connect.ExternalConfiguration;

public interface KafkaConnectSpecFluent<A extends KafkaConnectSpecFluent<A>> extends Fluent<A>{


    public A addToConfig(String key,Object value);
    public A addToConfig(Map<String,Object> map);
    public A removeFromConfig(String key);
    public A removeFromConfig(Map<String,Object> map);
    public Map<String,Object> getConfig();
    public A withConfig(Map<String,Object> config);
    public Boolean hasConfig();
    
/**
 * This method has been deprecated, please use method buildLogging instead.
 * @return The buildable object.
 */
@Deprecated public Logging getLogging();
    public Logging buildLogging();
    public A withLogging(Logging logging);
    public Boolean hasLogging();
    public A withExternalLogging(ExternalLogging externalLogging);
    public KafkaConnectSpecFluent.ExternalLoggingNested<A> withNewExternalLogging();
    public KafkaConnectSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item);
    public A withInlineLogging(InlineLogging inlineLogging);
    public KafkaConnectSpecFluent.InlineLoggingNested<A> withNewInlineLogging();
    public KafkaConnectSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item);
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Boolean hasReplicas();
    public String getVersion();
    public A withVersion(String version);
    public Boolean hasVersion();
    public A withNewVersion(String arg1);
    public A withNewVersion(StringBuilder arg1);
    public A withNewVersion(StringBuffer arg1);
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(String arg1);
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(StringBuffer arg1);
    public ResourceRequirements getResources();
    public A withResources(ResourceRequirements resources);
    public Boolean hasResources();
    
/**
 * This method has been deprecated, please use method buildLivenessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getLivenessProbe();
    public Probe buildLivenessProbe();
    public A withLivenessProbe(Probe livenessProbe);
    public Boolean hasLivenessProbe();
    public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds);
    public KafkaConnectSpecFluent.LivenessProbeNested<A> withNewLivenessProbe();
    public KafkaConnectSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item);
    public KafkaConnectSpecFluent.LivenessProbeNested<A> editLivenessProbe();
    public KafkaConnectSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe();
    public KafkaConnectSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item);
    
/**
 * This method has been deprecated, please use method buildReadinessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getReadinessProbe();
    public Probe buildReadinessProbe();
    public A withReadinessProbe(Probe readinessProbe);
    public Boolean hasReadinessProbe();
    public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds);
    public KafkaConnectSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe();
    public KafkaConnectSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item);
    public KafkaConnectSpecFluent.ReadinessProbeNested<A> editReadinessProbe();
    public KafkaConnectSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe();
    public KafkaConnectSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item);
    
/**
 * This method has been deprecated, please use method buildJvmOptions instead.
 * @return The buildable object.
 */
@Deprecated public JvmOptions getJvmOptions();
    public JvmOptions buildJvmOptions();
    public A withJvmOptions(JvmOptions jvmOptions);
    public Boolean hasJvmOptions();
    public KafkaConnectSpecFluent.JvmOptionsNested<A> withNewJvmOptions();
    public KafkaConnectSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item);
    public KafkaConnectSpecFluent.JvmOptionsNested<A> editJvmOptions();
    public KafkaConnectSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions();
    public KafkaConnectSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item);
    public A addToMetrics(String key,Object value);
    public A addToMetrics(Map<String,Object> map);
    public A removeFromMetrics(String key);
    public A removeFromMetrics(Map<String,Object> map);
    public Map<String,Object> getMetrics();
    public A withMetrics(Map<String,Object> metrics);
    public Boolean hasMetrics();
    
/**
 * This method has been deprecated, please use method buildTracing instead.
 * @return The buildable object.
 */
@Deprecated public Tracing getTracing();
    public Tracing buildTracing();
    public A withTracing(Tracing tracing);
    public Boolean hasTracing();
    public A withJaegerTracing(JaegerTracing jaegerTracing);
    public KafkaConnectSpecFluent.JaegerTracingNested<A> withNewJaegerTracing();
    public KafkaConnectSpecFluent.JaegerTracingNested<A> withNewJaegerTracingLike(JaegerTracing item);
    public Affinity getAffinity();
    public A withAffinity(Affinity affinity);
    public Boolean hasAffinity();
    public A addToTolerations(int index,Toleration item);
    public A setToTolerations(int index,Toleration item);
    public A addToTolerations(Toleration... items);
    public A addAllToTolerations(Collection<Toleration> items);
    public A removeFromTolerations(Toleration... items);
    public A removeAllFromTolerations(Collection<Toleration> items);
    public List<Toleration> getTolerations();
    public Toleration getToleration(int index);
    public Toleration getFirstToleration();
    public Toleration getLastToleration();
    public Toleration getMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate);
    public Boolean hasMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate);
    public A withTolerations(List<Toleration> tolerations);
    public A withTolerations(Toleration... tolerations);
    public Boolean hasTolerations();
    public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value);
    public String getBootstrapServers();
    public A withBootstrapServers(String bootstrapServers);
    public Boolean hasBootstrapServers();
    public A withNewBootstrapServers(String arg1);
    public A withNewBootstrapServers(StringBuilder arg1);
    public A withNewBootstrapServers(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildTls instead.
 * @return The buildable object.
 */
@Deprecated public KafkaConnectTls getTls();
    public KafkaConnectTls buildTls();
    public A withTls(KafkaConnectTls tls);
    public Boolean hasTls();
    public KafkaConnectSpecFluent.TlsNested<A> withNewTls();
    public KafkaConnectSpecFluent.TlsNested<A> withNewTlsLike(KafkaConnectTls item);
    public KafkaConnectSpecFluent.TlsNested<A> editTls();
    public KafkaConnectSpecFluent.TlsNested<A> editOrNewTls();
    public KafkaConnectSpecFluent.TlsNested<A> editOrNewTlsLike(KafkaConnectTls item);
    
/**
 * This method has been deprecated, please use method buildAuthentication instead.
 * @return The buildable object.
 */
@Deprecated public KafkaClientAuthentication getAuthentication();
    public KafkaClientAuthentication buildAuthentication();
    public A withAuthentication(KafkaClientAuthentication authentication);
    public Boolean hasAuthentication();
    public A withKafkaClientAuthenticationScramSha512(KafkaClientAuthenticationScramSha512 kafkaClientAuthenticationScramSha512);
    public KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512();
    public KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512Like(KafkaClientAuthenticationScramSha512 item);
    public A withKafkaClientAuthenticationPlain(KafkaClientAuthenticationPlain kafkaClientAuthenticationPlain);
    public KafkaConnectSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlain();
    public KafkaConnectSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlainLike(KafkaClientAuthenticationPlain item);
    public A withKafkaClientAuthenticationOAuth(KafkaClientAuthenticationOAuth kafkaClientAuthenticationOAuth);
    public KafkaConnectSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuth();
    public KafkaConnectSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuthLike(KafkaClientAuthenticationOAuth item);
    public A withKafkaClientAuthenticationTls(KafkaClientAuthenticationTls kafkaClientAuthenticationTls);
    public KafkaConnectSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTls();
    public KafkaConnectSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTlsLike(KafkaClientAuthenticationTls item);
    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public KafkaConnectTemplate getTemplate();
    public KafkaConnectTemplate buildTemplate();
    public A withTemplate(KafkaConnectTemplate template);
    public Boolean hasTemplate();
    public KafkaConnectSpecFluent.TemplateNested<A> withNewTemplate();
    public KafkaConnectSpecFluent.TemplateNested<A> withNewTemplateLike(KafkaConnectTemplate item);
    public KafkaConnectSpecFluent.TemplateNested<A> editTemplate();
    public KafkaConnectSpecFluent.TemplateNested<A> editOrNewTemplate();
    public KafkaConnectSpecFluent.TemplateNested<A> editOrNewTemplateLike(KafkaConnectTemplate item);
    
/**
 * This method has been deprecated, please use method buildExternalConfiguration instead.
 * @return The buildable object.
 */
@Deprecated public ExternalConfiguration getExternalConfiguration();
    public ExternalConfiguration buildExternalConfiguration();
    public A withExternalConfiguration(ExternalConfiguration externalConfiguration);
    public Boolean hasExternalConfiguration();
    public KafkaConnectSpecFluent.ExternalConfigurationNested<A> withNewExternalConfiguration();
    public KafkaConnectSpecFluent.ExternalConfigurationNested<A> withNewExternalConfigurationLike(ExternalConfiguration item);
    public KafkaConnectSpecFluent.ExternalConfigurationNested<A> editExternalConfiguration();
    public KafkaConnectSpecFluent.ExternalConfigurationNested<A> editOrNewExternalConfiguration();
    public KafkaConnectSpecFluent.ExternalConfigurationNested<A> editOrNewExternalConfigurationLike(ExternalConfiguration item);

    public interface ExternalLoggingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ExternalLoggingFluent<KafkaConnectSpecFluent.ExternalLoggingNested<N>>{

        
    public N and();    public N endExternalLogging();
}
    public interface InlineLoggingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,InlineLoggingFluent<KafkaConnectSpecFluent.InlineLoggingNested<N>>{

        
    public N and();    public N endInlineLogging();
}
    public interface LivenessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProbeFluent<KafkaConnectSpecFluent.LivenessProbeNested<N>>{

        
    public N and();    public N endLivenessProbe();
}
    public interface ReadinessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProbeFluent<KafkaConnectSpecFluent.ReadinessProbeNested<N>>{

        
    public N and();    public N endReadinessProbe();
}
    public interface JvmOptionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,JvmOptionsFluent<KafkaConnectSpecFluent.JvmOptionsNested<N>>{

        
    public N and();    public N endJvmOptions();
}
    public interface JaegerTracingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,JaegerTracingFluent<KafkaConnectSpecFluent.JaegerTracingNested<N>>{

        
    public N and();    public N endJaegerTracing();
}
    public interface TlsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaConnectTlsFluent<KafkaConnectSpecFluent.TlsNested<N>>{

        
    public N and();    public N endTls();
}
    public interface KafkaClientAuthenticationScramSha512Nested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaClientAuthenticationScramSha512Fluent<KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>>{

        
    public N and();    public N endKafkaClientAuthenticationScramSha512();
}
    public interface KafkaClientAuthenticationPlainNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaClientAuthenticationPlainFluent<KafkaConnectSpecFluent.KafkaClientAuthenticationPlainNested<N>>{

        
    public N and();    public N endKafkaClientAuthenticationPlain();
}
    public interface KafkaClientAuthenticationOAuthNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaClientAuthenticationOAuthFluent<KafkaConnectSpecFluent.KafkaClientAuthenticationOAuthNested<N>>{

        
    public N and();    public N endKafkaClientAuthenticationOAuth();
}
    public interface KafkaClientAuthenticationTlsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaClientAuthenticationTlsFluent<KafkaConnectSpecFluent.KafkaClientAuthenticationTlsNested<N>>{

        
    public N and();    public N endKafkaClientAuthenticationTls();
}
    public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaConnectTemplateFluent<KafkaConnectSpecFluent.TemplateNested<N>>{

        
    public N and();    public N endTemplate();
}
    public interface ExternalConfigurationNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ExternalConfigurationFluent<KafkaConnectSpecFluent.ExternalConfigurationNested<N>>{

        
    public N and();    public N endExternalConfiguration();
}


}
