package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaConnectSpecBuilder extends KafkaConnectSpecFluentImpl<KafkaConnectSpecBuilder> implements VisitableBuilder<KafkaConnectSpec,KafkaConnectSpecBuilder>{

    KafkaConnectSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaConnectSpecBuilder(){
            this(true);
    }
    public KafkaConnectSpecBuilder(Boolean validationEnabled){
            this(new KafkaConnectSpec(), validationEnabled);
    }
    public KafkaConnectSpecBuilder(KafkaConnectSpecFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaConnectSpecBuilder(KafkaConnectSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaConnectSpec(), validationEnabled);
    }
    public KafkaConnectSpecBuilder(KafkaConnectSpecFluent<?> fluent,KafkaConnectSpec instance){
            this(fluent, instance, true);
    }
    public KafkaConnectSpecBuilder(KafkaConnectSpecFluent<?> fluent,KafkaConnectSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConfig(instance.getConfig());

            fluent.withLogging(instance.getLogging());

            fluent.withReplicas(instance.getReplicas());

            fluent.withVersion(instance.getVersion());

            fluent.withImage(instance.getImage());

            fluent.withResources(instance.getResources());

            fluent.withLivenessProbe(instance.getLivenessProbe());

            fluent.withReadinessProbe(instance.getReadinessProbe());

            fluent.withJvmOptions(instance.getJvmOptions());

            fluent.withMetrics(instance.getMetrics());

            fluent.withTracing(instance.getTracing());

            fluent.withAffinity(instance.getAffinity());

            fluent.withTolerations(instance.getTolerations());

            fluent.withBootstrapServers(instance.getBootstrapServers());

            fluent.withTls(instance.getTls());

            fluent.withAuthentication(instance.getAuthentication());

            fluent.withTemplate(instance.getTemplate());

            fluent.withExternalConfiguration(instance.getExternalConfiguration());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaConnectSpecBuilder(KafkaConnectSpec instance){
            this(instance,true);
    }
    public KafkaConnectSpecBuilder(KafkaConnectSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConfig(instance.getConfig());

            this.withLogging(instance.getLogging());

            this.withReplicas(instance.getReplicas());

            this.withVersion(instance.getVersion());

            this.withImage(instance.getImage());

            this.withResources(instance.getResources());

            this.withLivenessProbe(instance.getLivenessProbe());

            this.withReadinessProbe(instance.getReadinessProbe());

            this.withJvmOptions(instance.getJvmOptions());

            this.withMetrics(instance.getMetrics());

            this.withTracing(instance.getTracing());

            this.withAffinity(instance.getAffinity());

            this.withTolerations(instance.getTolerations());

            this.withBootstrapServers(instance.getBootstrapServers());

            this.withTls(instance.getTls());

            this.withAuthentication(instance.getAuthentication());

            this.withTemplate(instance.getTemplate());

            this.withExternalConfiguration(instance.getExternalConfiguration());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaConnectSpec build(){
            KafkaConnectSpec buildable = new KafkaConnectSpec();
            buildable.setConfig(fluent.getConfig());
            buildable.setLogging(fluent.getLogging());
            buildable.setReplicas(fluent.getReplicas());
            buildable.setVersion(fluent.getVersion());
            buildable.setImage(fluent.getImage());
            buildable.setResources(fluent.getResources());
            buildable.setLivenessProbe(fluent.getLivenessProbe());
            buildable.setReadinessProbe(fluent.getReadinessProbe());
            buildable.setJvmOptions(fluent.getJvmOptions());
            buildable.setMetrics(fluent.getMetrics());
            buildable.setTracing(fluent.getTracing());
            buildable.setAffinity(fluent.getAffinity());
            buildable.setTolerations(fluent.getTolerations());
            buildable.setBootstrapServers(fluent.getBootstrapServers());
            buildable.setTls(fluent.getTls());
            buildable.setAuthentication(fluent.getAuthentication());
            buildable.setTemplate(fluent.getTemplate());
            buildable.setExternalConfiguration(fluent.getExternalConfiguration());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaConnectSpecBuilder that = (KafkaConnectSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
