package io.strimzi.api.kafka.model;

import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.strimzi.api.kafka.model.status.KafkaConnectS2IstatusBuilder;
import io.strimzi.api.kafka.model.status.KafkaConnectS2IstatusFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.strimzi.api.kafka.model.status.KafkaConnectS2Istatus;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Object;

public class KafkaConnectS2IFluentImpl<A extends KafkaConnectS2IFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaConnectS2IFluent<A>{

    private String apiVersion;
    private ObjectMetaBuilder metadata;
    private KafkaConnectS2ISpecBuilder spec;
    private KafkaConnectS2IstatusBuilder status;

    public KafkaConnectS2IFluentImpl(){
    }
    public KafkaConnectS2IFluentImpl(KafkaConnectS2I instance){
            this.withApiVersion(instance.getApiVersion());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.get("metadata").remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public KafkaConnectS2IFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public KafkaConnectS2IFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public KafkaConnectS2IFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public KafkaConnectS2IFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public KafkaConnectS2IFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public KafkaConnectS2ISpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public KafkaConnectS2ISpec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(KafkaConnectS2ISpec spec){
            _visitables.get("spec").remove(this.spec);
            if (spec!=null){ this.spec= new KafkaConnectS2ISpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public KafkaConnectS2IFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public KafkaConnectS2IFluent.SpecNested<A> withNewSpecLike(KafkaConnectS2ISpec item){
            return new SpecNestedImpl(item);
    }

    public KafkaConnectS2IFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public KafkaConnectS2IFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new KafkaConnectS2ISpecBuilder().build());
    }

    public KafkaConnectS2IFluent.SpecNested<A> editOrNewSpecLike(KafkaConnectS2ISpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public KafkaConnectS2Istatus getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public KafkaConnectS2Istatus buildStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(KafkaConnectS2Istatus status){
            _visitables.get("status").remove(this.status);
            if (status!=null){ this.status= new KafkaConnectS2IstatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public KafkaConnectS2IFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public KafkaConnectS2IFluent.StatusNested<A> withNewStatusLike(KafkaConnectS2Istatus item){
            return new StatusNestedImpl(item);
    }

    public KafkaConnectS2IFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public KafkaConnectS2IFluent.StatusNested<A> editOrNewStatus(){
            return withNewStatusLike(getStatus() != null ? getStatus(): new KafkaConnectS2IstatusBuilder().build());
    }

    public KafkaConnectS2IFluent.StatusNested<A> editOrNewStatusLike(KafkaConnectS2Istatus item){
            return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            KafkaConnectS2IFluentImpl that = (KafkaConnectS2IFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<KafkaConnectS2IFluent.MetadataNested<N>> implements KafkaConnectS2IFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) KafkaConnectS2IFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SpecNestedImpl<N> extends KafkaConnectS2ISpecFluentImpl<KafkaConnectS2IFluent.SpecNested<N>> implements KafkaConnectS2IFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaConnectS2ISpecBuilder builder;
    
            SpecNestedImpl(KafkaConnectS2ISpec item){
                    this.builder = new KafkaConnectS2ISpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new KafkaConnectS2ISpecBuilder(this);
            }
    
    public N and(){
            return (N) KafkaConnectS2IFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}
    public class StatusNestedImpl<N> extends KafkaConnectS2IstatusFluentImpl<KafkaConnectS2IFluent.StatusNested<N>> implements KafkaConnectS2IFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaConnectS2IstatusBuilder builder;
    
            StatusNestedImpl(KafkaConnectS2Istatus item){
                    this.builder = new KafkaConnectS2IstatusBuilder(this, item);
            }
            StatusNestedImpl(){
                    this.builder = new KafkaConnectS2IstatusBuilder(this);
            }
    
    public N and(){
            return (N) KafkaConnectS2IFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}


}
