package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaConnectS2IBuilder extends KafkaConnectS2IFluentImpl<KafkaConnectS2IBuilder> implements VisitableBuilder<KafkaConnectS2I,KafkaConnectS2IBuilder>{

    KafkaConnectS2IFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaConnectS2IBuilder(){
            this(true);
    }
    public KafkaConnectS2IBuilder(Boolean validationEnabled){
            this(new KafkaConnectS2I(), validationEnabled);
    }
    public KafkaConnectS2IBuilder(KafkaConnectS2IFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaConnectS2IBuilder(KafkaConnectS2IFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaConnectS2I(), validationEnabled);
    }
    public KafkaConnectS2IBuilder(KafkaConnectS2IFluent<?> fluent,KafkaConnectS2I instance){
            this(fluent, instance, true);
    }
    public KafkaConnectS2IBuilder(KafkaConnectS2IFluent<?> fluent,KafkaConnectS2I instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaConnectS2IBuilder(KafkaConnectS2I instance){
            this(instance,true);
    }
    public KafkaConnectS2IBuilder(KafkaConnectS2I instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaConnectS2I build(){
            KafkaConnectS2I buildable = new KafkaConnectS2I();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaConnectS2IBuilder that = (KafkaConnectS2IBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
