package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaClusterSpecBuilder extends KafkaClusterSpecFluentImpl<KafkaClusterSpecBuilder> implements VisitableBuilder<KafkaClusterSpec,KafkaClusterSpecBuilder>{

    KafkaClusterSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaClusterSpecBuilder(){
            this(true);
    }
    public KafkaClusterSpecBuilder(Boolean validationEnabled){
            this(new KafkaClusterSpec(), validationEnabled);
    }
    public KafkaClusterSpecBuilder(KafkaClusterSpecFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaClusterSpecBuilder(KafkaClusterSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaClusterSpec(), validationEnabled);
    }
    public KafkaClusterSpecBuilder(KafkaClusterSpecFluent<?> fluent,KafkaClusterSpec instance){
            this(fluent, instance, true);
    }
    public KafkaClusterSpecBuilder(KafkaClusterSpecFluent<?> fluent,KafkaClusterSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withStorage(instance.getStorage());

            fluent.withVersion(instance.getVersion());

            fluent.withConfig(instance.getConfig());

            fluent.withBrokerRackInitImage(instance.getBrokerRackInitImage());

            fluent.withRack(instance.getRack());

            fluent.withLogging(instance.getLogging());

            fluent.withTlsSidecar(instance.getTlsSidecar());

            fluent.withReplicas(instance.getReplicas());

            fluent.withImage(instance.getImage());

            fluent.withResources(instance.getResources());

            fluent.withLivenessProbe(instance.getLivenessProbe());

            fluent.withReadinessProbe(instance.getReadinessProbe());

            fluent.withJvmOptions(instance.getJvmOptions());

            fluent.withJmxOptions(instance.getJmxOptions());

            fluent.withMetrics(instance.getMetrics());

            fluent.withAffinity(instance.getAffinity());

            fluent.withTolerations(instance.getTolerations());

            fluent.withListeners(instance.getListeners());

            fluent.withAuthorization(instance.getAuthorization());

            fluent.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaClusterSpecBuilder(KafkaClusterSpec instance){
            this(instance,true);
    }
    public KafkaClusterSpecBuilder(KafkaClusterSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withStorage(instance.getStorage());

            this.withVersion(instance.getVersion());

            this.withConfig(instance.getConfig());

            this.withBrokerRackInitImage(instance.getBrokerRackInitImage());

            this.withRack(instance.getRack());

            this.withLogging(instance.getLogging());

            this.withTlsSidecar(instance.getTlsSidecar());

            this.withReplicas(instance.getReplicas());

            this.withImage(instance.getImage());

            this.withResources(instance.getResources());

            this.withLivenessProbe(instance.getLivenessProbe());

            this.withReadinessProbe(instance.getReadinessProbe());

            this.withJvmOptions(instance.getJvmOptions());

            this.withJmxOptions(instance.getJmxOptions());

            this.withMetrics(instance.getMetrics());

            this.withAffinity(instance.getAffinity());

            this.withTolerations(instance.getTolerations());

            this.withListeners(instance.getListeners());

            this.withAuthorization(instance.getAuthorization());

            this.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaClusterSpec build(){
            KafkaClusterSpec buildable = new KafkaClusterSpec();
            buildable.setStorage(fluent.getStorage());
            buildable.setVersion(fluent.getVersion());
            buildable.setConfig(fluent.getConfig());
            buildable.setBrokerRackInitImage(fluent.getBrokerRackInitImage());
            buildable.setRack(fluent.getRack());
            buildable.setLogging(fluent.getLogging());
            buildable.setTlsSidecar(fluent.getTlsSidecar());
            buildable.setReplicas(fluent.getReplicas());
            buildable.setImage(fluent.getImage());
            buildable.setResources(fluent.getResources());
            buildable.setLivenessProbe(fluent.getLivenessProbe());
            buildable.setReadinessProbe(fluent.getReadinessProbe());
            buildable.setJvmOptions(fluent.getJvmOptions());
            buildable.setJmxOptions(fluent.getJmxOptions());
            buildable.setMetrics(fluent.getMetrics());
            buildable.setAffinity(fluent.getAffinity());
            buildable.setTolerations(fluent.getTolerations());
            buildable.setListeners(fluent.getListeners());
            buildable.setAuthorization(fluent.getAuthorization());
            buildable.setTemplate(fluent.getTemplate());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaClusterSpecBuilder that = (KafkaClusterSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
