package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface KafkaBridgeTlsFluent<A extends KafkaBridgeTlsFluent<A>> extends Fluent<A>{


    public A addToTrustedCertificates(int index,CertSecretSource item);
    public A setToTrustedCertificates(int index,CertSecretSource item);
    public A addToTrustedCertificates(CertSecretSource... items);
    public A addAllToTrustedCertificates(Collection<CertSecretSource> items);
    public A removeFromTrustedCertificates(CertSecretSource... items);
    public A removeAllFromTrustedCertificates(Collection<CertSecretSource> items);
    public A removeMatchingFromTrustedCertificates(io.fabric8.kubernetes.api.builder.Predicate<CertSecretSourceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildTrustedCertificates instead.
 * @return The buildable object.
 */
@Deprecated public List<CertSecretSource> getTrustedCertificates();
    public List<CertSecretSource> buildTrustedCertificates();
    public CertSecretSource buildTrustedCertificate(int index);
    public CertSecretSource buildFirstTrustedCertificate();
    public CertSecretSource buildLastTrustedCertificate();
    public CertSecretSource buildMatchingTrustedCertificate(io.fabric8.kubernetes.api.builder.Predicate<CertSecretSourceBuilder> predicate);
    public Boolean hasMatchingTrustedCertificate(io.fabric8.kubernetes.api.builder.Predicate<CertSecretSourceBuilder> predicate);
    public A withTrustedCertificates(List<CertSecretSource> trustedCertificates);
    public A withTrustedCertificates(CertSecretSource... trustedCertificates);
    public Boolean hasTrustedCertificates();
    public KafkaBridgeTlsFluent.TrustedCertificatesNested<A> addNewTrustedCertificate();
    public KafkaBridgeTlsFluent.TrustedCertificatesNested<A> addNewTrustedCertificateLike(CertSecretSource item);
    public KafkaBridgeTlsFluent.TrustedCertificatesNested<A> setNewTrustedCertificateLike(int index,CertSecretSource item);
    public KafkaBridgeTlsFluent.TrustedCertificatesNested<A> editTrustedCertificate(int index);
    public KafkaBridgeTlsFluent.TrustedCertificatesNested<A> editFirstTrustedCertificate();
    public KafkaBridgeTlsFluent.TrustedCertificatesNested<A> editLastTrustedCertificate();
    public KafkaBridgeTlsFluent.TrustedCertificatesNested<A> editMatchingTrustedCertificate(io.fabric8.kubernetes.api.builder.Predicate<CertSecretSourceBuilder> predicate);

    public interface TrustedCertificatesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CertSecretSourceFluent<KafkaBridgeTlsFluent.TrustedCertificatesNested<N>>{

        
    public N and();    public N endTrustedCertificate();
}


}
