package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512FluentImpl;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.template.KafkaBridgeTemplate;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication;
import java.lang.Object;
import io.strimzi.api.kafka.model.tracing.Tracing;
import java.util.Map;
import io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth;
import io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluentImpl;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluentImpl;
import io.strimzi.api.kafka.model.tracing.JaegerTracing;
import java.lang.StringBuffer;
import io.strimzi.api.kafka.model.template.KafkaBridgeTemplateBuilder;
import io.strimzi.api.kafka.model.tracing.JaegerTracingFluentImpl;

public class KafkaBridgeSpecFluentImpl<A extends KafkaBridgeSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaBridgeSpecFluent<A>{

    private int replicas;
    private String image;
    private KafkaBridgeHttpConfigBuilder http;
    private String bootstrapServers;
    private KafkaBridgeTlsBuilder tls;
    private VisitableBuilder<? extends KafkaClientAuthentication,?> authentication;
    private KafkaBridgeConsumerSpecBuilder consumer;
    private KafkaBridgeProducerSpecBuilder producer;
    private ResourceRequirements resources;
    private JvmOptionsBuilder jvmOptions;
    private VisitableBuilder<? extends Logging,?> logging;
    private Map<String,Object> metrics;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private KafkaBridgeTemplateBuilder template;
    private VisitableBuilder<? extends Tracing,?> tracing;

    public KafkaBridgeSpecFluentImpl(){
    }
    public KafkaBridgeSpecFluentImpl(KafkaBridgeSpec instance){
            this.withReplicas(instance.getReplicas());

            this.withImage(instance.getImage());

            this.withHttp(instance.getHttp());

            this.withBootstrapServers(instance.getBootstrapServers());

            this.withTls(instance.getTls());

            this.withAuthentication(instance.getAuthentication());

            this.withConsumer(instance.getConsumer());

            this.withProducer(instance.getProducer());

            this.withResources(instance.getResources());

            this.withJvmOptions(instance.getJvmOptions());

            this.withLogging(instance.getLogging());

            this.withMetrics(instance.getMetrics());

            this.withLivenessProbe(instance.getLivenessProbe());

            this.withReadinessProbe(instance.getReadinessProbe());

            this.withTemplate(instance.getTemplate());

            this.withTracing(instance.getTracing());

    }

    public int getReplicas(){
            return this.replicas;
    }

    public A withReplicas(int replicas){
            this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas(){
            return true;
    }

    public String getImage(){
            return this.image;
    }

    public A withImage(String image){
            this.image=image; return (A) this;
    }

    public Boolean hasImage(){
            return this.image != null;
    }

    public A withNewImage(String arg1){
            return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuilder arg1){
            return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1){
            return (A)withImage(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildHttp instead.
 * @return The buildable object.
 */
@Deprecated public KafkaBridgeHttpConfig getHttp(){
            return this.http!=null?this.http.build():null;
    }

    public KafkaBridgeHttpConfig buildHttp(){
            return this.http!=null?this.http.build():null;
    }

    public A withHttp(KafkaBridgeHttpConfig http){
            _visitables.get("http").remove(this.http);
            if (http!=null){ this.http= new KafkaBridgeHttpConfigBuilder(http); _visitables.get("http").add(this.http);} return (A) this;
    }

    public Boolean hasHttp(){
            return this.http != null;
    }

    public A withNewHttp(int port){
            return (A)withHttp(new KafkaBridgeHttpConfig(port));
    }

    public KafkaBridgeSpecFluent.HttpNested<A> withNewHttp(){
            return new HttpNestedImpl();
    }

    public KafkaBridgeSpecFluent.HttpNested<A> withNewHttpLike(KafkaBridgeHttpConfig item){
            return new HttpNestedImpl(item);
    }

    public KafkaBridgeSpecFluent.HttpNested<A> editHttp(){
            return withNewHttpLike(getHttp());
    }

    public KafkaBridgeSpecFluent.HttpNested<A> editOrNewHttp(){
            return withNewHttpLike(getHttp() != null ? getHttp(): new KafkaBridgeHttpConfigBuilder().build());
    }

    public KafkaBridgeSpecFluent.HttpNested<A> editOrNewHttpLike(KafkaBridgeHttpConfig item){
            return withNewHttpLike(getHttp() != null ? getHttp(): item);
    }

    public String getBootstrapServers(){
            return this.bootstrapServers;
    }

    public A withBootstrapServers(String bootstrapServers){
            this.bootstrapServers=bootstrapServers; return (A) this;
    }

    public Boolean hasBootstrapServers(){
            return this.bootstrapServers != null;
    }

    public A withNewBootstrapServers(String arg1){
            return (A)withBootstrapServers(new String(arg1));
    }

    public A withNewBootstrapServers(StringBuilder arg1){
            return (A)withBootstrapServers(new String(arg1));
    }

    public A withNewBootstrapServers(StringBuffer arg1){
            return (A)withBootstrapServers(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTls instead.
 * @return The buildable object.
 */
@Deprecated public KafkaBridgeTls getTls(){
            return this.tls!=null?this.tls.build():null;
    }

    public KafkaBridgeTls buildTls(){
            return this.tls!=null?this.tls.build():null;
    }

    public A withTls(KafkaBridgeTls tls){
            _visitables.get("tls").remove(this.tls);
            if (tls!=null){ this.tls= new KafkaBridgeTlsBuilder(tls); _visitables.get("tls").add(this.tls);} return (A) this;
    }

    public Boolean hasTls(){
            return this.tls != null;
    }

    public KafkaBridgeSpecFluent.TlsNested<A> withNewTls(){
            return new TlsNestedImpl();
    }

    public KafkaBridgeSpecFluent.TlsNested<A> withNewTlsLike(KafkaBridgeTls item){
            return new TlsNestedImpl(item);
    }

    public KafkaBridgeSpecFluent.TlsNested<A> editTls(){
            return withNewTlsLike(getTls());
    }

    public KafkaBridgeSpecFluent.TlsNested<A> editOrNewTls(){
            return withNewTlsLike(getTls() != null ? getTls(): new KafkaBridgeTlsBuilder().build());
    }

    public KafkaBridgeSpecFluent.TlsNested<A> editOrNewTlsLike(KafkaBridgeTls item){
            return withNewTlsLike(getTls() != null ? getTls(): item);
    }

    
/**
 * This method has been deprecated, please use method buildAuthentication instead.
 * @return The buildable object.
 */
@Deprecated public KafkaClientAuthentication getAuthentication(){
            return this.authentication!=null?this.authentication.build():null;
    }

    public KafkaClientAuthentication buildAuthentication(){
            return this.authentication!=null?this.authentication.build():null;
    }

    public A withAuthentication(KafkaClientAuthentication authentication){
            if (authentication instanceof KafkaClientAuthenticationScramSha512){ this.authentication= new KafkaClientAuthenticationScramSha512Builder((KafkaClientAuthenticationScramSha512)authentication); _visitables.get("authentication").add(this.authentication);}
            if (authentication instanceof KafkaClientAuthenticationPlain){ this.authentication= new KafkaClientAuthenticationPlainBuilder((KafkaClientAuthenticationPlain)authentication); _visitables.get("authentication").add(this.authentication);}
            if (authentication instanceof KafkaClientAuthenticationOAuth){ this.authentication= new KafkaClientAuthenticationOAuthBuilder((KafkaClientAuthenticationOAuth)authentication); _visitables.get("authentication").add(this.authentication);}
            if (authentication instanceof KafkaClientAuthenticationTls){ this.authentication= new KafkaClientAuthenticationTlsBuilder((KafkaClientAuthenticationTls)authentication); _visitables.get("authentication").add(this.authentication);}
            return (A) this;
    }

    public Boolean hasAuthentication(){
            return this.authentication != null;
    }

    public A withKafkaClientAuthenticationScramSha512(KafkaClientAuthenticationScramSha512 kafkaClientAuthenticationScramSha512){
            _visitables.get("authentication").remove(this.authentication);
            if (kafkaClientAuthenticationScramSha512!=null){ this.authentication= new KafkaClientAuthenticationScramSha512Builder(kafkaClientAuthenticationScramSha512); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public KafkaBridgeSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512(){
            return new KafkaClientAuthenticationScramSha512NestedImpl();
    }

    public KafkaBridgeSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512Like(KafkaClientAuthenticationScramSha512 item){
            return new KafkaClientAuthenticationScramSha512NestedImpl(item);
    }

    public A withKafkaClientAuthenticationPlain(KafkaClientAuthenticationPlain kafkaClientAuthenticationPlain){
            _visitables.get("authentication").remove(this.authentication);
            if (kafkaClientAuthenticationPlain!=null){ this.authentication= new KafkaClientAuthenticationPlainBuilder(kafkaClientAuthenticationPlain); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public KafkaBridgeSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlain(){
            return new KafkaClientAuthenticationPlainNestedImpl();
    }

    public KafkaBridgeSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlainLike(KafkaClientAuthenticationPlain item){
            return new KafkaClientAuthenticationPlainNestedImpl(item);
    }

    public A withKafkaClientAuthenticationOAuth(KafkaClientAuthenticationOAuth kafkaClientAuthenticationOAuth){
            _visitables.get("authentication").remove(this.authentication);
            if (kafkaClientAuthenticationOAuth!=null){ this.authentication= new KafkaClientAuthenticationOAuthBuilder(kafkaClientAuthenticationOAuth); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public KafkaBridgeSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuth(){
            return new KafkaClientAuthenticationOAuthNestedImpl();
    }

    public KafkaBridgeSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuthLike(KafkaClientAuthenticationOAuth item){
            return new KafkaClientAuthenticationOAuthNestedImpl(item);
    }

    public A withKafkaClientAuthenticationTls(KafkaClientAuthenticationTls kafkaClientAuthenticationTls){
            _visitables.get("authentication").remove(this.authentication);
            if (kafkaClientAuthenticationTls!=null){ this.authentication= new KafkaClientAuthenticationTlsBuilder(kafkaClientAuthenticationTls); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public KafkaBridgeSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTls(){
            return new KafkaClientAuthenticationTlsNestedImpl();
    }

    public KafkaBridgeSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTlsLike(KafkaClientAuthenticationTls item){
            return new KafkaClientAuthenticationTlsNestedImpl(item);
    }

    
/**
 * This method has been deprecated, please use method buildConsumer instead.
 * @return The buildable object.
 */
@Deprecated public KafkaBridgeConsumerSpec getConsumer(){
            return this.consumer!=null?this.consumer.build():null;
    }

    public KafkaBridgeConsumerSpec buildConsumer(){
            return this.consumer!=null?this.consumer.build():null;
    }

    public A withConsumer(KafkaBridgeConsumerSpec consumer){
            _visitables.get("consumer").remove(this.consumer);
            if (consumer!=null){ this.consumer= new KafkaBridgeConsumerSpecBuilder(consumer); _visitables.get("consumer").add(this.consumer);} return (A) this;
    }

    public Boolean hasConsumer(){
            return this.consumer != null;
    }

    public KafkaBridgeSpecFluent.ConsumerNested<A> withNewConsumer(){
            return new ConsumerNestedImpl();
    }

    public KafkaBridgeSpecFluent.ConsumerNested<A> withNewConsumerLike(KafkaBridgeConsumerSpec item){
            return new ConsumerNestedImpl(item);
    }

    public KafkaBridgeSpecFluent.ConsumerNested<A> editConsumer(){
            return withNewConsumerLike(getConsumer());
    }

    public KafkaBridgeSpecFluent.ConsumerNested<A> editOrNewConsumer(){
            return withNewConsumerLike(getConsumer() != null ? getConsumer(): new KafkaBridgeConsumerSpecBuilder().build());
    }

    public KafkaBridgeSpecFluent.ConsumerNested<A> editOrNewConsumerLike(KafkaBridgeConsumerSpec item){
            return withNewConsumerLike(getConsumer() != null ? getConsumer(): item);
    }

    
/**
 * This method has been deprecated, please use method buildProducer instead.
 * @return The buildable object.
 */
@Deprecated public KafkaBridgeProducerSpec getProducer(){
            return this.producer!=null?this.producer.build():null;
    }

    public KafkaBridgeProducerSpec buildProducer(){
            return this.producer!=null?this.producer.build():null;
    }

    public A withProducer(KafkaBridgeProducerSpec producer){
            _visitables.get("producer").remove(this.producer);
            if (producer!=null){ this.producer= new KafkaBridgeProducerSpecBuilder(producer); _visitables.get("producer").add(this.producer);} return (A) this;
    }

    public Boolean hasProducer(){
            return this.producer != null;
    }

    public KafkaBridgeSpecFluent.ProducerNested<A> withNewProducer(){
            return new ProducerNestedImpl();
    }

    public KafkaBridgeSpecFluent.ProducerNested<A> withNewProducerLike(KafkaBridgeProducerSpec item){
            return new ProducerNestedImpl(item);
    }

    public KafkaBridgeSpecFluent.ProducerNested<A> editProducer(){
            return withNewProducerLike(getProducer());
    }

    public KafkaBridgeSpecFluent.ProducerNested<A> editOrNewProducer(){
            return withNewProducerLike(getProducer() != null ? getProducer(): new KafkaBridgeProducerSpecBuilder().build());
    }

    public KafkaBridgeSpecFluent.ProducerNested<A> editOrNewProducerLike(KafkaBridgeProducerSpec item){
            return withNewProducerLike(getProducer() != null ? getProducer(): item);
    }

    public ResourceRequirements getResources(){
            return this.resources;
    }

    public A withResources(ResourceRequirements resources){
            this.resources=resources; return (A) this;
    }

    public Boolean hasResources(){
            return this.resources != null;
    }

    
/**
 * This method has been deprecated, please use method buildJvmOptions instead.
 * @return The buildable object.
 */
@Deprecated public JvmOptions getJvmOptions(){
            return this.jvmOptions!=null?this.jvmOptions.build():null;
    }

    public JvmOptions buildJvmOptions(){
            return this.jvmOptions!=null?this.jvmOptions.build():null;
    }

    public A withJvmOptions(JvmOptions jvmOptions){
            _visitables.get("jvmOptions").remove(this.jvmOptions);
            if (jvmOptions!=null){ this.jvmOptions= new JvmOptionsBuilder(jvmOptions); _visitables.get("jvmOptions").add(this.jvmOptions);} return (A) this;
    }

    public Boolean hasJvmOptions(){
            return this.jvmOptions != null;
    }

    public KafkaBridgeSpecFluent.JvmOptionsNested<A> withNewJvmOptions(){
            return new JvmOptionsNestedImpl();
    }

    public KafkaBridgeSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item){
            return new JvmOptionsNestedImpl(item);
    }

    public KafkaBridgeSpecFluent.JvmOptionsNested<A> editJvmOptions(){
            return withNewJvmOptionsLike(getJvmOptions());
    }

    public KafkaBridgeSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions(){
            return withNewJvmOptionsLike(getJvmOptions() != null ? getJvmOptions(): new JvmOptionsBuilder().build());
    }

    public KafkaBridgeSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item){
            return withNewJvmOptionsLike(getJvmOptions() != null ? getJvmOptions(): item);
    }

    
/**
 * This method has been deprecated, please use method buildLogging instead.
 * @return The buildable object.
 */
@Deprecated public Logging getLogging(){
            return this.logging!=null?this.logging.build():null;
    }

    public Logging buildLogging(){
            return this.logging!=null?this.logging.build():null;
    }

    public A withLogging(Logging logging){
            if (logging instanceof ExternalLogging){ this.logging= new ExternalLoggingBuilder((ExternalLogging)logging); _visitables.get("logging").add(this.logging);}
            if (logging instanceof InlineLogging){ this.logging= new InlineLoggingBuilder((InlineLogging)logging); _visitables.get("logging").add(this.logging);}
            return (A) this;
    }

    public Boolean hasLogging(){
            return this.logging != null;
    }

    public A withExternalLogging(ExternalLogging externalLogging){
            _visitables.get("logging").remove(this.logging);
            if (externalLogging!=null){ this.logging= new ExternalLoggingBuilder(externalLogging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public KafkaBridgeSpecFluent.ExternalLoggingNested<A> withNewExternalLogging(){
            return new ExternalLoggingNestedImpl();
    }

    public KafkaBridgeSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item){
            return new ExternalLoggingNestedImpl(item);
    }

    public A withInlineLogging(InlineLogging inlineLogging){
            _visitables.get("logging").remove(this.logging);
            if (inlineLogging!=null){ this.logging= new InlineLoggingBuilder(inlineLogging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public KafkaBridgeSpecFluent.InlineLoggingNested<A> withNewInlineLogging(){
            return new InlineLoggingNestedImpl();
    }

    public KafkaBridgeSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item){
            return new InlineLoggingNestedImpl(item);
    }

    public A addToMetrics(String key,Object value){
            if(this.metrics == null && key != null && value != null) { this.metrics = new LinkedHashMap<String,Object>(); }
            if(key != null && value != null) {this.metrics.put(key, value);} return (A)this;
    }

    public A addToMetrics(Map<String,Object> map){
            if(this.metrics == null && map != null) { this.metrics = new LinkedHashMap<String,Object>(); }
            if(map != null) { this.metrics.putAll(map);} return (A)this;
    }

    public A removeFromMetrics(String key){
            if(this.metrics == null) { return (A) this; }
            if(key != null && this.metrics != null) {this.metrics.remove(key);} return (A)this;
    }

    public A removeFromMetrics(Map<String,Object> map){
            if(this.metrics == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.metrics != null){this.metrics.remove(key);}}} return (A)this;
    }

    public Map<String,Object> getMetrics(){
            return this.metrics;
    }

    public A withMetrics(Map<String,Object> metrics){
            if (metrics == null) { this.metrics =  null;} else {this.metrics = new LinkedHashMap<String,Object>(metrics);} return (A) this;
    }

    public Boolean hasMetrics(){
            return this.metrics != null;
    }

    
/**
 * This method has been deprecated, please use method buildLivenessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getLivenessProbe(){
            return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public Probe buildLivenessProbe(){
            return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public A withLivenessProbe(Probe livenessProbe){
            _visitables.get("livenessProbe").remove(this.livenessProbe);
            if (livenessProbe!=null){ this.livenessProbe= new ProbeBuilder(livenessProbe); _visitables.get("livenessProbe").add(this.livenessProbe);} return (A) this;
    }

    public Boolean hasLivenessProbe(){
            return this.livenessProbe != null;
    }

    public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds){
            return (A)withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public KafkaBridgeSpecFluent.LivenessProbeNested<A> withNewLivenessProbe(){
            return new LivenessProbeNestedImpl();
    }

    public KafkaBridgeSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item){
            return new LivenessProbeNestedImpl(item);
    }

    public KafkaBridgeSpecFluent.LivenessProbeNested<A> editLivenessProbe(){
            return withNewLivenessProbeLike(getLivenessProbe());
    }

    public KafkaBridgeSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe(){
            return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): new ProbeBuilder().build());
    }

    public KafkaBridgeSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item){
            return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): item);
    }

    
/**
 * This method has been deprecated, please use method buildReadinessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getReadinessProbe(){
            return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public Probe buildReadinessProbe(){
            return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public A withReadinessProbe(Probe readinessProbe){
            _visitables.get("readinessProbe").remove(this.readinessProbe);
            if (readinessProbe!=null){ this.readinessProbe= new ProbeBuilder(readinessProbe); _visitables.get("readinessProbe").add(this.readinessProbe);} return (A) this;
    }

    public Boolean hasReadinessProbe(){
            return this.readinessProbe != null;
    }

    public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds){
            return (A)withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public KafkaBridgeSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe(){
            return new ReadinessProbeNestedImpl();
    }

    public KafkaBridgeSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item){
            return new ReadinessProbeNestedImpl(item);
    }

    public KafkaBridgeSpecFluent.ReadinessProbeNested<A> editReadinessProbe(){
            return withNewReadinessProbeLike(getReadinessProbe());
    }

    public KafkaBridgeSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe(){
            return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): new ProbeBuilder().build());
    }

    public KafkaBridgeSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item){
            return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public KafkaBridgeTemplate getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public KafkaBridgeTemplate buildTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(KafkaBridgeTemplate template){
            _visitables.get("template").remove(this.template);
            if (template!=null){ this.template= new KafkaBridgeTemplateBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public Boolean hasTemplate(){
            return this.template != null;
    }

    public KafkaBridgeSpecFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public KafkaBridgeSpecFluent.TemplateNested<A> withNewTemplateLike(KafkaBridgeTemplate item){
            return new TemplateNestedImpl(item);
    }

    public KafkaBridgeSpecFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public KafkaBridgeSpecFluent.TemplateNested<A> editOrNewTemplate(){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): new KafkaBridgeTemplateBuilder().build());
    }

    public KafkaBridgeSpecFluent.TemplateNested<A> editOrNewTemplateLike(KafkaBridgeTemplate item){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTracing instead.
 * @return The buildable object.
 */
@Deprecated public Tracing getTracing(){
            return this.tracing!=null?this.tracing.build():null;
    }

    public Tracing buildTracing(){
            return this.tracing!=null?this.tracing.build():null;
    }

    public A withTracing(Tracing tracing){
            if (tracing instanceof JaegerTracing){ this.tracing= new JaegerTracingBuilder((JaegerTracing)tracing); _visitables.get("tracing").add(this.tracing);}
            return (A) this;
    }

    public Boolean hasTracing(){
            return this.tracing != null;
    }

    public A withJaegerTracing(JaegerTracing jaegerTracing){
            _visitables.get("tracing").remove(this.tracing);
            if (jaegerTracing!=null){ this.tracing= new JaegerTracingBuilder(jaegerTracing); _visitables.get("tracing").add(this.tracing);} return (A) this;
    }

    public KafkaBridgeSpecFluent.JaegerTracingNested<A> withNewJaegerTracing(){
            return new JaegerTracingNestedImpl();
    }

    public KafkaBridgeSpecFluent.JaegerTracingNested<A> withNewJaegerTracingLike(JaegerTracing item){
            return new JaegerTracingNestedImpl(item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            KafkaBridgeSpecFluentImpl that = (KafkaBridgeSpecFluentImpl) o;
            if (replicas != that.replicas) return false;
            if (image != null ? !image.equals(that.image) :that.image != null) return false;
            if (http != null ? !http.equals(that.http) :that.http != null) return false;
            if (bootstrapServers != null ? !bootstrapServers.equals(that.bootstrapServers) :that.bootstrapServers != null) return false;
            if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
            if (authentication != null ? !authentication.equals(that.authentication) :that.authentication != null) return false;
            if (consumer != null ? !consumer.equals(that.consumer) :that.consumer != null) return false;
            if (producer != null ? !producer.equals(that.producer) :that.producer != null) return false;
            if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
            if (jvmOptions != null ? !jvmOptions.equals(that.jvmOptions) :that.jvmOptions != null) return false;
            if (logging != null ? !logging.equals(that.logging) :that.logging != null) return false;
            if (metrics != null ? !metrics.equals(that.metrics) :that.metrics != null) return false;
            if (livenessProbe != null ? !livenessProbe.equals(that.livenessProbe) :that.livenessProbe != null) return false;
            if (readinessProbe != null ? !readinessProbe.equals(that.readinessProbe) :that.readinessProbe != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            if (tracing != null ? !tracing.equals(that.tracing) :that.tracing != null) return false;
            return true;
    }


    public class HttpNestedImpl<N> extends KafkaBridgeHttpConfigFluentImpl<KafkaBridgeSpecFluent.HttpNested<N>> implements KafkaBridgeSpecFluent.HttpNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaBridgeHttpConfigBuilder builder;
    
            HttpNestedImpl(KafkaBridgeHttpConfig item){
                    this.builder = new KafkaBridgeHttpConfigBuilder(this, item);
            }
            HttpNestedImpl(){
                    this.builder = new KafkaBridgeHttpConfigBuilder(this);
            }
    
    public N and(){
            return (N) KafkaBridgeSpecFluentImpl.this.withHttp(builder.build());
    }
    public N endHttp(){
            return and();
    }

}
    public class TlsNestedImpl<N> extends KafkaBridgeTlsFluentImpl<KafkaBridgeSpecFluent.TlsNested<N>> implements KafkaBridgeSpecFluent.TlsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaBridgeTlsBuilder builder;
    
            TlsNestedImpl(KafkaBridgeTls item){
                    this.builder = new KafkaBridgeTlsBuilder(this, item);
            }
            TlsNestedImpl(){
                    this.builder = new KafkaBridgeTlsBuilder(this);
            }
    
    public N and(){
            return (N) KafkaBridgeSpecFluentImpl.this.withTls(builder.build());
    }
    public N endTls(){
            return and();
    }

}
    public class KafkaClientAuthenticationScramSha512NestedImpl<N> extends KafkaClientAuthenticationScramSha512FluentImpl<KafkaBridgeSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>> implements KafkaBridgeSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaClientAuthenticationScramSha512Builder builder;
    
            KafkaClientAuthenticationScramSha512NestedImpl(KafkaClientAuthenticationScramSha512 item){
                    this.builder = new KafkaClientAuthenticationScramSha512Builder(this, item);
            }
            KafkaClientAuthenticationScramSha512NestedImpl(){
                    this.builder = new KafkaClientAuthenticationScramSha512Builder(this);
            }
    
    public N and(){
            return (N) KafkaBridgeSpecFluentImpl.this.withKafkaClientAuthenticationScramSha512(builder.build());
    }
    public N endKafkaClientAuthenticationScramSha512(){
            return and();
    }

}
    public class KafkaClientAuthenticationPlainNestedImpl<N> extends KafkaClientAuthenticationPlainFluentImpl<KafkaBridgeSpecFluent.KafkaClientAuthenticationPlainNested<N>> implements KafkaBridgeSpecFluent.KafkaClientAuthenticationPlainNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaClientAuthenticationPlainBuilder builder;
    
            KafkaClientAuthenticationPlainNestedImpl(KafkaClientAuthenticationPlain item){
                    this.builder = new KafkaClientAuthenticationPlainBuilder(this, item);
            }
            KafkaClientAuthenticationPlainNestedImpl(){
                    this.builder = new KafkaClientAuthenticationPlainBuilder(this);
            }
    
    public N and(){
            return (N) KafkaBridgeSpecFluentImpl.this.withKafkaClientAuthenticationPlain(builder.build());
    }
    public N endKafkaClientAuthenticationPlain(){
            return and();
    }

}
    public class KafkaClientAuthenticationOAuthNestedImpl<N> extends KafkaClientAuthenticationOAuthFluentImpl<KafkaBridgeSpecFluent.KafkaClientAuthenticationOAuthNested<N>> implements KafkaBridgeSpecFluent.KafkaClientAuthenticationOAuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaClientAuthenticationOAuthBuilder builder;
    
            KafkaClientAuthenticationOAuthNestedImpl(KafkaClientAuthenticationOAuth item){
                    this.builder = new KafkaClientAuthenticationOAuthBuilder(this, item);
            }
            KafkaClientAuthenticationOAuthNestedImpl(){
                    this.builder = new KafkaClientAuthenticationOAuthBuilder(this);
            }
    
    public N and(){
            return (N) KafkaBridgeSpecFluentImpl.this.withKafkaClientAuthenticationOAuth(builder.build());
    }
    public N endKafkaClientAuthenticationOAuth(){
            return and();
    }

}
    public class KafkaClientAuthenticationTlsNestedImpl<N> extends KafkaClientAuthenticationTlsFluentImpl<KafkaBridgeSpecFluent.KafkaClientAuthenticationTlsNested<N>> implements KafkaBridgeSpecFluent.KafkaClientAuthenticationTlsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaClientAuthenticationTlsBuilder builder;
    
            KafkaClientAuthenticationTlsNestedImpl(KafkaClientAuthenticationTls item){
                    this.builder = new KafkaClientAuthenticationTlsBuilder(this, item);
            }
            KafkaClientAuthenticationTlsNestedImpl(){
                    this.builder = new KafkaClientAuthenticationTlsBuilder(this);
            }
    
    public N and(){
            return (N) KafkaBridgeSpecFluentImpl.this.withKafkaClientAuthenticationTls(builder.build());
    }
    public N endKafkaClientAuthenticationTls(){
            return and();
    }

}
    public class ConsumerNestedImpl<N> extends KafkaBridgeConsumerSpecFluentImpl<KafkaBridgeSpecFluent.ConsumerNested<N>> implements KafkaBridgeSpecFluent.ConsumerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaBridgeConsumerSpecBuilder builder;
    
            ConsumerNestedImpl(KafkaBridgeConsumerSpec item){
                    this.builder = new KafkaBridgeConsumerSpecBuilder(this, item);
            }
            ConsumerNestedImpl(){
                    this.builder = new KafkaBridgeConsumerSpecBuilder(this);
            }
    
    public N and(){
            return (N) KafkaBridgeSpecFluentImpl.this.withConsumer(builder.build());
    }
    public N endConsumer(){
            return and();
    }

}
    public class ProducerNestedImpl<N> extends KafkaBridgeProducerSpecFluentImpl<KafkaBridgeSpecFluent.ProducerNested<N>> implements KafkaBridgeSpecFluent.ProducerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaBridgeProducerSpecBuilder builder;
    
            ProducerNestedImpl(KafkaBridgeProducerSpec item){
                    this.builder = new KafkaBridgeProducerSpecBuilder(this, item);
            }
            ProducerNestedImpl(){
                    this.builder = new KafkaBridgeProducerSpecBuilder(this);
            }
    
    public N and(){
            return (N) KafkaBridgeSpecFluentImpl.this.withProducer(builder.build());
    }
    public N endProducer(){
            return and();
    }

}
    public class JvmOptionsNestedImpl<N> extends JvmOptionsFluentImpl<KafkaBridgeSpecFluent.JvmOptionsNested<N>> implements KafkaBridgeSpecFluent.JvmOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final JvmOptionsBuilder builder;
    
            JvmOptionsNestedImpl(JvmOptions item){
                    this.builder = new JvmOptionsBuilder(this, item);
            }
            JvmOptionsNestedImpl(){
                    this.builder = new JvmOptionsBuilder(this);
            }
    
    public N and(){
            return (N) KafkaBridgeSpecFluentImpl.this.withJvmOptions(builder.build());
    }
    public N endJvmOptions(){
            return and();
    }

}
    public class ExternalLoggingNestedImpl<N> extends ExternalLoggingFluentImpl<KafkaBridgeSpecFluent.ExternalLoggingNested<N>> implements KafkaBridgeSpecFluent.ExternalLoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ExternalLoggingBuilder builder;
    
            ExternalLoggingNestedImpl(ExternalLogging item){
                    this.builder = new ExternalLoggingBuilder(this, item);
            }
            ExternalLoggingNestedImpl(){
                    this.builder = new ExternalLoggingBuilder(this);
            }
    
    public N and(){
            return (N) KafkaBridgeSpecFluentImpl.this.withExternalLogging(builder.build());
    }
    public N endExternalLogging(){
            return and();
    }

}
    public class InlineLoggingNestedImpl<N> extends InlineLoggingFluentImpl<KafkaBridgeSpecFluent.InlineLoggingNested<N>> implements KafkaBridgeSpecFluent.InlineLoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final InlineLoggingBuilder builder;
    
            InlineLoggingNestedImpl(InlineLogging item){
                    this.builder = new InlineLoggingBuilder(this, item);
            }
            InlineLoggingNestedImpl(){
                    this.builder = new InlineLoggingBuilder(this);
            }
    
    public N and(){
            return (N) KafkaBridgeSpecFluentImpl.this.withInlineLogging(builder.build());
    }
    public N endInlineLogging(){
            return and();
    }

}
    public class LivenessProbeNestedImpl<N> extends ProbeFluentImpl<KafkaBridgeSpecFluent.LivenessProbeNested<N>> implements KafkaBridgeSpecFluent.LivenessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ProbeBuilder builder;
    
            LivenessProbeNestedImpl(Probe item){
                    this.builder = new ProbeBuilder(this, item);
            }
            LivenessProbeNestedImpl(){
                    this.builder = new ProbeBuilder(this);
            }
    
    public N and(){
            return (N) KafkaBridgeSpecFluentImpl.this.withLivenessProbe(builder.build());
    }
    public N endLivenessProbe(){
            return and();
    }

}
    public class ReadinessProbeNestedImpl<N> extends ProbeFluentImpl<KafkaBridgeSpecFluent.ReadinessProbeNested<N>> implements KafkaBridgeSpecFluent.ReadinessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ProbeBuilder builder;
    
            ReadinessProbeNestedImpl(Probe item){
                    this.builder = new ProbeBuilder(this, item);
            }
            ReadinessProbeNestedImpl(){
                    this.builder = new ProbeBuilder(this);
            }
    
    public N and(){
            return (N) KafkaBridgeSpecFluentImpl.this.withReadinessProbe(builder.build());
    }
    public N endReadinessProbe(){
            return and();
    }

}
    public class TemplateNestedImpl<N> extends KafkaBridgeTemplateFluentImpl<KafkaBridgeSpecFluent.TemplateNested<N>> implements KafkaBridgeSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaBridgeTemplateBuilder builder;
    
            TemplateNestedImpl(KafkaBridgeTemplate item){
                    this.builder = new KafkaBridgeTemplateBuilder(this, item);
            }
            TemplateNestedImpl(){
                    this.builder = new KafkaBridgeTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaBridgeSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate(){
            return and();
    }

}
    public class JaegerTracingNestedImpl<N> extends JaegerTracingFluentImpl<KafkaBridgeSpecFluent.JaegerTracingNested<N>> implements KafkaBridgeSpecFluent.JaegerTracingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final JaegerTracingBuilder builder;
    
            JaegerTracingNestedImpl(JaegerTracing item){
                    this.builder = new JaegerTracingBuilder(this, item);
            }
            JaegerTracingNestedImpl(){
                    this.builder = new JaegerTracingBuilder(this);
            }
    
    public N and(){
            return (N) KafkaBridgeSpecFluentImpl.this.withJaegerTracing(builder.build());
    }
    public N endJaegerTracing(){
            return and();
    }

}


}
