package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import io.strimzi.api.kafka.model.template.KafkaBridgeTemplate;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication;
import io.strimzi.api.kafka.model.tracing.JaegerTracingFluent;
import io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent;
import java.lang.Object;
import io.strimzi.api.kafka.model.tracing.Tracing;
import java.util.Map;
import io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512;
import io.strimzi.api.kafka.model.tracing.JaegerTracing;
import java.lang.StringBuffer;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent;
import io.strimzi.api.kafka.model.template.KafkaBridgeTemplateBuilder;

public interface KafkaBridgeSpecFluent<A extends KafkaBridgeSpecFluent<A>> extends Fluent<A>{


    public int getReplicas();
    public A withReplicas(int replicas);
    public Boolean hasReplicas();
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(String arg1);
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildHttp instead.
 * @return The buildable object.
 */
@Deprecated public KafkaBridgeHttpConfig getHttp();
    public KafkaBridgeHttpConfig buildHttp();
    public A withHttp(KafkaBridgeHttpConfig http);
    public Boolean hasHttp();
    public A withNewHttp(int port);
    public KafkaBridgeSpecFluent.HttpNested<A> withNewHttp();
    public KafkaBridgeSpecFluent.HttpNested<A> withNewHttpLike(KafkaBridgeHttpConfig item);
    public KafkaBridgeSpecFluent.HttpNested<A> editHttp();
    public KafkaBridgeSpecFluent.HttpNested<A> editOrNewHttp();
    public KafkaBridgeSpecFluent.HttpNested<A> editOrNewHttpLike(KafkaBridgeHttpConfig item);
    public String getBootstrapServers();
    public A withBootstrapServers(String bootstrapServers);
    public Boolean hasBootstrapServers();
    public A withNewBootstrapServers(String arg1);
    public A withNewBootstrapServers(StringBuilder arg1);
    public A withNewBootstrapServers(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildTls instead.
 * @return The buildable object.
 */
@Deprecated public KafkaBridgeTls getTls();
    public KafkaBridgeTls buildTls();
    public A withTls(KafkaBridgeTls tls);
    public Boolean hasTls();
    public KafkaBridgeSpecFluent.TlsNested<A> withNewTls();
    public KafkaBridgeSpecFluent.TlsNested<A> withNewTlsLike(KafkaBridgeTls item);
    public KafkaBridgeSpecFluent.TlsNested<A> editTls();
    public KafkaBridgeSpecFluent.TlsNested<A> editOrNewTls();
    public KafkaBridgeSpecFluent.TlsNested<A> editOrNewTlsLike(KafkaBridgeTls item);
    
/**
 * This method has been deprecated, please use method buildAuthentication instead.
 * @return The buildable object.
 */
@Deprecated public KafkaClientAuthentication getAuthentication();
    public KafkaClientAuthentication buildAuthentication();
    public A withAuthentication(KafkaClientAuthentication authentication);
    public Boolean hasAuthentication();
    public A withKafkaClientAuthenticationScramSha512(KafkaClientAuthenticationScramSha512 kafkaClientAuthenticationScramSha512);
    public KafkaBridgeSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512();
    public KafkaBridgeSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512Like(KafkaClientAuthenticationScramSha512 item);
    public A withKafkaClientAuthenticationPlain(KafkaClientAuthenticationPlain kafkaClientAuthenticationPlain);
    public KafkaBridgeSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlain();
    public KafkaBridgeSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlainLike(KafkaClientAuthenticationPlain item);
    public A withKafkaClientAuthenticationOAuth(KafkaClientAuthenticationOAuth kafkaClientAuthenticationOAuth);
    public KafkaBridgeSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuth();
    public KafkaBridgeSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuthLike(KafkaClientAuthenticationOAuth item);
    public A withKafkaClientAuthenticationTls(KafkaClientAuthenticationTls kafkaClientAuthenticationTls);
    public KafkaBridgeSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTls();
    public KafkaBridgeSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTlsLike(KafkaClientAuthenticationTls item);
    
/**
 * This method has been deprecated, please use method buildConsumer instead.
 * @return The buildable object.
 */
@Deprecated public KafkaBridgeConsumerSpec getConsumer();
    public KafkaBridgeConsumerSpec buildConsumer();
    public A withConsumer(KafkaBridgeConsumerSpec consumer);
    public Boolean hasConsumer();
    public KafkaBridgeSpecFluent.ConsumerNested<A> withNewConsumer();
    public KafkaBridgeSpecFluent.ConsumerNested<A> withNewConsumerLike(KafkaBridgeConsumerSpec item);
    public KafkaBridgeSpecFluent.ConsumerNested<A> editConsumer();
    public KafkaBridgeSpecFluent.ConsumerNested<A> editOrNewConsumer();
    public KafkaBridgeSpecFluent.ConsumerNested<A> editOrNewConsumerLike(KafkaBridgeConsumerSpec item);
    
/**
 * This method has been deprecated, please use method buildProducer instead.
 * @return The buildable object.
 */
@Deprecated public KafkaBridgeProducerSpec getProducer();
    public KafkaBridgeProducerSpec buildProducer();
    public A withProducer(KafkaBridgeProducerSpec producer);
    public Boolean hasProducer();
    public KafkaBridgeSpecFluent.ProducerNested<A> withNewProducer();
    public KafkaBridgeSpecFluent.ProducerNested<A> withNewProducerLike(KafkaBridgeProducerSpec item);
    public KafkaBridgeSpecFluent.ProducerNested<A> editProducer();
    public KafkaBridgeSpecFluent.ProducerNested<A> editOrNewProducer();
    public KafkaBridgeSpecFluent.ProducerNested<A> editOrNewProducerLike(KafkaBridgeProducerSpec item);
    public ResourceRequirements getResources();
    public A withResources(ResourceRequirements resources);
    public Boolean hasResources();
    
/**
 * This method has been deprecated, please use method buildJvmOptions instead.
 * @return The buildable object.
 */
@Deprecated public JvmOptions getJvmOptions();
    public JvmOptions buildJvmOptions();
    public A withJvmOptions(JvmOptions jvmOptions);
    public Boolean hasJvmOptions();
    public KafkaBridgeSpecFluent.JvmOptionsNested<A> withNewJvmOptions();
    public KafkaBridgeSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item);
    public KafkaBridgeSpecFluent.JvmOptionsNested<A> editJvmOptions();
    public KafkaBridgeSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions();
    public KafkaBridgeSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item);
    
/**
 * This method has been deprecated, please use method buildLogging instead.
 * @return The buildable object.
 */
@Deprecated public Logging getLogging();
    public Logging buildLogging();
    public A withLogging(Logging logging);
    public Boolean hasLogging();
    public A withExternalLogging(ExternalLogging externalLogging);
    public KafkaBridgeSpecFluent.ExternalLoggingNested<A> withNewExternalLogging();
    public KafkaBridgeSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item);
    public A withInlineLogging(InlineLogging inlineLogging);
    public KafkaBridgeSpecFluent.InlineLoggingNested<A> withNewInlineLogging();
    public KafkaBridgeSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item);
    public A addToMetrics(String key,Object value);
    public A addToMetrics(Map<String,Object> map);
    public A removeFromMetrics(String key);
    public A removeFromMetrics(Map<String,Object> map);
    public Map<String,Object> getMetrics();
    public A withMetrics(Map<String,Object> metrics);
    public Boolean hasMetrics();
    
/**
 * This method has been deprecated, please use method buildLivenessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getLivenessProbe();
    public Probe buildLivenessProbe();
    public A withLivenessProbe(Probe livenessProbe);
    public Boolean hasLivenessProbe();
    public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds);
    public KafkaBridgeSpecFluent.LivenessProbeNested<A> withNewLivenessProbe();
    public KafkaBridgeSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item);
    public KafkaBridgeSpecFluent.LivenessProbeNested<A> editLivenessProbe();
    public KafkaBridgeSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe();
    public KafkaBridgeSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item);
    
/**
 * This method has been deprecated, please use method buildReadinessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getReadinessProbe();
    public Probe buildReadinessProbe();
    public A withReadinessProbe(Probe readinessProbe);
    public Boolean hasReadinessProbe();
    public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds);
    public KafkaBridgeSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe();
    public KafkaBridgeSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item);
    public KafkaBridgeSpecFluent.ReadinessProbeNested<A> editReadinessProbe();
    public KafkaBridgeSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe();
    public KafkaBridgeSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item);
    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public KafkaBridgeTemplate getTemplate();
    public KafkaBridgeTemplate buildTemplate();
    public A withTemplate(KafkaBridgeTemplate template);
    public Boolean hasTemplate();
    public KafkaBridgeSpecFluent.TemplateNested<A> withNewTemplate();
    public KafkaBridgeSpecFluent.TemplateNested<A> withNewTemplateLike(KafkaBridgeTemplate item);
    public KafkaBridgeSpecFluent.TemplateNested<A> editTemplate();
    public KafkaBridgeSpecFluent.TemplateNested<A> editOrNewTemplate();
    public KafkaBridgeSpecFluent.TemplateNested<A> editOrNewTemplateLike(KafkaBridgeTemplate item);
    
/**
 * This method has been deprecated, please use method buildTracing instead.
 * @return The buildable object.
 */
@Deprecated public Tracing getTracing();
    public Tracing buildTracing();
    public A withTracing(Tracing tracing);
    public Boolean hasTracing();
    public A withJaegerTracing(JaegerTracing jaegerTracing);
    public KafkaBridgeSpecFluent.JaegerTracingNested<A> withNewJaegerTracing();
    public KafkaBridgeSpecFluent.JaegerTracingNested<A> withNewJaegerTracingLike(JaegerTracing item);

    public interface HttpNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaBridgeHttpConfigFluent<KafkaBridgeSpecFluent.HttpNested<N>>{

        
    public N and();    public N endHttp();
}
    public interface TlsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaBridgeTlsFluent<KafkaBridgeSpecFluent.TlsNested<N>>{

        
    public N and();    public N endTls();
}
    public interface KafkaClientAuthenticationScramSha512Nested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaClientAuthenticationScramSha512Fluent<KafkaBridgeSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>>{

        
    public N and();    public N endKafkaClientAuthenticationScramSha512();
}
    public interface KafkaClientAuthenticationPlainNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaClientAuthenticationPlainFluent<KafkaBridgeSpecFluent.KafkaClientAuthenticationPlainNested<N>>{

        
    public N and();    public N endKafkaClientAuthenticationPlain();
}
    public interface KafkaClientAuthenticationOAuthNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaClientAuthenticationOAuthFluent<KafkaBridgeSpecFluent.KafkaClientAuthenticationOAuthNested<N>>{

        
    public N and();    public N endKafkaClientAuthenticationOAuth();
}
    public interface KafkaClientAuthenticationTlsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaClientAuthenticationTlsFluent<KafkaBridgeSpecFluent.KafkaClientAuthenticationTlsNested<N>>{

        
    public N and();    public N endKafkaClientAuthenticationTls();
}
    public interface ConsumerNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaBridgeConsumerSpecFluent<KafkaBridgeSpecFluent.ConsumerNested<N>>{

        
    public N and();    public N endConsumer();
}
    public interface ProducerNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaBridgeProducerSpecFluent<KafkaBridgeSpecFluent.ProducerNested<N>>{

        
    public N and();    public N endProducer();
}
    public interface JvmOptionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,JvmOptionsFluent<KafkaBridgeSpecFluent.JvmOptionsNested<N>>{

        
    public N and();    public N endJvmOptions();
}
    public interface ExternalLoggingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ExternalLoggingFluent<KafkaBridgeSpecFluent.ExternalLoggingNested<N>>{

        
    public N and();    public N endExternalLogging();
}
    public interface InlineLoggingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,InlineLoggingFluent<KafkaBridgeSpecFluent.InlineLoggingNested<N>>{

        
    public N and();    public N endInlineLogging();
}
    public interface LivenessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProbeFluent<KafkaBridgeSpecFluent.LivenessProbeNested<N>>{

        
    public N and();    public N endLivenessProbe();
}
    public interface ReadinessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProbeFluent<KafkaBridgeSpecFluent.ReadinessProbeNested<N>>{

        
    public N and();    public N endReadinessProbe();
}
    public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaBridgeTemplateFluent<KafkaBridgeSpecFluent.TemplateNested<N>>{

        
    public N and();    public N endTemplate();
}
    public interface JaegerTracingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,JaegerTracingFluent<KafkaBridgeSpecFluent.JaegerTracingNested<N>>{

        
    public N and();    public N endJaegerTracing();
}


}
