package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaBridgeHttpConfigBuilder extends KafkaBridgeHttpConfigFluentImpl<KafkaBridgeHttpConfigBuilder> implements VisitableBuilder<KafkaBridgeHttpConfig,KafkaBridgeHttpConfigBuilder>{

    KafkaBridgeHttpConfigFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaBridgeHttpConfigBuilder(){
            this(true);
    }
    public KafkaBridgeHttpConfigBuilder(Boolean validationEnabled){
            this(new KafkaBridgeHttpConfig(), validationEnabled);
    }
    public KafkaBridgeHttpConfigBuilder(KafkaBridgeHttpConfigFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaBridgeHttpConfigBuilder(KafkaBridgeHttpConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaBridgeHttpConfig(), validationEnabled);
    }
    public KafkaBridgeHttpConfigBuilder(KafkaBridgeHttpConfigFluent<?> fluent,KafkaBridgeHttpConfig instance){
            this(fluent, instance, true);
    }
    public KafkaBridgeHttpConfigBuilder(KafkaBridgeHttpConfigFluent<?> fluent,KafkaBridgeHttpConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPort(instance.getPort()); 
            this.validationEnabled = validationEnabled; 
    }
    public KafkaBridgeHttpConfigBuilder(KafkaBridgeHttpConfig instance){
            this(instance,true);
    }
    public KafkaBridgeHttpConfigBuilder(KafkaBridgeHttpConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPort(instance.getPort()); 
            this.validationEnabled = validationEnabled; 
    }

    public KafkaBridgeHttpConfig build(){
            KafkaBridgeHttpConfig buildable = new KafkaBridgeHttpConfig(fluent.getPort());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaBridgeHttpConfigBuilder that = (KafkaBridgeHttpConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
