package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public class KafkaBridgeClientSpecFluentImpl<A extends KafkaBridgeClientSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaBridgeClientSpecFluent<A>{

    private Map<String,Object> config;

    public KafkaBridgeClientSpecFluentImpl(){
    }
    public KafkaBridgeClientSpecFluentImpl(KafkaBridgeClientSpec instance){
            this.withConfig(instance.getConfig());

    }

    public A addToConfig(String key,Object value){
            if(this.config == null && key != null && value != null) { this.config = new LinkedHashMap<String,Object>(); }
            if(key != null && value != null) {this.config.put(key, value);} return (A)this;
    }

    public A addToConfig(Map<String,Object> map){
            if(this.config == null && map != null) { this.config = new LinkedHashMap<String,Object>(); }
            if(map != null) { this.config.putAll(map);} return (A)this;
    }

    public A removeFromConfig(String key){
            if(this.config == null) { return (A) this; }
            if(key != null && this.config != null) {this.config.remove(key);} return (A)this;
    }

    public A removeFromConfig(Map<String,Object> map){
            if(this.config == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.config != null){this.config.remove(key);}}} return (A)this;
    }

    public Map<String,Object> getConfig(){
            return this.config;
    }

    public A withConfig(Map<String,Object> config){
            if (config == null) { this.config =  null;} else {this.config = new LinkedHashMap<String,Object>(config);} return (A) this;
    }

    public Boolean hasConfig(){
            return this.config != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            KafkaBridgeClientSpecFluentImpl that = (KafkaBridgeClientSpecFluentImpl) o;
            if (config != null ? !config.equals(that.config) :that.config != null) return false;
            return true;
    }




}
