package io.strimzi.api.kafka.model;

import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class KafkaAuthorizationSimpleFluentImpl<A extends KafkaAuthorizationSimpleFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaAuthorizationSimpleFluent<A>{

    private List<String> superUsers;

    public KafkaAuthorizationSimpleFluentImpl(){
    }
    public KafkaAuthorizationSimpleFluentImpl(KafkaAuthorizationSimple instance){
            this.withSuperUsers(instance.getSuperUsers());

    }

    public A addToSuperUsers(int index,String item){
            if (this.superUsers == null) {this.superUsers = new ArrayList<String>();}
            this.superUsers.add(index, item);
            return (A)this;
    }

    public A setToSuperUsers(int index,String item){
            if (this.superUsers == null) {this.superUsers = new ArrayList<String>();}
            this.superUsers.set(index, item); return (A)this;
    }

    public A addToSuperUsers(String... items){
            if (this.superUsers == null) {this.superUsers = new ArrayList<String>();}
            for (String item : items) {this.superUsers.add(item);} return (A)this;
    }

    public A addAllToSuperUsers(Collection<String> items){
            if (this.superUsers == null) {this.superUsers = new ArrayList<String>();}
            for (String item : items) {this.superUsers.add(item);} return (A)this;
    }

    public A removeFromSuperUsers(String... items){
            for (String item : items) {if (this.superUsers!= null){ this.superUsers.remove(item);}} return (A)this;
    }

    public A removeAllFromSuperUsers(Collection<String> items){
            for (String item : items) {if (this.superUsers!= null){ this.superUsers.remove(item);}} return (A)this;
    }

    public List<String> getSuperUsers(){
            return this.superUsers;
    }

    public String getSuperUser(int index){
            return this.superUsers.get(index);
    }

    public String getFirstSuperUser(){
            return this.superUsers.get(0);
    }

    public String getLastSuperUser(){
            return this.superUsers.get(superUsers.size() - 1);
    }

    public String getMatchingSuperUser(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: superUsers) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingSuperUser(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: superUsers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withSuperUsers(List<String> superUsers){
            if (this.superUsers != null) { _visitables.get("superUsers").removeAll(this.superUsers);}
            if (superUsers != null) {this.superUsers = new ArrayList<String>(); for (String item : superUsers){this.addToSuperUsers(item);}} else { this.superUsers = null;} return (A) this;
    }

    public A withSuperUsers(String... superUsers){
            if (this.superUsers != null) {this.superUsers.clear();}
            if (superUsers != null) {for (String item :superUsers){ this.addToSuperUsers(item);}} return (A) this;
    }

    public Boolean hasSuperUsers(){
            return superUsers != null && !superUsers.isEmpty();
    }

    public A addNewSuperUser(String arg1){
            return (A)addToSuperUsers(new String(arg1));
    }

    public A addNewSuperUser(StringBuilder arg1){
            return (A)addToSuperUsers(new String(arg1));
    }

    public A addNewSuperUser(StringBuffer arg1){
            return (A)addToSuperUsers(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            KafkaAuthorizationSimpleFluentImpl that = (KafkaAuthorizationSimpleFluentImpl) o;
            if (superUsers != null ? !superUsers.equals(that.superUsers) :that.superUsers != null) return false;
            return true;
    }




}
