package io.strimzi.api.kafka.model;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public class JvmOptionsFluentImpl<A extends JvmOptionsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements JvmOptionsFluent<A>{

    private String xmx;
    private String xms;
    private Boolean server;
    private boolean gcLoggingEnabled;
    private Map<String,String> xx;

    public JvmOptionsFluentImpl(){
    }
    public JvmOptionsFluentImpl(JvmOptions instance){
            this.withXmx(instance.getXmx());

            this.withXms(instance.getXms());

            this.withServer(instance.isServer());

            this.withGcLoggingEnabled(instance.isGcLoggingEnabled());

            this.withXx(instance.getXx());

    }

    public String getXmx(){
            return this.xmx;
    }

    public A withXmx(String xmx){
            this.xmx=xmx; return (A) this;
    }

    public Boolean hasXmx(){
            return this.xmx != null;
    }

    public A withNewXmx(String arg1){
            return (A)withXmx(new String(arg1));
    }

    public A withNewXmx(StringBuilder arg1){
            return (A)withXmx(new String(arg1));
    }

    public A withNewXmx(StringBuffer arg1){
            return (A)withXmx(new String(arg1));
    }

    public String getXms(){
            return this.xms;
    }

    public A withXms(String xms){
            this.xms=xms; return (A) this;
    }

    public Boolean hasXms(){
            return this.xms != null;
    }

    public A withNewXms(String arg1){
            return (A)withXms(new String(arg1));
    }

    public A withNewXms(StringBuilder arg1){
            return (A)withXms(new String(arg1));
    }

    public A withNewXms(StringBuffer arg1){
            return (A)withXms(new String(arg1));
    }

    public Boolean isServer(){
            return this.server;
    }

    public A withServer(Boolean server){
            this.server=server; return (A) this;
    }

    public Boolean hasServer(){
            return this.server != null;
    }

    public A withNewServer(String arg1){
            return (A)withServer(new Boolean(arg1));
    }

    public A withNewServer(boolean arg1){
            return (A)withServer(new Boolean(arg1));
    }

    public boolean isGcLoggingEnabled(){
            return this.gcLoggingEnabled;
    }

    public A withGcLoggingEnabled(boolean gcLoggingEnabled){
            this.gcLoggingEnabled=gcLoggingEnabled; return (A) this;
    }

    public Boolean hasGcLoggingEnabled(){
            return true;
    }

    public A addToXx(String key,String value){
            if(this.xx == null && key != null && value != null) { this.xx = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.xx.put(key, value);} return (A)this;
    }

    public A addToXx(Map<String,String> map){
            if(this.xx == null && map != null) { this.xx = new LinkedHashMap<String,String>(); }
            if(map != null) { this.xx.putAll(map);} return (A)this;
    }

    public A removeFromXx(String key){
            if(this.xx == null) { return (A) this; }
            if(key != null && this.xx != null) {this.xx.remove(key);} return (A)this;
    }

    public A removeFromXx(Map<String,String> map){
            if(this.xx == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.xx != null){this.xx.remove(key);}}} return (A)this;
    }

    public Map<String,String> getXx(){
            return this.xx;
    }

    public A withXx(Map<String,String> xx){
            if (xx == null) { this.xx =  null;} else {this.xx = new LinkedHashMap<String,String>(xx);} return (A) this;
    }

    public Boolean hasXx(){
            return this.xx != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            JvmOptionsFluentImpl that = (JvmOptionsFluentImpl) o;
            if (xmx != null ? !xmx.equals(that.xmx) :that.xmx != null) return false;
            if (xms != null ? !xms.equals(that.xms) :that.xms != null) return false;
            if (server != null ? !server.equals(that.server) :that.server != null) return false;
            if (gcLoggingEnabled != that.gcLoggingEnabled) return false;
            if (xx != null ? !xx.equals(that.xx) :that.xx != null) return false;
            return true;
    }




}
