package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class JvmOptionsBuilder extends JvmOptionsFluentImpl<JvmOptionsBuilder> implements VisitableBuilder<JvmOptions,JvmOptionsBuilder>{

    JvmOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public JvmOptionsBuilder(){
            this(true);
    }
    public JvmOptionsBuilder(Boolean validationEnabled){
            this(new JvmOptions(), validationEnabled);
    }
    public JvmOptionsBuilder(JvmOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public JvmOptionsBuilder(JvmOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new JvmOptions(), validationEnabled);
    }
    public JvmOptionsBuilder(JvmOptionsFluent<?> fluent,JvmOptions instance){
            this(fluent, instance, true);
    }
    public JvmOptionsBuilder(JvmOptionsFluent<?> fluent,JvmOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withXmx(instance.getXmx());

            fluent.withXms(instance.getXms());

            fluent.withServer(instance.isServer());

            fluent.withGcLoggingEnabled(instance.isGcLoggingEnabled());

            fluent.withXx(instance.getXx());

            this.validationEnabled = validationEnabled; 
    }
    public JvmOptionsBuilder(JvmOptions instance){
            this(instance,true);
    }
    public JvmOptionsBuilder(JvmOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withXmx(instance.getXmx());

            this.withXms(instance.getXms());

            this.withServer(instance.isServer());

            this.withGcLoggingEnabled(instance.isGcLoggingEnabled());

            this.withXx(instance.getXx());

            this.validationEnabled = validationEnabled; 
    }

    public JvmOptions build(){
            JvmOptions buildable = new JvmOptions();
            buildable.setXmx(fluent.getXmx());
            buildable.setXms(fluent.getXms());
            buildable.setServer(fluent.isServer());
            buildable.setGcLoggingEnabled(fluent.isGcLoggingEnabled());
            buildable.setXx(fluent.getXx());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            JvmOptionsBuilder that = (JvmOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
