package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class InlineLoggingBuilder extends InlineLoggingFluentImpl<InlineLoggingBuilder> implements VisitableBuilder<InlineLogging,InlineLoggingBuilder>{

    InlineLoggingFluent<?> fluent;
    Boolean validationEnabled;

    public InlineLoggingBuilder(){
            this(true);
    }
    public InlineLoggingBuilder(Boolean validationEnabled){
            this(new InlineLogging(), validationEnabled);
    }
    public InlineLoggingBuilder(InlineLoggingFluent<?> fluent){
            this(fluent, true);
    }
    public InlineLoggingBuilder(InlineLoggingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new InlineLogging(), validationEnabled);
    }
    public InlineLoggingBuilder(InlineLoggingFluent<?> fluent,InlineLogging instance){
            this(fluent, instance, true);
    }
    public InlineLoggingBuilder(InlineLoggingFluent<?> fluent,InlineLogging instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLoggers(instance.getLoggers());

            this.validationEnabled = validationEnabled; 
    }
    public InlineLoggingBuilder(InlineLogging instance){
            this(instance,true);
    }
    public InlineLoggingBuilder(InlineLogging instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLoggers(instance.getLoggers());

            this.validationEnabled = validationEnabled; 
    }

    public InlineLogging build(){
            InlineLogging buildable = new InlineLogging();
            buildable.setLoggers(fluent.getLoggers());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            InlineLoggingBuilder that = (InlineLoggingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
