package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GenericSecretSourceBuilder extends GenericSecretSourceFluentImpl<GenericSecretSourceBuilder> implements VisitableBuilder<GenericSecretSource,GenericSecretSourceBuilder>{

    GenericSecretSourceFluent<?> fluent;
    Boolean validationEnabled;

    public GenericSecretSourceBuilder(){
            this(true);
    }
    public GenericSecretSourceBuilder(Boolean validationEnabled){
            this(new GenericSecretSource(), validationEnabled);
    }
    public GenericSecretSourceBuilder(GenericSecretSourceFluent<?> fluent){
            this(fluent, true);
    }
    public GenericSecretSourceBuilder(GenericSecretSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new GenericSecretSource(), validationEnabled);
    }
    public GenericSecretSourceBuilder(GenericSecretSourceFluent<?> fluent,GenericSecretSource instance){
            this(fluent, instance, true);
    }
    public GenericSecretSourceBuilder(GenericSecretSourceFluent<?> fluent,GenericSecretSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSecretName(instance.getSecretName());

            fluent.withKey(instance.getKey());

            this.validationEnabled = validationEnabled; 
    }
    public GenericSecretSourceBuilder(GenericSecretSource instance){
            this(instance,true);
    }
    public GenericSecretSourceBuilder(GenericSecretSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSecretName(instance.getSecretName());

            this.withKey(instance.getKey());

            this.validationEnabled = validationEnabled; 
    }

    public GenericSecretSource build(){
            GenericSecretSource buildable = new GenericSecretSource();
            buildable.setSecretName(fluent.getSecretName());
            buildable.setKey(fluent.getKey());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            GenericSecretSourceBuilder that = (GenericSecretSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
