package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class EntityOperatorJvmOptionsFluentImpl<A extends EntityOperatorJvmOptionsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements EntityOperatorJvmOptionsFluent<A>{

    private boolean gcLoggingEnabled;

    public EntityOperatorJvmOptionsFluentImpl(){
    }
    public EntityOperatorJvmOptionsFluentImpl(EntityOperatorJvmOptions instance){
            this.withGcLoggingEnabled(instance.isGcLoggingEnabled());

    }

    public boolean isGcLoggingEnabled(){
            return this.gcLoggingEnabled;
    }

    public A withGcLoggingEnabled(boolean gcLoggingEnabled){
            this.gcLoggingEnabled=gcLoggingEnabled; return (A) this;
    }

    public Boolean hasGcLoggingEnabled(){
            return true;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            EntityOperatorJvmOptionsFluentImpl that = (EntityOperatorJvmOptionsFluentImpl) o;
            if (gcLoggingEnabled != that.gcLoggingEnabled) return false;
            return true;
    }




}
