package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EntityOperatorJvmOptionsBuilder extends EntityOperatorJvmOptionsFluentImpl<EntityOperatorJvmOptionsBuilder> implements VisitableBuilder<EntityOperatorJvmOptions,EntityOperatorJvmOptionsBuilder>{

    EntityOperatorJvmOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public EntityOperatorJvmOptionsBuilder(){
            this(true);
    }
    public EntityOperatorJvmOptionsBuilder(Boolean validationEnabled){
            this(new EntityOperatorJvmOptions(), validationEnabled);
    }
    public EntityOperatorJvmOptionsBuilder(EntityOperatorJvmOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public EntityOperatorJvmOptionsBuilder(EntityOperatorJvmOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new EntityOperatorJvmOptions(), validationEnabled);
    }
    public EntityOperatorJvmOptionsBuilder(EntityOperatorJvmOptionsFluent<?> fluent,EntityOperatorJvmOptions instance){
            this(fluent, instance, true);
    }
    public EntityOperatorJvmOptionsBuilder(EntityOperatorJvmOptionsFluent<?> fluent,EntityOperatorJvmOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withGcLoggingEnabled(instance.isGcLoggingEnabled());

            this.validationEnabled = validationEnabled; 
    }
    public EntityOperatorJvmOptionsBuilder(EntityOperatorJvmOptions instance){
            this(instance,true);
    }
    public EntityOperatorJvmOptionsBuilder(EntityOperatorJvmOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withGcLoggingEnabled(instance.isGcLoggingEnabled());

            this.validationEnabled = validationEnabled; 
    }

    public EntityOperatorJvmOptions build(){
            EntityOperatorJvmOptions buildable = new EntityOperatorJvmOptions();
            buildable.setGcLoggingEnabled(fluent.isGcLoggingEnabled());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EntityOperatorJvmOptionsBuilder that = (EntityOperatorJvmOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
