package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CertificateAuthorityBuilder extends CertificateAuthorityFluentImpl<CertificateAuthorityBuilder> implements VisitableBuilder<CertificateAuthority,CertificateAuthorityBuilder>{

    CertificateAuthorityFluent<?> fluent;
    Boolean validationEnabled;

    public CertificateAuthorityBuilder(){
            this(true);
    }
    public CertificateAuthorityBuilder(Boolean validationEnabled){
            this(new CertificateAuthority(), validationEnabled);
    }
    public CertificateAuthorityBuilder(CertificateAuthorityFluent<?> fluent){
            this(fluent, true);
    }
    public CertificateAuthorityBuilder(CertificateAuthorityFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CertificateAuthority(), validationEnabled);
    }
    public CertificateAuthorityBuilder(CertificateAuthorityFluent<?> fluent,CertificateAuthority instance){
            this(fluent, instance, true);
    }
    public CertificateAuthorityBuilder(CertificateAuthorityFluent<?> fluent,CertificateAuthority instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withValidityDays(instance.getValidityDays());

            fluent.withGenerateCertificateAuthority(instance.isGenerateCertificateAuthority());

            fluent.withRenewalDays(instance.getRenewalDays());

            fluent.withCertificateExpirationPolicy(instance.getCertificateExpirationPolicy());

            this.validationEnabled = validationEnabled; 
    }
    public CertificateAuthorityBuilder(CertificateAuthority instance){
            this(instance,true);
    }
    public CertificateAuthorityBuilder(CertificateAuthority instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withValidityDays(instance.getValidityDays());

            this.withGenerateCertificateAuthority(instance.isGenerateCertificateAuthority());

            this.withRenewalDays(instance.getRenewalDays());

            this.withCertificateExpirationPolicy(instance.getCertificateExpirationPolicy());

            this.validationEnabled = validationEnabled; 
    }

    public CertificateAuthority build(){
            CertificateAuthority buildable = new CertificateAuthority();
            buildable.setValidityDays(fluent.getValidityDays());
            buildable.setGenerateCertificateAuthority(fluent.isGenerateCertificateAuthority());
            buildable.setRenewalDays(fluent.getRenewalDays());
            buildable.setCertificateExpirationPolicy(fluent.getCertificateExpirationPolicy());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CertificateAuthorityBuilder that = (CertificateAuthorityBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
