package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CertAndKeySecretSourceBuilder extends CertAndKeySecretSourceFluentImpl<CertAndKeySecretSourceBuilder> implements VisitableBuilder<CertAndKeySecretSource,CertAndKeySecretSourceBuilder>{

    CertAndKeySecretSourceFluent<?> fluent;
    Boolean validationEnabled;

    public CertAndKeySecretSourceBuilder(){
            this(true);
    }
    public CertAndKeySecretSourceBuilder(Boolean validationEnabled){
            this(new CertAndKeySecretSource(), validationEnabled);
    }
    public CertAndKeySecretSourceBuilder(CertAndKeySecretSourceFluent<?> fluent){
            this(fluent, true);
    }
    public CertAndKeySecretSourceBuilder(CertAndKeySecretSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new CertAndKeySecretSource(), validationEnabled);
    }
    public CertAndKeySecretSourceBuilder(CertAndKeySecretSourceFluent<?> fluent,CertAndKeySecretSource instance){
            this(fluent, instance, true);
    }
    public CertAndKeySecretSourceBuilder(CertAndKeySecretSourceFluent<?> fluent,CertAndKeySecretSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withKey(instance.getKey());

            fluent.withSecretName(instance.getSecretName());

            fluent.withCertificate(instance.getCertificate());

            this.validationEnabled = validationEnabled; 
    }
    public CertAndKeySecretSourceBuilder(CertAndKeySecretSource instance){
            this(instance,true);
    }
    public CertAndKeySecretSourceBuilder(CertAndKeySecretSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withKey(instance.getKey());

            this.withSecretName(instance.getSecretName());

            this.withCertificate(instance.getCertificate());

            this.validationEnabled = validationEnabled; 
    }

    public CertAndKeySecretSource build(){
            CertAndKeySecretSource buildable = new CertAndKeySecretSource();
            buildable.setSecretName(fluent.getSecretName());
            buildable.setCertificate(fluent.getCertificate());
            buildable.setKey(fluent.getKey());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CertAndKeySecretSourceBuilder that = (CertAndKeySecretSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
