/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.api.kafka.model.KafkaConnect;
import io.strimzi.test.k8s.KubeClusterException;
import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class KafkaConnectCrdIT
extends AbstractCrdIT {
    public static final String NAMESPACE = "kafkaconnect-crd-it";

    @Test
    void testKafkaConnectV1alpha1() {
        this.assumeKube1_11Plus();
        this.createDelete(KafkaConnect.class, "KafkaConnectV1alpha1.yaml");
    }

    @Test
    void testKafkaConnectV1beta1() {
        this.createDelete(KafkaConnect.class, "KafkaConnectV1beta1.yaml");
    }

    @Test
    void testKafkaConnectMinimal() {
        this.createDelete(KafkaConnect.class, "KafkaConnect-minimal.yaml");
    }

    @Test
    void testKafkaConnectWithExtraProperty() {
        this.createDelete(KafkaConnect.class, "KafkaConnect-with-extra-property.yaml");
    }

    @Test
    void testKafkaConnectWithMissingRequired() {
        try {
            this.createDelete(KafkaConnect.class, "KafkaConnect-with-missing-required-property.yaml");
        }
        catch (KubeClusterException.InvalidResource e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("spec.bootstrapServers in body is required"));
        }
    }

    @Test
    void testKafkaConnectWithInvalidReplicas() {
        try {
            this.createDelete(KafkaConnect.class, "KafkaConnect-with-invalid-replicas.yaml");
        }
        catch (KubeClusterException.InvalidResource e) {
            Assert.assertTrue((boolean)e.getMessage().contains("spec.replicas in body must be of type integer: \"string\""));
        }
    }

    @Test
    void testKafkaConnectWithTls() {
        this.createDelete(KafkaConnect.class, "KafkaConnect-with-tls.yaml");
    }

    @Test
    void testKafkaConnectWithTlsAuth() {
        this.createDelete(KafkaConnect.class, "KafkaConnect-with-tls-auth.yaml");
    }

    @Test
    void testKafkaConnectWithTlsAuthWithMissingRequired() {
        try {
            this.createDelete(KafkaConnect.class, "KafkaConnect-with-tls-auth-with-missing-required.yaml");
        }
        catch (KubeClusterException.InvalidResource e) {
            Assert.assertTrue((boolean)e.getMessage().contains("spec.authentication.certificateAndKey.certificate in body is required"));
            Assert.assertTrue((boolean)e.getMessage().contains("spec.authentication.certificateAndKey.key in body is required"));
        }
    }

    @Test
    void testKafkaConnectWithScramSha512Auth() {
        this.createDelete(KafkaConnect.class, "KafkaConnect-with-scram-sha-512-auth.yaml");
    }

    @Test
    public void testKafkaConnectWithTemplate() {
        this.createDelete(KafkaConnect.class, "KafkaConnect-with-template.yaml");
    }

    @Test
    public void testKafkaConnectWithExternalConfiguration() {
        this.createDelete(KafkaConnect.class, "KafkaConnect-with-external-configuration.yaml");
    }

    @Test
    public void testKafkaConnectWithInvalidExternalConfiguration() {
        try {
            this.createDelete(KafkaConnect.class, "KafkaConnect-with-invalid-external-configuration.yaml");
        }
        catch (KubeClusterException.InvalidResource e) {
            Assert.assertTrue((boolean)e.getMessage().contains("spec.externalConfiguration.env.valueFrom in body is required"));
        }
    }

    @BeforeAll
    void setupEnvironment() {
        this.createNamespace(NAMESPACE);
        this.createCustomResources(new String[]{"../install/cluster-operator/041-Crd-kafkaconnect.yaml"});
    }

    @AfterAll
    void teardownEnvironment() {
        this.deleteCustomResources();
        this.deleteNamespaces();
    }
}

