/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.JvmOptions;
import io.strimzi.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class JvmOptionsTest {
    @Test
    public void testXmxXms() {
        JvmOptions opts = (JvmOptions)TestUtils.fromJson((String)"{  \"-Xmx\": \"2g\",  \"-Xms\": \"1g\"}", JvmOptions.class);
        Assert.assertEquals((Object)"1g", (Object)opts.getXms());
        Assert.assertEquals((Object)"2g", (Object)opts.getXmx());
    }

    @Test
    public void testEmptyXmxXms() {
        JvmOptions opts = (JvmOptions)TestUtils.fromJson((String)"{}", JvmOptions.class);
        Assert.assertNull((Object)opts.getXms());
        Assert.assertNull((Object)opts.getXmx());
    }

    @Test
    public void testServer() {
        JvmOptions opts = (JvmOptions)TestUtils.fromJson((String)"{  \"-server\": \"true\"}", JvmOptions.class);
        Assert.assertTrue((boolean)opts.isServer());
        opts = (JvmOptions)TestUtils.fromJson((String)"{  \"-server\": true}", JvmOptions.class);
        Assert.assertTrue((boolean)opts.isServer());
        opts = (JvmOptions)TestUtils.fromJson((String)"{  \"-server\": \"false\"}", JvmOptions.class);
        Assert.assertFalse((boolean)opts.isServer());
        opts = (JvmOptions)TestUtils.fromJson((String)"{}", JvmOptions.class);
        Assert.assertNull((Object)opts.isServer());
    }

    @Test
    public void testXx() {
        JvmOptions opts = (JvmOptions)TestUtils.fromJson((String)"{    \"-XX\":            {\"key1\": \"value1\",            \"key2\": \"value2\",            \"key3\": \"true\",            \"key4\": true,            \"key5\": 10}}", JvmOptions.class);
        Assert.assertEquals((Object)TestUtils.map((Object[])new String[]{"key1", "value1", "key2", "value2", "key3", "true", "key4", "true", "key5", "10"}), (Object)opts.getXx());
    }
}

