/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.test;

import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.TimeZone;
import org.apache.logging.log4j.core.util.CronExpression;
import org.junit.Assert;
import org.junit.Test;

public class CronTest {
    @Test
    public void testHoursRangeEveryDay() throws ParseException {
        CronExpression cronExpression = new CronExpression("* * 14-15 * * ?");
        Date d = Date.from(LocalDateTime.of(2018, 11, 26, 13, 59, 0).atZone(ZoneId.systemDefault()).toInstant());
        Assert.assertFalse((boolean)cronExpression.isSatisfiedBy(d));
        d = Date.from(LocalDateTime.of(2018, 11, 26, 14, 0, 0).atZone(ZoneId.systemDefault()).toInstant());
        Assert.assertTrue((boolean)cronExpression.isSatisfiedBy(d));
        d = Date.from(LocalDateTime.of(2018, 11, 26, 15, 59, 0).atZone(ZoneId.systemDefault()).toInstant());
        Assert.assertTrue((boolean)cronExpression.isSatisfiedBy(d));
        d = Date.from(LocalDateTime.of(2018, 11, 26, 16, 0, 1).atZone(ZoneId.systemDefault()).toInstant());
        Assert.assertFalse((boolean)cronExpression.isSatisfiedBy(d));
    }

    @Test
    public void testHoursRangeOnWeekend() throws ParseException {
        CronExpression cronExpression = new CronExpression("* * 14-15 ? * 1,7");
        Date d = Date.from(LocalDateTime.of(2018, 11, 24, 14, 0, 0).atZone(ZoneId.systemDefault()).toInstant());
        Assert.assertTrue((boolean)cronExpression.isSatisfiedBy(d));
        d = Date.from(LocalDateTime.of(2018, 11, 25, 14, 0, 0).atZone(ZoneId.systemDefault()).toInstant());
        Assert.assertTrue((boolean)cronExpression.isSatisfiedBy(d));
        for (int day = 26; day <= 30; ++day) {
            d = Date.from(LocalDateTime.of(2018, 11, day, 14, 0, 0).atZone(ZoneId.systemDefault()).toInstant());
            Assert.assertFalse((boolean)cronExpression.isSatisfiedBy(d));
        }
    }

    @Test
    public void testUserTimeZoneVsPodTimeZone() throws ParseException {
        CronExpression cronExpression = new CronExpression("* * 14-15 * * ?");
        cronExpression.setTimeZone(TimeZone.getTimeZone(ZoneId.of("Europe/Rome")));
        Date d = Date.from(LocalDateTime.of(2018, 11, 26, 8, 0, 0).atZone(ZoneId.of("Pacific/Easter")).toInstant());
        Assert.assertTrue((boolean)cronExpression.isSatisfiedBy(d));
    }

    @Test
    public void testUtcTimeZone() throws ParseException {
        CronExpression cronExpression = new CronExpression("* * 14-15 * * ?");
        cronExpression.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date d = Date.from(LocalDateTime.of(2018, 11, 26, 9, 0, 0).atZone(ZoneId.of("Pacific/Easter")).toInstant());
        Assert.assertTrue((boolean)cronExpression.isSatisfiedBy(d));
    }
}

