/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.Resources;
import io.strimzi.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class ResourcesTest {
    @Test
    public void testDeserializeInts() {
        Resources opts = (Resources)TestUtils.fromJson((String)"{\"limits\": {\"memory\": 10737418240}, \"requests\": {\"memory\": 5000000000}}", Resources.class);
        Assert.assertEquals((long)0x280000000L, (long)opts.getLimits().memoryAsLong());
        Assert.assertEquals((long)5000000000L, (long)opts.getRequests().memoryAsLong());
    }

    @Test
    public void testDeserializeDefaults() {
        Resources opts = (Resources)TestUtils.fromJson((String)"{\"limits\": {\"memory\": 10737418240}, \"requests\": {} }", Resources.class);
        Assert.assertEquals((long)0x280000000L, (long)opts.getLimits().memoryAsLong());
        Assert.assertEquals((long)0L, (long)opts.getRequests().memoryAsLong());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDeserializeInvalidMemory() {
        TestUtils.fromJson((String)"{\"limits\": {\"memory\": \"foo\"}, \"requests\": {\"memory\": bar}}", Resources.class);
    }
}

