/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.Quantities;
import org.junit.Assert;
import org.junit.Test;

public class QuantitiesTest {
    @Test
    public void testParseMemory() {
        Assert.assertEquals((long)1234L, (long)Quantities.parseMemory((String)"1234"));
        Assert.assertEquals((long)0L, (long)Quantities.parseMemory((String)"0"));
        Assert.assertEquals((long)1000L, (long)Quantities.parseMemory((String)"1K"));
        Assert.assertEquals((long)1024L, (long)Quantities.parseMemory((String)"1Ki"));
        Assert.assertEquals((long)524288L, (long)Quantities.parseMemory((String)"512Ki"));
        Assert.assertEquals((long)1000000L, (long)Quantities.parseMemory((String)"1e6"));
        Assert.assertEquals((long)0L, (long)Quantities.parseMemory((String)"0"));
        Assert.assertEquals((long)0L, (long)Quantities.parseMemory((String)"0K"));
        Assert.assertEquals((long)0L, (long)Quantities.parseMemory((String)"0e6"));
        try {
            Quantities.parseMemory((String)"-1K");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Quantities.parseMemory((String)"K");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Quantities.parseMemory((String)"1Kb");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Quantities.parseMemory((String)"foo");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFormatMemory() {
        Assert.assertEquals((Object)"0", (Object)Quantities.formatMemory((long)0L));
        Assert.assertEquals((Object)"1", (Object)Quantities.formatMemory((long)1L));
        Assert.assertEquals((Object)"1023", (Object)Quantities.formatMemory((long)1023L));
        Assert.assertEquals((Object)"1Ki", (Object)Quantities.formatMemory((long)1024L));
        Assert.assertEquals((Object)"1K", (Object)Quantities.formatMemory((long)1000L));
        Assert.assertEquals((Object)"2Ki", (Object)Quantities.formatMemory((long)2048L));
        Assert.assertEquals((Object)"2K", (Object)Quantities.formatMemory((long)2000L));
        Assert.assertEquals((Object)"2Mi", (Object)Quantities.formatMemory((long)0x200000L));
        Assert.assertEquals((Object)"4096K", (Object)Quantities.formatMemory((long)4096000L));
        Assert.assertEquals((Object)"4M", (Object)Quantities.formatMemory((long)4000000L));
        Assert.assertEquals((Object)"1E", (Object)Quantities.formatMemory((long)1000000000000000L));
        Assert.assertEquals((Object)"1000E", (Object)Quantities.formatMemory((long)1000000000000000000L));
        Assert.assertEquals((Object)"1Ei", (Object)Quantities.formatMemory((long)Quantities.parseMemory((String)"1Ei")));
        Assert.assertEquals((Object)"1024Ei", (Object)Quantities.formatMemory((long)Quantities.parseMemory((String)"1024Ei")));
    }

    @Test
    public void testNormalizeMemory() {
        Assert.assertEquals((Object)"1K", (Object)Quantities.normalizeMemory((String)"1K"));
        Assert.assertEquals((Object)"1Ki", (Object)Quantities.normalizeMemory((String)"1Ki"));
        Assert.assertEquals((Object)"1M", (Object)Quantities.normalizeMemory((String)"1M"));
        Assert.assertEquals((Object)"1Mi", (Object)Quantities.normalizeMemory((String)"1Mi"));
        Assert.assertEquals((Object)"12345", (Object)Quantities.normalizeMemory((String)"12345"));
    }

    @Test
    public void testParse() {
        Assert.assertEquals((long)1000L, (long)Quantities.parseCpuAsMilliCpus((String)"1"));
        Assert.assertEquals((long)1L, (long)Quantities.parseCpuAsMilliCpus((String)"1m"));
        Assert.assertEquals((long)500L, (long)Quantities.parseCpuAsMilliCpus((String)"0.5"));
        Assert.assertEquals((long)0L, (long)Quantities.parseCpuAsMilliCpus((String)"0"));
        Assert.assertEquals((long)0L, (long)Quantities.parseCpuAsMilliCpus((String)"0m"));
        Assert.assertEquals((long)0L, (long)Quantities.parseCpuAsMilliCpus((String)"0.0"));
        Assert.assertEquals((long)0L, (long)Quantities.parseCpuAsMilliCpus((String)"0.000001"));
        try {
            Quantities.parseCpuAsMilliCpus((String)"0.0m");
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            Quantities.parseCpuAsMilliCpus((String)"0.1m");
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testFormat() {
        Assert.assertEquals((Object)"1", (Object)Quantities.formatMilliCpu((int)1000));
        Assert.assertEquals((Object)"500m", (Object)Quantities.formatMilliCpu((int)500));
        Assert.assertEquals((Object)"1m", (Object)Quantities.formatMilliCpu((int)1));
    }

    @Test
    public void testRt() {
        Assert.assertEquals((Object)"1", (Object)Quantities.formatMilliCpu((int)Quantities.parseCpuAsMilliCpus((String)"1")));
        Assert.assertEquals((Object)"500m", (Object)Quantities.formatMilliCpu((int)Quantities.parseCpuAsMilliCpus((String)"500m")));
        Assert.assertEquals((Object)"1m", (Object)Quantities.formatMilliCpu((int)Quantities.parseCpuAsMilliCpus((String)"1m")));
    }

    @Test
    public void testNormalizeCpu() {
        Assert.assertEquals((Object)"1", (Object)Quantities.normalizeCpu((String)"1"));
        Assert.assertEquals((Object)"1", (Object)Quantities.normalizeCpu((String)"1000m"));
        Assert.assertEquals((Object)"500m", (Object)Quantities.normalizeCpu((String)"500m"));
        Assert.assertEquals((Object)"500m", (Object)Quantities.normalizeCpu((String)"0.5"));
        Assert.assertEquals((Object)"100m", (Object)Quantities.normalizeCpu((String)"0.1"));
        Assert.assertEquals((Object)"10m", (Object)Quantities.normalizeCpu((String)"0.01"));
        Assert.assertEquals((Object)"1m", (Object)Quantities.normalizeCpu((String)"0.001"));
    }
}

