/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.api.kafka.model.KafkaUser;
import io.strimzi.test.k8s.KubeClusterException;
import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class KafkaUserCrdIT
extends AbstractCrdIT {
    public static final String NAMESPACE = "kafkausercrd-it";

    @Test
    void testKafkaUser() {
        this.createDelete(KafkaUser.class, "KafkaUser.yaml");
    }

    @Test
    void testKafkaUserMinimal() {
        this.createDelete(KafkaUser.class, "KafkaUser-minimal.yaml");
    }

    @Test
    void testKafkaUserWithExtraProperty() {
        this.createDelete(KafkaUser.class, "KafkaUser-with-extra-property.yaml");
    }

    @Test
    void testKafkaUserWithMissingRequired() {
        try {
            this.createDelete(KafkaUser.class, "KafkaUser-with-missing-required.yaml");
        }
        catch (KubeClusterException.InvalidResource e) {
            Assert.assertTrue((boolean)e.getMessage().contains("spec.authentication in body is required"));
        }
    }

    @BeforeAll
    void setupEnvironment() {
        this.createNamespace(NAMESPACE);
        this.createCustomResources(new String[]{"../install/cluster-operator/044-Crd-kafkauser.yaml"});
    }

    @AfterAll
    void teardownEnvironment() {
        this.deleteCustomResources();
        this.deleteNamespaces();
    }
}

