/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.api.kafka.model.KafkaTopic;
import io.strimzi.test.k8s.KubeClusterException;
import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class KafkaTopicCrdIT
extends AbstractCrdIT {
    public static final String NAMESPACE = "topiccrd-it";

    @Test
    void testKafkaTopic() {
        this.createDelete(KafkaTopic.class, "KafkaTopic.yaml");
    }

    @Test
    void testKafkaTopicMinimal() {
        this.createDelete(KafkaTopic.class, "KafkaTopic-minimal.yaml");
    }

    @Test
    void testKafkaTopicWithExtraProperty() {
        this.createDelete(KafkaTopic.class, "KafkaTopic-with-extra-property.yaml");
    }

    @Test
    void testKafkaTopicWithMissingProperty() {
        try {
            this.createDelete(KafkaTopic.class, "KafkaTopic-with-missing-required-property.yaml");
        }
        catch (KubeClusterException.InvalidResource e) {
            Assert.assertTrue((boolean)e.getMessage().contains("spec.partitions in body is required"));
            Assert.assertTrue((boolean)e.getMessage().contains("spec.replicas in body is required"));
        }
    }

    @BeforeAll
    void setupEnvironment() {
        this.createNamespace(NAMESPACE);
        this.createCustomResources(new String[]{"../install/cluster-operator/043-Crd-kafkatopic.yaml"});
    }

    @AfterAll
    void teardownEnvironment() {
        this.deleteCustomResources();
        this.deleteNamespaces();
    }
}

