/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.api.kafka.model.KafkaMirrorMaker;
import io.strimzi.test.k8s.KubeClusterException;
import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class KafkaMirrorMakerCrdIT
extends AbstractCrdIT {
    public static final String NAMESPACE = "kafkamirrormaker-crd-it";

    @Test
    void testKafkaMirrorMaker() {
        this.createDelete(KafkaMirrorMaker.class, "KafkaMirrorMaker.yaml");
    }

    @Test
    void testKafkaMirrorMakerMinimal() {
        this.createDelete(KafkaMirrorMaker.class, "KafkaMirrorMaker-minimal.yaml");
    }

    @Test
    void testKafkaMirrorMakerWithExtraProperty() {
        this.createDelete(KafkaMirrorMaker.class, "KafkaMirrorMaker-with-extra-property.yaml");
    }

    @Test
    void testKafkaMirrorMakerWithMissingRequired() {
        try {
            this.createDelete(KafkaMirrorMaker.class, "KafkaMirrorMaker-with-missing-required-property.yaml");
        }
        catch (KubeClusterException.InvalidResource e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("spec.consumer.bootstrapServers in body is required"));
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("spec.producer in body is required"));
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("spec.whitelist in body is required"));
        }
    }

    @Test
    void testKafkaMirrorMakerWithTls() {
        this.createDelete(KafkaMirrorMaker.class, "KafkaMirrorMaker-with-tls.yaml");
    }

    @Test
    void testKafkaMirrorMakerWithTlsAuth() {
        this.createDelete(KafkaMirrorMaker.class, "KafkaMirrorMaker-with-tls-auth.yaml");
    }

    @Test
    void testKafkaMirrorMakerWithTlsAuthWithMissingRequired() {
        try {
            this.createDelete(KafkaMirrorMaker.class, "KafkaMirrorMaker-with-tls-auth-with-missing-required.yaml");
        }
        catch (KubeClusterException.InvalidResource e) {
            Assert.assertTrue((boolean)e.getMessage().contains("spec.producer.authentication.certificateAndKey.certificate in body is required"));
            Assert.assertTrue((boolean)e.getMessage().contains("spec.producer.authentication.certificateAndKey.key in body is required"));
        }
    }

    @Test
    void testKafkaMirrorMakerWithScramSha512Auth() {
        this.createDelete(KafkaMirrorMaker.class, "KafkaMirrorMaker-with-scram-sha-512-auth.yaml");
    }

    @Test
    void testKafkaMirrorMakerWithTemplate() {
        this.createDelete(KafkaMirrorMaker.class, "KafkaMirrorMaker-with-template.yaml");
    }

    @BeforeAll
    void setupEnvironment() {
        this.createNamespace(NAMESPACE);
        this.createCustomResources(new String[]{"../install/cluster-operator/045-Crd-kafkamirrormaker.yaml"});
    }

    @AfterAll
    void teardownEnvironment() {
        this.deleteCustomResources();
        this.deleteNamespaces();
    }
}

