/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.AbstractCrdIT;
import io.strimzi.api.kafka.model.Kafka;
import io.strimzi.test.extensions.StrimziExtension;
import io.strimzi.test.k8s.KubeClusterException;
import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={StrimziExtension.class})
public class KafkaCrdIT
extends AbstractCrdIT {
    public static final String NAMESPACE = "kafkacrd-it";

    @Test
    void testKafka() {
        this.createDelete(Kafka.class, "Kafka.yaml");
    }

    @Test
    void testKafkaMinimal() {
        this.createDelete(Kafka.class, "Kafka-minimal.yaml");
    }

    @Test
    void testKafkaWithExtraProperty() {
        this.createDelete(Kafka.class, "Kafka-with-extra-property.yaml");
    }

    @Test
    void testKafkaWithMissingRequired() {
        try {
            this.createDelete(Kafka.class, "Kafka-with-missing-required-property.yaml");
        }
        catch (KubeClusterException.InvalidResource e) {
            Assert.assertTrue((boolean)e.getMessage().contains("spec.zookeeper in body is required"));
            Assert.assertTrue((boolean)e.getMessage().contains("spec.kafka in body is required"));
        }
    }

    @Test
    void testKafkaWithInvalidResourceMemory() {
        try {
            this.createDelete(Kafka.class, "Kafka-with-invalid-resource-memory.yaml");
        }
        catch (KubeClusterException.InvalidResource e) {
            Assert.assertTrue((boolean)e.getMessage().contains("spec.kafka.resources.limits.memory in body should match '[0-9]+([kKmMgGtTpPeE]i?)?$'"));
        }
    }

    @Test
    public void testKafkaWithEntityOperator() {
        this.createDelete(Kafka.class, "Kafka-with-entity-operator.yaml");
    }

    @Test
    public void testKafkaWithMaintenance() {
        this.createDelete(Kafka.class, "Kafka-with-maintenance.yaml");
    }

    @Test
    public void testKafkaWithNullMaintenance() {
        try {
            this.createDelete(Kafka.class, "Kafka-with-null-maintenance.yaml");
        }
        catch (KubeClusterException.InvalidResource e) {
            Assert.assertTrue((boolean)e.getMessage().contains("spec.maintenanceTimeWindows in body must be of type string: \"null\""));
        }
    }

    @Test
    public void testKafkaWithTemplate() {
        this.createDelete(Kafka.class, "Kafka-with-template.yaml");
    }

    @Test
    public void testKafkaWithTlsSidecarWithCustomConfiguration() {
        this.createDelete(Kafka.class, "Kafka-with-tls-sidecar-with-custom-configuration.yaml");
    }

    @Test
    public void testKafkaWithTlsSidecarWithInvalidLogLevel() {
        try {
            this.createDelete(Kafka.class, "Kafka-with-tls-sidecar-invalid-loglevel.yaml");
        }
        catch (KubeClusterException.InvalidResource e) {
            Assert.assertTrue((boolean)e.getMessage().contains("spec.kafka.tlsSidecar.logLevel in body should be one of [emerg alert crit err warning notice info debug]"));
        }
    }

    @Test
    public void testKafkaWithJbodStorage() {
        this.createDelete(Kafka.class, "Kafka-with-jbod-storage.yaml");
    }

    @Test
    public void testKafkaWithJbodStorageOnZookeeper() {
        try {
            this.createDelete(Kafka.class, "Kafka-with-jbod-storage-on-zookeeper.yaml");
        }
        catch (KubeClusterException.InvalidResource e) {
            Assert.assertTrue((boolean)e.getMessage().contains("spec.zookeeper.storage.type in body should be one of [ephemeral persistent-claim]"));
        }
    }

    @Test
    public void testKafkaWithInvalidStorage() {
        try {
            this.createDelete(Kafka.class, "Kafka-with-invalid-storage.yaml");
        }
        catch (KubeClusterException.InvalidResource e) {
            Assert.assertTrue((boolean)e.getMessage().contains("spec.kafka.storage.type in body should be one of [ephemeral persistent-claim jbod]"));
        }
    }

    @BeforeAll
    void setupEnvironment() {
        this.createNamespace(NAMESPACE);
        this.createCustomResources(new String[]{"../install/cluster-operator/040-Crd-kafka.yaml"});
    }

    @AfterAll
    void teardownEnvironment() {
        this.deleteCustomResources();
        this.deleteNamespaces();
    }
}

