/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.CustomResource;
import io.strimzi.test.TestUtils;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractCrdTest<R extends CustomResource, T> {
    private final Class<R> crdClass;
    private final String kind;
    private final Class<T> visitorClass;

    protected AbstractCrdTest(Class<R> crdClass, Class<T> visitorClass) {
        this.crdClass = crdClass;
        this.visitorClass = visitorClass;
        try {
            this.kind = ((CustomResource)crdClass.newInstance()).getKind();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    protected void assertDesiredResource(R k, String resource) throws IOException {
        String content = TestUtils.readResource(this.getClass(), (String)resource);
        if (content != null) {
            String ssStr = TestUtils.toYamlString(k);
            Assert.assertEquals((Object)content.trim(), (Object)ssStr.trim());
        } else {
            Assert.fail((String)("The resource " + resource + " does not exist"));
        }
    }

    @Test
    public void roundTrip() throws IOException {
        String resourceName = this.crdClass.getSimpleName() + ".yaml";
        CustomResource model = (CustomResource)TestUtils.fromYaml((String)resourceName, this.crdClass);
        Assert.assertNotNull((String)("The classpath resource " + resourceName + " does not exist"), (Object)model);
        ObjectMeta metadata = model.getMetadata();
        Assert.assertNotNull((Object)metadata);
        this.assertDesiredResource(model, this.crdClass.getSimpleName() + ".out.yaml");
        this.assertDesiredResource((CustomResource)TestUtils.fromYamlString((String)TestUtils.toYamlString((Object)model), this.crdClass), this.crdClass.getSimpleName() + ".out.yaml");
    }
}

