/*
 * Decompiled with CFR 0.152.
 */
package io.soabase.guice;

import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.dropwizard.Configuration;
import io.dropwizard.setup.Environment;
import io.soabase.guice.InjectorProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class StandardInjectorProvider<T extends Configuration>
implements InjectorProvider<T> {
    private final Module[] modules;

    public StandardInjectorProvider(Module ... modules) {
        this.modules = modules != null ? Arrays.copyOf(modules, modules.length) : new Module[]{};
    }

    @Override
    public Injector get(T configuration, Environment environment, Module additionalModule) {
        ArrayList localModules = Lists.newArrayList();
        Collections.addAll(localModules, this.modules);
        if (additionalModule != null) {
            localModules.add(additionalModule);
        }
        return Guice.createInjector((Iterable)localModules);
    }
}

