/*
 * Decompiled with CFR 0.152.
 */
package io.soabase.guice;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import io.dropwizard.setup.Environment;
import io.soabase.core.SoaBundle;
import io.soabase.core.SoaFeatures;
import io.soabase.core.SoaInfo;
import io.soabase.core.features.ExecutorBuilder;
import io.soabase.core.features.attributes.DynamicAttributes;
import io.soabase.core.features.discovery.Discovery;
import io.soabase.core.features.discovery.deployment.DeploymentGroupManager;
import java.lang.annotation.Annotation;

public class SoaIntegrationModule
extends AbstractModule {
    private final Environment environment;

    public SoaIntegrationModule(Environment environment) {
        this.environment = environment;
    }

    protected void configure() {
        SoaFeatures features = SoaBundle.getFeatures((Environment)this.environment);
        this.bind(SoaFeatures.class).toInstance((Object)features);
        if (features.getDiscovery() != null) {
            this.bind(Discovery.class).toInstance((Object)features.getDiscovery());
        }
        if (features.getAttributes() != null) {
            this.bind(DynamicAttributes.class).toInstance((Object)features.getAttributes());
        }
        if (features.getSoaInfo() != null) {
            this.bind(SoaInfo.class).toInstance((Object)features.getSoaInfo());
        }
        if (features.getExecutorBuilder() != null) {
            this.bind(ExecutorBuilder.class).toInstance((Object)features.getExecutorBuilder());
        }
        if (features.getDeploymentGroupManager() != null) {
            this.bind(DeploymentGroupManager.class).toInstance((Object)features.getDeploymentGroupManager());
        }
        for (Class clazz : features.getClasses()) {
            for (String name : features.getNames(clazz)) {
                Object named = features.getNamed(clazz, name);
                this.bind(clazz).annotatedWith((Annotation)Names.named((String)name)).toInstance(named);
                if (!name.equals("default")) continue;
                this.bind(clazz).toInstance(named);
            }
        }
    }
}

