/*
 * Decompiled with CFR 0.152.
 */
package io.soabase.guice;

import com.google.common.base.Preconditions;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import io.soabase.guice.InternalFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ServletScopes {
    public static final Scope REQUEST = new Scope(){

        public <T> Provider<T> scope(Key<T> key, final Provider<T> creator) {
            final String name = key.toString();
            return new Provider<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public T get() {
                    HttpServletRequest request;
                    InternalFilter filter = (InternalFilter)Preconditions.checkNotNull((Object)InternalFilter.get(), (Object)"Internal filter not set!");
                    HttpServletRequest httpServletRequest = request = filter.getServletRequest();
                    synchronized (httpServletRequest) {
                        Object obj = request.getAttribute(name);
                        if (NullObject.INSTANCE == obj) {
                            return null;
                        }
                        Object t = obj;
                        if (t == null) {
                            t = creator.get();
                            request.setAttribute(name, t != null ? t : NullObject.INSTANCE);
                        }
                        return t;
                    }
                }

                public String toString() {
                    return String.format("%s[%s]", creator, REQUEST);
                }
            };
        }

        public String toString() {
            return "ServletScopes.REQUEST";
        }
    };
    public static final Scope SESSION = new Scope(){

        public <T> Provider<T> scope(Key<T> key, final Provider<T> creator) {
            final String name = key.toString();
            return new Provider<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public T get() {
                    HttpSession session;
                    InternalFilter filter = (InternalFilter)Preconditions.checkNotNull((Object)InternalFilter.get(), (Object)"Internal filter not set!");
                    HttpSession httpSession = session = filter.getServletRequest().getSession();
                    synchronized (httpSession) {
                        Object obj = session.getAttribute(name);
                        if (NullObject.INSTANCE == obj) {
                            return null;
                        }
                        Object t = obj;
                        if (t == null) {
                            t = creator.get();
                            session.setAttribute(name, t != null ? t : NullObject.INSTANCE);
                        }
                        return t;
                    }
                }

                public String toString() {
                    return String.format("%s[%s]", creator, SESSION);
                }
            };
        }

        public String toString() {
            return "ServletScopes.SESSION";
        }
    };

    private ServletScopes() {
    }

    static enum NullObject {
        INSTANCE;

    }
}

