/*
 * Decompiled with CFR 0.152.
 */
package io.soabase.guice;

import com.google.common.collect.ImmutableList;
import com.google.inject.Key;
import com.google.inject.internal.UniqueAnnotations;
import io.soabase.guice.JerseyMultiGuiceModule;
import io.soabase.guice.ServletDefinition;
import io.soabase.guice.ServletKeyBindingBuilder;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServlet;

class ServletKeyBindingBuilderImpl
implements ServletKeyBindingBuilder {
    private final List<String> uriPatterns;
    private final JerseyMultiGuiceModule module;

    ServletKeyBindingBuilderImpl(JerseyMultiGuiceModule module, List<String> uriPatterns) {
        this.module = module;
        this.uriPatterns = ImmutableList.copyOf(uriPatterns);
    }

    @Override
    public void with(Class<? extends HttpServlet> servletKey) {
        this.with((Key<? extends HttpServlet>)Key.get(servletKey));
    }

    @Override
    public void with(Key<? extends HttpServlet> servletKey) {
        this.with(servletKey, new HashMap<String, String>());
    }

    @Override
    public void with(HttpServlet servlet) {
        this.with(servlet, new HashMap<String, String>());
    }

    @Override
    public void with(Class<? extends HttpServlet> servletKey, Map<String, String> initParams) {
        this.with((Key<? extends HttpServlet>)Key.get(servletKey), initParams);
    }

    @Override
    public void with(Key<? extends HttpServlet> servletKey, Map<String, String> initParams) {
        this.with(servletKey, initParams, null);
    }

    @Override
    public void with(HttpServlet servlet, Map<String, String> initParams) {
        Key servletKey = Key.get(HttpServlet.class, (Annotation)UniqueAnnotations.create());
        this.module.add((Key<HttpServlet>)servletKey, servlet);
        this.with((Key<? extends HttpServlet>)servletKey, initParams, servlet);
    }

    private void with(Key<? extends HttpServlet> servletKey, Map<String, String> initParams, HttpServlet servletInstance) {
        this.module.add(new ServletDefinition(this.uriPatterns, servletKey, initParams, servletInstance));
    }
}

