/*
 * Decompiled with CFR 0.152.
 */
package io.soabase.guice;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Key;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServlet;

class ServletDefinition {
    private final List<String> patterns;
    private final Key<? extends HttpServlet> servletKey;
    private final Map<String, String> initParams;
    private final HttpServlet servletInstance;

    ServletDefinition(List<String> patterns, Key<? extends HttpServlet> servletKey, Map<String, String> initParams, HttpServlet servletInstance) {
        this.patterns = ImmutableList.copyOf(patterns);
        this.servletKey = servletKey;
        this.initParams = ImmutableMap.copyOf((Map)Maps.newHashMap(initParams));
        this.servletInstance = servletInstance;
    }

    String[] getPatterns() {
        return this.patterns.toArray(new String[this.patterns.size()]);
    }

    Key<? extends HttpServlet> getServletKey() {
        return this.servletKey;
    }

    Map<String, String> getInitParams() {
        return this.initParams;
    }

    HttpServlet getServletInstance() {
        return this.servletInstance;
    }

    public String toString() {
        return "ServletDefinition{patterns=" + this.patterns + ", servletKey=" + this.servletKey + ", initParams=" + this.initParams + ", servletInstance=" + this.servletInstance + '}';
    }
}

