/*
 * Decompiled with CFR 0.152.
 */
package io.soabase.guice;

import com.google.inject.Provides;
import io.soabase.guice.InternalCommonConfig;
import io.soabase.guice.InternalFilter;
import io.soabase.guice.JerseyMultiGuiceModule;
import io.soabase.guice.RequestParameters;
import io.soabase.guice.RequestScoped;
import io.soabase.guice.ServletScopes;
import io.soabase.guice.SessionScoped;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ExtendedResourceContext;

public class JerseyGuiceModule
extends JerseyMultiGuiceModule {
    private final InternalCommonConfig commonConfig = new InternalCommonConfig();
    private final InternalFilter filter = new InternalFilter();

    public Configurable<?> configurable() {
        return this.commonConfig;
    }

    @Override
    void internalConfigure() {
        this.bind(InternalFilter.class).toInstance((Object)this.filter);
        this.bind(InternalCommonConfig.class).toInstance((Object)this.commonConfig);
        this.filter("/*").through(this.filter);
        this.bindScope(RequestScoped.class, ServletScopes.REQUEST);
        this.bindScope(SessionScoped.class, ServletScopes.SESSION);
    }

    @Provides
    @RequestScoped
    public HttpServletRequest provideHttpServletRequest() {
        return this.filter.getServletRequest();
    }

    @Provides
    @RequestScoped
    public HttpServletResponse provideHttpServletResponse() {
        return this.filter.getServletResponse();
    }

    @Provides
    @RequestScoped
    public ServletContext provideServletContext() {
        HttpServletRequest request = this.filter.getServletRequest();
        return request != null ? request.getServletContext() : null;
    }

    @Provides
    @RequestScoped
    public HttpSession provideHttpSession() {
        HttpServletRequest request = this.filter.getServletRequest();
        return request != null ? request.getSession() : null;
    }

    @Provides
    @RequestParameters
    @RequestScoped
    public Map<String, String[]> provideParameterMap() {
        HttpServletRequest request = this.filter.getServletRequest();
        return request != null ? request.getParameterMap() : null;
    }

    @Provides
    @RequestScoped
    public ContainerRequestContext providesContainerRequestContext() {
        return this.filter.getContainerRequestContext();
    }

    @Provides
    @RequestScoped
    public ExtendedResourceContext providesExtendedResourceContext() {
        return this.filter.getResourceContext();
    }

    @Provides
    @RequestScoped
    public ResourceContext providesResourceContext() {
        return this.filter.getResourceContext();
    }

    @Provides
    @RequestScoped
    public Request providesRequest() {
        return this.filter.getContainerRequestContext().getRequest();
    }

    @Provides
    @RequestScoped
    public UriInfo providesUriInfo() {
        ContainerRequestContext context = this.filter.getContainerRequestContext();
        return context != null ? context.getUriInfo() : null;
    }

    @Provides
    @RequestScoped
    public HttpHeaders providesHttpHeaders() {
        ContainerRequestContext context = this.filter.getContainerRequestContext();
        return context != null ? (ContainerRequest)context.getRequest() : null;
    }

    @Provides
    @RequestScoped
    public MessageBodyWorkers providesMessageBodyWorkers() {
        ContainerRequestContext context = this.filter.getContainerRequestContext();
        return context != null ? ((ContainerRequest)context.getRequest()).getWorkers() : null;
    }

    @Provides
    @RequestScoped
    public SecurityContext providesSecurityContext() {
        ContainerRequestContext context = this.filter.getContainerRequestContext();
        return context != null ? context.getSecurityContext() : null;
    }
}

