/*
 * Decompiled with CFR 0.152.
 */
package io.soabase.guice;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import org.glassfish.jersey.server.ExtendedResourceContext;

@PreMatching
class InternalFilter
implements Filter,
ContainerRequestFilter {
    private volatile HttpServletRequest servletRequest;
    private volatile HttpServletResponse servletResponse;
    private volatile ContainerRequestContext containerRequestContext;
    private static final ThreadLocal<InternalFilter> threadLocal = new ThreadLocal();
    @Context
    private volatile ExtendedResourceContext resourceContext;

    InternalFilter() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        this.containerRequestContext = requestContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.servletRequest = (HttpServletRequest)request;
        this.servletResponse = (HttpServletResponse)response;
        try {
            threadLocal.set(this);
            chain.doFilter(request, response);
        }
        finally {
            threadLocal.remove();
            this.servletRequest = null;
            this.servletResponse = null;
            this.containerRequestContext = null;
        }
    }

    public void destroy() {
    }

    static InternalFilter get() {
        return threadLocal.get();
    }

    ExtendedResourceContext getResourceContext() {
        return this.resourceContext;
    }

    ContainerRequestContext getContainerRequestContext() {
        return this.containerRequestContext;
    }

    HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    HttpServletResponse getServletResponse() {
        return this.servletResponse;
    }
}

