/*
 * Decompiled with CFR 0.152.
 */
package io.soabase.guice;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.configuration.ConfigurationFactory;
import io.dropwizard.configuration.ConfigurationFactoryFactory;
import io.dropwizard.jersey.DropwizardResourceConfig;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.soabase.guice.FilterDefinition;
import io.soabase.guice.GuiceBundleFeature;
import io.soabase.guice.InjectorProvider;
import io.soabase.guice.InternalCommonConfig;
import io.soabase.guice.InternalFilter;
import io.soabase.guice.ServletDefinition;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletRegistration;
import javax.servlet.http.HttpServlet;
import javax.validation.Validator;
import javax.ws.rs.Path;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.ServiceLocatorProvider;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;
import org.jvnet.hk2.guice.bridge.api.GuiceBridge;
import org.jvnet.hk2.guice.bridge.api.GuiceIntoHK2Bridge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiceBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private Injector injector = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final InjectorProvider<T> injectorProvider;
    private final DropwizardResourceConfig loggingConfig = new DropwizardResourceConfig(){

        public String getEndpointsInfo() {
            return "GuiceBundle - " + super.getEndpointsInfo();
        }
    };
    private static final Collection<Class<?>> componentClasses = ImmutableSet.of(ContainerRequestFilter.class, ContainerResponseFilter.class, ClientResponseFilter.class, ClientRequestFilter.class, DynamicFeature.class, ReaderInterceptor.class, (Object[])new Class[]{WriterInterceptor.class});

    public GuiceBundle(InjectorProvider<T> injectorProvider) {
        this.injectorProvider = injectorProvider;
    }

    public void initialize(Bootstrap<?> bootstrap) {
        final InjectableValues injectableValues = new InjectableValues(){

            public Object findInjectableValue(Object valueId, DeserializationContext ctxt, BeanProperty forProperty, Object beanInstance) {
                return null;
            }
        };
        final ConfigurationFactoryFactory configurationFactoryFactory = bootstrap.getConfigurationFactoryFactory();
        ConfigurationFactoryFactory factoryFactory = new ConfigurationFactoryFactory(){

            public ConfigurationFactory create(Class klass, Validator validator, ObjectMapper objectMapper, String propertyPrefix) {
                objectMapper.setInjectableValues(injectableValues);
                return configurationFactoryFactory.create(klass, validator, objectMapper, propertyPrefix);
            }
        };
        bootstrap.setConfigurationFactoryFactory(factoryFactory);
    }

    public void run(T configuration, final Environment environment) throws Exception {
        GuiceBundleFeature feature = new GuiceBundleFeature((Configuration)configuration){
            private final AtomicBoolean firstTime = new AtomicBoolean(true);
            final /* synthetic */ Configuration val$configuration;
            {
                this.val$configuration = configuration;
            }

            public boolean configure(FeatureContext context) {
                this.internalApply(context);
                return true;
            }

            private void internalApply(FeatureContext context) {
                ServiceLocator serviceLocator = ServiceLocatorProvider.getServiceLocator((FeatureContext)context);
                GuiceBridge.getGuiceBridge().initializeGuiceBridge(serviceLocator);
                GuiceIntoHK2Bridge guiceBridge = (GuiceIntoHK2Bridge)serviceLocator.getService(GuiceIntoHK2Bridge.class, new Annotation[0]);
                AbstractModule additionalModule = new AbstractModule(){

                    protected void configure() {
                        try {
                            Class.forName("io.soabase.core.SoaFeatures");
                            GuiceBundle.this.log.info("Installing SoaIntegrationModule");
                            Module soaIntegrationModule = (Module)Class.forName("io.soabase.guice.SoaIntegrationModule").getConstructor(Environment.class).newInstance(environment);
                            this.install(soaIntegrationModule);
                        }
                        catch (ClassNotFoundException ignore) {
                            GuiceBundle.this.log.info("SoaFeatures not available");
                        }
                        catch (Exception e) {
                            GuiceBundle.this.log.error("Could not instantiate SoaIntegrationModule", (Throwable)e);
                        }
                    }
                };
                Injector localInjector = GuiceBundle.this.getInjector(this.val$configuration, environment, (Module)additionalModule);
                guiceBridge.bridgeGuiceInjector(localInjector);
                if (this.firstTime.compareAndSet(true, false)) {
                    GuiceBundle.this.registerBoundJerseyComponents(localInjector, context, environment);
                }
            }
        };
        environment.jersey().register((Object)feature);
        ApplicationEventListener listener = new ApplicationEventListener(){

            public void onEvent(ApplicationEvent event) {
                if (event.getType() == ApplicationEvent.Type.INITIALIZATION_APP_FINISHED) {
                    GuiceBundle.this.loggingConfig.logComponents();
                }
            }

            public RequestEventListener onRequest(RequestEvent requestEvent) {
                return null;
            }
        };
        environment.jersey().register((Object)listener);
    }

    private void registerBoundJerseyComponents(Injector injector, FeatureContext context, Environment environment) {
        while (injector != null) {
            for (Key key : injector.getBindings().keySet()) {
                Type type = key.getTypeLiteral().getType();
                if (!(type instanceof Class)) continue;
                Class c = (Class)type;
                if (GuiceBundle.isProviderClass(c)) {
                    this.log.info(String.format("Registering %s as a provider class", c.getName()));
                    context.register(c);
                    this.loggingConfig.register(c);
                    continue;
                }
                if (GuiceBundle.isRootResourceClass(c)) {
                    this.log.info(String.format("Registering %s as a root resource class", c.getName()));
                    context.register(c);
                    this.loggingConfig.register(c);
                    continue;
                }
                if (componentClasses.contains(c)) {
                    this.log.info(String.format("Registering %s", c.getName()));
                    context.register(c);
                    this.loggingConfig.register(c);
                    continue;
                }
                if (FilterDefinition.class.equals((Object)c)) {
                    this.registerFilter(injector, environment, injector.getBinding(key));
                    this.loggingConfig.register(c);
                    continue;
                }
                if (ServletDefinition.class.equals((Object)c)) {
                    this.registerServlet(injector, environment, injector.getBinding(key));
                    this.loggingConfig.register(c);
                    continue;
                }
                if (InternalFilter.class.equals((Object)c)) {
                    this.log.debug("Registering internal filter");
                    context.register(injector.getBinding(key).getProvider().get());
                    this.loggingConfig.register(c);
                    continue;
                }
                if (!InternalCommonConfig.class.equals((Object)c)) continue;
                this.applyInternalCommonConfig(context, (InternalCommonConfig)injector.getBinding(key).getProvider().get());
                this.loggingConfig.register(c);
            }
            injector = injector.getParent();
        }
    }

    private synchronized Injector getInjector(T configuration, Environment environment, Module module) {
        if (this.injector == null) {
            this.injector = this.injectorProvider.get(configuration, environment, module);
        }
        return this.injector;
    }

    private void applyInternalCommonConfig(FeatureContext context, InternalCommonConfig internalCommonConfig) {
        for (Class<?> clazz : internalCommonConfig.getClasses()) {
            this.log.info(String.format("Registering %s as a component", clazz));
            context.register(clazz);
        }
        for (Object object : internalCommonConfig.getInstances()) {
            this.log.info(String.format("Registering instance of %s as a component", object.getClass()));
            context.register(object);
        }
        for (Map.Entry entry : internalCommonConfig.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            this.log.info(String.format("Registering property key: %s\tvalue: %s", key, value));
            context.property(key, value);
        }
    }

    private void registerServlet(Injector injector, Environment environment, Binding<?> binding) {
        ServletDefinition servletDefinition = (ServletDefinition)binding.getProvider().get();
        this.log.info("Registering servlet: " + servletDefinition);
        HttpServlet servletInstance = servletDefinition.getServletInstance();
        if (servletInstance == null) {
            servletInstance = (HttpServlet)injector.getInstance(servletDefinition.getServletKey());
        }
        ServletRegistration.Dynamic registration = environment.servlets().addServlet(servletDefinition.getServletKey().toString(), (Servlet)servletInstance);
        registration.setInitParameters(servletDefinition.getInitParams());
        registration.addMapping(servletDefinition.getPatterns());
    }

    private void registerFilter(Injector injector, Environment environment, Binding<?> binding) {
        FilterDefinition filterDefinition = (FilterDefinition)binding.getProvider().get();
        this.log.info("Registering filter: " + filterDefinition);
        Filter filterInstance = filterDefinition.getFilterInstance();
        if (filterInstance == null) {
            filterInstance = (Filter)injector.getInstance(filterDefinition.getFilterKey());
        }
        FilterRegistration.Dynamic registration = environment.servlets().addFilter(filterDefinition.getFilterKey().toString(), filterInstance);
        registration.setInitParameters(filterDefinition.getInitParams());
        registration.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, filterDefinition.getUriPatterns());
    }

    private static boolean isProviderClass(Class<?> c) {
        return c != null && c.isAnnotationPresent(Provider.class);
    }

    private static boolean isRootResourceClass(Class<?> c) {
        if (c == null) {
            return false;
        }
        if (c.isAnnotationPresent(Path.class)) {
            return true;
        }
        for (Class<?> clazz : c.getInterfaces()) {
            if (!clazz.isAnnotationPresent(Path.class)) continue;
            return true;
        }
        return false;
    }
}

