/*
 * Decompiled with CFR 0.152.
 */
package io.soabase.guice;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.Key;
import com.google.inject.internal.UniqueAnnotations;
import io.soabase.guice.FilterDefinition;
import io.soabase.guice.FilterKeyBindingBuilder;
import io.soabase.guice.JerseyMultiGuiceModule;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;

class FilterKeyBindingBuilderImpl
implements FilterKeyBindingBuilder {
    private final JerseyMultiGuiceModule module;
    private final List<String> uriPatterns;

    FilterKeyBindingBuilderImpl(JerseyMultiGuiceModule module, List<String> uriPatterns) {
        this.module = module;
        this.uriPatterns = ImmutableList.copyOf(uriPatterns);
    }

    @Override
    public void through(Class<? extends Filter> filterKey) {
        this.through((Key<? extends Filter>)Key.get(filterKey));
    }

    @Override
    public void through(Key<? extends Filter> filterKey) {
        this.through(filterKey, (Map<String, String>)Maps.newHashMap());
    }

    @Override
    public void through(Filter filter) {
        this.through(filter, (Map<String, String>)Maps.newHashMap());
    }

    @Override
    public void through(Class<? extends Filter> filterKey, Map<String, String> initParams) {
        this.through((Key<? extends Filter>)Key.get(filterKey), initParams);
    }

    @Override
    public void through(Key<? extends Filter> filterKey, Map<String, String> initParams) {
        this.through(filterKey, initParams, null);
    }

    @Override
    public void through(Filter filter, Map<String, String> initParams) {
        Key filterKey = Key.get(Filter.class, (Annotation)UniqueAnnotations.create());
        this.module.add((Key<Filter>)filterKey, filter);
        this.through((Key<? extends Filter>)filterKey, initParams, filter);
    }

    private void through(Key<? extends Filter> filterKey, Map<String, String> initParams, Filter filterInstance) {
        this.module.add(new FilterDefinition(this.uriPatterns, filterKey, initParams, filterInstance));
    }
}

