/*
 * Decompiled with CFR 0.152.
 */
package io.soabase.guice;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.Key;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;

class FilterDefinition {
    private final List<String> uriPatterns;
    private final Key<? extends Filter> filterKey;
    private final Filter filterInstance;
    private final Map<String, String> initParams;

    FilterDefinition(List<String> uriPatterns, Key<? extends Filter> filterKey, Map<String, String> initParams, Filter filterInstance) {
        this.uriPatterns = ImmutableList.copyOf(uriPatterns);
        this.filterKey = filterKey;
        this.filterInstance = filterInstance;
        this.initParams = Collections.unmodifiableMap(Maps.newHashMap(initParams));
    }

    String[] getUriPatterns() {
        return this.uriPatterns.toArray(new String[this.uriPatterns.size()]);
    }

    Key<? extends Filter> getFilterKey() {
        return this.filterKey;
    }

    Filter getFilterInstance() {
        return this.filterInstance;
    }

    Map<String, String> getInitParams() {
        return this.initParams;
    }

    public String toString() {
        return "FilterDefinition{uriPatterns=" + this.uriPatterns + ", filterKey=" + this.filterKey + ", filterInstance=" + this.filterInstance + ", initParams=" + this.initParams + '}';
    }
}

