/*
 * Decompiled with CFR 0.152.
 */
package io.smartdatalake.workflow.connection;

import com.github.takezoe.scaladoc.Scaladoc;
import com.snowflake.snowpark.Session;
import com.snowflake.snowpark.Session$;
import com.typesafe.config.Config;
import configs.ConfigKeyNaming;
import configs.ConfigReader;
import io.smartdatalake.config.ConfigHolder;
import io.smartdatalake.config.FromConfigFactory;
import io.smartdatalake.config.InstanceRegistry;
import io.smartdatalake.config.SdlConfigObject;
import io.smartdatalake.definitions.AuthMode;
import io.smartdatalake.definitions.BasicAuthMode;
import io.smartdatalake.definitions.Condition;
import io.smartdatalake.definitions.SaveModeOptions;
import io.smartdatalake.util.hdfs.SparkRepartitionDef;
import io.smartdatalake.util.misc.SmartDataLakeLogger;
import io.smartdatalake.util.secrets.SecretProviderConfig;
import io.smartdatalake.util.secrets.StringOrSecret;
import io.smartdatalake.workflow.AtlasExportable;
import io.smartdatalake.workflow.action.executionMode.ExecutionMode;
import io.smartdatalake.workflow.action.generic.transformer.GenericDfTransformer;
import io.smartdatalake.workflow.action.generic.transformer.GenericDfsTransformer;
import io.smartdatalake.workflow.action.script.ParsableScriptDef;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfCreatorConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfsTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomFileTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.SparkUDFCreatorConfig;
import io.smartdatalake.workflow.connection.Connection;
import io.smartdatalake.workflow.connection.ConnectionMetadata;
import io.smartdatalake.workflow.connection.SnowflakeConnection$;
import io.smartdatalake.workflow.dataframe.GenericSchema;
import io.smartdatalake.workflow.dataobject.Expectation;
import java.io.Serializable;
import java.sql.ResultSet;
import net.snowflake.spark.snowflake.Utils$;
import org.apache.spark.sql.streaming.OutputMode;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple7;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n * Connection information for Snowflake databases.\n * The connection can be used for SnowflakeTableDataObjects\n * If multiple SnowflakeTableDataObjects share a connection, they share the same Snowpark session\n *\n * @param id        unique id of this connection\n * @param url       snowflake connection url\n * @param warehouse Snowflake namespace\n * @param database  Snowflake database\n * @param role      Snowflake role\n * @param authMode  optional authentication information: for now BasicAuthMode is supported.\n * @param metadata  Connection metadata\n */")
@ScalaSignature(bytes="\u0006\u0001\t}f\u0001\u0002\u001b6\u0001zB\u0001b\u0016\u0001\u0003\u0016\u0004%\t\u0005\u0017\u0005\tW\u0002\u0011\t\u0012)A\u00053\"AA\u000e\u0001BK\u0002\u0013\u0005Q\u000e\u0003\u0005w\u0001\tE\t\u0015!\u0003o\u0011!9\bA!f\u0001\n\u0003i\u0007\u0002\u0003=\u0001\u0005#\u0005\u000b\u0011\u00028\t\u0011e\u0004!Q3A\u0005\u00025D\u0001B\u001f\u0001\u0003\u0012\u0003\u0006IA\u001c\u0005\tw\u0002\u0011)\u001a!C\u0001[\"AA\u0010\u0001B\tB\u0003%a\u000e\u0003\u0005~\u0001\tU\r\u0011\"\u0001\u007f\u0011%\tY\u0001\u0001B\tB\u0003%q\u0010\u0003\u0006\u0002\u000e\u0001\u0011)\u001a!C!\u0003\u001fA!\"!\b\u0001\u0005#\u0005\u000b\u0011BA\t\u0011\u001d\ty\u0002\u0001C\u0001\u0003CA\u0011\"a\r\u0001\u0005\u0004%I!!\u000e\t\u0011\u0005e\u0003\u0001)A\u0005\u0003oA\u0011\"a\u0017\u0001\u0001\u0004%I!!\u0018\t\u0013\u0005U\u0004\u00011A\u0005\n\u0005]\u0004\u0002CAB\u0001\u0001\u0006K!a\u0018\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002\b\"I\u0011\u0011\u0015\u0001\u0012\u0002\u0013\u0005\u00111\u0015\u0005\b\u0003s\u0003A\u0011AA^\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013Dq!!4\u0001\t\u0013\ty\rC\u0004\u0002T\u0002!\t%!6\t\u0013\u0005}\u0007!!A\u0005\u0002\u0005\u0005\b\"CAy\u0001E\u0005I\u0011AAz\u0011%\t9\u0010AI\u0001\n\u0003\tI\u0010C\u0005\u0002~\u0002\t\n\u0011\"\u0001\u0002z\"I\u0011q \u0001\u0012\u0002\u0013\u0005\u0011\u0011 \u0005\n\u0005\u0003\u0001\u0011\u0013!C\u0001\u0003sD\u0011Ba\u0001\u0001#\u0003%\tA!\u0002\t\u0013\t%\u0001!%A\u0005\u0002\t-\u0001\"\u0003B\b\u0001\u0005\u0005I\u0011\tB\t\u0011%\u00119\u0002AA\u0001\n\u0003\u0011I\u0002C\u0005\u0003\"\u0001\t\t\u0011\"\u0001\u0003$!I!Q\u0006\u0001\u0002\u0002\u0013\u0005#q\u0006\u0005\n\u0005o\u0001\u0011\u0011!C\u0001\u0005sA\u0011B!\u0010\u0001\u0003\u0003%\tEa\u0010\t\u0013\t\u0005\u0003!!A\u0005B\t\r\u0003\"\u0003B#\u0001\u0005\u0005I\u0011\tB$\u000f\u001d\u00119'\u000eE\u0001\u0005S2a\u0001N\u001b\t\u0002\t-\u0004bBA\u0010Y\u0011\u0005!Q\u000e\u0005\b\u0005_bC\u0011\tB9\u0011%\u0011y\tLA\u0001\n\u0003\u0013\t\nC\u0005\u0003\"2\n\n\u0011\"\u0001\u0003\f!I!1\u0015\u0017\u0002\u0002\u0013\u0005%Q\u0015\u0005\n\u0005gc\u0013\u0013!C\u0001\u0005\u0017A\u0011B!.-\u0003\u0003%IAa.\u0003'Mswn\u001e4mC.,7i\u001c8oK\u000e$\u0018n\u001c8\u000b\u0005Y:\u0014AC2p]:,7\r^5p]*\u0011\u0001(O\u0001\to>\u00148N\u001a7po*\u0011!hO\u0001\u000eg6\f'\u000f\u001e3bi\u0006d\u0017m[3\u000b\u0003q\n!![8\u0004\u0001M1\u0001aP#J#R\u0003\"\u0001Q\"\u000e\u0003\u0005S\u0011AQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\t\u0006\u0013a!\u00118z%\u00164\u0007C\u0001$H\u001b\u0005)\u0014B\u0001%6\u0005)\u0019uN\u001c8fGRLwN\u001c\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000bA!\\5tG*\u0011a*O\u0001\u0005kRLG.\u0003\u0002Q\u0017\n\u00192+\\1si\u0012\u000bG/\u0019'bW\u0016dunZ4feB\u0011\u0001IU\u0005\u0003'\u0006\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002A+&\u0011a+\u0011\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0003S\u0012,\u0012!\u0017\t\u00035\"t!aW3\u000f\u0005q\u001bgBA/c\u001d\tq\u0016-D\u0001`\u0015\t\u0001W(\u0001\u0004=e>|GOP\u0005\u0002y%\u0011!hO\u0005\u0003If\naaY8oM&<\u0017B\u00014h\u0003=\u0019F\r\\\"p]\u001aLwm\u00142kK\u000e$(B\u00013:\u0013\tI'N\u0001\u0007D_:tWm\u0019;j_:LEM\u0003\u0002gO\u0006\u0019\u0011\u000e\u001a\u0011\u0002\u0007U\u0014H.F\u0001o!\ty7O\u0004\u0002qcB\u0011a,Q\u0005\u0003e\u0006\u000ba\u0001\u0015:fI\u00164\u0017B\u0001;v\u0005\u0019\u0019FO]5oO*\u0011!/Q\u0001\u0005kJd\u0007%A\u0005xCJ,\u0007n\\;tK\u0006Qq/\u0019:fQ>,8/\u001a\u0011\u0002\u0011\u0011\fG/\u00192bg\u0016\f\u0011\u0002Z1uC\n\f7/\u001a\u0011\u0002\tI|G.Z\u0001\u0006e>dW\rI\u0001\tCV$\b.T8eKV\tq\u0010\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)!O\u0001\fI\u00164\u0017N\\5uS>t7/\u0003\u0003\u0002\n\u0005\r!\u0001C!vi\"lu\u000eZ3\u0002\u0013\u0005,H\u000f['pI\u0016\u0004\u0013\u0001C7fi\u0006$\u0017\r^1\u0016\u0005\u0005E\u0001#\u0002!\u0002\u0014\u0005]\u0011bAA\u000b\u0003\n1q\n\u001d;j_:\u00042ARA\r\u0013\r\tY\"\u000e\u0002\u0013\u0007>tg.Z2uS>tW*\u001a;bI\u0006$\u0018-A\u0005nKR\fG-\u0019;bA\u00051A(\u001b8jiz\"\u0002#a\t\u0002&\u0005\u001d\u0012\u0011FA\u0016\u0003[\ty#!\r\u0011\u0005\u0019\u0003\u0001\"B,\u0010\u0001\u0004I\u0006\"\u00027\u0010\u0001\u0004q\u0007\"B<\u0010\u0001\u0004q\u0007\"B=\u0010\u0001\u0004q\u0007\"B>\u0010\u0001\u0004q\u0007\"B?\u0010\u0001\u0004y\b\"CA\u0007\u001fA\u0005\t\u0019AA\t\u00039\u0019X\u000f\u001d9peR,G-Q;uQN,\"!a\u000e\u0011\r\u0005e\u0012qHA\"\u001b\t\tYDC\u0002\u0002>\u0005\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t%a\u000f\u0003\u0007M+\u0017\u000f\u0005\u0004\u0002F\u0005=\u00131K\u0007\u0003\u0003\u000fRA!!\u0013\u0002L\u0005!A.\u00198h\u0015\t\ti%\u0001\u0003kCZ\f\u0017\u0002BA)\u0003\u000f\u0012Qa\u00117bgN\u0004B!!\u0001\u0002V%!\u0011qKA\u0002\u00055\u0011\u0015m]5d\u0003V$\b.T8eK\u0006y1/\u001e9q_J$X\rZ!vi\"\u001c\b%\u0001\t`g:|w\u000f]1sWN+7o]5p]V\u0011\u0011q\f\t\u0006\u0001\u0006M\u0011\u0011\r\t\u0005\u0003G\n\t(\u0004\u0002\u0002f)!\u0011qMA5\u0003!\u0019hn\\<qCJ\\'\u0002BA6\u0003[\n\u0011b\u001d8po\u001ad\u0017m[3\u000b\u0005\u0005=\u0014aA2p[&!\u00111OA3\u0005\u001d\u0019Vm]:j_:\fAcX:o_^\u0004\u0018M]6TKN\u001c\u0018n\u001c8`I\u0015\fH\u0003BA=\u0003\u007f\u00022\u0001QA>\u0013\r\ti(\u0011\u0002\u0005+:LG\u000fC\u0005\u0002\u0002N\t\t\u00111\u0001\u0002`\u0005\u0019\u0001\u0010J\u0019\u0002#}\u001bhn\\<qCJ\\7+Z:tS>t\u0007%\u0001\ffq\u0016\u001c7K\\8xM2\f7.Z*uCR,W.\u001a8u)\u0019\tI)!&\u0002\u0018B!\u00111RAI\u001b\t\tiI\u0003\u0003\u0002\u0010\u0006-\u0013aA:rY&!\u00111SAG\u0005%\u0011Vm];miN+G\u000f\u0003\u0004\u0002\u0010V\u0001\rA\u001c\u0005\n\u00033+\u0002\u0013!a\u0001\u00037\u000bq\u0001\\8hO&tw\rE\u0002A\u0003;K1!a(B\u0005\u001d\u0011un\u001c7fC:\f\u0001%\u001a=fGNswn\u001e4mC.,7\u000b^1uK6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0015\u0016\u0005\u00037\u000b9k\u000b\u0002\u0002*B!\u00111VA[\u001b\t\tiK\u0003\u0003\u00020\u0006E\u0016!C;oG\",7m[3e\u0015\r\t\u0019,Q\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\\\u0003[\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003M9W\r^*o_^4G.Y6f\u001fB$\u0018n\u001c8t)\u0011\ti,a1\u0011\u000b=\fyL\u001c8\n\u0007\u0005\u0005WOA\u0002NCBDa!!2\u0018\u0001\u0004q\u0017AB:dQ\u0016l\u0017-\u0001\nhKR\u001cfn\\<qCJ\\7+Z:tS>tG\u0003BA1\u0003\u0017Da!!2\u0019\u0001\u0004q\u0017!F2sK\u0006$Xm\u00158poB\f'o[*fgNLwN\u001c\u000b\u0005\u0003C\n\t\u000e\u0003\u0004\u0002Ff\u0001\rA\\\u0001\bM\u0006\u001cGo\u001c:z+\t\t9\u000eE\u0003\u0002Z\u0006mW)D\u0001h\u0013\r\tin\u001a\u0002\u0012\rJ|WnQ8oM&<g)Y2u_JL\u0018\u0001B2paf$\u0002#a\t\u0002d\u0006\u0015\u0018q]Au\u0003W\fi/a<\t\u000f][\u0002\u0013!a\u00013\"9An\u0007I\u0001\u0002\u0004q\u0007bB<\u001c!\u0003\u0005\rA\u001c\u0005\bsn\u0001\n\u00111\u0001o\u0011\u001dY8\u0004%AA\u00029Dq!`\u000e\u0011\u0002\u0003\u0007q\u0010C\u0005\u0002\u000em\u0001\n\u00111\u0001\u0002\u0012\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA{U\rI\u0016qU\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tYPK\u0002o\u0003O\u000babY8qs\u0012\"WMZ1vYR$3'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%k\u0005q1m\u001c9zI\u0011,g-Y;mi\u00122TC\u0001B\u0004U\ry\u0018qU\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011iA\u000b\u0003\u0002\u0012\u0005\u001d\u0016!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\u0014A!\u0011Q\tB\u000b\u0013\r!\u0018qI\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u00057\u00012\u0001\u0011B\u000f\u0013\r\u0011y\"\u0011\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005K\u0011Y\u0003E\u0002A\u0005OI1A!\u000bB\u0005\r\te.\u001f\u0005\n\u0003\u0003+\u0013\u0011!a\u0001\u00057\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005c\u0001b!!\u000f\u00034\t\u0015\u0012\u0002\u0002B\u001b\u0003w\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111\u0014B\u001e\u0011%\t\tiJA\u0001\u0002\u0004\u0011)#\u0001\u0005iCND7i\u001c3f)\t\u0011Y\"\u0001\u0005u_N#(/\u001b8h)\t\u0011\u0019\"\u0001\u0004fcV\fGn\u001d\u000b\u0005\u00037\u0013I\u0005C\u0005\u0002\u0002*\n\t\u00111\u0001\u0003&!:\u0001A!\u0014\u0003b\t\r\u0004\u0003\u0002B(\u0005;j!A!\u0015\u000b\t\tM#QK\u0001\tg\u000e\fG.\u00193pG*!!q\u000bB-\u0003\u001d!\u0018m[3{_\u0016TAAa\u0017\u0002n\u00051q-\u001b;ik\nLAAa\u0018\u0003R\tA1kY1mC\u0012|7-A\u0003wC2,X-\t\u0002\u0003f\u0005!\tg\f\u0016+\u0015\u0001R\u0003eQ8o]\u0016\u001cG/[8oA%tgm\u001c:nCRLwN\u001c\u0011g_J\u00043K\\8xM2\f7.\u001a\u0011eCR\f'-Y:fg:R\u0001E\u000b\u0011UQ\u0016\u00043m\u001c8oK\u000e$\u0018n\u001c8!G\u0006t\u0007EY3!kN,G\r\t4pe\u0002\u001afn\\<gY\u0006\\W\rV1cY\u0016$\u0015\r^1PE*,7\r^:\u000bA)\u0002\u0013J\u001a\u0011nk2$\u0018\u000e\u001d7fAMswn\u001e4mC.,G+\u00192mK\u0012\u000bG/Y(cU\u0016\u001cGo\u001d\u0011tQ\u0006\u0014X\rI1!G>tg.Z2uS>tG\u0006\t;iKf\u00043\u000f[1sK\u0002\"\b.\u001a\u0011tC6,\u0007e\u00158poB\f'o\u001b\u0011tKN\u001c\u0018n\u001c8\u000bA)R\u0001E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011jI\u0002\u0002\u0003\u0005\t\u0011!A\u0001*h.[9vK\u0002JG\rI8gAQD\u0017n\u001d\u0011d_:tWm\u0019;j_:T\u0001E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011ve2\u0004\u0003\u0005\t\u0011!A\u0001\u001ahn\\<gY\u0006\\W\rI2p]:,7\r^5p]\u0002*(\u000f\u001c\u0006!U\u0001\u0002\u0005/\u0019:b[\u0002:\u0018M]3i_V\u001cX\rI*o_^4G.Y6fA9\fW.Z:qC\u000e,'\u0002\t\u0016!\u0001B\f'/Y7!I\u0006$\u0018MY1tK\u0002\u00023K\\8xM2\f7.\u001a\u0011eCR\f'-Y:f\u0015\u0001R\u0003\u0005\u00119be\u0006l\u0007E]8mK\u0002\u0002\u0003\u0005\t\u0011!':|wO\u001a7bW\u0016\u0004#o\u001c7f\u0015\u0001R\u0003\u0005\u00119be\u0006l\u0007%Y;uQ6{G-\u001a\u0011!_B$\u0018n\u001c8bY\u0002\nW\u000f\u001e5f]RL7-\u0019;j_:\u0004\u0013N\u001c4pe6\fG/[8ou\u00012wN\u001d\u0011o_^\u0004#)Y:jG\u0006+H\u000f['pI\u0016\u0004\u0013n\u001d\u0011tkB\u0004xN\u001d;fI:R\u0001E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011nKR\fG-\u0019;bA\u0001\u001auN\u001c8fGRLwN\u001c\u0011nKR\fG-\u0019;b\u0015\u0001Rs&A\nT]><h\r\\1lK\u000e{gN\\3di&|g\u000e\u0005\u0002GYM)AfPAl)R\u0011!\u0011N\u0001\u000bMJ|WnQ8oM&<G\u0003\u0002B:\u0005\u007f\"B!a\t\u0003v!9!q\u000f\u0018A\u0004\te\u0014\u0001E5ogR\fgnY3SK\u001eL7\u000f\u001e:z!\u0011\tINa\u001f\n\u0007\tutM\u0001\tJ]N$\u0018M\\2f%\u0016<\u0017n\u001d;ss\"1AM\fa\u0001\u0005\u0003\u0003BAa!\u0003\f6\u0011!Q\u0011\u0006\u0004I\n\u001d%\u0002\u0002BE\u0003[\n\u0001\u0002^=qKN\fg-Z\u0005\u0005\u0005\u001b\u0013)I\u0001\u0004D_:4\u0017nZ\u0001\u0006CB\u0004H.\u001f\u000b\u0011\u0003G\u0011\u0019J!&\u0003\u0018\ne%1\u0014BO\u0005?CQaV\u0018A\u0002eCQ\u0001\\\u0018A\u00029DQa^\u0018A\u00029DQ!_\u0018A\u00029DQa_\u0018A\u00029DQ!`\u0018A\u0002}D\u0011\"!\u00040!\u0003\u0005\r!!\u0005\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uI]\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003(\n=\u0006#\u0002!\u0002\u0014\t%\u0006c\u0003!\u0003,fsgN\u001c8\u0000\u0003#I1A!,B\u0005\u0019!V\u000f\u001d7fo!I!\u0011W\u0019\u0002\u0002\u0003\u0007\u00111E\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$s'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B]!\u0011\t)Ea/\n\t\tu\u0016q\t\u0002\u0007\u001f\nTWm\u0019;")
public class SnowflakeConnection
implements Connection,
SmartDataLakeLogger,
Product,
scala.Serializable {
    private final String id;
    private final String url;
    private final String warehouse;
    private final String database;
    private final String role;
    private final AuthMode authMode;
    private final Option<ConnectionMetadata> metadata;
    private final Seq<Class<BasicAuthMode>> supportedAuths;
    private Option<Session> _snowparkSession;
    private transient Logger logger;
    private Option<Config> _config;
    private volatile transient boolean bitmap$trans$0;

    public static Option<ConnectionMetadata> $lessinit$greater$default$7() {
        return SnowflakeConnection$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<Tuple7<SdlConfigObject.ConnectionId, String, String, String, String, AuthMode, Option<ConnectionMetadata>>> unapply(SnowflakeConnection snowflakeConnection) {
        return SnowflakeConnection$.MODULE$.unapply(snowflakeConnection);
    }

    public static Option<ConnectionMetadata> apply$default$7() {
        return SnowflakeConnection$.MODULE$.apply$default$7();
    }

    public static SnowflakeConnection apply(String string, String string2, String string3, String string4, String string5, AuthMode authMode, Option<ConnectionMetadata> option) {
        return SnowflakeConnection$.MODULE$.apply(string, string2, string3, string4, string5, authMode, option);
    }

    public static SnowflakeConnection fromConfig(Config config, InstanceRegistry instanceRegistry) {
        return SnowflakeConnection$.MODULE$.fromConfig(config, instanceRegistry);
    }

    @Scaladoc(value="/**\n   * A reader that reads [[StringOrSecret]] values.\n   */")
    public static ConfigReader<StringOrSecret> stringOrSecretReader() {
        return SnowflakeConnection$.MODULE$.stringOrSecretReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ExecutionMode]] values.\n   * Note that Expectation must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<ExecutionMode> executionModeReader() {
        return SnowflakeConnection$.MODULE$.executionModeReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[Connection]] values inside [[Agent]].\n   * Note that Connection must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<Connection> connectionDefReader() {
        return SnowflakeConnection$.MODULE$.connectionDefReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[Expectation]] values.\n   * Note that Expectation must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<Expectation> expectationReader() {
        return SnowflakeConnection$.MODULE$.expectationReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ParsableScriptDef]] values.\n   * Note that ParsableScriptDef must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<ParsableScriptDef> scriptDefReader() {
        return SnowflakeConnection$.MODULE$.scriptDefReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[GenericDfsTransformer]] values.\n   * Note that GenericDfsTransformer must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<GenericDfsTransformer> dfsTransformerReader() {
        return SnowflakeConnection$.MODULE$.dfsTransformerReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[GenericDfTransformer]] values.\n   * Note that GenericDfTransformer must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<GenericDfTransformer> dfTransformerReader() {
        return SnowflakeConnection$.MODULE$.dfTransformerReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ActionId]] values.\n   */")
    public static ConfigReader<SdlConfigObject.ActionId> actionIdReader() {
        return SnowflakeConnection$.MODULE$.actionIdReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[DataObjectId]] values.\n   */")
    public static ConfigReader<SdlConfigObject.DataObjectId> dataObjectIdReader() {
        return SnowflakeConnection$.MODULE$.dataObjectIdReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ConnectionId]] values.\n   */")
    public static ConfigReader<SdlConfigObject.ConnectionId> connectionIdReader() {
        return SnowflakeConnection$.MODULE$.connectionIdReader();
    }

    public static ConfigReader<Map<SdlConfigObject.DataObjectId, String>> mapDataObjectIdStringReader(ConfigReader<Map<String, String>> configReader) {
        return SnowflakeConnection$.MODULE$.mapDataObjectIdStringReader(configReader);
    }

    public static ConfigReader<SaveModeOptions> saveModeOptionsReader() {
        return SnowflakeConnection$.MODULE$.saveModeOptionsReader();
    }

    public static ConfigReader<AuthMode> authModeReader() {
        return SnowflakeConnection$.MODULE$.authModeReader();
    }

    public static ConfigReader<Condition> conditionReader() {
        return SnowflakeConnection$.MODULE$.conditionReader();
    }

    public static ConfigReader<SecretProviderConfig> secretProviderConfigReader() {
        return SnowflakeConnection$.MODULE$.secretProviderConfigReader();
    }

    public static ConfigReader<SparkRepartitionDef> sparkRepartitionDefReader() {
        return SnowflakeConnection$.MODULE$.sparkRepartitionDefReader();
    }

    public static ConfigReader<SparkUDFCreatorConfig> sparkUdfCreatorConfigReader() {
        return SnowflakeConnection$.MODULE$.sparkUdfCreatorConfigReader();
    }

    public static ConfigReader<CustomFileTransformerConfig> customFileTransformerConfigReader() {
        return SnowflakeConnection$.MODULE$.customFileTransformerConfigReader();
    }

    public static ConfigReader<CustomDfsTransformerConfig> customDfsTransformerConfigReader() {
        return SnowflakeConnection$.MODULE$.customDfsTransformerConfigReader();
    }

    public static ConfigReader<CustomDfTransformerConfig> customDfTransformerConfigReader() {
        return SnowflakeConnection$.MODULE$.customDfTransformerConfigReader();
    }

    public static ConfigReader<CustomDfCreatorConfig> customDfCreatorConfigReader() {
        return SnowflakeConnection$.MODULE$.customDfCreatorConfigReader();
    }

    @Scaladoc(value="/**\n   * A [[ConfigReader]] reader that reads [[OutputMode]].\n   */")
    public static ConfigReader<OutputMode> outputModeReader() {
        return SnowflakeConnection$.MODULE$.outputModeReader();
    }

    @Scaladoc(value="/**\n   * A [[ConfigReader]] reader that reads [[GenericSchema]] values.\n   *\n   * This reader parses a Spark [[StructType]] by using the desired schema provider.\n   * The schema provider is included in the configuration value as prefix terminated by '#'.\n   */")
    public static ConfigReader<GenericSchema> genericSchemaReader() {
        return SnowflakeConnection$.MODULE$.genericSchemaReader();
    }

    @Scaladoc(value="/**\n   * default naming strategy is to allow lowerCamelCase and hypen-separated key naming, and fail on superfluous keys\n   */")
    public static <A> ConfigKeyNaming<A> sdlDefaultNaming() {
        return SnowflakeConnection$.MODULE$.sdlDefaultNaming();
    }

    public void logAndThrowException(String msg, Exception e) {
        SmartDataLakeLogger.logAndThrowException$((SmartDataLakeLogger)this, (String)msg, (Exception)e);
    }

    public Exception logException(Exception e) {
        return SmartDataLakeLogger.logException$((SmartDataLakeLogger)this, (Exception)e);
    }

    public void logWithSeverity(Level severity, String msg, Throwable cause) {
        SmartDataLakeLogger.logWithSeverity$((SmartDataLakeLogger)this, (Level)severity, (String)msg, (Throwable)cause);
    }

    public String toStringShort() {
        return Connection.toStringShort$((Connection)this);
    }

    public String atlasName() {
        return Connection.atlasName$((Connection)this);
    }

    public String atlasQualifiedName(String prefix) {
        return AtlasExportable.atlasQualifiedName$((AtlasExportable)this, (String)prefix);
    }

    private Logger logger$lzycompute() {
        SnowflakeConnection snowflakeConnection = this;
        synchronized (snowflakeConnection) {
            if (!this.bitmap$trans$0) {
                this.logger = SmartDataLakeLogger.logger$((SmartDataLakeLogger)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Option<Config> _config() {
        return this._config;
    }

    public void _config_$eq(Option<Config> x$1) {
        this._config = x$1;
    }

    public String id() {
        return this.id;
    }

    public String url() {
        return this.url;
    }

    public String warehouse() {
        return this.warehouse;
    }

    public String database() {
        return this.database;
    }

    public String role() {
        return this.role;
    }

    public AuthMode authMode() {
        return this.authMode;
    }

    public Option<ConnectionMetadata> metadata() {
        return this.metadata;
    }

    private Seq<Class<BasicAuthMode>> supportedAuths() {
        return this.supportedAuths;
    }

    private Option<Session> _snowparkSession() {
        return this._snowparkSession;
    }

    private void _snowparkSession_$eq(Option<Session> x$1) {
        this._snowparkSession = x$1;
    }

    public ResultSet execSnowflakeStatement(String sql, boolean logging) {
        block0: {
            if (!logging) break block0;
            this.logger().info(new StringBuilder(27).append("(").append(new SdlConfigObject.ConnectionId(this.id())).append(") execSnowflakeStatement: ").append(sql).toString());
        }
        return Utils$.MODULE$.runQuery(this.getSnowflakeOptions(""), sql);
    }

    public boolean execSnowflakeStatement$default$2() {
        return true;
    }

    public Map<String, String> getSnowflakeOptions(String schema) {
        AuthMode authMode = this.authMode();
        if (!(authMode instanceof BasicAuthMode)) {
            throw new IllegalArgumentException(new StringBuilder(56).append("(").append(new SdlConfigObject.ConnectionId(this.id())).append(") No supported authMode given for Snowflake connection.").toString());
        }
        BasicAuthMode basicAuthMode = (BasicAuthMode)authMode;
        Map map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sfURL"), (Object)this.url()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sfUser"), (Object)basicAuthMode.userSecret().resolve()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sfPassword"), (Object)basicAuthMode.passwordSecret().resolve()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sfDatabase"), (Object)this.database()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sfRole"), (Object)this.role()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sfSchema"), (Object)schema), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sfWarehouse"), (Object)this.warehouse())}));
        return map;
    }

    public Session getSnowparkSession(String schema) {
        Option<Session> option = this._snowparkSession();
        synchronized (option) {
            if (this._snowparkSession().isEmpty()) {
                this._snowparkSession_$eq((Option<Session>)new Some((Object)this.createSnowparkSession(schema)));
            }
        }
        return (Session)this._snowparkSession().get();
    }

    private Session createSnowparkSession(String schema) {
        AuthMode authMode = this.authMode();
        if (!(authMode instanceof BasicAuthMode)) {
            throw new IllegalArgumentException(new StringBuilder(56).append("(").append(new SdlConfigObject.ConnectionId(this.id())).append(") No supported authMode given for Snowflake connection.").toString());
        }
        BasicAuthMode basicAuthMode = (BasicAuthMode)authMode;
        Session.SessionBuilder builder = Session$.MODULE$.builder().configs((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"URL"), (Object)this.url()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"USER"), (Object)basicAuthMode.userSecret().resolve()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PASSWORD"), (Object)basicAuthMode.passwordSecret().resolve()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ROLE"), (Object)this.role()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"WAREHOUSE"), (Object)this.warehouse()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DB"), (Object)this.database()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SCHEMA"), (Object)schema)})));
        Session session = builder.create();
        return session;
    }

    public FromConfigFactory<Connection> factory() {
        return SnowflakeConnection$.MODULE$;
    }

    public SnowflakeConnection copy(String id, String url, String warehouse, String database, String role, AuthMode authMode, Option<ConnectionMetadata> metadata) {
        return new SnowflakeConnection(id, url, warehouse, database, role, authMode, metadata);
    }

    public String copy$default$1() {
        return this.id();
    }

    public String copy$default$2() {
        return this.url();
    }

    public String copy$default$3() {
        return this.warehouse();
    }

    public String copy$default$4() {
        return this.database();
    }

    public String copy$default$5() {
        return this.role();
    }

    public AuthMode copy$default$6() {
        return this.authMode();
    }

    public Option<ConnectionMetadata> copy$default$7() {
        return this.metadata();
    }

    public String productPrefix() {
        return "SnowflakeConnection";
    }

    public int productArity() {
        return 7;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = new SdlConfigObject.ConnectionId(this.id());
                break;
            }
            case 1: {
                object = this.url();
                break;
            }
            case 2: {
                object = this.warehouse();
                break;
            }
            case 3: {
                object = this.database();
                break;
            }
            case 4: {
                object = this.role();
                break;
            }
            case 5: {
                object = this.authMode();
                break;
            }
            case 6: {
                object = this.metadata();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SnowflakeConnection;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SnowflakeConnection)) return false;
        boolean bl = true;
        if (!bl) return false;
        SnowflakeConnection snowflakeConnection = (SnowflakeConnection)x$1;
        String string = this.id();
        String string2 = snowflakeConnection.id();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.url();
        String string4 = snowflakeConnection.url();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = this.warehouse();
        String string6 = snowflakeConnection.warehouse();
        if (string5 == null) {
            if (string6 != null) {
                return false;
            }
        } else if (!string5.equals(string6)) return false;
        String string7 = this.database();
        String string8 = snowflakeConnection.database();
        if (string7 == null) {
            if (string8 != null) {
                return false;
            }
        } else if (!string7.equals(string8)) return false;
        String string9 = this.role();
        String string10 = snowflakeConnection.role();
        if (string9 == null) {
            if (string10 != null) {
                return false;
            }
        } else if (!string9.equals(string10)) return false;
        AuthMode authMode = this.authMode();
        AuthMode authMode2 = snowflakeConnection.authMode();
        if (authMode == null) {
            if (authMode2 != null) {
                return false;
            }
        } else if (!authMode.equals(authMode2)) return false;
        Option<ConnectionMetadata> option = this.metadata();
        Option<ConnectionMetadata> option2 = snowflakeConnection.metadata();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!snowflakeConnection.canEqual(this)) return false;
        return true;
    }

    public SnowflakeConnection(String id, String url, String warehouse, String database, String role, AuthMode authMode, Option<ConnectionMetadata> metadata) {
        this.id = id;
        this.url = url;
        this.warehouse = warehouse;
        this.database = database;
        this.role = role;
        this.authMode = authMode;
        this.metadata = metadata;
        ConfigHolder.$init$((ConfigHolder)this);
        SdlConfigObject.$init$((SdlConfigObject)this);
        AtlasExportable.$init$((AtlasExportable)this);
        Connection.$init$((Connection)this);
        SmartDataLakeLogger.$init$((SmartDataLakeLogger)this);
        Product.$init$((Product)this);
        this.supportedAuths = (Seq)new .colon.colon(BasicAuthMode.class, (List)Nil$.MODULE$);
        this._snowparkSession = None$.MODULE$;
        Predef$.MODULE$.require(this.supportedAuths().contains(authMode.getClass()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("(").append(new SdlConfigObject.ConnectionId(this.id())).append(") ").append(this.authMode().getClass().getSimpleName()).append(" not supported by ").append(this.getClass().getSimpleName()).append(". Supported auth modes are ").append(((TraversableOnce)this.supportedAuths().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getSimpleName(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append(".").toString());
    }
}

