/*
 * Decompiled with CFR 0.152.
 */
package io.smartdatalake.workflow.action.snowflake.transformer;

import com.github.takezoe.scaladoc.Scaladoc;
import com.snowflake.snowpark.DataFrame;
import com.snowflake.snowpark.Session;
import com.typesafe.config.Config;
import configs.ConfigKeyNaming;
import configs.ConfigReader;
import io.smartdatalake.config.ConfigHolder;
import io.smartdatalake.config.FromConfigFactory;
import io.smartdatalake.config.InstanceRegistry;
import io.smartdatalake.config.SdlConfigObject;
import io.smartdatalake.definitions.AuthMode;
import io.smartdatalake.definitions.Condition;
import io.smartdatalake.definitions.SaveModeOptions;
import io.smartdatalake.util.hdfs.PartitionValues;
import io.smartdatalake.util.hdfs.SparkRepartitionDef;
import io.smartdatalake.util.misc.CustomCodeUtil$;
import io.smartdatalake.util.secrets.SecretProviderConfig;
import io.smartdatalake.util.secrets.StringOrSecret;
import io.smartdatalake.workflow.ActionPipelineContext;
import io.smartdatalake.workflow.action.Action;
import io.smartdatalake.workflow.action.executionMode.ExecutionMode;
import io.smartdatalake.workflow.action.generic.transformer.GenericDfTransformer;
import io.smartdatalake.workflow.action.generic.transformer.GenericDfsTransformer;
import io.smartdatalake.workflow.action.generic.transformer.GenericDfsTransformerDef;
import io.smartdatalake.workflow.action.generic.transformer.OptionsGenericDfsTransformer;
import io.smartdatalake.workflow.action.generic.transformer.PartitionValueTransformer;
import io.smartdatalake.workflow.action.script.ParsableScriptDef;
import io.smartdatalake.workflow.action.snowflake.customlogic.CustomSnowparkDfsTransformer;
import io.smartdatalake.workflow.action.snowflake.transformer.ScalaClassSnowparkDfsTransformer$;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfCreatorConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfsTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomFileTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.SparkUDFCreatorConfig;
import io.smartdatalake.workflow.connection.Connection;
import io.smartdatalake.workflow.dataframe.GenericDataFrame;
import io.smartdatalake.workflow.dataframe.GenericSchema;
import io.smartdatalake.workflow.dataframe.snowflake.SnowparkDataFrame;
import io.smartdatalake.workflow.dataframe.snowflake.SnowparkDataFrame$;
import io.smartdatalake.workflow.dataframe.spark.SparkDataFrame;
import io.smartdatalake.workflow.dataobject.Expectation;
import io.smartdatalake.workflow.dataobject.SnowflakeTableDataObject;
import java.io.Serializable;
import org.apache.spark.sql.streaming.OutputMode;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n * Configuration of a custom Spark-DataFrame transformation between many inputs and many outputs (n:m)\n * Define a transform function which receives a map of input DataObjectIds with DataFrames and a map of options and as\n * to return a map of output DataObjectIds with DataFrames, see also trait [[CustomSnowparkDfsTransformer]].\n *\n * @param name           name of the transformer\n * @param description    Optional description of the transformer\n * @param className      class name implementing trait [[CustomSnowparkDfsTransformer]]\n * @param options        Options to pass to the transformation\n * @param runtimeOptions optional tuples of [key, spark sql expression] to be added as additional options when executing transformation.\n *                       The spark sql expressions are evaluated against an instance of [[DefaultExpressionData]].\n */")
@ScalaSignature(bytes="\u0006\u0001\tef\u0001\u0002\u00180\u0001rB\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\t;\u0002\u0011\t\u0012)A\u0005%\"Aa\f\u0001BK\u0002\u0013\u0005q\f\u0003\u0005d\u0001\tE\t\u0015!\u0003a\u0011!!\u0007A!f\u0001\n\u0003\t\u0006\u0002C3\u0001\u0005#\u0005\u000b\u0011\u0002*\t\u0011\u0019\u0004!Q3A\u0005\u0002\u001dD\u0001b\u001b\u0001\u0003\u0012\u0003\u0006I\u0001\u001b\u0005\tY\u0002\u0011)\u001a!C\u0001O\"AQ\u000e\u0001B\tB\u0003%\u0001\u000eC\u0003o\u0001\u0011\u0005q\u000eC\u0004x\u0001\t\u0007I\u0011\u0002=\t\r}\u0004\u0001\u0015!\u0003z\u0011\u001d\t\t\u0001\u0001C\u0001\u0003\u0007Aq!a\u001c\u0001\t\u0003\n\t\bC\u0004\u0002\u001e\u0002!\t%a(\t\u0013\u0005=\u0006!!A\u0005\u0002\u0005E\u0006\"CA_\u0001E\u0005I\u0011AA`\u0011%\t)\u000eAI\u0001\n\u0003\t9\u000eC\u0005\u0002\\\u0002\t\n\u0011\"\u0001\u0002@\"I\u0011Q\u001c\u0001\u0012\u0002\u0013\u0005\u0011q\u001c\u0005\n\u0003G\u0004\u0011\u0013!C\u0001\u0003?D\u0011\"!:\u0001\u0003\u0003%\t%a:\t\u0013\u0005]\b!!A\u0005\u0002\u0005e\b\"\u0003B\u0001\u0001\u0005\u0005I\u0011\u0001B\u0002\u0011%\u0011y\u0001AA\u0001\n\u0003\u0012\t\u0002C\u0005\u0003 \u0001\t\t\u0011\"\u0001\u0003\"!I!1\u0006\u0001\u0002\u0002\u0013\u0005#Q\u0006\u0005\n\u0005_\u0001\u0011\u0011!C!\u0005cA\u0011Ba\r\u0001\u0003\u0003%\tE!\u000e\b\u000f\tes\u0006#\u0001\u0003\\\u00191af\fE\u0001\u0005;BaA\u001c\u0011\u0005\u0002\t}\u0003b\u0002B1A\u0011\u0005#1\r\u0005\n\u0005\u0003\u0003\u0013\u0011!CA\u0005\u0007C\u0011Ba$!#\u0003%\t!a0\t\u0013\tE\u0005%%A\u0005\u0002\u0005]\u0007\"\u0003BJAE\u0005I\u0011AAp\u0011%\u0011)\nII\u0001\n\u0003\ty\u000eC\u0005\u0003\u0018\u0002\n\t\u0011\"!\u0003\u001a\"I!q\u0015\u0011\u0012\u0002\u0013\u0005\u0011q\u0018\u0005\n\u0005S\u0003\u0013\u0013!C\u0001\u0003/D\u0011Ba+!#\u0003%\t!a8\t\u0013\t5\u0006%%A\u0005\u0002\u0005}\u0007\"\u0003BXA\u0005\u0005I\u0011\u0002BY\u0005\u0001\u001a6-\u00197b\u00072\f7o]*o_^\u0004\u0018M]6EMN$&/\u00198tM>\u0014X.\u001a:\u000b\u0005A\n\u0014a\u0003;sC:\u001chm\u001c:nKJT!AM\u001a\u0002\u0013Mtwn\u001e4mC.,'B\u0001\u001b6\u0003\u0019\t7\r^5p]*\u0011agN\u0001\to>\u00148N\u001a7po*\u0011\u0001(O\u0001\u000eg6\f'\u000f\u001e3bi\u0006d\u0017m[3\u000b\u0003i\n!![8\u0004\u0001M)\u0001!P\"K\u001bB\u0011a(Q\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\t1\u0011I\\=SK\u001a\u0004\"\u0001\u0012%\u000e\u0003\u0015S!\u0001\r$\u000b\u0005\u001d\u001b\u0014aB4f]\u0016\u0014\u0018nY\u0005\u0003\u0013\u0016\u0013Ad\u00149uS>t7oR3oKJL7\r\u00124t)J\fgn\u001d4pe6,'\u000f\u0005\u0002?\u0017&\u0011Aj\u0010\u0002\b!J|G-^2u!\tqd*\u0003\u0002P\u007f\ta1+\u001a:jC2L'0\u00192mK\u0006!a.Y7f+\u0005\u0011\u0006CA*[\u001d\t!\u0006\f\u0005\u0002V\u007f5\taK\u0003\u0002Xw\u00051AH]8pizJ!!W \u0002\rA\u0013X\rZ3g\u0013\tYFL\u0001\u0004TiJLgn\u001a\u0006\u00033~\nQA\\1nK\u0002\n1\u0002Z3tGJL\u0007\u000f^5p]V\t\u0001\rE\u0002?CJK!AY \u0003\r=\u0003H/[8o\u00031!Wm]2sSB$\u0018n\u001c8!\u0003%\u0019G.Y:t\u001d\u0006lW-\u0001\u0006dY\u0006\u001c8OT1nK\u0002\nqa\u001c9uS>t7/F\u0001i!\u0011\u0019\u0016N\u0015*\n\u0005)d&aA'ba\u0006Aq\u000e\u001d;j_:\u001c\b%\u0001\bsk:$\u0018.\\3PaRLwN\\:\u0002\u001fI,h\u000e^5nK>\u0003H/[8og\u0002\na\u0001P5oSRtDC\u00029sgR,h\u000f\u0005\u0002r\u00015\tq\u0006C\u0004Q\u0017A\u0005\t\u0019\u0001*\t\u000fy[\u0001\u0013!a\u0001A\")Am\u0003a\u0001%\"9am\u0003I\u0001\u0002\u0004A\u0007b\u00027\f!\u0003\u0005\r\u0001[\u0001\u0012GV\u001cHo\\7Ue\u0006t7OZ8s[\u0016\u0014X#A=\u0011\u0005ilX\"A>\u000b\u0005q\f\u0014aC2vgR|W\u000e\\8hS\u000eL!A`>\u00039\r+8\u000f^8n':|w\u000f]1sW\u001237\u000f\u0016:b]N4wN]7fe\u0006\u00112-^:u_6$&/\u00198tM>\u0014X.\u001a:!\u0003Q!(/\u00198tM>\u0014XnV5uQ>\u0003H/[8ogRQ\u0011QAA\u0011\u0003\u0007\nI'!\u001c\u0015\t\u0005\u001d\u0011Q\u0003\t\u0006'&\u0014\u0016\u0011\u0002\t\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011qB\u001b\u0002\u0013\u0011\fG/\u00194sC6,\u0017\u0002BA\n\u0003\u001b\u0011\u0001cR3oKJL7\rR1uC\u001a\u0013\u0018-\\3\t\u000f\u0005]a\u0002q\u0001\u0002\u001a\u000591m\u001c8uKb$\b\u0003BA\u000e\u0003;i\u0011!N\u0005\u0004\u0003?)$!F!di&|g\u000eU5qK2Lg.Z\"p]R,\u0007\u0010\u001e\u0005\b\u0003Gq\u0001\u0019AA\u0013\u0003!\t7\r^5p]&#\u0007\u0003BA\u0014\u0003{qA!!\u000b\u000289!\u00111FA\u001a\u001d\u0011\ti#!\r\u000f\u0007U\u000by#C\u0001;\u0013\tA\u0014(C\u0002\u00026]\naaY8oM&<\u0017\u0002BA\u001d\u0003w\tqb\u00153m\u0007>tg-[4PE*,7\r\u001e\u0006\u0004\u0003k9\u0014\u0002BA \u0003\u0003\u0012\u0001\"Q2uS>t\u0017\n\u001a\u0006\u0005\u0003s\tY\u0004C\u0004\u0002F9\u0001\r!a\u0012\u0002\u001fA\f'\u000f^5uS>tg+\u00197vKN\u0004b!!\u0013\u0002T\u0005ec\u0002BA&\u0003\u001fr1!VA'\u0013\u0005\u0001\u0015bAA)\u007f\u00059\u0001/Y2lC\u001e,\u0017\u0002BA+\u0003/\u00121aU3r\u0015\r\t\tf\u0010\t\u0005\u00037\n)'\u0004\u0002\u0002^)!\u0011qLA1\u0003\u0011AGMZ:\u000b\u0007\u0005\rt'\u0001\u0003vi&d\u0017\u0002BA4\u0003;\u0012q\u0002U1si&$\u0018n\u001c8WC2,Xm\u001d\u0005\b\u0003Wr\u0001\u0019AA\u0004\u0003\r!gm\u001d\u0005\u0006M:\u0001\r\u0001[\u0001\u0018O\u0016$8+\u001e2GK\u0016$7+\u001e9q_J$X\r\u001a+za\u0016,\"!a\u001d\u0011\t\u0005U\u0014\u0011\u0013\b\u0005\u0003o\nYI\u0004\u0003\u0002z\u0005\u001de\u0002BA>\u0003\u0003sA!a\u0013\u0002~%\u0019\u0011qP \u0002\u000fI,g\r\\3di&!\u00111QAC\u0003\u001d\u0011XO\u001c;j[\u0016T1!a @\u0013\u0011\t\t&!#\u000b\t\u0005\r\u0015QQ\u0005\u0005\u0003\u001b\u000by)\u0001\u0005v]&4XM]:f\u0015\u0011\t\t&!#\n\t\u0005M\u0015Q\u0013\u0002\u0005)f\u0004X-\u0003\u0003\u0002\u0018\u0006e%!\u0002+za\u0016\u001c(\u0002BAN\u0003\u000b\u000b1!\u00199j\u0003\u001d1\u0017m\u0019;pef,\"!!)\u0011\r\u0005\r\u0016QUAU\u001b\t\tY$\u0003\u0003\u0002(\u0006m\"!\u0005$s_6\u001cuN\u001c4jO\u001a\u000b7\r^8ssB\u0019A)a+\n\u0007\u00055VIA\u000bHK:,'/[2EMN$&/\u00198tM>\u0014X.\u001a:\u0002\t\r|\u0007/\u001f\u000b\fa\u0006M\u0016QWA\\\u0003s\u000bY\fC\u0004Q#A\u0005\t\u0019\u0001*\t\u000fy\u000b\u0002\u0013!a\u0001A\"9A-\u0005I\u0001\u0002\u0004\u0011\u0006b\u00024\u0012!\u0003\u0005\r\u0001\u001b\u0005\bYF\u0001\n\u00111\u0001i\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!1+\u0007I\u000b\u0019m\u000b\u0002\u0002FB!\u0011qYAi\u001b\t\tIM\u0003\u0003\u0002L\u00065\u0017!C;oG\",7m[3e\u0015\r\tymP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAj\u0003\u0013\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!7+\u0007\u0001\f\u0019-\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011\u0011\u001d\u0016\u0004Q\u0006\r\u0017AD2paf$C-\u001a4bk2$H%N\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005%\b\u0003BAv\u0003kl!!!<\u000b\t\u0005=\u0018\u0011_\u0001\u0005Y\u0006twM\u0003\u0002\u0002t\u0006!!.\u0019<b\u0013\rY\u0016Q^\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003w\u00042APA\u007f\u0013\r\typ\u0010\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005\u000b\u0011Y\u0001E\u0002?\u0005\u000fI1A!\u0003@\u0005\r\te.\u001f\u0005\n\u0005\u001bI\u0012\u0011!a\u0001\u0003w\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\n!\u0019\u0011)Ba\u0007\u0003\u00065\u0011!q\u0003\u0006\u0004\u00053y\u0014AC2pY2,7\r^5p]&!!Q\u0004B\f\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t\r\"\u0011\u0006\t\u0004}\t\u0015\u0012b\u0001B\u0014\u007f\t9!i\\8mK\u0006t\u0007\"\u0003B\u00077\u0005\u0005\t\u0019\u0001B\u0003\u0003!A\u0017m\u001d5D_\u0012,GCAA~\u0003!!xn\u0015;sS:<GCAAu\u0003\u0019)\u0017/^1mgR!!1\u0005B\u001c\u0011%\u0011iAHA\u0001\u0002\u0004\u0011)\u0001K\u0004\u0001\u0005w\u0011\u0019F!\u0016\u0011\t\tu\"qJ\u0007\u0003\u0005\u007fQAA!\u0011\u0003D\u0005A1oY1mC\u0012|7M\u0003\u0003\u0003F\t\u001d\u0013a\u0002;bW\u0016Tx.\u001a\u0006\u0005\u0005\u0013\u0012Y%\u0001\u0004hSRDWO\u0019\u0006\u0003\u0005\u001b\n1aY8n\u0013\u0011\u0011\tFa\u0010\u0003\u0011M\u001b\u0017\r\\1e_\u000e\fQA^1mk\u0016\f#Aa\u0016\u0002\rk{#F\u000b\u0006!U\u0001\u001auN\u001c4jOV\u0014\u0018\r^5p]\u0002zg\rI1!GV\u001cHo\\7!'B\f'o[\u0017ECR\fgI]1nK\u0002\"(/\u00198tM>\u0014X.\u0019;j_:\u0004#-\u001a;xK\u0016t\u0007%\\1os\u0002Jg\u000e];ug\u0002\ng\u000e\u001a\u0011nC:L\be\\;uaV$8\u000f\t\u0015ou5L#\u0002\t\u0016!\t\u00164\u0017N\\3!C\u0002\"(/\u00198tM>\u0014X\u000e\t4v]\u000e$\u0018n\u001c8!o\"L7\r\u001b\u0011sK\u000e,\u0017N^3tA\u0005\u0004S.\u00199!_\u001a\u0004\u0013N\u001c9vi\u0002\"\u0015\r^1PE*,7\r^%eg\u0002:\u0018\u000e\u001e5!\t\u0006$\u0018M\u0012:b[\u0016\u001c\b%\u00198eA\u0005\u0004S.\u00199!_\u001a\u0004s\u000e\u001d;j_:\u001c\b%\u00198eA\u0005\u001c(\u0002\t\u0016!i>\u0004#/\u001a;ve:\u0004\u0013\rI7ba\u0002zg\rI8viB,H\u000f\t#bi\u0006|%M[3di&#7\u000fI<ji\"\u0004C)\u0019;b\rJ\fW.Z:-AM,W\rI1mg>\u0004CO]1ji\u0002Z6lQ;ti>l7K\\8xa\u0006\u00148\u000e\u00124t)J\fgn\u001d4pe6,'/X//\u0015\u0001R#\u0002\t\u0016!\u0001B\f'/Y7!]\u0006lW\r\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A9\fW.\u001a\u0011pM\u0002\"\b.\u001a\u0011ue\u0006t7OZ8s[\u0016\u0014(\u0002\t\u0016!\u0001B\f'/Y7!I\u0016\u001c8M]5qi&|g\u000e\t\u0011!A=\u0003H/[8oC2\u0004C-Z:de&\u0004H/[8oA=4\u0007\u0005\u001e5fAQ\u0014\u0018M\\:g_JlWM\u001d\u0006!U\u0001\u0002\u0005/\u0019:b[\u0002\u001aG.Y:t\u001d\u0006lW\r\t\u0011!A\u0001\u00023\r\\1tg\u0002r\u0017-\\3!S6\u0004H.Z7f]RLgn\u001a\u0011ue\u0006LG\u000fI.\\\u0007V\u001cHo\\7T]><\b/\u0019:l\t\u001a\u001cHK]1og\u001a|'/\\3s;vS\u0001E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011paRLwN\\:!A\u0001\u0002\u0003\u0005\t\u0011!\u001fB$\u0018n\u001c8tAQ|\u0007\u0005]1tg\u0002\"x\u000e\t;iK\u0002\"(/\u00198tM>\u0014X.\u0019;j_:T\u0001E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011sk:$\u0018.\\3PaRLwN\\:!_B$\u0018n\u001c8bY\u0002\"X\u000f\u001d7fg\u0002zg\rI.lKfd\u0003e\u001d9be.\u00043/\u001d7!Kb\u0004(/Z:tS>tW\f\t;pA\t,\u0007%\u00193eK\u0012\u0004\u0013m\u001d\u0011bI\u0012LG/[8oC2\u0004s\u000e\u001d;j_:\u001c\be\u001e5f]\u0002*\u00070Z2vi&tw\r\t;sC:\u001chm\u001c:nCRLwN\u001c\u0018\u000bA)\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\u00165fAM\u0004\u0018M]6!gFd\u0007%\u001a=qe\u0016\u001c8/[8og\u0002\n'/\u001a\u0011fm\u0006dW/\u0019;fI\u0002\nw-Y5ogR\u0004\u0013M\u001c\u0011j]N$\u0018M\\2fA=4\u0007eW.EK\u001a\fW\u000f\u001c;FqB\u0014Xm]:j_:$\u0015\r^1^;:R\u0001EK\u0018\u0002AM\u001b\u0017\r\\1DY\u0006\u001c8o\u00158poB\f'o\u001b#ggR\u0013\u0018M\\:g_JlWM\u001d\t\u0003c\u0002\u001aR\u0001I\u001f\u0002\"6#\"Aa\u0017\u0002\u0015\u0019\u0014x.\\\"p]\u001aLw\r\u0006\u0003\u0003f\tEDc\u00019\u0003h!9!\u0011\u000e\u0012A\u0004\t-\u0014\u0001E5ogR\fgnY3SK\u001eL7\u000f\u001e:z!\u0011\t\u0019K!\u001c\n\t\t=\u00141\b\u0002\u0011\u0013:\u001cH/\u00198dKJ+w-[:uefDq!!\u000e#\u0001\u0004\u0011\u0019\b\u0005\u0003\u0003v\tuTB\u0001B<\u0015\u0011\t)D!\u001f\u000b\t\tm$1J\u0001\tif\u0004Xm]1gK&!!q\u0010B<\u0005\u0019\u0019uN\u001c4jO\u0006)\u0011\r\u001d9msRY\u0001O!\"\u0003\b\n%%1\u0012BG\u0011\u001d\u00016\u0005%AA\u0002ICqAX\u0012\u0011\u0002\u0003\u0007\u0001\rC\u0003eG\u0001\u0007!\u000bC\u0004gGA\u0005\t\u0019\u00015\t\u000f1\u001c\u0003\u0013!a\u0001Q\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0013'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0014aD1qa2LH\u0005Z3gCVdG\u000fJ\u001b\u0002\u000fUt\u0017\r\u001d9msR!!1\u0014BR!\u0011q\u0014M!(\u0011\u0011y\u0012yJ\u00151SQ\"L1A!)@\u0005\u0019!V\u000f\u001d7fk!A!Q\u0015\u0015\u0002\u0002\u0003\u0007\u0001/A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005g\u0003B!a;\u00036&!!qWAw\u0005\u0019y%M[3di\u0002")
public class ScalaClassSnowparkDfsTransformer
implements OptionsGenericDfsTransformer,
Product,
scala.Serializable {
    private final String name;
    private final Option<String> description;
    private final String className;
    private final Map<String, String> options;
    private final Map<String, String> runtimeOptions;
    private final CustomSnowparkDfsTransformer customTransformer;
    private Option<Config> _config;

    public static Map<String, String> $lessinit$greater$default$5() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.$lessinit$greater$default$5();
    }

    public static Map<String, String> $lessinit$greater$default$4() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<String> $lessinit$greater$default$2() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.$lessinit$greater$default$2();
    }

    public static String $lessinit$greater$default$1() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Tuple5<String, Option<String>, String, Map<String, String>, Map<String, String>>> unapply(ScalaClassSnowparkDfsTransformer scalaClassSnowparkDfsTransformer) {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.unapply(scalaClassSnowparkDfsTransformer);
    }

    public static Map<String, String> apply$default$5() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.apply$default$5();
    }

    public static Map<String, String> apply$default$4() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.apply$default$4();
    }

    public static Option<String> apply$default$2() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.apply$default$2();
    }

    public static String apply$default$1() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.apply$default$1();
    }

    public static ScalaClassSnowparkDfsTransformer apply(String string, Option<String> option, String string2, Map<String, String> map, Map<String, String> map2) {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.apply(string, option, string2, map, map2);
    }

    public static ScalaClassSnowparkDfsTransformer fromConfig(Config config, InstanceRegistry instanceRegistry) {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.fromConfig(config, instanceRegistry);
    }

    @Scaladoc(value="/**\n   * A reader that reads [[StringOrSecret]] values.\n   */")
    public static ConfigReader<StringOrSecret> stringOrSecretReader() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.stringOrSecretReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ExecutionMode]] values.\n   * Note that Expectation must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<ExecutionMode> executionModeReader() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.executionModeReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[Connection]] values inside [[Agent]].\n   * Note that Connection must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<Connection> connectionDefReader() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.connectionDefReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[Expectation]] values.\n   * Note that Expectation must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<Expectation> expectationReader() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.expectationReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ParsableScriptDef]] values.\n   * Note that ParsableScriptDef must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<ParsableScriptDef> scriptDefReader() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.scriptDefReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[GenericDfsTransformer]] values.\n   * Note that GenericDfsTransformer must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<GenericDfsTransformer> dfsTransformerReader() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.dfsTransformerReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[GenericDfTransformer]] values.\n   * Note that GenericDfTransformer must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<GenericDfTransformer> dfTransformerReader() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.dfTransformerReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ActionId]] values.\n   */")
    public static ConfigReader<SdlConfigObject.ActionId> actionIdReader() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.actionIdReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[DataObjectId]] values.\n   */")
    public static ConfigReader<SdlConfigObject.DataObjectId> dataObjectIdReader() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.dataObjectIdReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ConnectionId]] values.\n   */")
    public static ConfigReader<SdlConfigObject.ConnectionId> connectionIdReader() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.connectionIdReader();
    }

    public static ConfigReader<Map<SdlConfigObject.DataObjectId, String>> mapDataObjectIdStringReader(ConfigReader<Map<String, String>> configReader) {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.mapDataObjectIdStringReader(configReader);
    }

    public static ConfigReader<SaveModeOptions> saveModeOptionsReader() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.saveModeOptionsReader();
    }

    public static ConfigReader<AuthMode> authModeReader() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.authModeReader();
    }

    public static ConfigReader<Condition> conditionReader() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.conditionReader();
    }

    public static ConfigReader<SecretProviderConfig> secretProviderConfigReader() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.secretProviderConfigReader();
    }

    public static ConfigReader<SparkRepartitionDef> sparkRepartitionDefReader() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.sparkRepartitionDefReader();
    }

    public static ConfigReader<SparkUDFCreatorConfig> sparkUdfCreatorConfigReader() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.sparkUdfCreatorConfigReader();
    }

    public static ConfigReader<CustomFileTransformerConfig> customFileTransformerConfigReader() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.customFileTransformerConfigReader();
    }

    public static ConfigReader<CustomDfsTransformerConfig> customDfsTransformerConfigReader() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.customDfsTransformerConfigReader();
    }

    public static ConfigReader<CustomDfTransformerConfig> customDfTransformerConfigReader() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.customDfTransformerConfigReader();
    }

    public static ConfigReader<CustomDfCreatorConfig> customDfCreatorConfigReader() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.customDfCreatorConfigReader();
    }

    @Scaladoc(value="/**\n   * A [[ConfigReader]] reader that reads [[OutputMode]].\n   */")
    public static ConfigReader<OutputMode> outputModeReader() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.outputModeReader();
    }

    @Scaladoc(value="/**\n   * A [[ConfigReader]] reader that reads [[GenericSchema]] values.\n   *\n   * This reader parses a Spark [[StructType]] by using the desired schema provider.\n   * The schema provider is included in the configuration value as prefix terminated by '#'.\n   */")
    public static ConfigReader<GenericSchema> genericSchemaReader() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.genericSchemaReader();
    }

    @Scaladoc(value="/**\n   * default naming strategy is to allow lowerCamelCase and hypen-separated key naming, and fail on superfluous keys\n   */")
    public static <A> ConfigKeyNaming<A> sdlDefaultNaming() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$.sdlDefaultNaming();
    }

    @Scaladoc(value="/**\n   * Optional function to define the transformation of input to output partition values.\n   * For example this enables to implement aggregations where multiple input partitions are combined into one output partition.\n   * Note that the default value is input = output partition values, which should be correct for most use cases.\n   * see also [[GenericDfsTransformerDef.transformPartitionValues()]]\n   *\n   * @param options Options specified in the configuration for this transformation, including evaluated runtimeOptions\n   */")
    public Option<Map<PartitionValues, PartitionValues>> transformPartitionValuesWithOptions(String actionId, Seq<PartitionValues> partitionValues, Map<String, String> options, ActionPipelineContext context) {
        return OptionsGenericDfsTransformer.transformPartitionValuesWithOptions$((OptionsGenericDfsTransformer)this, (String)actionId, partitionValues, options, (ActionPipelineContext)context);
    }

    public Option<Map<PartitionValues, PartitionValues>> transformPartitionValues(String actionId, Seq<PartitionValues> partitionValues, Map<String, String> executionModeResultOptions, ActionPipelineContext context) {
        return OptionsGenericDfsTransformer.transformPartitionValues$((OptionsGenericDfsTransformer)this, (String)actionId, partitionValues, executionModeResultOptions, (ActionPipelineContext)context);
    }

    public Map<String, GenericDataFrame> transform(String actionId, Seq<PartitionValues> partitionValues, Map<String, GenericDataFrame> dfs, Map<String, String> executionModeResultOptions, ActionPipelineContext context) {
        return OptionsGenericDfsTransformer.transform$((OptionsGenericDfsTransformer)this, (String)actionId, partitionValues, dfs, executionModeResultOptions, (ActionPipelineContext)context);
    }

    @Scaladoc(value="/**\n   * Optional function to implement validations in prepare phase.\n   */")
    public void prepare(String actionId, ActionPipelineContext context) {
        GenericDfsTransformerDef.prepare$((GenericDfsTransformerDef)this, (String)actionId, (ActionPipelineContext)context);
    }

    public Tuple2<Map<String, GenericDataFrame>, Seq<PartitionValues>> applyTransformation(String actionId, Seq<PartitionValues> partitionValues, Map<String, GenericDataFrame> dfs, Map<String, String> executionModeResultOptions, ActionPipelineContext context) {
        return GenericDfsTransformerDef.applyTransformation$((GenericDfsTransformerDef)this, (String)actionId, partitionValues, dfs, executionModeResultOptions, (ActionPipelineContext)context);
    }

    public Map<PartitionValues, PartitionValues> applyTransformation(String actionId, Map<PartitionValues, PartitionValues> partitionValuesMap, Map<String, String> executionModeResultOptions, ActionPipelineContext context) {
        return PartitionValueTransformer.applyTransformation$((PartitionValueTransformer)this, (String)actionId, partitionValuesMap, executionModeResultOptions, (ActionPipelineContext)context);
    }

    public Option<Config> _config() {
        return this._config;
    }

    public void _config_$eq(Option<Config> x$1) {
        this._config = x$1;
    }

    public String name() {
        return this.name;
    }

    public Option<String> description() {
        return this.description;
    }

    public String className() {
        return this.className;
    }

    public Map<String, String> options() {
        return this.options;
    }

    public Map<String, String> runtimeOptions() {
        return this.runtimeOptions;
    }

    private CustomSnowparkDfsTransformer customTransformer() {
        return this.customTransformer;
    }

    public Map<String, GenericDataFrame> transformWithOptions(String actionId, Seq<PartitionValues> partitionValues, Map<String, GenericDataFrame> dfs, Map<String, String> options, ActionPipelineContext context) {
        Predef$.MODULE$.assert(dfs.values().forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ScalaClassSnowparkDfsTransformer.$anonfun$transformWithOptions$1(x$1))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("(").append(new SdlConfigObject.ActionId(actionId)).append(") Unsupported subFeedType(s) ").append(((TraversableOnce)((TraversableLike)dfs.values().filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ScalaClassSnowparkDfsTransformer.$anonfun$transformWithOptions$3(x$2)))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.subFeedType().typeSymbol().name(), Iterable$.MODULE$.canBuildFrom())).toSet().mkString(", ")).append(" in method transform").toString());
        Action action = (Action)context.instanceRegistry().get((SdlConfigObject.ConfigObjectId)new SdlConfigObject.ActionId(actionId));
        Session snowparkSession = ((SnowflakeTableDataObject)action.inputs().head()).snowparkSession();
        Map snowparkDfs = dfs.mapValues((Function1 & Serializable & scala.Serializable)x$4 -> ((SnowparkDataFrame)x$4).inner());
        return this.customTransformer().transform(snowparkSession, options, (Map<String, DataFrame>)snowparkDfs).mapValues((Function1)SnowparkDataFrame$.MODULE$);
    }

    public Types.TypeApi getSubFeedSupportedType() {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ScalaClassSnowparkDfsTransformer.class.getClassLoader());
        public final class Io_smartdatalake_workflow_action_snowflake_transformer_ScalaClassSnowparkDfsTransformer$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("io.smartdatalake.workflow.dataframe.snowflake.SnowparkSubFeed").asType().toTypeConstructor();
            }

            public Io_smartdatalake_workflow_action_snowflake_transformer_ScalaClassSnowparkDfsTransformer$$typecreator1$1(ScalaClassSnowparkDfsTransformer $outer) {
            }
        }
        return ((TypeTags)package$.MODULE$.universe()).typeOf(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Io_smartdatalake_workflow_action_snowflake_transformer_ScalaClassSnowparkDfsTransformer$$typecreator1$1(null)));
    }

    public FromConfigFactory<GenericDfsTransformer> factory() {
        return ScalaClassSnowparkDfsTransformer$.MODULE$;
    }

    public ScalaClassSnowparkDfsTransformer copy(String name, Option<String> description, String className, Map<String, String> options, Map<String, String> runtimeOptions) {
        return new ScalaClassSnowparkDfsTransformer(name, description, className, options, runtimeOptions);
    }

    public String copy$default$1() {
        return this.name();
    }

    public Option<String> copy$default$2() {
        return this.description();
    }

    public String copy$default$3() {
        return this.className();
    }

    public Map<String, String> copy$default$4() {
        return this.options();
    }

    public Map<String, String> copy$default$5() {
        return this.runtimeOptions();
    }

    public String productPrefix() {
        return "ScalaClassSnowparkDfsTransformer";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.name();
                break;
            }
            case 1: {
                object = this.description();
                break;
            }
            case 2: {
                object = this.className();
                break;
            }
            case 3: {
                object = this.options();
                break;
            }
            case 4: {
                object = this.runtimeOptions();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ScalaClassSnowparkDfsTransformer;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ScalaClassSnowparkDfsTransformer)) return false;
        boolean bl = true;
        if (!bl) return false;
        ScalaClassSnowparkDfsTransformer scalaClassSnowparkDfsTransformer = (ScalaClassSnowparkDfsTransformer)x$1;
        String string = this.name();
        String string2 = scalaClassSnowparkDfsTransformer.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Option<String> option = this.description();
        Option<String> option2 = scalaClassSnowparkDfsTransformer.description();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        String string3 = this.className();
        String string4 = scalaClassSnowparkDfsTransformer.className();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = scalaClassSnowparkDfsTransformer.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Map<String, String> map3 = this.runtimeOptions();
        Map<String, String> map4 = scalaClassSnowparkDfsTransformer.runtimeOptions();
        if (map3 == null) {
            if (map4 != null) {
                return false;
            }
        } else if (!map3.equals(map4)) return false;
        if (!scalaClassSnowparkDfsTransformer.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$transformWithOptions$1(GenericDataFrame x$1) {
        return x$1 instanceof SnowparkDataFrame;
    }

    public static final /* synthetic */ boolean $anonfun$transformWithOptions$3(GenericDataFrame x$2) {
        return x$2 instanceof SparkDataFrame;
    }

    public ScalaClassSnowparkDfsTransformer(String name, Option<String> description, String className, Map<String, String> options, Map<String, String> runtimeOptions) {
        this.name = name;
        this.description = description;
        this.className = className;
        this.options = options;
        this.runtimeOptions = runtimeOptions;
        PartitionValueTransformer.$init$((PartitionValueTransformer)this);
        GenericDfsTransformerDef.$init$((GenericDfsTransformerDef)this);
        ConfigHolder.$init$((ConfigHolder)this);
        OptionsGenericDfsTransformer.$init$((OptionsGenericDfsTransformer)this);
        Product.$init$((Product)this);
        this.customTransformer = (CustomSnowparkDfsTransformer)CustomCodeUtil$.MODULE$.getClassInstanceByName(className);
    }
}

