/*
 * Decompiled with CFR 0.152.
 */
package io.smartdatalake.workflow.action.snowflake.transformer;

import com.github.takezoe.scaladoc.Scaladoc;
import com.snowflake.snowpark.Session;
import com.typesafe.config.Config;
import configs.ConfigKeyNaming;
import configs.ConfigReader;
import io.smartdatalake.config.ConfigHolder;
import io.smartdatalake.config.FromConfigFactory;
import io.smartdatalake.config.InstanceRegistry;
import io.smartdatalake.config.SdlConfigObject;
import io.smartdatalake.definitions.AuthMode;
import io.smartdatalake.definitions.Condition;
import io.smartdatalake.definitions.SaveModeOptions;
import io.smartdatalake.util.hdfs.PartitionValues;
import io.smartdatalake.util.hdfs.SparkRepartitionDef;
import io.smartdatalake.util.misc.CustomCodeUtil$;
import io.smartdatalake.util.secrets.SecretProviderConfig;
import io.smartdatalake.util.secrets.StringOrSecret;
import io.smartdatalake.workflow.ActionPipelineContext;
import io.smartdatalake.workflow.DataFrameSubFeed;
import io.smartdatalake.workflow.action.Action;
import io.smartdatalake.workflow.action.executionMode.ExecutionMode;
import io.smartdatalake.workflow.action.generic.transformer.GenericDfTransformer;
import io.smartdatalake.workflow.action.generic.transformer.GenericDfTransformerDef;
import io.smartdatalake.workflow.action.generic.transformer.GenericDfsTransformer;
import io.smartdatalake.workflow.action.generic.transformer.OptionsGenericDfTransformer;
import io.smartdatalake.workflow.action.generic.transformer.PartitionValueTransformer;
import io.smartdatalake.workflow.action.script.ParsableScriptDef;
import io.smartdatalake.workflow.action.snowflake.customlogic.CustomSnowparkDfTransformer;
import io.smartdatalake.workflow.action.snowflake.transformer.ScalaClassSnowparkDfTransformer$;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfCreatorConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfsTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomFileTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.SparkUDFCreatorConfig;
import io.smartdatalake.workflow.connection.Connection;
import io.smartdatalake.workflow.dataframe.GenericDataFrame;
import io.smartdatalake.workflow.dataframe.GenericSchema;
import io.smartdatalake.workflow.dataframe.snowflake.SnowparkDataFrame;
import io.smartdatalake.workflow.dataobject.Expectation;
import io.smartdatalake.workflow.dataobject.SnowflakeTableDataObject;
import org.apache.spark.sql.streaming.OutputMode;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n * Configuration of a custom Snowpark-DataFrame transformation between one input and one output (1:1) as Java/Scala Class.\n * Define a transform function which receives a DataObjectId, a DataFrame and a map of options and has to return a\n * DataFrame. The Java/Scala class has to implement interface [[CustomSnowparkDfTransformer]].\n *\n * @param name           name of the transformer\n * @param description    Optional description of the transformer\n * @param className      class name implementing trait [[CustomSnowparkDfTransformer]]\n * @param options        Options to pass to the transformation\n * @param runtimeOptions optional tuples of [key, spark sql expression] to be added as additional options when executing transformation.\n *                       The spark sql expressions are evaluated against an instance of [[DefaultExpressionData]].\n */")
@ScalaSignature(bytes="\u0006\u0001\tUg\u0001B\u00181\u0001vB\u0001\"\u0015\u0001\u0003\u0016\u0004%\tE\u0015\u0005\t=\u0002\u0011\t\u0012)A\u0005'\"Aq\f\u0001BK\u0002\u0013\u0005\u0003\r\u0003\u0005e\u0001\tE\t\u0015!\u0003b\u0011!)\u0007A!f\u0001\n\u0003\u0011\u0006\u0002\u00034\u0001\u0005#\u0005\u000b\u0011B*\t\u0011\u001d\u0004!Q3A\u0005\u0002!D\u0001\u0002\u001c\u0001\u0003\u0012\u0003\u0006I!\u001b\u0005\t[\u0002\u0011)\u001a!C\u0001Q\"Aa\u000e\u0001B\tB\u0003%\u0011\u000eC\u0003p\u0001\u0011\u0005\u0001\u000fC\u0004y\u0001\t\u0007I\u0011B=\t\u000f\u0005\u0005\u0001\u0001)A\u0005u\"9\u00111\u0001\u0001\u0005B\u0005\u0015\u0001bBA2\u0001\u0011\u0005\u0013Q\r\u0005\b\u0003\u0017\u0003A\u0011IAG\u0011\u001d\tI\f\u0001C!\u0003wC\u0011\"a3\u0001\u0003\u0003%\t!!4\t\u0013\u0005e\u0007!%A\u0005\u0002\u0005m\u0007\"CAy\u0001E\u0005I\u0011AAz\u0011%\t9\u0010AI\u0001\n\u0003\tY\u000eC\u0005\u0002z\u0002\t\n\u0011\"\u0001\u0002|\"I\u0011q \u0001\u0012\u0002\u0013\u0005\u00111 \u0005\n\u0005\u0003\u0001\u0011\u0011!C!\u0005\u0007A\u0011Ba\u0005\u0001\u0003\u0003%\tA!\u0006\t\u0013\tu\u0001!!A\u0005\u0002\t}\u0001\"\u0003B\u0016\u0001\u0005\u0005I\u0011\tB\u0017\u0011%\u0011Y\u0004AA\u0001\n\u0003\u0011i\u0004C\u0005\u0003H\u0001\t\t\u0011\"\u0011\u0003J!I!1\n\u0001\u0002\u0002\u0013\u0005#Q\n\u0005\n\u0005\u001f\u0002\u0011\u0011!C!\u0005#:qA!\u001e1\u0011\u0003\u00119H\u0002\u00040a!\u0005!\u0011\u0010\u0005\u0007_\u0006\"\tAa\u001f\t\u000f\tu\u0014\u0005\"\u0011\u0003\u0000!I!QT\u0011\u0002\u0002\u0013\u0005%q\u0014\u0005\n\u0005W\u000b\u0013\u0013!C\u0001\u00037D\u0011B!,\"#\u0003%\t!a=\t\u0013\t=\u0016%%A\u0005\u0002\u0005m\b\"\u0003BYCE\u0005I\u0011AA~\u0011%\u0011\u0019,IA\u0001\n\u0003\u0013)\fC\u0005\u0003D\u0006\n\n\u0011\"\u0001\u0002\\\"I!QY\u0011\u0012\u0002\u0013\u0005\u00111\u001f\u0005\n\u0005\u000f\f\u0013\u0013!C\u0001\u0003wD\u0011B!3\"#\u0003%\t!a?\t\u0013\t-\u0017%!A\u0005\n\t5'aH*dC2\f7\t\\1tgNswn\u001e9be.$e\r\u0016:b]N4wN]7fe*\u0011\u0011GM\u0001\fiJ\fgn\u001d4pe6,'O\u0003\u00024i\u0005I1O\\8xM2\f7.\u001a\u0006\u0003kY\na!Y2uS>t'BA\u001c9\u0003!9xN]6gY><(BA\u001d;\u00035\u0019X.\u0019:uI\u0006$\u0018\r\\1lK*\t1(\u0001\u0002j_\u000e\u00011#\u0002\u0001?\t.s\u0005CA C\u001b\u0005\u0001%\"A!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0003%AB!osJ+g\r\u0005\u0002F\u00136\taI\u0003\u00022\u000f*\u0011\u0001\nN\u0001\bO\u0016tWM]5d\u0013\tQeIA\u000ePaRLwN\\:HK:,'/[2EMR\u0013\u0018M\\:g_JlWM\u001d\t\u0003\u007f1K!!\u0014!\u0003\u000fA\u0013x\u000eZ;diB\u0011qhT\u0005\u0003!\u0002\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fAA\\1nKV\t1\u000b\u0005\u0002U7:\u0011Q+\u0017\t\u0003-\u0002k\u0011a\u0016\u0006\u00031r\na\u0001\u0010:p_Rt\u0014B\u0001.A\u0003\u0019\u0001&/\u001a3fM&\u0011A,\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i\u0003\u0015!\u00028b[\u0016\u0004\u0013a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:,\u0012!\u0019\t\u0004\u007f\t\u001c\u0016BA2A\u0005\u0019y\u0005\u000f^5p]\u0006aA-Z:de&\u0004H/[8oA\u0005I1\r\\1tg:\u000bW.Z\u0001\u000bG2\f7o\u001d(b[\u0016\u0004\u0013aB8qi&|gn]\u000b\u0002SB!AK[*T\u0013\tYWLA\u0002NCB\f\u0001b\u001c9uS>t7\u000fI\u0001\u000feVtG/[7f\u001fB$\u0018n\u001c8t\u0003=\u0011XO\u001c;j[\u0016|\u0005\u000f^5p]N\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0004rgR,ho\u001e\t\u0003e\u0002i\u0011\u0001\r\u0005\b#.\u0001\n\u00111\u0001T\u0011\u001dy6\u0002%AA\u0002\u0005DQ!Z\u0006A\u0002MCqaZ\u0006\u0011\u0002\u0003\u0007\u0011\u000eC\u0004n\u0017A\u0005\t\u0019A5\u0002#\r,8\u000f^8n)J\fgn\u001d4pe6,'/F\u0001{!\tYh0D\u0001}\u0015\ti('A\u0006dkN$x.\u001c7pO&\u001c\u0017BA@}\u0005m\u0019Uo\u001d;p[Nswn\u001e9be.$e\r\u0016:b]N4wN]7fe\u0006\u00112-^:u_6$&/\u00198tM>\u0014X.\u001a:!\u0003\r\"(/\u00198tM>\u0014X\u000eU1si&$\u0018n\u001c8WC2,Xm],ji\"|\u0005\u000f^5p]N$\u0002\"a\u0002\u0002*\u0005-\u0013\u0011\r\u000b\u0005\u0003\u0013\ti\u0002\u0005\u0003@E\u0006-\u0001C\u0002+k\u0003\u001b\ti\u0001\u0005\u0003\u0002\u0010\u0005eQBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\t!$gm\u001d\u0006\u0004\u0003/A\u0014\u0001B;uS2LA!a\u0007\u0002\u0012\ty\u0001+\u0019:uSRLwN\u001c,bYV,7\u000fC\u0004\u0002 9\u0001\u001d!!\t\u0002\u000f\r|g\u000e^3yiB!\u00111EA\u0013\u001b\u00051\u0014bAA\u0014m\t)\u0012i\u0019;j_:\u0004\u0016\u000e]3mS:,7i\u001c8uKb$\bbBA\u0016\u001d\u0001\u0007\u0011QF\u0001\tC\u000e$\u0018n\u001c8JIB!\u0011qFA#\u001d\u0011\t\t$a\u0010\u000f\t\u0005M\u00121\b\b\u0005\u0003k\tIDD\u0002W\u0003oI\u0011aO\u0005\u0003siJ1!!\u00109\u0003\u0019\u0019wN\u001c4jO&!\u0011\u0011IA\"\u0003=\u0019F\r\\\"p]\u001aLwm\u00142kK\u000e$(bAA\u001fq%!\u0011qIA%\u0005!\t5\r^5p]&#'\u0002BA!\u0003\u0007Bq!!\u0014\u000f\u0001\u0004\ty%A\bqCJ$\u0018\u000e^5p]Z\u000bG.^3t!\u0019\t\t&a\u0017\u0002\u000e9!\u00111KA,\u001d\r1\u0016QK\u0005\u0002\u0003&\u0019\u0011\u0011\f!\u0002\u000fA\f7m[1hK&!\u0011QLA0\u0005\r\u0019V-\u001d\u0006\u0004\u00033\u0002\u0005\"B4\u000f\u0001\u0004I\u0017\u0001\u0006;sC:\u001chm\u001c:n/&$\bn\u00149uS>t7\u000f\u0006\u0007\u0002h\u0005]\u0014\u0011PA>\u0003\u007f\nI\t\u0006\u0003\u0002j\u0005U\u0004\u0003BA6\u0003cj!!!\u001c\u000b\u0007\u0005=d'A\u0005eCR\fgM]1nK&!\u00111OA7\u0005A9UM\\3sS\u000e$\u0015\r^1Ge\u0006lW\rC\u0004\u0002 =\u0001\u001d!!\t\t\u000f\u0005-r\u00021\u0001\u0002.!9\u0011QJ\bA\u0002\u0005=\u0003bBA?\u001f\u0001\u0007\u0011\u0011N\u0001\u0003I\u001aDq!!!\u0010\u0001\u0004\t\u0019)\u0001\u0007eCR\fwJ\u00196fGRLE\r\u0005\u0003\u00020\u0005\u0015\u0015\u0002BAD\u0003\u0013\u0012A\u0002R1uC>\u0013'.Z2u\u0013\u0012DQaZ\bA\u0002%\fqcZ3u'V\u0014g)Z3e'V\u0004\bo\u001c:uK\u0012$\u0016\u0010]3\u0016\u0005\u0005=\u0005\u0003BAI\u0003[sA!a%\u0002(:!\u0011QSAR\u001d\u0011\t9*!(\u000f\t\u0005M\u0013\u0011T\u0005\u0004\u00037\u0003\u0015a\u0002:fM2,7\r^\u0005\u0005\u0003?\u000b\t+A\u0004sk:$\u0018.\\3\u000b\u0007\u0005m\u0005)\u0003\u0003\u0002Z\u0005\u0015&\u0002BAP\u0003CKA!!+\u0002,\u0006AQO\\5wKJ\u001cXM\u0003\u0003\u0002Z\u0005\u0015\u0016\u0002BAX\u0003c\u0013A\u0001V=qK&!\u00111WA[\u0005\u0015!\u0016\u0010]3t\u0015\u0011\t9,!)\u0002\u0007\u0005\u0004\u0018.A\u0004gC\u000e$xN]=\u0016\u0005\u0005u\u0006CBA`\u0003\u0003\f)-\u0004\u0002\u0002D%!\u00111YA\"\u0005E1%o\\7D_:4\u0017n\u001a$bGR|'/\u001f\t\u0004\u000b\u0006\u001d\u0017bAAe\r\n!r)\u001a8fe&\u001cGI\u001a+sC:\u001chm\u001c:nKJ\fAaY8qsRY\u0011/a4\u0002R\u0006M\u0017Q[Al\u0011\u001d\t&\u0003%AA\u0002MCqa\u0018\n\u0011\u0002\u0003\u0007\u0011\rC\u0004f%A\u0005\t\u0019A*\t\u000f\u001d\u0014\u0002\u0013!a\u0001S\"9QN\u0005I\u0001\u0002\u0004I\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003;T3aUApW\t\t\t\u000f\u0005\u0003\u0002d\u00065XBAAs\u0015\u0011\t9/!;\u0002\u0013Ut7\r[3dW\u0016$'bAAv\u0001\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0018Q\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003kT3!YAp\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0002~*\u001a\u0011.a8\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%k\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!\u0002\u0011\t\t\u001d!\u0011C\u0007\u0003\u0005\u0013QAAa\u0003\u0003\u000e\u0005!A.\u00198h\u0015\t\u0011y!\u0001\u0003kCZ\f\u0017b\u0001/\u0003\n\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011!q\u0003\t\u0004\u007f\te\u0011b\u0001B\u000e\u0001\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!\u0011\u0005B\u0014!\ry$1E\u0005\u0004\u0005K\u0001%aA!os\"I!\u0011\u0006\u000e\u0002\u0002\u0003\u0007!qC\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t=\u0002C\u0002B\u0019\u0005o\u0011\t#\u0004\u0002\u00034)\u0019!Q\u0007!\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003:\tM\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa\u0010\u0003FA\u0019qH!\u0011\n\u0007\t\r\u0003IA\u0004C_>dW-\u00198\t\u0013\t%B$!AA\u0002\t\u0005\u0012\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\t]\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t\u0015\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0003@\tM\u0003\"\u0003B\u0015?\u0005\u0005\t\u0019\u0001B\u0011Q\u001d\u0001!q\u000bB8\u0005c\u0002BA!\u0017\u0003l5\u0011!1\f\u0006\u0005\u0005;\u0012y&\u0001\u0005tG\u0006d\u0017\rZ8d\u0015\u0011\u0011\tGa\u0019\u0002\u000fQ\f7.\u001a>pK*!!Q\rB4\u0003\u00199\u0017\u000e\u001e5vE*\u0011!\u0011N\u0001\u0004G>l\u0017\u0002\u0002B7\u00057\u0012\u0001bU2bY\u0006$wnY\u0001\u0006m\u0006dW/Z\u0011\u0003\u0005g\naqW\u0018+U)\u0001#\u0006I\"p]\u001aLw-\u001e:bi&|g\u000eI8gA\u0005\u00043-^:u_6\u00043K\\8xa\u0006\u00148.\f#bi\u00064%/Y7fAQ\u0014\u0018M\\:g_Jl\u0017\r^5p]\u0002\u0012W\r^<fK:\u0004sN\\3!S:\u0004X\u000f\u001e\u0011b]\u0012\u0004sN\\3!_V$\b/\u001e;!QER\u0014'\u000b\u0011bg\u0002R\u0015M^10'\u000e\fG.\u0019\u0011DY\u0006\u001c8O\f\u0006!U\u0001\"UMZ5oK\u0002\n\u0007\u0005\u001e:b]N4wN]7!MVt7\r^5p]\u0002:\b.[2iAI,7-Z5wKN\u0004\u0013\r\t#bi\u0006|%M[3di&#G\u0006I1!\t\u0006$\u0018M\u0012:b[\u0016\u0004\u0013M\u001c3!C\u0002j\u0017\r\u001d\u0011pM\u0002z\u0007\u000f^5p]N\u0004\u0013M\u001c3!Q\u0006\u001c\b\u0005^8!e\u0016$XO\u001d8!C*\u0001#\u0006\t#bi\u00064%/Y7f]\u0001\"\u0006.\u001a\u0011KCZ\fwfU2bY\u0006\u00043\r\\1tg\u0002B\u0017m\u001d\u0011u_\u0002JW\u000e\u001d7f[\u0016tG\u000fI5oi\u0016\u0014h-Y2fAm[6)^:u_6\u001cfn\\<qCJ\\GI\u001a+sC:\u001chm\u001c:nKJlVL\f\u0006!U)\u0001#\u0006\t!qCJ\fW\u000e\t8b[\u0016\u0004\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011oC6,\u0007e\u001c4!i\",\u0007\u0005\u001e:b]N4wN]7fe*\u0001#\u0006\t!qCJ\fW\u000e\t3fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004\u0003\u0005\t\u0011PaRLwN\\1mA\u0011,7o\u0019:jaRLwN\u001c\u0011pM\u0002\"\b.\u001a\u0011ue\u0006t7OZ8s[\u0016\u0014(\u0002\t\u0016!\u0001B\f'/Y7!G2\f7o\u001d(b[\u0016\u0004\u0003\u0005\t\u0011!A\rd\u0017m]:!]\u0006lW\rI5na2,W.\u001a8uS:<\u0007\u0005\u001e:bSR\u00043lW\"vgR|Wn\u00158poB\f'o\u001b#g)J\fgn\u001d4pe6,'/X/\u000bA)\u0002\u0003\t]1sC6\u0004s\u000e\u001d;j_:\u001c\b\u0005\t\u0011!A\u0001\u0002\u0003e\u00149uS>t7\u000f\t;pAA\f7o\u001d\u0011u_\u0002\"\b.\u001a\u0011ue\u0006t7OZ8s[\u0006$\u0018n\u001c8\u000bA)\u0002\u0003\t]1sC6\u0004#/\u001e8uS6,w\n\u001d;j_:\u001c\be\u001c9uS>t\u0017\r\u001c\u0011ukBdWm\u001d\u0011pM\u0002Z6.Z=-AM\u0004\u0018M]6!gFd\u0007%\u001a=qe\u0016\u001c8/[8o;\u0002\"x\u000e\t2fA\u0005$G-\u001a3!CN\u0004\u0013\r\u001a3ji&|g.\u00197!_B$\u0018n\u001c8tA]DWM\u001c\u0011fq\u0016\u001cW\u000f^5oO\u0002\"(/\u00198tM>\u0014X.\u0019;j_:t#\u0002\t\u0016!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AQCW\rI:qCJ\\\u0007e]9mA\u0015D\bO]3tg&|gn\u001d\u0011be\u0016\u0004SM^1mk\u0006$X\r\u001a\u0011bO\u0006Lgn\u001d;!C:\u0004\u0013N\\:uC:\u001cW\rI8gAm[F)\u001a4bk2$X\t\u001f9sKN\u001c\u0018n\u001c8ECR\fW,\u0018\u0018\u000bA)z\u0013aH*dC2\f7\t\\1tgNswn\u001e9be.$e\r\u0016:b]N4wN]7feB\u0011!/I\n\u0006Cy\niL\u0014\u000b\u0003\u0005o\n!B\u001a:p[\u000e{gNZ5h)\u0011\u0011\tI!$\u0015\u0007E\u0014\u0019\tC\u0004\u0003\u0006\u000e\u0002\u001dAa\"\u0002!%t7\u000f^1oG\u0016\u0014VmZ5tiJL\b\u0003BA`\u0005\u0013KAAa#\u0002D\t\u0001\u0012J\\:uC:\u001cWMU3hSN$(/\u001f\u0005\b\u0003{\u0019\u0003\u0019\u0001BH!\u0011\u0011\tJ!'\u000e\u0005\tM%\u0002BA\u001f\u0005+SAAa&\u0003h\u0005AA/\u001f9fg\u00064W-\u0003\u0003\u0003\u001c\nM%AB\"p]\u001aLw-A\u0003baBd\u0017\u0010F\u0006r\u0005C\u0013\u0019K!*\u0003(\n%\u0006bB)%!\u0003\u0005\ra\u0015\u0005\b?\u0012\u0002\n\u00111\u0001b\u0011\u0015)G\u00051\u0001T\u0011\u001d9G\u0005%AA\u0002%Dq!\u001c\u0013\u0011\u0002\u0003\u0007\u0011.A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00132\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0014aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIU\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u00038\n}\u0006\u0003B c\u0005s\u0003\u0002b\u0010B^'\u0006\u001c\u0016.[\u0005\u0004\u0005{\u0003%A\u0002+va2,W\u0007\u0003\u0005\u0003B&\n\t\u00111\u0001r\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU\n1B]3bIJ+7o\u001c7wKR\u0011!q\u001a\t\u0005\u0005\u000f\u0011\t.\u0003\u0003\u0003T\n%!AB(cU\u0016\u001cG\u000f")
public class ScalaClassSnowparkDfTransformer
implements OptionsGenericDfTransformer,
Product,
Serializable {
    private final String name;
    private final Option<String> description;
    private final String className;
    private final Map<String, String> options;
    private final Map<String, String> runtimeOptions;
    private final CustomSnowparkDfTransformer customTransformer;
    private Option<Config> _config;

    public static Map<String, String> $lessinit$greater$default$5() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.$lessinit$greater$default$5();
    }

    public static Map<String, String> $lessinit$greater$default$4() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<String> $lessinit$greater$default$2() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.$lessinit$greater$default$2();
    }

    public static String $lessinit$greater$default$1() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Tuple5<String, Option<String>, String, Map<String, String>, Map<String, String>>> unapply(ScalaClassSnowparkDfTransformer scalaClassSnowparkDfTransformer) {
        return ScalaClassSnowparkDfTransformer$.MODULE$.unapply(scalaClassSnowparkDfTransformer);
    }

    public static Map<String, String> apply$default$5() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.apply$default$5();
    }

    public static Map<String, String> apply$default$4() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.apply$default$4();
    }

    public static Option<String> apply$default$2() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.apply$default$2();
    }

    public static String apply$default$1() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.apply$default$1();
    }

    public static ScalaClassSnowparkDfTransformer apply(String string, Option<String> option, String string2, Map<String, String> map, Map<String, String> map2) {
        return ScalaClassSnowparkDfTransformer$.MODULE$.apply(string, option, string2, map, map2);
    }

    public static ScalaClassSnowparkDfTransformer fromConfig(Config config, InstanceRegistry instanceRegistry) {
        return ScalaClassSnowparkDfTransformer$.MODULE$.fromConfig(config, instanceRegistry);
    }

    @Scaladoc(value="/**\n   * A reader that reads [[StringOrSecret]] values.\n   */")
    public static ConfigReader<StringOrSecret> stringOrSecretReader() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.stringOrSecretReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ExecutionMode]] values.\n   * Note that Expectation must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<ExecutionMode> executionModeReader() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.executionModeReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[Connection]] values inside [[Agent]].\n   * Note that Connection must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<Connection> connectionDefReader() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.connectionDefReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[Expectation]] values.\n   * Note that Expectation must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<Expectation> expectationReader() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.expectationReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ParsableScriptDef]] values.\n   * Note that ParsableScriptDef must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<ParsableScriptDef> scriptDefReader() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.scriptDefReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[GenericDfsTransformer]] values.\n   * Note that GenericDfsTransformer must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<GenericDfsTransformer> dfsTransformerReader() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.dfsTransformerReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[GenericDfTransformer]] values.\n   * Note that GenericDfTransformer must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<GenericDfTransformer> dfTransformerReader() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.dfTransformerReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ActionId]] values.\n   */")
    public static ConfigReader<SdlConfigObject.ActionId> actionIdReader() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.actionIdReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[DataObjectId]] values.\n   */")
    public static ConfigReader<SdlConfigObject.DataObjectId> dataObjectIdReader() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.dataObjectIdReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ConnectionId]] values.\n   */")
    public static ConfigReader<SdlConfigObject.ConnectionId> connectionIdReader() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.connectionIdReader();
    }

    public static ConfigReader<Map<SdlConfigObject.DataObjectId, String>> mapDataObjectIdStringReader(ConfigReader<Map<String, String>> configReader) {
        return ScalaClassSnowparkDfTransformer$.MODULE$.mapDataObjectIdStringReader(configReader);
    }

    public static ConfigReader<SaveModeOptions> saveModeOptionsReader() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.saveModeOptionsReader();
    }

    public static ConfigReader<AuthMode> authModeReader() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.authModeReader();
    }

    public static ConfigReader<Condition> conditionReader() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.conditionReader();
    }

    public static ConfigReader<SecretProviderConfig> secretProviderConfigReader() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.secretProviderConfigReader();
    }

    public static ConfigReader<SparkRepartitionDef> sparkRepartitionDefReader() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.sparkRepartitionDefReader();
    }

    public static ConfigReader<SparkUDFCreatorConfig> sparkUdfCreatorConfigReader() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.sparkUdfCreatorConfigReader();
    }

    public static ConfigReader<CustomFileTransformerConfig> customFileTransformerConfigReader() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.customFileTransformerConfigReader();
    }

    public static ConfigReader<CustomDfsTransformerConfig> customDfsTransformerConfigReader() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.customDfsTransformerConfigReader();
    }

    public static ConfigReader<CustomDfTransformerConfig> customDfTransformerConfigReader() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.customDfTransformerConfigReader();
    }

    public static ConfigReader<CustomDfCreatorConfig> customDfCreatorConfigReader() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.customDfCreatorConfigReader();
    }

    @Scaladoc(value="/**\n   * A [[ConfigReader]] reader that reads [[OutputMode]].\n   */")
    public static ConfigReader<OutputMode> outputModeReader() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.outputModeReader();
    }

    @Scaladoc(value="/**\n   * A [[ConfigReader]] reader that reads [[GenericSchema]] values.\n   *\n   * This reader parses a Spark [[StructType]] by using the desired schema provider.\n   * The schema provider is included in the configuration value as prefix terminated by '#'.\n   */")
    public static ConfigReader<GenericSchema> genericSchemaReader() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.genericSchemaReader();
    }

    @Scaladoc(value="/**\n   * default naming strategy is to allow lowerCamelCase and hypen-separated key naming, and fail on superfluous keys\n   */")
    public static <A> ConfigKeyNaming<A> sdlDefaultNaming() {
        return ScalaClassSnowparkDfTransformer$.MODULE$.sdlDefaultNaming();
    }

    public final Option<Map<PartitionValues, PartitionValues>> transformPartitionValues(String actionId, Seq<PartitionValues> partitionValues, Map<String, String> executionModeResultOptions, ActionPipelineContext context) {
        return OptionsGenericDfTransformer.transformPartitionValues$((OptionsGenericDfTransformer)this, (String)actionId, partitionValues, executionModeResultOptions, (ActionPipelineContext)context);
    }

    public final GenericDataFrame transform(String actionId, Seq<PartitionValues> partitionValues, GenericDataFrame df, String dataObjectId, Option<String> previousTransformerName, Map<String, String> executionModeResultOptions, ActionPipelineContext context) {
        return OptionsGenericDfTransformer.transform$((OptionsGenericDfTransformer)this, (String)actionId, partitionValues, (GenericDataFrame)df, (String)dataObjectId, previousTransformerName, executionModeResultOptions, (ActionPipelineContext)context);
    }

    @Scaladoc(value="/**\n   * Optional function to implement validations in prepare phase.\n   */")
    public void prepare(String actionId, ActionPipelineContext context) {
        GenericDfTransformerDef.prepare$((GenericDfTransformerDef)this, (String)actionId, (ActionPipelineContext)context);
    }

    public DataFrameSubFeed applyTransformation(String actionId, DataFrameSubFeed subFeed, Option<String> previousTransformerName, Map<String, String> executionModeResultOptions, ActionPipelineContext context) {
        return GenericDfTransformerDef.applyTransformation$((GenericDfTransformerDef)this, (String)actionId, (DataFrameSubFeed)subFeed, previousTransformerName, executionModeResultOptions, (ActionPipelineContext)context);
    }

    public Map<PartitionValues, PartitionValues> applyTransformation(String actionId, Map<PartitionValues, PartitionValues> partitionValuesMap, Map<String, String> executionModeResultOptions, ActionPipelineContext context) {
        return PartitionValueTransformer.applyTransformation$((PartitionValueTransformer)this, (String)actionId, partitionValuesMap, executionModeResultOptions, (ActionPipelineContext)context);
    }

    public Option<Config> _config() {
        return this._config;
    }

    public void _config_$eq(Option<Config> x$1) {
        this._config = x$1;
    }

    public String name() {
        return this.name;
    }

    public Option<String> description() {
        return this.description;
    }

    public String className() {
        return this.className;
    }

    public Map<String, String> options() {
        return this.options;
    }

    public Map<String, String> runtimeOptions() {
        return this.runtimeOptions;
    }

    private CustomSnowparkDfTransformer customTransformer() {
        return this.customTransformer;
    }

    public Option<Map<PartitionValues, PartitionValues>> transformPartitionValuesWithOptions(String actionId, Seq<PartitionValues> partitionValues, Map<String, String> options, ActionPipelineContext context) {
        return this.customTransformer().transformPartitionValues(options, partitionValues);
    }

    public GenericDataFrame transformWithOptions(String actionId, Seq<PartitionValues> partitionValues, GenericDataFrame df, String dataObjectId, Map<String, String> options, ActionPipelineContext context) {
        Action action = (Action)context.instanceRegistry().get((SdlConfigObject.ConfigObjectId)new SdlConfigObject.ActionId(actionId));
        Session snowparkSession = ((SnowflakeTableDataObject)action.inputs().head()).snowparkSession();
        GenericDataFrame genericDataFrame = df;
        if (!(genericDataFrame instanceof SnowparkDataFrame)) {
            throw new IllegalStateException(new StringBuilder(58).append("(").append(new SdlConfigObject.ActionId(actionId)).append(") Unsupported subFeedType ").append(df.subFeedType().typeSymbol().name()).append(" in method transformWithOptions").toString());
        }
        SnowparkDataFrame snowparkDataFrame = (SnowparkDataFrame)genericDataFrame;
        SnowparkDataFrame snowparkDataFrame2 = new SnowparkDataFrame(this.customTransformer().transform(snowparkSession, options, snowparkDataFrame.inner(), dataObjectId));
        return snowparkDataFrame2;
    }

    public Types.TypeApi getSubFeedSupportedType() {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ScalaClassSnowparkDfTransformer.class.getClassLoader());
        public final class Io_smartdatalake_workflow_action_snowflake_transformer_ScalaClassSnowparkDfTransformer$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("io.smartdatalake.workflow.dataframe.snowflake.SnowparkSubFeed").asType().toTypeConstructor();
            }

            public Io_smartdatalake_workflow_action_snowflake_transformer_ScalaClassSnowparkDfTransformer$$typecreator1$1(ScalaClassSnowparkDfTransformer $outer) {
            }
        }
        return ((TypeTags)package$.MODULE$.universe()).typeOf(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Io_smartdatalake_workflow_action_snowflake_transformer_ScalaClassSnowparkDfTransformer$$typecreator1$1(null)));
    }

    public FromConfigFactory<GenericDfTransformer> factory() {
        return ScalaClassSnowparkDfTransformer$.MODULE$;
    }

    public ScalaClassSnowparkDfTransformer copy(String name, Option<String> description, String className, Map<String, String> options, Map<String, String> runtimeOptions) {
        return new ScalaClassSnowparkDfTransformer(name, description, className, options, runtimeOptions);
    }

    public String copy$default$1() {
        return this.name();
    }

    public Option<String> copy$default$2() {
        return this.description();
    }

    public String copy$default$3() {
        return this.className();
    }

    public Map<String, String> copy$default$4() {
        return this.options();
    }

    public Map<String, String> copy$default$5() {
        return this.runtimeOptions();
    }

    public String productPrefix() {
        return "ScalaClassSnowparkDfTransformer";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.name();
                break;
            }
            case 1: {
                object = this.description();
                break;
            }
            case 2: {
                object = this.className();
                break;
            }
            case 3: {
                object = this.options();
                break;
            }
            case 4: {
                object = this.runtimeOptions();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ScalaClassSnowparkDfTransformer;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ScalaClassSnowparkDfTransformer)) return false;
        boolean bl = true;
        if (!bl) return false;
        ScalaClassSnowparkDfTransformer scalaClassSnowparkDfTransformer = (ScalaClassSnowparkDfTransformer)x$1;
        String string = this.name();
        String string2 = scalaClassSnowparkDfTransformer.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Option<String> option = this.description();
        Option<String> option2 = scalaClassSnowparkDfTransformer.description();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        String string3 = this.className();
        String string4 = scalaClassSnowparkDfTransformer.className();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        Map<String, String> map = this.options();
        Map<String, String> map2 = scalaClassSnowparkDfTransformer.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Map<String, String> map3 = this.runtimeOptions();
        Map<String, String> map4 = scalaClassSnowparkDfTransformer.runtimeOptions();
        if (map3 == null) {
            if (map4 != null) {
                return false;
            }
        } else if (!map3.equals(map4)) return false;
        if (!scalaClassSnowparkDfTransformer.canEqual(this)) return false;
        return true;
    }

    public ScalaClassSnowparkDfTransformer(String name, Option<String> description, String className, Map<String, String> options, Map<String, String> runtimeOptions) {
        this.name = name;
        this.description = description;
        this.className = className;
        this.options = options;
        this.runtimeOptions = runtimeOptions;
        PartitionValueTransformer.$init$((PartitionValueTransformer)this);
        GenericDfTransformerDef.$init$((GenericDfTransformerDef)this);
        ConfigHolder.$init$((ConfigHolder)this);
        OptionsGenericDfTransformer.$init$((OptionsGenericDfTransformer)this);
        Product.$init$((Product)this);
        this.customTransformer = (CustomSnowparkDfTransformer)CustomCodeUtil$.MODULE$.getClassInstanceByName(className);
    }
}

