/*
 * Decompiled with CFR 0.152.
 */
package io.smartdatalake.workflow.executionMode;

import com.github.takezoe.scaladoc.Scaladoc;
import com.typesafe.config.Config;
import configs.ConfigKeyNaming;
import configs.ConfigReader;
import io.smartdatalake.config.ConfigHolder;
import io.smartdatalake.config.FromConfigFactory;
import io.smartdatalake.config.InstanceRegistry;
import io.smartdatalake.config.SdlConfigObject;
import io.smartdatalake.definitions.AuthMode;
import io.smartdatalake.definitions.Condition;
import io.smartdatalake.definitions.SaveModeOptions;
import io.smartdatalake.util.hdfs.PartitionValues;
import io.smartdatalake.util.hdfs.SparkRepartitionDef;
import io.smartdatalake.util.misc.SmartDataLakeLogger;
import io.smartdatalake.util.secrets.SecretProviderConfig;
import io.smartdatalake.util.secrets.StringOrSecret;
import io.smartdatalake.util.spark.DefaultExpressionData$;
import io.smartdatalake.util.spark.SparkExpressionUtil$;
import io.smartdatalake.workflow.ActionPipelineContext;
import io.smartdatalake.workflow.DataObjectState;
import io.smartdatalake.workflow.SubFeed;
import io.smartdatalake.workflow.action.executionMode.ExecutionMode;
import io.smartdatalake.workflow.action.executionMode.ExecutionModeResult;
import io.smartdatalake.workflow.action.executionMode.ExecutionModeResult$;
import io.smartdatalake.workflow.action.generic.transformer.GenericDfTransformer;
import io.smartdatalake.workflow.action.generic.transformer.GenericDfsTransformer;
import io.smartdatalake.workflow.action.script.ParsableScriptDef;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfCreatorConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomDfsTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.CustomFileTransformerConfig;
import io.smartdatalake.workflow.action.spark.customlogic.SparkUDFCreatorConfig;
import io.smartdatalake.workflow.connection.Connection;
import io.smartdatalake.workflow.dataframe.GenericSchema;
import io.smartdatalake.workflow.dataobject.DataObject;
import io.smartdatalake.workflow.dataobject.Expectation;
import io.smartdatalake.workflow.dataobject.HousekeepingMode;
import io.smartdatalake.workflow.dataobject.KafkaTopicDataObject;
import io.smartdatalake.workflow.executionMode.KafkaStateIncrementalMode$;
import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.spark.sql.streaming.OutputMode;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@Scaladoc(value="/**\n * A special incremental execution mode for Kafka Inputs, remembering the state from the last increment through the Kafka Consumer, e.g. committed offsets.\n * @param delayedMaxTimestampExpr Optional expression to define a delay to read latest offsets from Kafka. The expression has to return a timestamp which is used to select ending offsets to read from Kafka.\n *                                Define a spark sql expression working with the attributes of [[DefaultExpressionData]] returning a timestamp.\n *                                Default is to read latest offsets existing in Kafka.\n */")
@ScalaSignature(bytes="\u0006\u0001\t%d\u0001B\u0010!\u0001&B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tA\u0010\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u007f!)a\n\u0001C\u0001\u001f\"91\u000b\u0001a\u0001\n\u0013!\u0006b\u00023\u0001\u0001\u0004%I!\u001a\u0005\u0007W\u0002\u0001\u000b\u0015B+\t\u000b1\u0004A\u0011I7\t\u000f\u00055\u0001\u0001\"\u0011\u0002\u0010!9\u0011Q\u0006\u0001\u0005B\u0005=\u0002bBA:\u0001\u0011\u0005\u0013Q\u000f\u0005\b\u0003\u0013\u0003A\u0011IAF\u0011%\t)\nAA\u0001\n\u0003\t9\nC\u0005\u0002\u001c\u0002\t\n\u0011\"\u0001\u0002\u001e\"I\u00111\u0017\u0001\u0002\u0002\u0013\u0005\u0013Q\u0017\u0005\n\u0003\u000b\u0004\u0011\u0011!C\u0001\u0003\u000fD\u0011\"a4\u0001\u0003\u0003%\t!!5\t\u0013\u0005m\u0007!!A\u0005B\u0005u\u0007\"CAv\u0001\u0005\u0005I\u0011AAw\u0011%\t9\u0010AA\u0001\n\u0003\nI\u0010C\u0005\u0002|\u0002\t\t\u0011\"\u0011\u0002~\"I\u0011q \u0001\u0002\u0002\u0013\u0005#\u0011A\u0004\b\u0005K\u0001\u0003\u0012\u0001B\u0014\r\u0019y\u0002\u0005#\u0001\u0003*!1aj\u0006C\u0001\u0005WAqA!\f\u0018\t\u0003\u0012y\u0003C\u0005\u0002.]\t\t\u0011\"!\u0003N!I!\u0011K\f\u0012\u0002\u0013\u0005\u0011Q\u0014\u0005\n\u0005':\u0012\u0011!CA\u0005+B\u0011B!\u0018\u0018#\u0003%\t!!(\t\u0013\t}s#!A\u0005\n\t\u0005$!G&bM.\f7\u000b^1uK&s7M]3nK:$\u0018\r\\'pI\u0016T!!\t\u0012\u0002\u001b\u0015DXmY;uS>tWj\u001c3f\u0015\t\u0019C%\u0001\u0005x_J\\g\r\\8x\u0015\t)c%A\u0007t[\u0006\u0014H\u000fZ1uC2\f7.\u001a\u0006\u0002O\u0005\u0011\u0011n\\\u0002\u0001'\u0015\u0001!\u0006M\u001c;!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0019\te.\u001f*fMB\u0011\u0011'N\u0007\u0002e)\u0011\u0011e\r\u0006\u0003i\t\na!Y2uS>t\u0017B\u0001\u001c3\u00055)\u00050Z2vi&|g.T8eKB\u00111\u0006O\u0005\u0003s1\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002,w%\u0011A\b\f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0018I\u0016d\u0017-_3e\u001b\u0006DH+[7fgR\fW\u000e]#yaJ,\u0012a\u0010\t\u0004W\u0001\u0013\u0015BA!-\u0005\u0019y\u0005\u000f^5p]B\u00111I\u0013\b\u0003\t\"\u0003\"!\u0012\u0017\u000e\u0003\u0019S!a\u0012\u0015\u0002\rq\u0012xn\u001c;?\u0013\tIE&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u00172\u0013aa\u0015;sS:<'BA%-\u0003a!W\r\\1zK\u0012l\u0015\r\u001f+j[\u0016\u001cH/Y7q\u000bb\u0004(\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005A\u0013\u0006CA)\u0001\u001b\u0005\u0001\u0003bB\u001f\u0004!\u0003\u0005\raP\u0001\fW\u000647.Y%oaV$8/F\u0001V!\r16L\u0018\b\u0003/fs!!\u0012-\n\u00035J!A\u0017\u0017\u0002\u000fA\f7m[1hK&\u0011A,\u0018\u0002\u0004'\u0016\f(B\u0001.-!\ty&-D\u0001a\u0015\t\t'%\u0001\u0006eCR\fwN\u00196fGRL!a\u00191\u0003)-\u000bgm[1U_BL7\rR1uC>\u0013'.Z2u\u0003=Y\u0017MZ6b\u0013:\u0004X\u000f^:`I\u0015\fHC\u00014j!\tYs-\u0003\u0002iY\t!QK\\5u\u0011\u001dQW!!AA\u0002U\u000b1\u0001\u001f\u00132\u00031Y\u0017MZ6b\u0013:\u0004X\u000f^:!\u0003\u001d\u0001(/\u001a9be\u0016$\"A\\;\u0015\u0005\u0019|\u0007\"\u00029\b\u0001\b\t\u0018aB2p]R,\u0007\u0010\u001e\t\u0003eNl\u0011AI\u0005\u0003i\n\u0012Q#Q2uS>t\u0007+\u001b9fY&tWmQ8oi\u0016DH\u000fC\u0003w\u000f\u0001\u0007q/\u0001\u0005bGRLwN\\%e!\rA\u0018q\u0001\b\u0004s\u0006\u0005aB\u0001>\u007f\u001d\tYXP\u0004\u0002Fy&\tq%\u0003\u0002&M%\u0011q\u0010J\u0001\u0007G>tg-[4\n\t\u0005\r\u0011QA\u0001\u0010'\u0012d7i\u001c8gS\u001e|%M[3di*\u0011q\u0010J\u0005\u0005\u0003\u0013\tYA\u0001\u0005BGRLwN\\%e\u0015\u0011\t\u0019!!\u0002\u0002\u000fA\u0014X-\u00138jiR1\u0011\u0011CA\u000b\u0003C!2AZA\n\u0011\u0015\u0001\b\u0002q\u0001r\u0011\u001d\t9\u0002\u0003a\u0001\u00033\t\u0001b];c\r\u0016,Gm\u001d\t\u0005-n\u000bY\u0002E\u0002s\u0003;I1!a\b#\u0005\u001d\u0019VO\u0019$fK\u0012Dq!a\t\t\u0001\u0004\t)#\u0001\teCR\fwJ\u00196fGR\u001c8\u000b^1uKB!akWA\u0014!\r\u0011\u0018\u0011F\u0005\u0004\u0003W\u0011#a\u0004#bi\u0006|%M[3diN#\u0018\r^3\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0019\u0005E\u0012QHA \u0003\u0013\ni%!\u0015\u0015\t\u0005M\u00121\b\t\u0005W\u0001\u000b)\u0004E\u00022\u0003oI1!!\u000f3\u0005M)\u00050Z2vi&|g.T8eKJ+7/\u001e7u\u0011\u0015\u0001\u0018\u0002q\u0001r\u0011\u00151\u0018\u00021\u0001x\u0011\u001d\t\t%\u0003a\u0001\u0003\u0007\n\u0011\"\\1j]&s\u0007/\u001e;\u0011\u0007}\u000b)%C\u0002\u0002H\u0001\u0014!\u0002R1uC>\u0013'.Z2u\u0011\u001d\tY%\u0003a\u0001\u0003\u0007\n!\"\\1j]>+H\u000f];u\u0011\u001d\ty%\u0003a\u0001\u00037\tqa];c\r\u0016,G\rC\u0004\u0002T%\u0001\r!!\u0016\u00021A\f'\u000f^5uS>tg+\u00197vKN$&/\u00198tM>\u0014X\u000eE\u0004,\u0003/\nY&!\u001c\n\u0007\u0005eCFA\u0005Gk:\u001cG/[8ocA!akWA/!\u0011\ty&!\u001b\u000e\u0005\u0005\u0005$\u0002BA2\u0003K\nA\u0001\u001b3gg*\u0019\u0011q\r\u0013\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003W\n\tGA\bQCJ$\u0018\u000e^5p]Z\u000bG.^3t!\u001d\u0019\u0015qNA/\u0003;J1!!\u001dM\u0005\ri\u0015\r]\u0001\ta>\u001cH/\u0012=fGRa\u0011qOA>\u0003{\ny(!!\u0002\u0006R\u0019a-!\u001f\t\u000bAT\u00019A9\t\u000bYT\u0001\u0019A<\t\u000f\u0005\u0005#\u00021\u0001\u0002D!9\u00111\n\u0006A\u0002\u0005\r\u0003bBAB\u0015\u0001\u0007\u00111D\u0001\u0011[\u0006Lg.\u00138qkR\u001cVO\u0019$fK\u0012Dq!a\"\u000b\u0001\u0004\tY\"A\tnC&tw*\u001e;qkR\u001cVO\u0019$fK\u0012\fqAZ1di>\u0014\u00180\u0006\u0002\u0002\u000eB)\u0011qRAIa5\u0011\u0011QA\u0005\u0005\u0003'\u000b)AA\tGe>l7i\u001c8gS\u001e4\u0015m\u0019;pef\fAaY8qsR\u0019\u0001+!'\t\u000fub\u0001\u0013!a\u0001\u007f\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAPU\ry\u0014\u0011U\u0016\u0003\u0003G\u0003B!!*\u000206\u0011\u0011q\u0015\u0006\u0005\u0003S\u000bY+A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0016\u0017\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00022\u0006\u001d&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a.\u0011\t\u0005e\u00161Y\u0007\u0003\u0003wSA!!0\u0002@\u0006!A.\u00198h\u0015\t\t\t-\u0001\u0003kCZ\f\u0017bA&\u0002<\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u001a\t\u0004W\u0005-\u0017bAAgY\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111[Am!\rY\u0013Q[\u0005\u0004\u0003/d#aA!os\"A!\u000eEA\u0001\u0002\u0004\tI-A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ty\u000e\u0005\u0004\u0002b\u0006\u001d\u00181[\u0007\u0003\u0003GT1!!:-\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003S\f\u0019O\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAx\u0003k\u00042aKAy\u0013\r\t\u0019\u0010\f\u0002\b\u0005>|G.Z1o\u0011!Q'#!AA\u0002\u0005M\u0017\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005%\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005]\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0002p\n\r\u0001\u0002\u00036\u0016\u0003\u0003\u0005\r!a5)\u000f\u0001\u00119Aa\b\u0003\"A!!\u0011\u0002B\u000e\u001b\t\u0011YA\u0003\u0003\u0003\u000e\t=\u0011\u0001C:dC2\fGm\\2\u000b\t\tE!1C\u0001\bi\u0006\\WM_8f\u0015\u0011\u0011)Ba\u0006\u0002\r\u001dLG\u000f[;c\u0015\t\u0011I\"A\u0002d_6LAA!\b\u0003\f\tA1kY1mC\u0012|7-A\u0003wC2,X-\t\u0002\u0003$\u0005!\u0019l\f\u0016+\u0015\u0001R\u0003%\u0011\u0011ta\u0016\u001c\u0017.\u00197!S:\u001c'/Z7f]R\fG\u000eI3yK\u000e,H/[8oA5|G-\u001a\u0011g_J\u00043*\u00194lC\u0002Je\u000e];ug2\u0002#/Z7f[\n,'/\u001b8hAQDW\rI:uCR,\u0007E\u001a:p[\u0002\"\b.\u001a\u0011mCN$\b%\u001b8de\u0016lWM\u001c;!i\"\u0014x.^4iAQDW\rI&bM.\f\u0007eQ8ogVlWM\u001d\u0017!K::g\u0006I2p[6LG\u000f^3eA=4gm]3ug:R\u0001E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011eK2\f\u00170\u001a3NCb$\u0016.\\3ti\u0006l\u0007/\u0012=qe\u0002z\u0005\u000f^5p]\u0006d\u0007%\u001a=qe\u0016\u001c8/[8oAQ|\u0007\u0005Z3gS:,\u0007%\u0019\u0011eK2\f\u0017\u0010\t;pAI,\u0017\r\u001a\u0011mCR,7\u000f\u001e\u0011pM\u001a\u001cX\r^:!MJ|W\u000eI&bM.\fg\u0006\t+iK\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011iCN\u0004Co\u001c\u0011sKR,(O\u001c\u0011bAQLW.Z:uC6\u0004\be\u001e5jG\"\u0004\u0013n\u001d\u0011vg\u0016$\u0007\u0005^8!g\u0016dWm\u0019;!K:$\u0017N\\4!_\u001a47/\u001a;tAQ|\u0007E]3bI\u00022'o\\7!\u0017\u000647.\u0019\u0018\u000bA)\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011EK\u001aLg.\u001a\u0011bAM\u0004\u0018M]6!gFd\u0007%\u001a=qe\u0016\u001c8/[8oA]|'o[5oO\u0002:\u0018\u000e\u001e5!i\",\u0007%\u0019;ue&\u0014W\u000f^3tA=4\u0007eW.EK\u001a\fW\u000f\u001c;FqB\u0014Xm]:j_:$\u0015\r^1^;\u0002\u0012X\r^;s]&tw\rI1!i&lWm\u001d;b[Bt#\u0002\t\u0016!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002C)\u001a4bk2$\b%[:!i>\u0004#/Z1eA1\fG/Z:uA=4gm]3ug\u0002*\u00070[:uS:<\u0007%\u001b8!\u0017\u000647.\u0019\u0018\u000bA)z\u0013!G&bM.\f7\u000b^1uK&s7M]3nK:$\u0018\r\\'pI\u0016\u0004\"!U\f\u0014\u000b]Q\u0013Q\u0012\u001e\u0015\u0005\t\u001d\u0012A\u00034s_6\u001cuN\u001c4jOR!!\u0011\u0007B\u001f)\r\u0001&1\u0007\u0005\b\u0005kI\u00029\u0001B\u001c\u0003AIgn\u001d;b]\u000e,'+Z4jgR\u0014\u0018\u0010\u0005\u0003\u0002\u0010\ne\u0012\u0002\u0002B\u001e\u0003\u000b\u0011\u0001#\u00138ti\u0006t7-\u001a*fO&\u001cHO]=\t\r}L\u0002\u0019\u0001B !\u0011\u0011\tE!\u0013\u000e\u0005\t\r#bA@\u0003F)!!q\tB\f\u0003!!\u0018\u0010]3tC\u001a,\u0017\u0002\u0002B&\u0005\u0007\u0012aaQ8oM&<Gc\u0001)\u0003P!9QH\u0007I\u0001\u0002\u0004y\u0014aD1qa2LH\u0005Z3gCVdG\u000fJ\u0019\u0002\u000fUt\u0017\r\u001d9msR!!q\u000bB-!\rY\u0003i\u0010\u0005\t\u00057b\u0012\u0011!a\u0001!\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\r\u0004\u0003BA]\u0005KJAAa\u001a\u0002<\n1qJ\u00196fGR\u0004")
public class KafkaStateIncrementalMode
implements ExecutionMode,
Product,
scala.Serializable {
    private final Option<String> delayedMaxTimestampExpr;
    private Seq<KafkaTopicDataObject> kafkaInputs;
    private final Seq<Condition> applyConditionsDef;
    private final Seq<Condition> failConditionsDef;
    private transient Logger logger;
    private Option<Config> _config;
    private volatile transient boolean bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$1() {
        return KafkaStateIncrementalMode$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Option<String>> unapply(KafkaStateIncrementalMode kafkaStateIncrementalMode) {
        return KafkaStateIncrementalMode$.MODULE$.unapply(kafkaStateIncrementalMode);
    }

    public static Option<String> apply$default$1() {
        return KafkaStateIncrementalMode$.MODULE$.apply$default$1();
    }

    public static KafkaStateIncrementalMode fromConfig(Config config, InstanceRegistry instanceRegistry) {
        return KafkaStateIncrementalMode$.MODULE$.fromConfig(config, instanceRegistry);
    }

    @Scaladoc(value="/**\n   * A reader that reads [[StringOrSecret]] values.\n   */")
    public static ConfigReader<StringOrSecret> stringOrSecretReader() {
        return KafkaStateIncrementalMode$.MODULE$.stringOrSecretReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[HousekeepingMode]] values.\n   * Note that Expectation must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<HousekeepingMode> housekeepingModeReader() {
        return KafkaStateIncrementalMode$.MODULE$.housekeepingModeReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ExecutionMode]] values.\n   * Note that Expectation must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<ExecutionMode> executionModeReader() {
        return KafkaStateIncrementalMode$.MODULE$.executionModeReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[Connection]] values inside [[Agent]].\n   * Note that Connection must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<Connection> connectionDefReader() {
        return KafkaStateIncrementalMode$.MODULE$.connectionDefReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[Expectation]] values.\n   * Note that Expectation must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<Expectation> expectationReader() {
        return KafkaStateIncrementalMode$.MODULE$.expectationReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ParsableScriptDef]] values.\n   * Note that ParsableScriptDef must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<ParsableScriptDef> scriptDefReader() {
        return KafkaStateIncrementalMode$.MODULE$.scriptDefReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[GenericDfsTransformer]] values.\n   * Note that GenericDfsTransformer must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<GenericDfsTransformer> dfsTransformerReader() {
        return KafkaStateIncrementalMode$.MODULE$.dfsTransformerReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[GenericDfTransformer]] values.\n   * Note that GenericDfTransformer must be parsed according to it's 'type' attribute by using SDL ConfigParser.\n   */")
    public static ConfigReader<GenericDfTransformer> dfTransformerReader() {
        return KafkaStateIncrementalMode$.MODULE$.dfTransformerReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ActionId]] values.\n   */")
    public static ConfigReader<SdlConfigObject.ActionId> actionIdReader() {
        return KafkaStateIncrementalMode$.MODULE$.actionIdReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[DataObjectId]] values.\n   */")
    public static ConfigReader<SdlConfigObject.DataObjectId> dataObjectIdReader() {
        return KafkaStateIncrementalMode$.MODULE$.dataObjectIdReader();
    }

    @Scaladoc(value="/**\n   * A reader that reads [[ConnectionId]] values.\n   */")
    public static ConfigReader<SdlConfigObject.ConnectionId> connectionIdReader() {
        return KafkaStateIncrementalMode$.MODULE$.connectionIdReader();
    }

    public static ConfigReader<Map<SdlConfigObject.DataObjectId, String>> mapDataObjectIdStringReader(ConfigReader<Map<String, String>> configReader) {
        return KafkaStateIncrementalMode$.MODULE$.mapDataObjectIdStringReader(configReader);
    }

    public static ConfigReader<SaveModeOptions> saveModeOptionsReader() {
        return KafkaStateIncrementalMode$.MODULE$.saveModeOptionsReader();
    }

    public static ConfigReader<AuthMode> authModeReader() {
        return KafkaStateIncrementalMode$.MODULE$.authModeReader();
    }

    public static ConfigReader<Condition> conditionReader() {
        return KafkaStateIncrementalMode$.MODULE$.conditionReader();
    }

    public static ConfigReader<SecretProviderConfig> secretProviderConfigReader() {
        return KafkaStateIncrementalMode$.MODULE$.secretProviderConfigReader();
    }

    public static ConfigReader<SparkRepartitionDef> sparkRepartitionDefReader() {
        return KafkaStateIncrementalMode$.MODULE$.sparkRepartitionDefReader();
    }

    public static ConfigReader<SparkUDFCreatorConfig> sparkUdfCreatorConfigReader() {
        return KafkaStateIncrementalMode$.MODULE$.sparkUdfCreatorConfigReader();
    }

    public static ConfigReader<CustomFileTransformerConfig> customFileTransformerConfigReader() {
        return KafkaStateIncrementalMode$.MODULE$.customFileTransformerConfigReader();
    }

    public static ConfigReader<CustomDfsTransformerConfig> customDfsTransformerConfigReader() {
        return KafkaStateIncrementalMode$.MODULE$.customDfsTransformerConfigReader();
    }

    public static ConfigReader<CustomDfTransformerConfig> customDfTransformerConfigReader() {
        return KafkaStateIncrementalMode$.MODULE$.customDfTransformerConfigReader();
    }

    public static ConfigReader<CustomDfCreatorConfig> customDfCreatorConfigReader() {
        return KafkaStateIncrementalMode$.MODULE$.customDfCreatorConfigReader();
    }

    @Scaladoc(value="/**\n   * A [[ConfigReader]] reader that reads [[OutputMode]].\n   */")
    public static ConfigReader<OutputMode> outputModeReader() {
        return KafkaStateIncrementalMode$.MODULE$.outputModeReader();
    }

    @Scaladoc(value="/**\n   * A [[ConfigReader]] reader that reads [[GenericSchema]] values.\n   *\n   * This reader parses a Spark [[StructType]] by using the desired schema provider.\n   * The schema provider is included in the configuration value as prefix terminated by '#'.\n   */")
    public static ConfigReader<GenericSchema> genericSchemaReader() {
        return KafkaStateIncrementalMode$.MODULE$.genericSchemaReader();
    }

    @Scaladoc(value="/**\n   * default naming strategy is to allow lowerCamelCase and hypen-separated key naming, and fail on superfluous keys\n   */")
    public static <A> ConfigKeyNaming<A> sdlDefaultNaming() {
        return KafkaStateIncrementalMode$.MODULE$.sdlDefaultNaming();
    }

    public boolean mainInputOutputNeeded() {
        return ExecutionMode.mainInputOutputNeeded$((ExecutionMode)this);
    }

    @Scaladoc(value="/**\n   * Evaluate apply conditions.\n   * @return Some(true) if any apply conditions evaluates to true (or-logic), None if there are no apply conditions\n   */")
    public final Option<Object> evaluateApplyConditions(String actionId, SubFeed subFeed, ActionPipelineContext context) {
        return ExecutionMode.evaluateApplyConditions$((ExecutionMode)this, (String)actionId, (SubFeed)subFeed, (ActionPipelineContext)context);
    }

    @Scaladoc(value="/**\n   * Evaluate fail conditions.\n   * @throws ExecutionModeFailedException if any fail condition evaluates to true\n   */")
    public final <T extends Product> void evaluateFailConditions(String actionId, T data, TypeTags.TypeTag<T> evidence$1, ActionPipelineContext context) {
        ExecutionMode.evaluateFailConditions$((ExecutionMode)this, (String)actionId, data, evidence$1, (ActionPipelineContext)context);
    }

    @Scaladoc(value="/**\n   * If this execution mode should be run as asynchronous streaming process\n   */")
    public boolean isAsynchronous() {
        return ExecutionMode.isAsynchronous$((ExecutionMode)this);
    }

    public void logAndThrowException(String msg, Exception e) {
        SmartDataLakeLogger.logAndThrowException$((SmartDataLakeLogger)this, (String)msg, (Exception)e);
    }

    public Exception logException(Exception e) {
        return SmartDataLakeLogger.logException$((SmartDataLakeLogger)this, (Exception)e);
    }

    public void logWithSeverity(Level severity, String msg, Throwable cause) {
        SmartDataLakeLogger.logWithSeverity$((SmartDataLakeLogger)this, (Level)severity, (String)msg, (Throwable)cause);
    }

    public Seq<Condition> applyConditionsDef() {
        return this.applyConditionsDef;
    }

    public Seq<Condition> failConditionsDef() {
        return this.failConditionsDef;
    }

    public void io$smartdatalake$workflow$action$executionMode$ExecutionMode$_setter_$applyConditionsDef_$eq(Seq<Condition> x$1) {
        this.applyConditionsDef = x$1;
    }

    public void io$smartdatalake$workflow$action$executionMode$ExecutionMode$_setter_$failConditionsDef_$eq(Seq<Condition> x$1) {
        this.failConditionsDef = x$1;
    }

    private Logger logger$lzycompute() {
        KafkaStateIncrementalMode kafkaStateIncrementalMode = this;
        synchronized (kafkaStateIncrementalMode) {
            if (!this.bitmap$trans$0) {
                this.logger = SmartDataLakeLogger.logger$((SmartDataLakeLogger)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Option<Config> _config() {
        return this._config;
    }

    public void _config_$eq(Option<Config> x$1) {
        this._config = x$1;
    }

    public Option<String> delayedMaxTimestampExpr() {
        return this.delayedMaxTimestampExpr;
    }

    private Seq<KafkaTopicDataObject> kafkaInputs() {
        return this.kafkaInputs;
    }

    private void kafkaInputs_$eq(Seq<KafkaTopicDataObject> x$1) {
        this.kafkaInputs = x$1;
    }

    public void prepare(String actionId, ActionPipelineContext context) {
        this.delayedMaxTimestampExpr().foreach((Function1 & Serializable & scala.Serializable)expression -> {
            KafkaStateIncrementalMode.$anonfun$prepare$1(actionId, expression);
            return BoxedUnit.UNIT;
        });
    }

    public void preInit(Seq<SubFeed> subFeeds, Seq<DataObjectState> dataObjectsState, ActionPipelineContext context) {
        this.kafkaInputs_$eq((Seq<KafkaTopicDataObject>)((Seq)((TraversableLike)subFeeds.map((Function1 & Serializable & scala.Serializable)s -> (DataObject)context.instanceRegistry().get((SdlConfigObject.ConfigObjectId)new SdlConfigObject.DataObjectId(s.dataObjectId())), Seq$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends DataObject, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof KafkaTopicDataObject) {
                    KafkaTopicDataObject kafkaTopicDataObject = (KafkaTopicDataObject)A1;
                    object = kafkaTopicDataObject;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(DataObject x1) {
                DataObject dataObject = x1;
                boolean bl = dataObject instanceof KafkaTopicDataObject;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())));
        Predef$.MODULE$.assert(this.kafkaInputs().nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "KafkaStateIncrementalMode needs at least one KafkaTopicDataObject as input");
    }

    public Option<ExecutionModeResult> apply(String actionId, DataObject mainInput, DataObject mainOutput, SubFeed subFeed, Function1<Seq<PartitionValues>, Map<PartitionValues, PartitionValues>> partitionValuesTransform, ActionPipelineContext context) {
        Option delayedMaxTimestamp = this.delayedMaxTimestampExpr().flatMap((Function1 & Serializable & scala.Serializable)expr -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(KafkaStateIncrementalMode.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(KafkaStateIncrementalMode.class.getClassLoader());
            public final class Io_smartdatalake_workflow_executionMode_KafkaStateIncrementalMode$$typecreator1$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("io.smartdatalake.util.spark.DefaultExpressionData").asType().toTypeConstructor();
                }

                public Io_smartdatalake_workflow_executionMode_KafkaStateIncrementalMode$$typecreator1$2(KafkaStateIncrementalMode $outer) {
                }
            }
            public final class Io_smartdatalake_workflow_executionMode_KafkaStateIncrementalMode$$typecreator2$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.sql.Timestamp").asType().toTypeConstructor();
                }

                public Io_smartdatalake_workflow_executionMode_KafkaStateIncrementalMode$$typecreator2$2(KafkaStateIncrementalMode $outer) {
                }
            }
            return SparkExpressionUtil$.MODULE$.evaluate((SdlConfigObject.ConfigObjectId)new SdlConfigObject.ActionId(actionId), (Option)new Some((Object)"delayedMaxTimestampExpr"), expr, (Product)DefaultExpressionData$.MODULE$.from(context, (Seq)Nil$.MODULE$), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Io_smartdatalake_workflow_executionMode_KafkaStateIncrementalMode$$typecreator1$2(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Io_smartdatalake_workflow_executionMode_KafkaStateIncrementalMode$$typecreator2$2(null)), ClassTag$.MODULE$.apply(Timestamp.class));
        });
        Map options = (Map)((TraversableLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delayedMaxTimestamp"), (Object)delayedMaxTimestamp.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString()))}))).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, Option<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    String key = (String)A1._1();
                    Option option = (Option)A1._2();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String value = (String)some.value();
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, Option<String>> x1) {
                Option option;
                Tuple2<String, Option<String>> tuple2 = x1;
                boolean bl = tuple2 != null && (option = (Option)tuple2._2()) instanceof Some;
                return bl;
            }
        }, Map$.MODULE$.canBuildFrom());
        this.kafkaInputs().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.enableKafkaStateIncrementalMode((Option<Timestamp>)delayedMaxTimestamp);
            return BoxedUnit.UNIT;
        });
        Map x$12 = options;
        Seq x$22 = ExecutionModeResult$.MODULE$.apply$default$1();
        Seq x$3 = ExecutionModeResult$.MODULE$.apply$default$2();
        Option x$4 = ExecutionModeResult$.MODULE$.apply$default$3();
        Option x$5 = ExecutionModeResult$.MODULE$.apply$default$4();
        return new Some((Object)new ExecutionModeResult(x$22, x$3, x$4, x$5, x$12));
    }

    public void postExec(String actionId, DataObject mainInput, DataObject mainOutput, SubFeed mainInputSubFeed, SubFeed mainOutputSubFeed, ActionPipelineContext context) {
        this.kafkaInputs().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.commitIncrementalOutputState(context);
            return BoxedUnit.UNIT;
        });
    }

    public FromConfigFactory<ExecutionMode> factory() {
        return KafkaStateIncrementalMode$.MODULE$;
    }

    public KafkaStateIncrementalMode copy(Option<String> delayedMaxTimestampExpr) {
        return new KafkaStateIncrementalMode(delayedMaxTimestampExpr);
    }

    public Option<String> copy$default$1() {
        return this.delayedMaxTimestampExpr();
    }

    public String productPrefix() {
        return "KafkaStateIncrementalMode";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return this.delayedMaxTimestampExpr();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof KafkaStateIncrementalMode;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof KafkaStateIncrementalMode)) return false;
        boolean bl = true;
        if (!bl) return false;
        KafkaStateIncrementalMode kafkaStateIncrementalMode = (KafkaStateIncrementalMode)x$1;
        Option<String> option = this.delayedMaxTimestampExpr();
        Option<String> option2 = kafkaStateIncrementalMode.delayedMaxTimestampExpr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!kafkaStateIncrementalMode.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$prepare$1(String actionId$1, String expression) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(KafkaStateIncrementalMode.class.getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(KafkaStateIncrementalMode.class.getClassLoader());
        public final class Io_smartdatalake_workflow_executionMode_KafkaStateIncrementalMode$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("io.smartdatalake.util.spark.DefaultExpressionData").asType().toTypeConstructor();
            }

            public Io_smartdatalake_workflow_executionMode_KafkaStateIncrementalMode$$typecreator1$1(KafkaStateIncrementalMode $outer) {
            }
        }
        public final class Io_smartdatalake_workflow_executionMode_KafkaStateIncrementalMode$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.sql.Timestamp").asType().toTypeConstructor();
            }

            public Io_smartdatalake_workflow_executionMode_KafkaStateIncrementalMode$$typecreator2$1(KafkaStateIncrementalMode $outer) {
            }
        }
        SparkExpressionUtil$.MODULE$.syntaxCheck((SdlConfigObject.ConfigObjectId)new SdlConfigObject.ActionId(actionId$1), (Option)new Some((Object)"delayedMaxTimestampExpr"), expression, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Io_smartdatalake_workflow_executionMode_KafkaStateIncrementalMode$$typecreator1$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Io_smartdatalake_workflow_executionMode_KafkaStateIncrementalMode$$typecreator2$1(null)), ClassTag$.MODULE$.apply(Timestamp.class));
    }

    public KafkaStateIncrementalMode(Option<String> delayedMaxTimestampExpr) {
        this.delayedMaxTimestampExpr = delayedMaxTimestampExpr;
        ConfigHolder.$init$((ConfigHolder)this);
        SmartDataLakeLogger.$init$((SmartDataLakeLogger)this);
        ExecutionMode.$init$((ExecutionMode)this);
        Product.$init$((Product)this);
        this.kafkaInputs = (Seq)Nil$.MODULE$;
    }
}

