/*
 * Decompiled with CFR 0.152.
 */
package io.smartdatalake.workflow.dataobject;

import com.github.takezoe.scaladoc.Scaladoc;
import io.smartdatalake.workflow.dataobject.TopicPartitionOffsets$;
import java.io.Serializable;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Scaladoc(value="/**\n * Offsets to process per topic partition\n *\n * Note: endOffset is exclusive\n */")
@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u0013'\t>B\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005}!A1\n\u0001BK\u0002\u0013\u0005A\n\u0003\u0005T\u0001\tE\t\u0015!\u0003N\u0011!!\u0006A!f\u0001\n\u0003a\u0005\u0002C+\u0001\u0005#\u0005\u000b\u0011B'\t\u000bY\u0003A\u0011A,\t\u000bu\u0003A\u0011\u00010\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004!9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0001bBA\u000f\u0001\u0011\u0005\u00111\u0002\u0005\n\u0003?\u0001\u0011\u0011!C\u0001\u0003CA\u0011\"!\u000b\u0001#\u0003%\t!a\u000b\t\u0013\u0005\u0005\u0003!%A\u0005\u0002\u0005\r\u0003\"CA$\u0001E\u0005I\u0011AA\"\u0011%\tI\u0005AA\u0001\n\u0003\nY\u0005C\u0005\u0002\\\u0001\t\t\u0011\"\u0001\u0002^!I\u0011q\f\u0001\u0002\u0002\u0013\u0005\u0011\u0011\r\u0005\n\u0003[\u0002\u0011\u0011!C!\u0003_B\u0011\"! \u0001\u0003\u0003%\t!a \t\u0013\u0005%\u0005!!A\u0005B\u0005-\u0005\"CAG\u0001\u0005\u0005I\u0011IAH\u0011%\t\t\nAA\u0001\n\u0003\n\u0019jB\u0004\u0002\u001e\u001aBI!a(\u0007\r\u00152\u0003\u0012BAQ\u0011\u00191\u0016\u0004\"\u0001\u0002$\"I\u0011QU\rC\u0002\u0013\u0005\u0011Q\f\u0005\b\u0003OK\u0002\u0015!\u0003n\u0011%\tI+\u0007b\u0001\n\u0003\ti\u0006C\u0004\u0002,f\u0001\u000b\u0011B7\t\u000f\u00055\u0016\u0004\"\u0001\u00020\"9\u00111Y\r\u0005\u0002\u0005\u0015\u0007bBAl3\u0011\u0005\u0011\u0011\u001c\u0005\n\u0003SL\u0012\u0011!CA\u0003WD\u0011\"a=\u001a\u0003\u0003%\t)!>\t\u0013\t\r\u0011$!A\u0005\n\t\u0015!!\u0006+pa&\u001c\u0007+\u0019:uSRLwN\\(gMN,Go\u001d\u0006\u0003O!\n!\u0002Z1uC>\u0014'.Z2u\u0015\tI#&\u0001\u0005x_J\\g\r\\8x\u0015\tYC&A\u0007t[\u0006\u0014H\u000fZ1uC2\f7.\u001a\u0006\u0002[\u0005\u0011\u0011n\\\u0002\u0001'\u0011\u0001\u0001GN\u001d\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\r\u0005s\u0017PU3g!\t\tt'\u0003\u00029e\t9\u0001K]8ek\u000e$\bCA\u0019;\u0013\tY$G\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0003y\u0002\"a\u0010%\u000e\u0003\u0001S!!\u0011\"\u0002\r\r|W.\\8o\u0015\t\u0019E)A\u0003lC\u001a\\\u0017M\u0003\u0002F\r\u00061\u0011\r]1dQ\u0016T\u0011aR\u0001\u0004_J<\u0017BA%A\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\fgR\f'\u000f^(gMN,G/F\u0001N!\r\td\nU\u0005\u0003\u001fJ\u0012aa\u00149uS>t\u0007CA\u0019R\u0013\t\u0011&G\u0001\u0003M_:<\u0017\u0001D:uCJ$xJ\u001a4tKR\u0004\u0013!C3oI>3gm]3u\u0003))g\u000eZ(gMN,G\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\taS6\f\u0018\t\u00033\u0002i\u0011A\n\u0005\u0006y\u001d\u0001\rA\u0010\u0005\u0006\u0017\u001e\u0001\r!\u0014\u0005\u0006)\u001e\u0001\r!T\u0001\u0006gBd\u0017\u000e\u001e\u000b\u0003?.\u00042\u0001\u00195Y\u001d\t\tgM\u0004\u0002cK6\t1M\u0003\u0002e]\u00051AH]8pizJ\u0011aM\u0005\u0003OJ\nq\u0001]1dW\u0006<W-\u0003\u0002jU\n\u00191+Z9\u000b\u0005\u001d\u0014\u0004\"\u00027\t\u0001\u0004i\u0017AC7bq>3gm]3ugB\u0011\u0011G\\\u0005\u0003_J\u00121!\u00138uQ\u0011A\u0011/ @\u0011\u0005I\\X\"A:\u000b\u0005Q,\u0018\u0001C:dC2\fGm\\2\u000b\u0005Y<\u0018a\u0002;bW\u0016Tx.\u001a\u0006\u0003qf\faaZ5uQV\u0014'\"\u0001>\u0002\u0007\r|W.\u0003\u0002}g\nA1kY1mC\u0012|7-A\u0003wC2,X-I\u0001\u0000\u0003\u0005\u0005sF\u000b\u0016\u000bA\u0001\u0002#\u0006I*qY&$8\u000f\t;iSN\u0004Ck\u001c9jGB\u000b'\u000f^5uS>twJ\u001a4tKR\u001c\b%\u001b8ti\u0006t7-\u001a\u0011j]R|\u0007%\\;mi&\u0004H.\u001a\u0011j]N$\u0018M\\2fg\u0002:\u0017N^3oAQDW\rI7bq&lW/\u001c\u0011pM\u001a\u001cX\r^:!a\u0016\u0014\b\u0005^1tW*\u0001\u0003\u0005\t\u0016\u000bA\u0001\u0002#\u0006\t(pi\u0016T\u0004%[7qY\u0016lWM\u001c;bi&|g\u000eI5tAI,7-\u001e:tSZ,'\u0002\t\u0011!U=\n!cZ3u\u000b6\u0004H/_#oI\u0016sGO]5fgR\u0019q,!\u0002\t\r\u0005\u001d\u0011\u00021\u0001n\u0003\u0011\u0019\u0018N_3\u0002-\u001d,Go\u0015;beR|eMZ:fi\u001a{'o\u00159be.,\"!!\u0004\u0011\t\u0005=\u0011q\u0003\b\u0005\u0003#\t\u0019\u0002\u0005\u0002ce%\u0019\u0011Q\u0003\u001a\u0002\rA\u0013X\rZ3g\u0013\u0011\tI\"a\u0007\u0003\rM#(/\u001b8h\u0015\r\t)BM\u0001\u0015O\u0016$XI\u001c3PM\u001a\u001cX\r\u001e$peN\u0003\u0018M]6\u0002\t\r|\u0007/\u001f\u000b\b1\u0006\r\u0012QEA\u0014\u0011\u001daD\u0002%AA\u0002yBqa\u0013\u0007\u0011\u0002\u0003\u0007Q\nC\u0004U\u0019A\u0005\t\u0019A'\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0006\u0016\u0004}\u0005=2FAA\u0019!\u0011\t\u0019$!\u0010\u000e\u0005\u0005U\"\u0002BA\u001c\u0003s\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005m\"'\u0001\u0006b]:|G/\u0019;j_:LA!a\u0010\u00026\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\t\u0016\u0004\u001b\u0006=\u0012AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u00055\u0003\u0003BA(\u00033j!!!\u0015\u000b\t\u0005M\u0013QK\u0001\u0005Y\u0006twM\u0003\u0002\u0002X\u0005!!.\u0019<b\u0013\u0011\tI\"!\u0015\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u00035\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002d\u0005%\u0004cA\u0019\u0002f%\u0019\u0011q\r\u001a\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002lI\t\t\u00111\u0001n\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u000f\t\u0007\u0003g\nI(a\u0019\u000e\u0005\u0005U$bAA<e\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005m\u0014Q\u000f\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0002\u0006\u001d\u0005cA\u0019\u0002\u0004&\u0019\u0011Q\u0011\u001a\u0003\u000f\t{w\u000e\\3b]\"I\u00111\u000e\u000b\u0002\u0002\u0003\u0007\u00111M\u0001\tQ\u0006\u001c\bnQ8eKR\tQ.\u0001\u0005u_N#(/\u001b8h)\t\ti%\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u0003\u000b)\nC\u0005\u0002l]\t\t\u00111\u0001\u0002d!*\u0001!]?\u0002\u001a\u0006\u0012\u00111T\u0001U_)R#\u0002\t\u0016!\u001f\u001a47/\u001a;tAQ|\u0007\u0005\u001d:pG\u0016\u001c8\u000f\t9fe\u0002\"x\u000e]5dAA\f'\u000f^5uS>t'\u0002\t\u0016\u000bA)\u0002cj\u001c;fu\u0001*g\u000eZ(gMN,G\u000fI5tA\u0015D8\r\\;tSZ,'\u0002\t\u00160\u0003U!v\u000e]5d!\u0006\u0014H/\u001b;j_:|eMZ:fiN\u0004\"!W\r\u0014\u0007e\u0001\u0014\b\u0006\u0002\u0002 \u0006)B-\u001a4bk2$xJ\u001a4tKR,\u0015M\u001d7jKN$\u0018A\u00063fM\u0006,H\u000e^(gMN,G/R1sY&,7\u000f\u001e\u0011\u0002'\u0011,g-Y;mi>3gm]3u\u0019\u0006$Xm\u001d;\u0002)\u0011,g-Y;mi>3gm]3u\u0019\u0006$Xm\u001d;!\u0003E9W\r^(gMN,GOR8s'B\f'o\u001b\u000b\t\u0003\u001b\t\t,!.\u0002:\"1\u00111W\u0010A\u00025\f\u0011\u0002]1si&$\u0018n\u001c8\t\r\u0005]v\u00041\u0001N\u0003\u0019ygMZ:fi\"1\u00111X\u0010A\u00025\fQ\u0002Z3gCVdGo\u00144gg\u0016$\b&B\u0010r{\u0006}\u0016EAAa\u0003\u0005\rsF\u000b\u0016\u000bA\u0001\u0002#\u0006I\"sK\u0006$X\rI:ue&tw\r\t;pAU\u001cX\rI1tAM$\u0018M\u001d;j]\u001e|SM\u001c3j]\u001e|eMZ:fi\u0002z\u0007\u000f^5p]\u00022wN\u001d\u0011Ta\u0006\u00148\u000eI&bM.\f\u0007\u0005Z1uC\u0002\u001ax.\u001e:dK*\u0001\u0003\u0005\t\u0016\u000bA\u0001\u0002#\u0006I(viB,H\u000f\t4pe6\fGO\u000f\u0011aEq\u0002\u0018M\u001d;ji&|gN\u00142;S:$XmZ3s}\tRDh\u001c4gg\u0016$(\b\\8oOz\u0002\u0007M\u0003\u0011!A)z\u0013a\u00059beN,wJ\u001a4tKR4uN]*qCJ\\G\u0003BAd\u0003\u001b\u0004R!MAe[6K1!a33\u0005\u0019!V\u000f\u001d7fe!9\u0011q\u001a\u0011A\u0002\u00055\u0011!C8gMN,Go\u0015;sQ\u0015\u0001\u0013/`AjC\t\t).AA\u001b_)R#\u0002\t\u0011!U\u0001\u0002\u0016M]:fAM$\u0018M\u001d;j]\u001e|SM\u001c3j]\u001e|eMZ:fi\u0002*8/\u001a3!M>\u0014\be\u00159be.\u00043*Y6gC\u0002\"\u0017\r^1!g>,(oY3!MJ|W\u000eI:ue&twM\u0003\u0011!A)R\u0001\u0005\t\u0011+A\u0015C\b/Z2uK\u0012\u0004cm\u001c:nCRT\u0004\u0005\u0019\u0012=a\u0006\u0014H/\u001b;j_:t%MO5oi\u0016<WM\u001d #uqzgMZ:fijbwN\\4?A*\u0001\u0003\u0005\t\u00160\u0003-1'o\\7PM\u001a\u001cX\r^:\u0015\u000f}\u000bY.a8\u0002f\"9\u0011Q\\\u0011A\u0002\u00055\u0011!\u0002;pa&\u001c\u0007bBAqC\u0001\u0007\u00111]\u0001\u0010gR\f'\u000f^5oO>3gm]3ugB!\u0001\r[Ad\u0011\u001d\t9/\ta\u0001\u0003G\fQ\"\u001a8eS:<wJ\u001a4tKR\u001c\u0018!B1qa2LHc\u0002-\u0002n\u0006=\u0018\u0011\u001f\u0005\u0006y\t\u0002\rA\u0010\u0005\u0006\u0017\n\u0002\r!\u0014\u0005\u0006)\n\u0002\r!T\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t90a@\u0011\tEr\u0015\u0011 \t\u0007c\u0005mh(T'\n\u0007\u0005u(G\u0001\u0004UkBdWm\r\u0005\t\u0005\u0003\u0019\u0013\u0011!a\u00011\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u000f\u0001B!a\u0014\u0003\n%!!1BA)\u0005\u0019y%M[3di\u0002")
public class TopicPartitionOffsets
implements Product,
scala.Serializable {
    private final TopicPartition topicPartition;
    private final Option<Object> startOffset;
    private final Option<Object> endOffset;

    public static Option<Tuple3<TopicPartition, Option<Object>, Option<Object>>> unapply(TopicPartitionOffsets topicPartitionOffsets) {
        return TopicPartitionOffsets$.MODULE$.unapply(topicPartitionOffsets);
    }

    public static TopicPartitionOffsets apply(TopicPartition topicPartition, Option<Object> option, Option<Object> option2) {
        return TopicPartitionOffsets$.MODULE$.apply(topicPartition, option, option2);
    }

    public static Seq<TopicPartitionOffsets> fromOffsets(String string, Seq<Tuple2<Object, Option<Object>>> seq, Seq<Tuple2<Object, Option<Object>>> seq2) {
        return TopicPartitionOffsets$.MODULE$.fromOffsets(string, seq, seq2);
    }

    @Scaladoc(value="/**\n   * Parse starting/endingOffset used for Spark Kakfa data source from string\n   *\n   * Expected format: `\"<partitionNb:integer>\":<offset:long>`\n   */")
    public static Tuple2<Object, Option<Object>> parseOffsetForSpark(String string) {
        return TopicPartitionOffsets$.MODULE$.parseOffsetForSpark(string);
    }

    @Scaladoc(value="/**\n   * Create string to use as starting/endingOffset option for Spark Kafka data source\n   *\n   * Output format: `\"<partitionNb:integer>\":<offset:long>``\n   */")
    public static String getOffsetForSpark(int n, Option<Object> option, int n2) {
        return TopicPartitionOffsets$.MODULE$.getOffsetForSpark(n, option, n2);
    }

    public static int defaultOffsetLatest() {
        return TopicPartitionOffsets$.MODULE$.defaultOffsetLatest();
    }

    public static int defaultOffsetEarliest() {
        return TopicPartitionOffsets$.MODULE$.defaultOffsetEarliest();
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Option<Object> startOffset() {
        return this.startOffset;
    }

    public Option<Object> endOffset() {
        return this.endOffset;
    }

    @Scaladoc(value="/**\n   * Splits this TopicPartitionOffsets instance into multiple instances given the maximum offsets per task\n   *\n   * Note: implementation is recursive\n   */")
    public Seq<TopicPartitionOffsets> split(int maxOffsets) {
        return this.startOffset().isDefined() && this.endOffset().isDefined() ? (BoxesRunTime.unboxToLong((Object)this.startOffset().get()) + (long)maxOffsets < BoxesRunTime.unboxToLong((Object)this.endOffset().get()) ? (Seq)((TraversableLike)new .colon.colon((Object)new TopicPartitionOffsets(this.topicPartition(), this.startOffset(), (Option<Object>)this.startOffset().map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$42 -> x$42 + (long)maxOffsets)), (List)Nil$.MODULE$)).$plus$plus(new TopicPartitionOffsets(this.topicPartition(), (Option<Object>)this.startOffset().map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$43 -> x$43 + (long)maxOffsets), this.endOffset()).split(maxOffsets), Seq$.MODULE$.canBuildFrom()) : (Seq)new .colon.colon((Object)this, (List)Nil$.MODULE$)) : (Seq)new .colon.colon((Object)this, (List)Nil$.MODULE$);
    }

    public Seq<TopicPartitionOffsets> getEmptyEndEntries(int size) {
        return (Seq)Seq$.MODULE$.fill(size, (Function0 & Serializable & scala.Serializable)() -> {
            Option<Object> x$1 = this.endOffset();
            TopicPartition x$2 = this.copy$default$1();
            Option<Object> x$3 = this.copy$default$3();
            return this.copy(x$2, x$1, x$3);
        });
    }

    public String getStartOffsetForSpark() {
        return TopicPartitionOffsets$.MODULE$.getOffsetForSpark(this.topicPartition().partition(), this.startOffset(), TopicPartitionOffsets$.MODULE$.defaultOffsetEarliest());
    }

    public String getEndOffsetForSpark() {
        return TopicPartitionOffsets$.MODULE$.getOffsetForSpark(this.topicPartition().partition(), this.endOffset(), TopicPartitionOffsets$.MODULE$.defaultOffsetLatest());
    }

    public TopicPartitionOffsets copy(TopicPartition topicPartition, Option<Object> startOffset, Option<Object> endOffset) {
        return new TopicPartitionOffsets(topicPartition, startOffset, endOffset);
    }

    public TopicPartition copy$default$1() {
        return this.topicPartition();
    }

    public Option<Object> copy$default$2() {
        return this.startOffset();
    }

    public Option<Object> copy$default$3() {
        return this.endOffset();
    }

    public String productPrefix() {
        return "TopicPartitionOffsets";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Option<Object> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.topicPartition();
                break;
            }
            case 1: {
                option = this.startOffset();
                break;
            }
            case 2: {
                option = this.endOffset();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return option;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TopicPartitionOffsets;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TopicPartitionOffsets)) return false;
        boolean bl = true;
        if (!bl) return false;
        TopicPartitionOffsets topicPartitionOffsets = (TopicPartitionOffsets)x$1;
        TopicPartition topicPartition = this.topicPartition();
        TopicPartition topicPartition2 = topicPartitionOffsets.topicPartition();
        if (topicPartition == null) {
            if (topicPartition2 != null) {
                return false;
            }
        } else if (!topicPartition.equals(topicPartition2)) return false;
        Option<Object> option = this.startOffset();
        Option<Object> option2 = topicPartitionOffsets.startOffset();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Object> option3 = this.endOffset();
        Option<Object> option4 = topicPartitionOffsets.endOffset();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!topicPartitionOffsets.canEqual(this)) return false;
        return true;
    }

    public TopicPartitionOffsets(TopicPartition topicPartition, Option<Object> startOffset, Option<Object> endOffset) {
        this.topicPartition = topicPartition;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        Product.$init$((Product)this);
    }
}

