/*
 * Decompiled with CFR 0.152.
 */
package io.smartdatalake.workflow.dataobject;

import com.github.takezoe.scaladoc.Scaladoc;
import io.smartdatalake.workflow.dataobject.TopicPartitionOffsets;
import java.io.Serializable;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

public final class TopicPartitionOffsets$
implements scala.Serializable {
    public static TopicPartitionOffsets$ MODULE$;
    private final int defaultOffsetEarliest;
    private final int defaultOffsetLatest;

    static {
        new TopicPartitionOffsets$();
    }

    public int defaultOffsetEarliest() {
        return this.defaultOffsetEarliest;
    }

    public int defaultOffsetLatest() {
        return this.defaultOffsetLatest;
    }

    @Scaladoc(value="/**\n   * Create string to use as starting/endingOffset option for Spark Kafka data source\n   *\n   * Output format: `\"<partitionNb:integer>\":<offset:long>``\n   */")
    public String getOffsetForSpark(int partition, Option<Object> offset, int defaultOffset) {
        return new StringBuilder(3).append("\"").append(partition).append("\":").append(offset.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> defaultOffset)).toString();
    }

    @Scaladoc(value="/**\n   * Parse starting/endingOffset used for Spark Kakfa data source from string\n   *\n   * Expected format: `\"<partitionNb:integer>\":<offset:long>`\n   */")
    public Tuple2<Object, Option<Object>> parseOffsetForSpark(String offsetStr) {
        String string;
        Regex offsetRegex = new StringOps(Predef$.MODULE$.augmentString("\"([0-9]*)\":(-?[0-9]*)")).r().anchored();
        Option option = offsetRegex.unapplySeq((CharSequence)(string = offsetStr));
        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) {
            throw new IllegalStateException(new StringBuilder(50).append("OffsetsForSpark '").append(offsetStr).append("' does not match regex pattern '").append(offsetRegex.pattern().toString()).append("'").toString());
        }
        String partitionStr = (String)((LinearSeqOptimized)option.get()).apply(0);
        String offsetStr2 = (String)((LinearSeqOptimized)option.get()).apply(1);
        Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(new StringOps(Predef$.MODULE$.augmentString(partitionStr)).toInt(), new StringOps(Predef$.MODULE$.augmentString(offsetStr2)).toLong());
        Tuple2.mcIJ.sp sp3 = sp2;
        if (sp3 == null) {
            throw new MatchError((Object)sp3);
        }
        int partition = sp3._1$mcI$sp();
        long offset = sp3._2$mcJ$sp();
        Tuple2.mcIJ.sp sp4 = new Tuple2.mcIJ.sp(partition, offset);
        Tuple2.mcIJ.sp sp5 = sp4;
        int partition2 = sp5._1$mcI$sp();
        long offset2 = sp5._2$mcJ$sp();
        None$ offsetOption = offset2 >= 0L ? new Some((Object)BoxesRunTime.boxToLong((long)offset2)) : None$.MODULE$;
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)partition2), (Object)offsetOption);
    }

    public Seq<TopicPartitionOffsets> fromOffsets(String topic, Seq<Tuple2<Object, Option<Object>>> startingOffsets, Seq<Tuple2<Object, Option<Object>>> endingOffsets) {
        Predef$.MODULE$.assert(startingOffsets.size() == endingOffsets.size());
        Map endingOffsetsLkp = endingOffsets.toMap(Predef$.MODULE$.$conforms());
        return (Seq)startingOffsets.map((Function1 & Serializable & scala.Serializable)s -> new TopicPartitionOffsets(new TopicPartition(topic, s._1$mcI$sp()), (Option<Object>)((Option)s._2()), (Option<Object>)((Option)endingOffsetsLkp.apply((Object)BoxesRunTime.boxToInteger((int)s._1$mcI$sp())))), Seq$.MODULE$.canBuildFrom());
    }

    public TopicPartitionOffsets apply(TopicPartition topicPartition, Option<Object> startOffset, Option<Object> endOffset) {
        return new TopicPartitionOffsets(topicPartition, startOffset, endOffset);
    }

    public Option<Tuple3<TopicPartition, Option<Object>, Option<Object>>> unapply(TopicPartitionOffsets x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.topicPartition(), x$0.startOffset(), x$0.endOffset()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TopicPartitionOffsets$() {
        MODULE$ = this;
        this.defaultOffsetEarliest = -2;
        this.defaultOffsetLatest = -1;
    }
}

