/*
 * Decompiled with CFR 0.152.
 */
package io.smartdatalake.workflow.dataobject;

import com.github.takezoe.scaladoc.Scaladoc;
import io.smartdatalake.workflow.dataobject.DatePartitionColumnDef$;
import io.smartdatalake.workflow.dataobject.TemporalQueries$;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Scaladoc(value="/**\n * Definition of date partition column to extract formatted time into column.\n *\n * @param colName date partition column name to extract time into column on batch read\n * @param timeFormat time format for timestamp in date partition column, definition according to java DateTimeFormatter. Default is \"yyyyMMdd\".\n * @param timeUnit time unit for timestamp in date partition column, definition according to java ChronoUnit. Default is \"days\".\n * @param timeZone time zone used for date logic. If not specified, java system default is used.\n * @param includeCurrentPartition If the current partition should be included. Default is to list only completed partitions.\n *                                Attention: including the current partition might result in data loss if there is more data arriving.\n *                                But it might be useful to export all data before a scheduled maintenance.\n */")
@ScalaSignature(bytes="\u0006\u0001\t\rc\u0001B\u001b7\u0001~B\u0001\u0002\u0014\u0001\u0003\u0016\u0004%\t!\u0014\u0005\t3\u0002\u0011\t\u0012)A\u0005\u001d\"A!\f\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005\\\u0001\tE\t\u0015!\u0003O\u0011!a\u0006A!f\u0001\n\u0003i\u0005\u0002C/\u0001\u0005#\u0005\u000b\u0011\u0002(\t\u0011y\u0003!Q3A\u0005\u0002}C\u0001b\u0019\u0001\u0003\u0012\u0003\u0006I\u0001\u0019\u0005\tI\u0002\u0011)\u001a!C\u0001K\"A\u0011\u000e\u0001B\tB\u0003%a\rC\u0003k\u0001\u0011\u00051\u000eC\u0005t\u0001!\u0015\r\u0011\"\u0001;i\"Q\u0011q\u0001\u0001C\u0002\u0013\u0005!(!\u0003\t\u0011\u0005]\u0001\u0001)A\u0005\u0003\u0017A!\"!\u0007\u0001\u0005\u0004%\tAOA\u000e\u0011!\t)\u0003\u0001Q\u0001\n\u0005u\u0001\u0002CA\u0014\u0001\u0011\u0005!(!\u000b\t\u000fa\u0004A\u0011\u0001\u001e\u00026!A\u0011Q\t\u0001\u0005\u0002i\n9\u0005\u0003\u0006\u0002V\u0001\t\n\u0011\"\u0001;\u0003/B\u0001\"!\u001c\u0001\t\u0003Q\u0014q\u000e\u0005\u000b\u0003k\u0002\u0011\u0013!C\u0001u\u0005]\u0003\u0002CA<\u0001\u0011\u0005!(!\u001f\t\u0013\u0005m\u0004!!A\u0005\u0002\u0005u\u0004\"CAE\u0001E\u0005I\u0011AAF\u0011%\ty\tAI\u0001\n\u0003\tY\tC\u0005\u0002\u0012\u0002\t\n\u0011\"\u0001\u0002\f\"I\u00111\u0013\u0001\u0012\u0002\u0013\u0005\u0011Q\u0013\u0005\n\u00033\u0003\u0011\u0013!C\u0001\u00037C\u0011\"a(\u0001\u0003\u0003%\t%!)\t\u0013\u0005\r\u0006!!A\u0005\u0002\u0005\u0015\u0006\"CAT\u0001\u0005\u0005I\u0011AAU\u0011%\t)\fAA\u0001\n\u0003\n9\fC\u0005\u0002F\u0002\t\t\u0011\"\u0001\u0002H\"I\u00111\u001a\u0001\u0002\u0002\u0013\u0005\u0013Q\u001a\u0005\n\u0003\u001f\u0004\u0011\u0011!C!\u0003#D\u0011\"a5\u0001\u0003\u0003%\t%!6\b\u0013\u0005]h'!A\t\u0002\u0005eh\u0001C\u001b7\u0003\u0003E\t!a?\t\r)<C\u0011\u0001B\u0005\u0011%\tymJA\u0001\n\u000b\n\t\u000eC\u0005\u0003\f\u001d\n\t\u0011\"!\u0003\u000e!I!\u0011D\u0014\u0012\u0002\u0013\u0005\u00111\u0012\u0005\n\u000579\u0013\u0013!C\u0001\u0003\u0017C\u0011B!\b(#\u0003%\t!!&\t\u0013\t}q%%A\u0005\u0002\u0005m\u0005\"\u0003B\u0011O\u0005\u0005I\u0011\u0011B\u0012\u0011%\u0011\tdJI\u0001\n\u0003\tY\tC\u0005\u00034\u001d\n\n\u0011\"\u0001\u0002\f\"I!QG\u0014\u0012\u0002\u0013\u0005\u0011Q\u0013\u0005\n\u0005o9\u0013\u0013!C\u0001\u00037C\u0011B!\u000f(\u0003\u0003%IAa\u000f\u0003-\u0011\u000bG/\u001a)beRLG/[8o\u0007>dW/\u001c8EK\u001aT!a\u000e\u001d\u0002\u0015\u0011\fG/Y8cU\u0016\u001cGO\u0003\u0002:u\u0005Aqo\u001c:lM2|wO\u0003\u0002<y\u0005i1/\\1si\u0012\fG/\u00197bW\u0016T\u0011!P\u0001\u0003S>\u001c\u0001a\u0005\u0003\u0001\u0001\u001aK\u0005CA!E\u001b\u0005\u0011%\"A\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0013%AB!osJ+g\r\u0005\u0002B\u000f&\u0011\u0001J\u0011\u0002\b!J|G-^2u!\t\t%*\u0003\u0002L\u0005\na1+\u001a:jC2L'0\u00192mK\u000691m\u001c7OC6,W#\u0001(\u0011\u0005=3fB\u0001)U!\t\t&)D\u0001S\u0015\t\u0019f(\u0001\u0004=e>|GOP\u0005\u0003+\n\u000ba\u0001\u0015:fI\u00164\u0017BA,Y\u0005\u0019\u0019FO]5oO*\u0011QKQ\u0001\tG>dg*Y7fA\u0005QA/[7f\r>\u0014X.\u0019;\u0002\u0017QLW.\u001a$pe6\fG\u000fI\u0001\ti&lW-\u00168ji\u0006IA/[7f+:LG\u000fI\u0001\ti&lWMW8oKV\t\u0001\rE\u0002BC:K!A\u0019\"\u0003\r=\u0003H/[8o\u0003%!\u0018.\\3[_:,\u0007%A\fj]\u000edW\u000fZ3DkJ\u0014XM\u001c;QCJ$\u0018\u000e^5p]V\ta\r\u0005\u0002BO&\u0011\u0001N\u0011\u0002\b\u0005>|G.Z1o\u0003aIgn\u00197vI\u0016\u001cUO\u001d:f]R\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\r1tw\u000e]9s!\ti\u0007!D\u00017\u0011\u0015a5\u00021\u0001O\u0011\u001dQ6\u0002%AA\u00029Cq\u0001X\u0006\u0011\u0002\u0003\u0007a\nC\u0004_\u0017A\u0005\t\u0019\u00011\t\u000f\u0011\\\u0001\u0013!a\u0001M\u0006Iam\u001c:nCR$XM]\u000b\u0002kB\u0011a/`\u0007\u0002o*\u0011\u00010_\u0001\u0007M>\u0014X.\u0019;\u000b\u0005i\\\u0018\u0001\u0002;j[\u0016T\u0011\u0001`\u0001\u0005U\u00064\u0018-\u0003\u0002\u007fo\n\tB)\u0019;f)&lWMR8s[\u0006$H/\u001a:)\u00071\t\t\u0001E\u0002B\u0003\u0007I1!!\u0002C\u0005%!(/\u00198tS\u0016tG/\u0001\u0006dQJ|gn\\+oSR,\"!a\u0003\u0011\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u0005z\u0003!!X-\u001c9pe\u0006d\u0017\u0002BA\u000b\u0003\u001f\u0011!b\u00115s_:|WK\\5u\u0003-\u0019\u0007N]8o_Vs\u0017\u000e\u001e\u0011\u0002\ri|g.Z%e+\t\ti\u0002\u0005\u0003\u0002 \u0005\u0005R\"A=\n\u0007\u0005\r\u0012P\u0001\u0004[_:,\u0017\nZ\u0001\bu>tW-\u00133!\u0003\u0015\u0001\u0018M]:f)\u0011\tY#!\r\u0011\t\u0005}\u0011QF\u0005\u0004\u0003_I(!\u0004'pG\u0006dG)\u0019;f)&lW\r\u0003\u0004\u00024E\u0001\rAT\u0001\u0006m\u0006dW/\u001a\u000b\u0005\u0003o\t\t\u0005\u0005\u0003\u0002:\u0005}RBAA\u001e\u0015\r\tid_\u0001\u0005Y\u0006tw-C\u0002X\u0003wAq!a\u0011\u0013\u0001\u0004\tY#\u0001\u0005eCR,G+[7f\u0003\u0011qW\r\u001f;\u0015\r\u0005-\u0012\u0011JA&\u0011\u001d\t\u0019e\u0005a\u0001\u0003WA\u0011\"!\u0014\u0014!\u0003\u0005\r!a\u0014\u0002\u000bUt\u0017\u000e^:\u0011\u0007\u0005\u000b\t&C\u0002\u0002T\t\u00131!\u00138u\u00039qW\r\u001f;%I\u00164\u0017-\u001e7uII*\"!!\u0017+\t\u0005=\u00131L\u0016\u0003\u0003;\u0002B!a\u0018\u0002j5\u0011\u0011\u0011\r\u0006\u0005\u0003G\n)'A\u0005v]\u000eDWmY6fI*\u0019\u0011q\r\"\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002l\u0005\u0005$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006A\u0001O]3wS>,8\u000f\u0006\u0004\u0002,\u0005E\u00141\u000f\u0005\b\u0003\u0007*\u0002\u0019AA\u0016\u0011%\ti%\u0006I\u0001\u0002\u0004\ty%\u0001\nqe\u00164\u0018n\\;tI\u0011,g-Y;mi\u0012\u0012\u0014aB2veJ,g\u000e^\u000b\u0003\u0003W\tAaY8qsRYA.a \u0002\u0002\u0006\r\u0015QQAD\u0011\u001da\u0005\u0004%AA\u00029CqA\u0017\r\u0011\u0002\u0003\u0007a\nC\u0004]1A\u0005\t\u0019\u0001(\t\u000fyC\u0002\u0013!a\u0001A\"9A\r\u0007I\u0001\u0002\u00041\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u001bS3ATA.\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005]%f\u00011\u0002\\\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*TCAAOU\r1\u00171L\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005]\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA(\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a+\u00022B\u0019\u0011)!,\n\u0007\u0005=&IA\u0002B]fD\u0011\"a-!\u0003\u0003\u0005\r!a\u0014\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\f\u0005\u0004\u0002<\u0006\u0005\u00171V\u0007\u0003\u0003{S1!a0C\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0007\fiL\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u00014\u0002J\"I\u00111\u0017\u0012\u0002\u0002\u0003\u0007\u00111V\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011qJ\u0001\ti>\u001cFO]5oOR\u0011\u0011qG\u0001\u0007KF,\u0018\r\\:\u0015\u0007\u0019\f9\u000eC\u0005\u00024\u0016\n\t\u00111\u0001\u0002,\":\u0001!a7\u00024\u0005M\b\u0003BAo\u0003_l!!a8\u000b\t\u0005\u0005\u00181]\u0001\tg\u000e\fG.\u00193pG*!\u0011Q]At\u0003\u001d!\u0018m[3{_\u0016TA!!;\u0002l\u00061q-\u001b;ik\nT!!!<\u0002\u0007\r|W.\u0003\u0003\u0002r\u0006}'\u0001C*dC2\fGm\\2\"\u0005\u0005U\u0018ab\t0U)R\u0001E\u000b\u0011EK\u001aLg.\u001b;j_:\u0004sN\u001a\u0011eCR,\u0007\u0005]1si&$\u0018n\u001c8!G>dW/\u001c8!i>\u0004S\r\u001f;sC\u000e$\bEZ8s[\u0006$H/\u001a3!i&lW\rI5oi>\u00043m\u001c7v[:t#\u0002\t\u0016\u000bA)\u0002\u0003\t]1sC6\u00043m\u001c7OC6,\u0007\u0005Z1uK\u0002\u0002\u0018M\u001d;ji&|g\u000eI2pYVlg\u000e\t8b[\u0016\u0004Co\u001c\u0011fqR\u0014\u0018m\u0019;!i&lW\rI5oi>\u00043m\u001c7v[:\u0004sN\u001c\u0011cCR\u001c\u0007\u000e\t:fC\u0012T\u0001E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011uS6,gi\u001c:nCR\u0004C/[7fA\u0019|'/\\1uA\u0019|'\u000f\t;j[\u0016\u001cH/Y7qA%t\u0007\u0005Z1uK\u0002\u0002\u0018M\u001d;ji&|g\u000eI2pYVlg\u000e\f\u0011eK\u001aLg.\u001b;j_:\u0004\u0013mY2pe\u0012Lgn\u001a\u0011u_\u0002R\u0017M^1!\t\u0006$X\rV5nK\u001a{'/\\1ui\u0016\u0014h\u0006\t#fM\u0006,H\u000e\u001e\u0011jg\u0002\u0012\u00130_=z\u001b6#GM\t\u0018\u000bA)\u0002\u0003\t]1sC6\u0004C/[7f+:LG\u000f\t;j[\u0016\u0004SO\\5uA\u0019|'\u000f\t;j[\u0016\u001cH/Y7qA%t\u0007\u0005Z1uK\u0002\u0002\u0018M\u001d;ji&|g\u000eI2pYVlg\u000e\f\u0011eK\u001aLg.\u001b;j_:\u0004\u0013mY2pe\u0012Lgn\u001a\u0011u_\u0002R\u0017M^1!\u0007\"\u0014xN\\8V]&$h\u0006\t#fM\u0006,H\u000e\u001e\u0011jg\u0002\u0012C-Y=tE9R\u0001E\u000b\u0011Aa\u0006\u0014\u0018-\u001c\u0011uS6,'l\u001c8fAQLW.\u001a\u0011{_:,\u0007%^:fI\u00022wN\u001d\u0011eCR,\u0007\u0005\\8hS\u000et\u0003%\u00134!]>$\be\u001d9fG&4\u0017.\u001a3-A)\fg/\u0019\u0011tsN$X-\u001c\u0011eK\u001a\fW\u000f\u001c;!SN\u0004So]3e])\u0001#\u0006\t!qCJ\fW\u000eI5oG2,H-Z\"veJ,g\u000e\u001e)beRLG/[8oA%3\u0007\u0005\u001e5fA\r,(O]3oi\u0002\u0002\u0018M\u001d;ji&|g\u000eI:i_VdG\r\t2fA%t7\r\\;eK\u0012t\u0003\u0005R3gCVdG\u000fI5tAQ|\u0007\u0005\\5ti\u0002zg\u000e\\=!G>l\u0007\u000f\\3uK\u0012\u0004\u0003/\u0019:uSRLwN\\:/\u0015\u0001R\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!\u0003R$XM\u001c;j_:T\u0004%\u001b8dYV$\u0017N\\4!i\",\u0007eY;se\u0016tG\u000f\t9beRLG/[8oA5Lw\r\u001b;!e\u0016\u001cX\u000f\u001c;!S:\u0004C-\u0019;bA1|7o\u001d\u0011jM\u0002\"\b.\u001a:fA%\u001c\b%\\8sK\u0002\"\u0017\r^1!CJ\u0014\u0018N^5oO:R\u0001E\u000b\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0012U\u000f\u001e\u0011ji\u0002j\u0017n\u001a5uA\t,\u0007%^:fMVd\u0007\u0005^8!Kb\u0004xN\u001d;!C2d\u0007\u0005Z1uC\u0002\u0012WMZ8sK\u0002\n\u0007e]2iK\u0012,H.\u001a3![\u0006Lg\u000e^3oC:\u001cWM\f\u0006!U=\na\u0003R1uKB\u000b'\u000f^5uS>t7i\u001c7v[:$UM\u001a\t\u0003[\u001e\u001aBaJA\u007f\u0013BQ\u0011q B\u0003\u001d:s\u0005M\u001a7\u000e\u0005\t\u0005!b\u0001B\u0002\u0005\u00069!/\u001e8uS6,\u0017\u0002\u0002B\u0004\u0005\u0003\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c86)\t\tI0A\u0003baBd\u0017\u0010F\u0006m\u0005\u001f\u0011\tBa\u0005\u0003\u0016\t]\u0001\"\u0002'+\u0001\u0004q\u0005b\u0002.+!\u0003\u0005\rA\u0014\u0005\b9*\u0002\n\u00111\u0001O\u0011\u001dq&\u0006%AA\u0002\u0001Dq\u0001\u001a\u0016\u0011\u0002\u0003\u0007a-A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIU\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003&\t5\u0002\u0003B!b\u0005O\u0001\u0002\"\u0011B\u0015\u001d:s\u0005MZ\u0005\u0004\u0005W\u0011%A\u0002+va2,W\u0007\u0003\u0005\u00030=\n\t\u00111\u0001m\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU\n1B]3bIJ+7o\u001c7wKR\u0011!Q\b\t\u0005\u0003s\u0011y$\u0003\u0003\u0003B\u0005m\"AB(cU\u0016\u001cG\u000f")
public class DatePartitionColumnDef
implements Product,
scala.Serializable {
    private transient DateTimeFormatter formatter;
    private final String colName;
    private final String timeFormat;
    private final String timeUnit;
    private final Option<String> timeZone;
    private final boolean includeCurrentPartition;
    private final ChronoUnit chronoUnit;
    private final ZoneId zoneId;
    private volatile transient boolean bitmap$trans$0;

    public static boolean $lessinit$greater$default$5() {
        return DatePartitionColumnDef$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<String> $lessinit$greater$default$4() {
        return DatePartitionColumnDef$.MODULE$.$lessinit$greater$default$4();
    }

    public static String $lessinit$greater$default$3() {
        return DatePartitionColumnDef$.MODULE$.$lessinit$greater$default$3();
    }

    public static String $lessinit$greater$default$2() {
        return DatePartitionColumnDef$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple5<String, String, String, Option<String>, Object>> unapply(DatePartitionColumnDef datePartitionColumnDef) {
        return DatePartitionColumnDef$.MODULE$.unapply(datePartitionColumnDef);
    }

    public static boolean apply$default$5() {
        return DatePartitionColumnDef$.MODULE$.apply$default$5();
    }

    public static Option<String> apply$default$4() {
        return DatePartitionColumnDef$.MODULE$.apply$default$4();
    }

    public static String apply$default$3() {
        return DatePartitionColumnDef$.MODULE$.apply$default$3();
    }

    public static String apply$default$2() {
        return DatePartitionColumnDef$.MODULE$.apply$default$2();
    }

    public static DatePartitionColumnDef apply(String string, String string2, String string3, Option<String> option, boolean bl) {
        return DatePartitionColumnDef$.MODULE$.apply(string, string2, string3, option, bl);
    }

    public static Function1<Tuple5<String, String, String, Option<String>, Object>, DatePartitionColumnDef> tupled() {
        return DatePartitionColumnDef$.MODULE$.tupled();
    }

    public static Function1<String, Function1<String, Function1<String, Function1<Option<String>, Function1<Object, DatePartitionColumnDef>>>>> curried() {
        return DatePartitionColumnDef$.MODULE$.curried();
    }

    public String colName() {
        return this.colName;
    }

    public String timeFormat() {
        return this.timeFormat;
    }

    public String timeUnit() {
        return this.timeUnit;
    }

    public Option<String> timeZone() {
        return this.timeZone;
    }

    public boolean includeCurrentPartition() {
        return this.includeCurrentPartition;
    }

    private DateTimeFormatter formatter$lzycompute() {
        DatePartitionColumnDef datePartitionColumnDef = this;
        synchronized (datePartitionColumnDef) {
            if (!this.bitmap$trans$0) {
                this.formatter = DateTimeFormatter.ofPattern(this.timeFormat());
                this.bitmap$trans$0 = true;
            }
        }
        return this.formatter;
    }

    public DateTimeFormatter formatter() {
        return !this.bitmap$trans$0 ? this.formatter$lzycompute() : this.formatter;
    }

    public ChronoUnit chronoUnit() {
        return this.chronoUnit;
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    public LocalDateTime parse(String value) {
        LocalDateTime localDateTime;
        TemporalAccessor temporalAccessor = this.formatter().parseBest(value, TemporalQueries$.MODULE$.LocalDateTimeQuery(), TemporalQueries$.MODULE$.LocalDateQuery(), TemporalQueries$.MODULE$.LocalYearMonthQuery());
        if (temporalAccessor instanceof LocalDateTime) {
            LocalDateTime localDateTime2;
            localDateTime = localDateTime2 = (LocalDateTime)temporalAccessor;
        } else if (temporalAccessor instanceof LocalDate) {
            LocalDate localDate = (LocalDate)temporalAccessor;
            localDateTime = localDate.atStartOfDay();
        } else if (temporalAccessor instanceof YearMonth) {
            YearMonth yearMonth = (YearMonth)temporalAccessor;
            localDateTime = yearMonth.atDay(1).atStartOfDay();
        } else {
            throw new MatchError((Object)temporalAccessor);
        }
        return localDateTime;
    }

    public String format(LocalDateTime dateTime) {
        return dateTime.format(this.formatter());
    }

    public LocalDateTime next(LocalDateTime dateTime, int units) {
        return dateTime.plus(units, this.chronoUnit());
    }

    public int next$default$2() {
        return 1;
    }

    public LocalDateTime previous(LocalDateTime dateTime, int units) {
        return dateTime.minus(units, this.chronoUnit());
    }

    public int previous$default$2() {
        return 1;
    }

    public LocalDateTime current() {
        return LocalDateTime.now().truncatedTo(this.chronoUnit());
    }

    public DatePartitionColumnDef copy(String colName, String timeFormat, String timeUnit, Option<String> timeZone, boolean includeCurrentPartition) {
        return new DatePartitionColumnDef(colName, timeFormat, timeUnit, timeZone, includeCurrentPartition);
    }

    public String copy$default$1() {
        return this.colName();
    }

    public String copy$default$2() {
        return this.timeFormat();
    }

    public String copy$default$3() {
        return this.timeUnit();
    }

    public Option<String> copy$default$4() {
        return this.timeZone();
    }

    public boolean copy$default$5() {
        return this.includeCurrentPartition();
    }

    public String productPrefix() {
        return "DatePartitionColumnDef";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.colName();
                break;
            }
            case 1: {
                object = this.timeFormat();
                break;
            }
            case 2: {
                object = this.timeUnit();
                break;
            }
            case 3: {
                object = this.timeZone();
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToBoolean((boolean)this.includeCurrentPartition());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DatePartitionColumnDef;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.colName()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.timeFormat()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.timeUnit()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.timeZone()));
        n = Statics.mix((int)n, (int)(this.includeCurrentPartition() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)5);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DatePartitionColumnDef)) return false;
        boolean bl = true;
        if (!bl) return false;
        DatePartitionColumnDef datePartitionColumnDef = (DatePartitionColumnDef)x$1;
        String string = this.colName();
        String string2 = datePartitionColumnDef.colName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.timeFormat();
        String string4 = datePartitionColumnDef.timeFormat();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        String string5 = this.timeUnit();
        String string6 = datePartitionColumnDef.timeUnit();
        if (string5 == null) {
            if (string6 != null) {
                return false;
            }
        } else if (!string5.equals(string6)) return false;
        Option<String> option = this.timeZone();
        Option<String> option2 = datePartitionColumnDef.timeZone();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (this.includeCurrentPartition() != datePartitionColumnDef.includeCurrentPartition()) return false;
        if (!datePartitionColumnDef.canEqual(this)) return false;
        return true;
    }

    public DatePartitionColumnDef(String colName, String timeFormat, String timeUnit, Option<String> timeZone, boolean includeCurrentPartition) {
        this.colName = colName;
        this.timeFormat = timeFormat;
        this.timeUnit = timeUnit;
        this.timeZone = timeZone;
        this.includeCurrentPartition = includeCurrentPartition;
        Product.$init$((Product)this);
        this.chronoUnit = ChronoUnit.valueOf(timeUnit.toUpperCase());
        this.zoneId = (ZoneId)timeZone.map((Function1 & Serializable & scala.Serializable)x$1 -> ZoneId.of(x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ZoneId.systemDefault());
    }
}

