/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.codegen;

import java.io.Serializable;
import overflowdb.algorithm.LowestCommonAncestors$;
import overflowdb.codegen.DefaultNodeTypes$;
import overflowdb.schema.AbstractNodeType;
import overflowdb.schema.ContainedNode;
import overflowdb.schema.EdgeType;
import overflowdb.schema.EdgeType$Cardinality$List$;
import overflowdb.schema.EdgeType$Cardinality$One$;
import overflowdb.schema.EdgeType$Cardinality$ZeroOrOne$;
import overflowdb.schema.NeighborInfoForNode;
import overflowdb.schema.NodeBaseType;
import overflowdb.schema.Property;
import overflowdb.schema.Property$Cardinality$List$;
import overflowdb.schema.Property$Cardinality$One$;
import overflowdb.schema.Property$Cardinality$ZeroOrOne$;
import overflowdb.schema.Property$ValueType$Boolean$;
import overflowdb.schema.Property$ValueType$Byte$;
import overflowdb.schema.Property$ValueType$Char$;
import overflowdb.schema.Property$ValueType$Double$;
import overflowdb.schema.Property$ValueType$Float$;
import overflowdb.schema.Property$ValueType$Int$;
import overflowdb.schema.Property$ValueType$List$;
import overflowdb.schema.Property$ValueType$Long$;
import overflowdb.schema.Property$ValueType$NodeRef$;
import overflowdb.schema.Property$ValueType$Short$;
import overflowdb.schema.Property$ValueType$String$;
import overflowdb.schema.Property$ValueType$Unknown$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;

public final class Helpers$
implements Serializable {
    private static final String propertyErrorRegisterImpl;
    private static final Set scalaReservedKeywords;
    private static final char quotes;
    public static final Helpers$ MODULE$;

    private Helpers$() {
    }

    static {
        MODULE$ = new Helpers$();
        propertyErrorRegisterImpl = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("object PropertyErrorRegister {\n       |  private var errorMap = Set[(Class[_], String)]()\n       |  private val logger = org.slf4j.LoggerFactory.getLogger(getClass)\n       |\n       |  def logPropertyErrorIfFirst(clazz: Class[_], propertyName: String): Unit = {\n       |    if (!errorMap.contains((clazz, propertyName))) {\n       |      logger.warn(\"Property \" + propertyName + \" is deprecated for \" + clazz.getName + \".\")\n       |      errorMap += ((clazz, propertyName))\n       |    }\n       |  }\n       |}\n       |"));
        scalaReservedKeywords = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"abstract", ">:", "if", ".", "catch", "protected", "final", "super", "while", "true", "val", "do", "throw", "<-", "package", "_", "macro", "@", "object", "false", "this", "then", "var", "trait", "with", "def", "else", "class", "type", "#", "lazy", "null", "=", "<:", "override", "=>", "private", "sealed", "finally", "new", "implicit", "extends", "for", "return", "case", "import", "forSome", ":", "yield", "try", "match", "<%"}));
        quotes = (char)34;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Helpers$.class);
    }

    public Iterable<String> quoted(Iterable<String> strings) {
        return (Iterable)strings.map((Function1 & Serializable)string -> this.quote((String)string));
    }

    public String quote(String string) {
        return new StringBuilder(2).append("\"").append(string).append("\"").toString();
    }

    public Option<String> stringToOption(String s) {
        None$ none$;
        String string = s.trim();
        if ("".equals(string)) {
            none$ = None$.MODULE$;
        } else {
            String nonEmptyString = string;
            none$ = Some$.MODULE$.apply((Object)nonEmptyString);
        }
        return none$;
    }

    public <A> String typeFor(Property<A> property) {
        String string;
        boolean isMandatory = property.isMandatory();
        Property.ValueType<A> valueType = property.valueType();
        if (Property$ValueType$Boolean$.MODULE$.equals(valueType)) {
            string = isMandatory ? "Boolean" : "java.lang.Boolean";
        } else if (Property$ValueType$String$.MODULE$.equals(valueType)) {
            string = "String";
        } else if (Property$ValueType$Byte$.MODULE$.equals(valueType)) {
            string = isMandatory ? "Byte" : "java.lang.Byte";
        } else if (Property$ValueType$Short$.MODULE$.equals(valueType)) {
            string = isMandatory ? "Short" : "java.lang.Short";
        } else if (Property$ValueType$Int$.MODULE$.equals(valueType)) {
            string = isMandatory ? "scala.Int" : "Integer";
        } else if (Property$ValueType$Long$.MODULE$.equals(valueType)) {
            string = isMandatory ? "Long" : "java.lang.Long";
        } else if (Property$ValueType$Float$.MODULE$.equals(valueType)) {
            string = isMandatory ? "Float" : "java.lang.Float";
        } else if (Property$ValueType$Double$.MODULE$.equals(valueType)) {
            string = isMandatory ? "Double" : "java.lang.Double";
        } else if (Property$ValueType$Char$.MODULE$.equals(valueType)) {
            string = isMandatory ? "scala.Char" : "Character";
        } else if (Property$ValueType$List$.MODULE$.equals(valueType)) {
            string = "Seq[_]";
        } else if (Property$ValueType$NodeRef$.MODULE$.equals(valueType)) {
            string = "overflowdb.NodeRef[_]";
        } else if (Property$ValueType$Unknown$.MODULE$.equals(valueType)) {
            string = "java.lang.Object";
        } else {
            throw new MatchError(valueType);
        }
        return string;
    }

    public String accessorName(NeighborInfoForNode neighborInfoForNode) {
        return (String)neighborInfoForNode.customStepName().getOrElse(() -> this.accessorName$$anonfun$1(neighborInfoForNode));
    }

    public String docAnnotationMaybe(Option<String> customStepDoc) {
        String string;
        Option option = customStepDoc.map((Function1 & Serializable)src -> this.escapeJava((String)src));
        if (option instanceof Some) {
            String doc = (String)((Some)option).value();
            string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(65).append("/** ").append(doc).append(" */\n           |@overflowdb.traversal.help.Doc(info = \"\"\"").append(doc).append("\"\"\")").toString()));
        } else if (None$.MODULE$.equals(option)) {
            string = "";
        } else {
            throw new MatchError((Object)option);
        }
        return string;
    }

    public String escapeJava(String src) {
        return src.replace("\"", "\\\"").replace("/*", "\\/\\*").replace("*/", "\\*\\/");
    }

    public boolean isNodeBaseTrait(Seq<NodeBaseType> baseTraits, String nodeName) {
        String string = nodeName;
        String string2 = DefaultNodeTypes$.MODULE$.AbstractNodeName();
        return !(string == null ? string2 != null : !string.equals(string2)) || ((SeqOps)baseTraits.map((Function1 & Serializable)_$1 -> _$1.name())).contains((Object)nodeName);
    }

    public String camelCaseCaps(String snakeCase) {
        return StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(this.camelCase(snakeCase)));
    }

    public String camelCase(String snakeCase) {
        Nil$ nil$;
        String corrected = snakeCase.startsWith("_") ? StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(snakeCase), 1) : snakeCase;
        Object object = Predef$.MODULE$.refArrayOps((Object[])corrected.split("_"));
        List list = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$2 -> _$2.toLowerCase(), ClassTag$.MODULE$.apply(String.class))).toList();
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list2 = colon2.next$access$1();
            String head = (String)colon2.head();
            List tail = list2;
            nil$ = tail.map((Function1 & Serializable)_$3 -> StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(_$3))).$colon$colon((Object)head);
        } else {
            Nil$ nil$2 = package$.MODULE$.Nil();
            List list3 = list;
            if (!(nil$2 != null ? !nil$2.equals(list3) : list3 != null)) {
                nil$ = package$.MODULE$.Nil();
            } else {
                throw new MatchError((Object)list);
            }
        }
        Nil$ elements = nil$;
        return elements.mkString();
    }

    public String snakeCase(String camelCase) {
        return this.go$1((List)package$.MODULE$.Nil(), Predef$.MODULE$.wrapString(camelCase).toList()).mkString().toLowerCase();
    }

    public String singularize(String str) {
        return str.endsWith("ies") ? new StringBuilder(1).append(StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(str), 3)).append("y").toString() : StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(str), 1);
    }

    public <A> String getCompleteType(Property<?> property) {
        return this.getCompleteType(property.cardinality(), this.typeFor(property));
    }

    public String typeFor(ContainedNode containedNode) {
        String className = containedNode.nodeType().className();
        return DefaultNodeTypes$.MODULE$.AllClassNames().contains((Object)className) ? className : new StringBuilder(4).append(className).append("Base").toString();
    }

    public String getCompleteType(ContainedNode containedNode) {
        return this.getCompleteType(containedNode.cardinality(), this.typeFor(containedNode));
    }

    public String getCompleteType(Property.Cardinality cardinality, String valueType) {
        String string;
        Property.Cardinality cardinality2 = cardinality;
        if (cardinality2 instanceof Property.Cardinality.One) {
            Property.Cardinality.One one = Property$Cardinality$One$.MODULE$.unapply((Property.Cardinality.One)cardinality2);
            Property.Default default_ = one._1();
            string = valueType;
        } else if (Property$Cardinality$ZeroOrOne$.MODULE$.equals(cardinality2)) {
            string = new StringBuilder(8).append("Option[").append(valueType).append("]").toString();
        } else if (Property$Cardinality$List$.MODULE$.equals(cardinality2)) {
            string = new StringBuilder(12).append("IndexedSeq[").append(valueType).append("]").toString();
        } else {
            throw new MatchError((Object)cardinality2);
        }
        return string;
    }

    public String propertyKeyDef(String name, String baseType, Property.Cardinality cardinality) {
        String string;
        Property.Cardinality cardinality2 = cardinality;
        if (cardinality2 instanceof Property.Cardinality.One) {
            Property.Cardinality.One one = Property$Cardinality$One$.MODULE$.unapply((Property.Cardinality.One)cardinality2);
            Property.Default default_ = one._1();
            string = baseType;
        } else if (Property$Cardinality$ZeroOrOne$.MODULE$.equals(cardinality2)) {
            string = baseType;
        } else if (Property$Cardinality$List$.MODULE$.equals(cardinality2)) {
            string = new StringBuilder(12).append("IndexedSeq[").append(baseType).append("]").toString();
        } else {
            throw new MatchError((Object)cardinality2);
        }
        String completeType = string;
        return new StringBuilder(40).append("val ").append(this.camelCaseCaps(name)).append(" = new overflowdb.PropertyKey[").append(completeType).append("](\"").append(name).append("\") ").toString();
    }

    public <A> String defaultValueImpl(Property.Default<A> default_) {
        String string;
        A a = default_.value();
        if (a instanceof String) {
            String str = (String)a;
            string = new StringBuilder(0).append(this.quotes()).append(str).append(this.quotes()).toString();
        } else if (a instanceof Character) {
            char c = BoxesRunTime.unboxToChar(a);
            string = new StringBuilder(2).append("'").append(c).append("'").toString();
        } else if (a instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte(a);
            string = new StringBuilder(6).append(by).append(": Byte").toString();
        } else if (a instanceof Short) {
            short s = BoxesRunTime.unboxToShort(a);
            string = new StringBuilder(7).append(s).append(": Short").toString();
        } else if (a instanceof Integer) {
            int n = BoxesRunTime.unboxToInt(a);
            string = new StringBuilder(5).append(n).append(": Int").toString();
        } else if (a instanceof Long) {
            long l = BoxesRunTime.unboxToLong(a);
            string = new StringBuilder(6).append(l).append(": Long").toString();
        } else if (a instanceof Float) {
            float f = BoxesRunTime.unboxToFloat(a);
            float f2 = f;
            if (Predef$.MODULE$.float2Float(f2).isNaN()) {
                string = "Float.NaN";
            } else {
                float = f;
                string = new StringBuilder(1).append(float).append("f").toString();
            }
        } else if (a instanceof Double) {
            double d = BoxesRunTime.unboxToDouble(a);
            double d2 = d;
            if (Predef$.MODULE$.double2Double(d2).isNaN()) {
                string = "Double.NaN";
            } else {
                double = d;
                string = new StringBuilder(1).append(double).append("d").toString();
            }
        } else {
            A other = a;
            string = String.valueOf(other);
        }
        return string;
    }

    public <A> String defaultValueCheckImpl(String memberName, Property.Default<A> default_) {
        double d;
        float f;
        String defaultValueSrc = this.defaultValueImpl(default_);
        A a = default_.value();
        String string = a instanceof Float && Predef$.MODULE$.float2Float(f = BoxesRunTime.unboxToFloat(a)).isNaN() ? new StringBuilder(6).append(memberName).append(".isNaN").toString() : (a instanceof Double && Predef$.MODULE$.double2Double(d = BoxesRunTime.unboxToDouble(a)).isNaN() ? new StringBuilder(6).append(memberName).append(".isNaN").toString() : new StringBuilder(6).append("(").append(defaultValueSrc).append(") == ").append(memberName).toString());
        return string;
    }

    public String propertyDefaultValueImpl(String propertyDefaultsPath, Seq<Property<?>> properties) {
        String propertyDefaultValueCases = ((IterableOnceOps)properties.collect((PartialFunction)new Serializable(propertyDefaultsPath){
            private final String propertyDefaultsPath$1;
            {
                this.propertyDefaultsPath$1 = propertyDefaultsPath$2;
            }

            public final boolean isDefinedAt(Property x) {
                Property property = x;
                Property property2 = property;
                return property2.hasDefault();
            }

            public final Object applyOrElse(Property x, Function1 function1) {
                Property property = x;
                Property property2 = property;
                return property2.hasDefault() ? new StringBuilder(12).append("case \"").append(property2.name()).append("\" => ").append(this.propertyDefaultsPath$1).append(".").append(property2.className()).toString() : function1.apply((Object)x);
            }
        })).mkString(System.lineSeparator());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(180).append("override def propertyDefaultValue(propertyKey: String) =\n       |  propertyKey match {\n       |    ").append(propertyDefaultValueCases).append("\n       |    case _ => super.propertyDefaultValue(propertyKey)\n       |}\n       |").toString()));
    }

    public String propertyDefaultCases(Seq<Property<?>> properties) {
        return ((IterableOnceOps)properties.collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Property x) {
                Property property = x;
                Property p = property;
                return p.hasDefault();
            }

            public final Object applyOrElse(Property x, Function1 function1) {
                Property property = x;
                Property p = property;
                return p.hasDefault() ? new StringBuilder(7).append("val ").append(p.className()).append(" = ").append(Helpers$.MODULE$.defaultValueImpl((Property.Default)p.default().get())).toString() : function1.apply((Object)x);
            }
        })).mkString("\n|    ");
    }

    public String propertyErrorRegisterImpl() {
        return propertyErrorRegisterImpl;
    }

    public Set<String> scalaReservedKeywords() {
        return scalaReservedKeywords;
    }

    public String escapeIfKeyword(String value) {
        return this.scalaReservedKeywords().contains((Object)value) ? new StringBuilder(2).append("`").append(value).append("`").toString() : value;
    }

    public String fullScalaType(AbstractNodeType neighborNode, EdgeType.Cardinality cardinality) {
        String string;
        String neighborNodeClass = neighborNode.className();
        EdgeType.Cardinality cardinality2 = cardinality;
        if (EdgeType$Cardinality$List$.MODULE$.equals(cardinality2)) {
            string = new StringBuilder(32).append("overflowdb.traversal.Traversal[").append(neighborNodeClass).append("]").toString();
        } else if (EdgeType$Cardinality$ZeroOrOne$.MODULE$.equals(cardinality2)) {
            string = new StringBuilder(8).append("Option[").append(neighborNodeClass).append("]").toString();
        } else if (EdgeType$Cardinality$One$.MODULE$.equals(cardinality2)) {
            string = String.valueOf(neighborNodeClass);
        } else {
            throw new MatchError((Object)cardinality2);
        }
        return string;
    }

    public String deriveCommonRootType(Set<AbstractNodeType> neighborNodeInfos) {
        return (String)this.lowestCommonAncestor(neighborNodeInfos).orElse(() -> this.deriveCommonRootType$$anonfun$1(neighborNodeInfos)).map((Function1 & Serializable)_$4 -> _$4.className()).getOrElse(this::deriveCommonRootType$$anonfun$3);
    }

    public Option<AbstractNodeType> lowestCommonAncestor(Set<AbstractNodeType> nodes) {
        return LowestCommonAncestors$.MODULE$.apply(nodes, (Function1 & Serializable)_$5 -> _$5.extendzRecursively().toSet()).headOption();
    }

    public Option<AbstractNodeType> findSharedRoot(Set<AbstractNodeType> nodeTypes) {
        Some some;
        if (nodeTypes.size() == 1) {
            some = Some$.MODULE$.apply(nodeTypes.head());
        } else if (nodeTypes.size() > 1) {
            Seq sorted = (Seq)nodeTypes.toSeq().sortBy((Function1 & Serializable)_$6 -> _$6.className(), (Ordering)Ordering.String$.MODULE$);
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(sorted.head(), sorted.tail());
            AbstractNodeType first = (AbstractNodeType)tuple2._1();
            Seq otherNodes = (Seq)tuple2._2();
            some = this.completeTypeHierarchy(first).find((Function1 & Serializable)candidate -> otherNodes.forall((Function1 & Serializable)otherNode -> this.completeTypeHierarchy((AbstractNodeType)otherNode).contains(candidate)));
        } else {
            some = None$.MODULE$;
        }
        return some;
    }

    public Seq<AbstractNodeType> completeTypeHierarchy(AbstractNodeType node) {
        return (Seq)node.extendzRecursively().$plus$colon((Object)node);
    }

    public char quotes() {
        return quotes;
    }

    private final String accessorName$$anonfun$1(NeighborInfoForNode neighborInfoForNode$1) {
        String neighborNodeName = neighborInfoForNode$1.neighborNode().name();
        String edgeName = neighborInfoForNode$1.edge().className();
        String direction = neighborInfoForNode$1.direction().toString();
        return new StringBuilder(4).append("_").append(this.camelCase(neighborNodeName)).append("Via").append(edgeName).append(this.camelCaseCaps(direction)).toString();
    }

    private final List go$1(List accDone, List acc) {
        List list;
        block5: {
            List list2;
            List list3 = acc;
            list = accDone;
            while (true) {
                list2 = list3;
                Nil$ nil$ = package$.MODULE$.Nil();
                List list4 = list2;
                if (!(nil$ == null ? list4 != null : !nil$.equals(list4))) break block5;
                if (!(list2 instanceof .colon.colon)) break;
                .colon.colon colon2 = (.colon.colon)list2;
                char c = BoxesRunTime.unboxToChar((Object)colon2.head());
                List list5 = colon2.next$access$1();
                char a = c;
                if (list5 instanceof .colon.colon) {
                    .colon.colon colon3 = (.colon.colon)list5;
                    char c2 = BoxesRunTime.unboxToChar((Object)colon3.head());
                    List list6 = colon3.next$access$1();
                    char b = c2;
                    if (list6 instanceof .colon.colon) {
                        .colon.colon colon4 = (.colon.colon)list6;
                        List list7 = colon4.next$access$1();
                        char c3 = BoxesRunTime.unboxToChar((Object)colon4.head());
                        List tail = list7;
                        if (RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(a)) && RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(b)) && RichChar$.MODULE$.isLower$extension(Predef$.MODULE$.charWrapper(c3))) {
                            List list8 = (List)list.$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{a, '_', b, c3})));
                            List list9 = tail;
                            list = list8;
                            list3 = list9;
                            continue;
                        }
                    }
                    char a2 = c;
                    char b2 = c2;
                    List tail = list6;
                    if (RichChar$.MODULE$.isLower$extension(Predef$.MODULE$.charWrapper(a2)) && RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(b2))) {
                        List list10 = (List)list.$plus$plus((IterableOnce)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{a2, '_', b2})));
                        List list11 = tail;
                        list = list10;
                        list3 = list11;
                        continue;
                    }
                }
                char a3 = c;
                List tail = list5;
                List list12 = (List)list.$colon$plus((Object)BoxesRunTime.boxToCharacter((char)a3));
                List list13 = tail;
                list = list12;
                list3 = list13;
            }
            throw new MatchError((Object)list2);
        }
        return list;
    }

    private final Option deriveCommonRootType$$anonfun$1(Set neighborNodeInfos$1) {
        return this.findSharedRoot((Set<AbstractNodeType>)neighborNodeInfos$1);
    }

    private final String deriveCommonRootType$$anonfun$3() {
        return DefaultNodeTypes$.MODULE$.StoredNodeClassname();
    }
}

