/*
 * Decompiled with CFR 0.152.
 */
package overflowdb.codegen;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import overflowdb.codegen.CodeGen;
import overflowdb.codegen.CodeGen$AjacentNodeWithInheritanceStatus$3$;
import overflowdb.codegen.CodeGen$ConstantContext$;
import overflowdb.codegen.CodeGen$FieldDescription$3$;
import overflowdb.codegen.Formatter$;
import overflowdb.codegen.Helpers$;
import overflowdb.schema.AbstractNodeType;
import overflowdb.schema.AdjacentNode;
import overflowdb.schema.AdjacentNode$;
import overflowdb.schema.ContainedNode;
import overflowdb.schema.Direction$;
import overflowdb.schema.EdgeType;
import overflowdb.schema.EdgeType$Cardinality$List$;
import overflowdb.schema.EdgeType$Cardinality$One$;
import overflowdb.schema.EdgeType$Cardinality$ZeroOrOne$;
import overflowdb.schema.MarkerTrait;
import overflowdb.schema.MarkerTrait$;
import overflowdb.schema.NeighborInfoForEdge;
import overflowdb.schema.NeighborInfoForEdge$;
import overflowdb.schema.NeighborInfoForNode;
import overflowdb.schema.NeighborInfoForNode$;
import overflowdb.schema.NodeBaseType;
import overflowdb.schema.NodeType;
import overflowdb.schema.ProductElement;
import overflowdb.schema.ProductElement$;
import overflowdb.schema.Property;
import overflowdb.schema.Property$Cardinality$List$;
import overflowdb.schema.Property$Cardinality$One$;
import overflowdb.schema.Property$Cardinality$ZeroOrOne$;
import overflowdb.schema.Property$ValueType$Boolean$;
import overflowdb.schema.Property$ValueType$Int$;
import overflowdb.schema.Property$ValueType$String$;
import overflowdb.schema.Schema;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class CodeGen {
    private final Schema schema;
    private final String basePackage;
    private final String nodesPackage;
    private final String edgesPackage;
    private final String traversalsPackage;
    private boolean enableScalafmt;
    private Option<better.files.File> scalafmtConfig;

    public CodeGen(Schema schema) {
        this.schema = schema;
        this.basePackage = schema.basePackage();
        this.nodesPackage = new StringBuilder(6).append(this.basePackage()).append(".nodes").toString();
        this.edgesPackage = new StringBuilder(6).append(this.basePackage()).append(".edges").toString();
        this.traversalsPackage = new StringBuilder(10).append(this.basePackage()).append(".traversal").toString();
        this.enableScalafmt = true;
        this.scalafmtConfig = None$.MODULE$;
    }

    public String basePackage() {
        return this.basePackage;
    }

    public String nodesPackage() {
        return this.nodesPackage;
    }

    public String edgesPackage() {
        return this.edgesPackage;
    }

    public String traversalsPackage() {
        return this.traversalsPackage;
    }

    public CodeGen disableScalafmt() {
        this.enableScalafmt = false;
        return this;
    }

    public CodeGen withScalafmtConfig(File file) {
        this.scalafmtConfig = Option$.MODULE$.apply((Object)better.files.package$.MODULE$.FileExtensions(file).toScala());
        return this;
    }

    public Seq<File> run(File outputDir) {
        this.warnForDuplicatePropertyDefinitions();
        better.files.File _outputDir = better.files.package$.MODULE$.FileExtensions(outputDir).toScala();
        Seq results = (Seq)((SeqOps)((IterableOps)((IterableOps)((IterableOps)this.writeStarters(_outputDir).$plus$plus(this.writeConstants(_outputDir))).$plus$plus(this.writeEdgeFiles(_outputDir))).$plus$plus(this.writeNodeFiles(_outputDir))).$plus$plus(this.writeNodeTraversalFiles(_outputDir))).$colon$plus((Object)this.writeNewNodeFile(_outputDir));
        Predef$.MODULE$.println((Object)new StringBuilder(20).append("generated ").append(results.size()).append(" files in ").append(_outputDir).toString());
        if (this.enableScalafmt) {
            Seq scalaSourceFiles = (Seq)results.filter((Function1 & Serializable)_$1 -> {
                Option option = _$1.extension();
                Some some = Some$.MODULE$.apply((Object)".scala");
                return !(option != null ? !option.equals(some) : some != null);
            });
            Formatter$.MODULE$.run((Seq<better.files.File>)scalaSourceFiles, this.scalafmtConfig);
        }
        return (Seq)results.map((Function1 & Serializable)_$2 -> _$2.toJava());
    }

    public void warnForDuplicatePropertyDefinitions() {
        Seq warnings = (Seq)this.schema.allNodeTypes().flatMap((Function1 & Serializable)nodeType -> (IterableOnce)nodeType.propertiesWithoutInheritance().flatMap((Function1 & Serializable)property -> (IterableOnce)nodeType.extendzRecursively().withFilter((Function1 & Serializable)baseType -> baseType.propertiesWithoutInheritance().contains(property) && !this.schema.noWarnList().contains((Object)Tuple2$.MODULE$.apply(nodeType, property))).map((Function1 & Serializable)baseType -> new StringBuilder(83).append("[info]: ").append(nodeType).append(" wouldn't need to have property `").append(property.name()).append("` added explicitly - ").append(baseType).append(" already brings it in").toString())));
        if (warnings.size() > 0) {
            Predef$.MODULE$.println((Object)new StringBuilder(16).append(warnings.size()).append(" warnings found:").toString());
        }
        ((IterableOnceOps)warnings.sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1)(JProcedure1 & Serializable)x -> Predef$.MODULE$.println(x));
    }

    public Seq<better.files.File> writeStarters(better.files.File outputDir) {
        Buffer results = (Buffer)Buffer$.MODULE$.empty();
        better.files.File baseDir = outputDir.$div(this.basePackage().replaceAll("\\.", "/"));
        baseDir.createDirectories(baseDir.createDirectories$default$1(), baseDir.createDirectories$default$2());
        String domainShortName = this.schema.domainShortName();
        String string = new StringBuilder(6).append(domainShortName).append(".scala").toString();
        boolean bl = baseDir.createChild$default$2();
        boolean bl2 = baseDir.createChild$default$3();
        better.files.File file = baseDir.createChild(string, bl, bl2, baseDir.createChild$default$4(string, bl, bl2), baseDir.createChild$default$5(string, bl, bl2));
        String string2 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(2902).append("package ").append(this.basePackage()).append("\n         |\n         |import java.nio.file.{Path, Paths}\n         |import overflowdb.traversal.help.{DocSearchPackages, TraversalHelp}\n         |import overflowdb.{Config, Graph}\n         |import scala.jdk.javaapi.CollectionConverters.asJava\n         |\n         |object ").append(domainShortName).append(" {\n         |  implicit val defaultDocSearchPackage: DocSearchPackages = DocSearchPackages(getClass.getPackage.getName)\n         |\n         |  /**\n         |    * Syntactic sugar for `new ").append(domainShortName).append("(graph)`.\n         |    * Usage:\n         |    *   `").append(domainShortName).append("(graph)` or simply `").append(domainShortName).append("` if you have an `implicit Graph` in scope\n         |    */\n         |  def apply(implicit graph: Graph) = new ").append(domainShortName).append("(graph)\n         |\n         |  def empty: ").append(domainShortName).append(" =\n         |    new ").append(domainShortName).append("(emptyGraph)\n         |\n         |  /**\n         |    * Instantiate ").append(domainShortName).append(" with storage.\n         |    * If the storage file already exists, it will load (a subset of) the data into memory. Otherwise it will create an empty ").append(domainShortName).append(".\n         |    * In either case, configuring storage means that OverflowDb will be stored to disk on shutdown (`close`).\n         |    * I.e. if you want to preserve state between sessions, just use this method to instantiate the ").append(domainShortName).append(" and ensure to properly `close` it at the end.\n         |    * @param path to the storage file, e.g. /home/user1/overflowdb.bin\n         |    */\n         |  def withStorage(path: Path): ").append(domainShortName).append(" =\n         |    withConfig(Config.withoutOverflow.withStorageLocation(path))\n         |\n         |  def withStorage(path: String): ").append(domainShortName).append(" =\n         |    withStorage(Paths.get(path))\n         |\n         |  def withConfig(config: overflowdb.Config): ").append(domainShortName).append(" =\n         |    new ").append(domainShortName).append("(\n         |      Graph.open(config, nodes.Factories.allAsJava, edges.Factories.allAsJava, convertPropertyForPersistence))\n         |\n         |  def emptyGraph: Graph =\n         |    Graph.open(Config.withoutOverflow, nodes.Factories.allAsJava, edges.Factories.allAsJava, convertPropertyForPersistence)\n         |\n         |  def convertPropertyForPersistence(property: Any): Any =\n         |    property match {\n         |      case arraySeq: scala.collection.immutable.ArraySeq[_] => arraySeq.unsafeArray\n         |      case coll: IterableOnce[Any] => asJava(coll.iterator.toArray)\n         |      case other => other\n         |    }\n         |\n         |}\n         |\n         |\n         |/**\n         |  * Domain-specific wrapper for graph, starting point for traversals.\n         |  * @param graph the underlying graph. An empty graph is created if this parameter is omitted.\n         |  */\n         |class ").append(domainShortName).append("(private val _graph: Graph = ").append(domainShortName).append(".emptyGraph) extends AutoCloseable {\n         |  def graph: Graph = _graph\n         |\n         |  def help(implicit searchPackageNames: DocSearchPackages): String =\n         |    new TraversalHelp(searchPackageNames).forTraversalSources\n         |\n         |  override def close(): Unit =\n         |    graph.close\n         |}\n         |\n         |").toString()));
        better.files.File domainMain = file.write(string2, file.write$default$2(string2), file.write$default$3(string2));
        results.append((Object)domainMain);
        return results.toSeq();
    }

    public Seq<better.files.File> writeConstants(better.files.File outputDir) {
        Buffer results = (Buffer)Buffer$.MODULE$.empty();
        better.files.File baseDir = outputDir.$div(this.basePackage().replaceAll("\\.", "/"));
        baseDir.createDirectories(baseDir.createDirectories$default$1(), baseDir.createDirectories$default$2());
        this.writeConstantsFile$1(results, baseDir, "PropertyNames", (Seq)this.schema.properties().map((Function1 & Serializable)property -> CodeGen$ConstantContext$.MODULE$.apply(property.name(), new StringBuilder(33).append("public static final String ").append(property.name()).append(" = \"").append(property.name()).append("\";").toString(), property.comment())));
        this.writeConstantsFile$1(results, baseDir, "NodeTypes", (Seq)this.schema.nodeTypes().map((Function1 & Serializable)nodeType -> CodeGen$ConstantContext$.MODULE$.apply(nodeType.name(), new StringBuilder(33).append("public static final String ").append(nodeType.name()).append(" = \"").append(nodeType.name()).append("\";").toString(), nodeType.comment())));
        this.writeConstantsFile$1(results, baseDir, "EdgeTypes", (Seq)this.schema.edgeTypes().map((Function1 & Serializable)edgeType -> CodeGen$ConstantContext$.MODULE$.apply(edgeType.name(), new StringBuilder(33).append("public static final String ").append(edgeType.name()).append(" = \"").append(edgeType.name()).append("\";").toString(), edgeType.comment())));
        this.schema.constantsByCategory().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String category = (String)tuple2._1();
            Seq constants = (Seq)tuple2._2();
            this.writeConstantsFile$1(results, baseDir, category, (Seq)constants.map((Function1 & Serializable)constant -> CodeGen$ConstantContext$.MODULE$.apply(constant.name(), new StringBuilder(33).append("public static final String ").append(constant.name()).append(" = \"").append(constant.value()).append("\";").toString(), constant.comment())));
        });
        this.writeConstantsFile$1(results, baseDir, "Properties", (Seq)this.schema.properties().map((Function1 & Serializable)property -> {
            String string;
            String valueType = Helpers$.MODULE$.typeFor(property);
            Property.Cardinality cardinality = property.cardinality();
            Property.Cardinality cardinality2 = cardinality;
            if (cardinality2 instanceof Property.Cardinality.One) {
                Property.Cardinality.One one = Property$Cardinality$One$.MODULE$.unapply((Property.Cardinality.One)cardinality2);
                Property.Default default_ = one._1();
                string = valueType;
            } else if (Property$Cardinality$ZeroOrOne$.MODULE$.equals(cardinality2)) {
                string = valueType;
            } else if (Property$Cardinality$List$.MODULE$.equals(cardinality2)) {
                string = new StringBuilder(29).append("scala.collection.IndexedSeq<").append(valueType).append(">").toString();
            } else {
                throw new MatchError((Object)cardinality2);
            }
            String completeType = string;
            String src = new StringBuilder(81).append("public static final overflowdb.PropertyKey<").append(completeType).append("> ").append(property.name()).append(" = new overflowdb.PropertyKey<>(\"").append(property.name()).append("\");").toString();
            return CodeGen$ConstantContext$.MODULE$.apply(property.name(), src, property.comment());
        }));
        return results.toSeq();
    }

    public Seq<better.files.File> writeEdgeFiles(better.files.File outputDir) {
        String staticHeader = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(110).append("package ").append(this.edgesPackage()).append("\n         |\n         |import overflowdb._\n         |import scala.jdk.CollectionConverters._\n         |").toString()));
        String edgeFactories = ((IterableOnceOps)this.schema.edgeTypes().map((Function1 & Serializable)edgeType -> new StringBuilder(8).append(edgeType.className()).append(".factory").toString())).mkString(", ");
        String factories = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(179).append("object Factories {\n           |  lazy val all: Seq[EdgeFactory[_]] = Seq(").append(edgeFactories).append(")\n           |  lazy val allAsJava: java.util.List[EdgeFactory[_]] = all.asJava\n           |}\n           |").toString()));
        String packageObject = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(33).append(staticHeader).append("\n         |").append(Helpers$.MODULE$.propertyErrorRegisterImpl()).append("\n         |").append(factories).append("\n         |").toString()));
        better.files.File baseDir = outputDir.$div(this.edgesPackage().replaceAll("\\.", "/"));
        if (baseDir.exists(baseDir.exists$default$1())) {
            baseDir.delete(baseDir.delete$default$1(), baseDir.delete$default$2());
        }
        baseDir.createDirectories(baseDir.createDirectories$default$1(), baseDir.createDirectories$default$2());
        boolean bl = baseDir.createChild$default$2();
        boolean bl2 = baseDir.createChild$default$3();
        better.files.File file = baseDir.createChild("package.scala", bl, bl2, baseDir.createChild$default$4("package.scala", bl, bl2), baseDir.createChild$default$5("package.scala", bl, bl2));
        better.files.File pkgObjFile = file.write(packageObject, file.write$default$2(packageObject), file.write$default$3(packageObject));
        Seq edgeTypeFiles = (Seq)this.schema.edgeTypes().map((Function1 & Serializable)edge -> {
            String src = CodeGen.generateEdgeSource$1(staticHeader, edge, edge.properties());
            String srcFile = new StringBuilder(6).append(edge.className()).append(".scala").toString();
            boolean bl = baseDir.createChild$default$2();
            boolean bl2 = baseDir.createChild$default$3();
            better.files.File file = baseDir.createChild(srcFile, bl, bl2, baseDir.createChild$default$4(srcFile, bl, bl2), baseDir.createChild$default$5(srcFile, bl, bl2));
            return file.write(src, file.write$default$2(src), file.write$default$3(src));
        });
        return (Seq)edgeTypeFiles.$plus$colon((Object)pkgObjFile);
    }

    public String neighborAccessorNameForEdge(EdgeType edge, Enumeration.Value direction) {
        return Helpers$.MODULE$.camelCase(new StringBuilder(1).append(edge.name()).append("_").append(direction).toString());
    }

    public Seq<better.files.File> writeNodeFiles(better.files.File outputDir) {
        List genericNeighborAccessors = Direction$.MODULE$.all().flatMap((Function1 & Serializable)direction -> (IterableOnce)((IterableOps)this.schema.edgeTypes().map((Function1 & Serializable)edgeType -> {
            String accessor = this.neighborAccessorNameForEdge((EdgeType)edgeType, (Enumeration.Value)direction);
            return Tuple2$.MODULE$.apply(edgeType, (Object)accessor);
        })).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            EdgeType edgeType = (EdgeType)tuple2._1();
            String accessor = (String)tuple2._2();
            return new StringBuilder(81).append("def _").append(accessor).append(": java.util.Iterator[StoredNode] = { java.util.Collections.emptyIterator() }").toString();
        }));
        String markerTraits = ((IterableOnceOps)((SeqOps)((IterableOps)((SeqOps)this.schema.allNodeTypes().flatMap((Function1 & Serializable)_$5 -> _$5.markerTraits())).distinct()).map((Function1 & Serializable)x$1 -> {
            String string;
            MarkerTrait markerTrait = x$1;
            if (markerTrait == null) {
                throw new MatchError((Object)markerTrait);
            }
            MarkerTrait markerTrait2 = MarkerTrait$.MODULE$.unapply(markerTrait);
            String name = string = markerTrait2._1();
            return new StringBuilder(6).append("trait ").append(name).toString();
        })).sorted((Ordering)Ordering.String$.MODULE$)).mkString(System.lineSeparator());
        String keyBasedTraits = ((IterableOnceOps)this.schema.nodeProperties().map((Function1 & Serializable)property -> {
            String camelCaseName = Helpers$.MODULE$.camelCase(property.name());
            String tpe = Helpers$.MODULE$.getCompleteType((Property<?>)property);
            String traitName = new StringBuilder(3).append("Has").append(property.className()).toString();
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(155).append("trait ").append(traitName).append(" {\n             |  def ").append(camelCaseName).append(": ").append(tpe).append("\n             |}\n             |trait ").append(traitName).append("Mutable extends ").append(traitName).append(" {\n             |  def ").append(camelCaseName).append("_=(value: ").append(tpe).append("): Unit\n             |}\n             |").toString()));
        })).mkString(System.lineSeparator());
        String nodeFactories = ((IterableOnceOps)this.schema.nodeTypes().map((Function1 & Serializable)nodeType -> new StringBuilder(8).append(nodeType.className()).append(".factory").toString())).mkString(", ");
        String factories = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(179).append("object Factories {\n           |  lazy val all: Seq[NodeFactory[_]] = Seq(").append(nodeFactories).append(")\n           |  lazy val allAsJava: java.util.List[NodeFactory[_]] = all.asJava\n           |}\n           |").toString()));
        String reChars = "[](){}*+&|?.,\\\\$";
        String rootTypeImpl = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(1461).append("package ").append(this.nodesPackage()).append("\n         |\n         |import overflowdb._\n         |import scala.jdk.CollectionConverters._\n         |\n         |").append(Helpers$.MODULE$.propertyErrorRegisterImpl()).append("\n         |\n         |object Misc {\n         |  val reChars = \"").append(reChars).append("\"\n         |  def isRegex(pattern: String): Boolean = pattern.exists(reChars.contains(_))\n         |}\n         |\n         |/** Abstract supertype for overflowdb.Node and NewNode */\n         |trait AbstractNode extends overflowdb.NodeOrDetachedNode {\n         |  def label: String\n         |}\n         |\n         |/* A node that is stored inside an Graph (rather than e.g. DiffGraph) */\n         |trait StoredNode extends Node with AbstractNode with Product {\n         |  /* underlying Node in the graph.\n         |   * since this is a StoredNode, this is always set */\n         |  def underlying: Node = this\n         |\n         |  /** labels of product elements, used e.g. for pretty-printing */\n         |  def productElementLabel(n: Int): String\n         |\n         |  /* all properties plus label and id */\n         |  def toMap: Map[String, Any] = {\n         |    val map = propertiesMap()\n         |    map.put(\"_label\", label)\n         |    map.put(\"_id\", id: java.lang.Long)\n         |    map.asScala.toMap\n         |  }\n         |\n         |  /*Sets fields from newNode*/\n         |  def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode):Unit = ???\n         |\n         |  ").append(genericNeighborAccessors.mkString(System.lineSeparator())).append("\n         |}\n         |\n         |  ").append(keyBasedTraits).append("\n         |  ").append(markerTraits).append("\n         |\n         |  ").append(factories).append("\n         |").toString()));
        String staticHeader = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(110).append("package ").append(this.nodesPackage()).append("\n         |\n         |import overflowdb._\n         |import scala.jdk.CollectionConverters._\n         |").toString()));
        Buffer results = (Buffer)Buffer$.MODULE$.empty();
        better.files.File baseDir = outputDir.$div(this.nodesPackage().replaceAll("\\.", "/"));
        if (baseDir.exists(baseDir.exists$default$1())) {
            baseDir.delete(baseDir.delete$default$1(), baseDir.delete$default$2());
        }
        baseDir.createDirectories(baseDir.createDirectories$default$1(), baseDir.createDirectories$default$2());
        boolean bl = baseDir.createChild$default$2();
        boolean bl2 = baseDir.createChild$default$3();
        better.files.File file = baseDir.createChild("RootTypes.scala", bl, bl2, baseDir.createChild$default$4("RootTypes.scala", bl, bl2), baseDir.createChild$default$5("RootTypes.scala", bl, bl2));
        results.append((Object)file.write(rootTypeImpl, file.write$default$2(rootTypeImpl), file.write$default$3(rootTypeImpl)));
        this.schema.nodeBaseTypes().foreach((Function1 & Serializable)nodeBaseTrait -> {
            String src = this.generateNodeBaseTypeSource$1((NodeBaseType)nodeBaseTrait);
            String srcFile = new StringBuilder(6).append(nodeBaseTrait.className()).append(".scala").toString();
            boolean bl = baseDir.createChild$default$2();
            boolean bl2 = baseDir.createChild$default$3();
            better.files.File file = baseDir.createChild(srcFile, bl, bl2, baseDir.createChild$default$4(srcFile, bl, bl2), baseDir.createChild$default$5(srcFile, bl, bl2));
            return results.append((Object)file.write(src, file.write$default$2(src), file.write$default$3(src)));
        });
        this.schema.nodeTypes().foreach((Function1 & Serializable)nodeType -> {
            String src = this.generateNodeSource$1(staticHeader, (NodeType)nodeType);
            String srcFile = new StringBuilder(6).append(nodeType.className()).append(".scala").toString();
            boolean bl = baseDir.createChild$default$2();
            boolean bl2 = baseDir.createChild$default$3();
            better.files.File file = baseDir.createChild(srcFile, bl, bl2, baseDir.createChild$default$4(srcFile, bl, bl2), baseDir.createChild$default$5(srcFile, bl, bl2));
            return results.append((Object)file.write(src, file.write$default$2(src), file.write$default$3(src)));
        });
        return results.toSeq();
    }

    public Seq<better.files.File> writeNodeTraversalFiles(better.files.File outputDir) {
        LazyRef lazyRef = new LazyRef();
        String packageObject = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(85).append("package ").append(this.basePackage()).append("\n         |package object traversal extends NodeTraversalImplicits\n         |").toString()));
        Buffer results = (Buffer)Buffer$.MODULE$.empty();
        better.files.File baseDir = outputDir.$div(this.traversalsPackage().replaceAll("\\.", "/"));
        if (baseDir.exists(baseDir.exists$default$1())) {
            baseDir.delete(baseDir.delete$default$1(), baseDir.delete$default$2());
        }
        baseDir.createDirectories(baseDir.createDirectories$default$1(), baseDir.createDirectories$default$2());
        boolean bl = baseDir.createChild$default$2();
        boolean bl2 = baseDir.createChild$default$3();
        better.files.File file = baseDir.createChild("package.scala", bl, bl2, baseDir.createChild$default$4("package.scala", bl, bl2), baseDir.createChild$default$5("package.scala", bl, bl2));
        results.append((Object)file.write(packageObject, file.write$default$2(packageObject), file.write$default$3(packageObject)));
        boolean bl3 = baseDir.createChild$default$2();
        boolean bl4 = baseDir.createChild$default$3();
        better.files.File file2 = baseDir.createChild("NodeTraversalImplicits.scala", bl3, bl4, baseDir.createChild$default$4("NodeTraversalImplicits.scala", bl3, bl4), baseDir.createChild$default$5("NodeTraversalImplicits.scala", bl3, bl4));
        String string = this.nodeTraversalImplicits$1(lazyRef);
        results.append((Object)file2.write(string, file2.write$default$2(string), file2.write$default$3(string)));
        this.schema.allNodeTypes().foreach((Function1 & Serializable)nodeType -> {
            String src = this.generateNodeTraversalExt$1((AbstractNodeType)nodeType);
            String srcFile = new StringBuilder(6).append(nodeType.className()).append(".scala").toString();
            boolean bl = baseDir.createChild$default$2();
            boolean bl2 = baseDir.createChild$default$3();
            better.files.File file = baseDir.createChild(srcFile, bl, bl2, baseDir.createChild$default$4(srcFile, bl, bl2), baseDir.createChild$default$5(srcFile, bl, bl2));
            return results.append((Object)file.write(src, file.write$default$2(src), file.write$default$3(src)));
        });
        return results.toSeq();
    }

    public better.files.File writeNewNodeFile(better.files.File outputDir) {
        String staticHeader = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(688).append("package ").append(this.nodesPackage()).append("\n         |\n         |/** base type for all nodes that can be added to a graph, e.g. the diffgraph */\n         |abstract class NewNode extends AbstractNode with overflowdb.DetachedNodeData with Product {\n         |  def properties: Map[String, Any]\n         |  def copy: this.type\n         |  type StoredType <: StoredNode\n         |  private var refOrId: Object = null\n         |  override def getRefOrId(): Object = refOrId\n         |  override def setRefOrId(r: Object): Unit = {this.refOrId = r}\n         |  def stored: Option[StoredType] = if(refOrId != null && refOrId.isInstanceOf[StoredNode]) Some(refOrId).asInstanceOf[Option[StoredType]] else None\n         |}\n         |").toString()));
        better.files.File outfile = outputDir.$div(this.nodesPackage().replaceAll("\\.", "/")).$div("NewNodes.scala");
        if (outfile.exists(outfile.exists$default$1())) {
            outfile.delete(outfile.delete$default$1(), outfile.delete$default$2());
        }
        outfile.createFile(outfile.createFile$default$1());
        String src = ((IterableOnceOps)this.schema.nodeTypes().map((Function1 & Serializable)nodeType -> this.generateNewNodeSource$1((NodeType)nodeType, (Seq)nodeType.properties()))).mkString(System.lineSeparator());
        String string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(46).append(staticHeader).append("\n                     |").append(src).append("\n                     |").toString()));
        return outfile.write(string, outfile.write$default$2(string), outfile.write$default$3(string));
    }

    private final String registerAdditionalSearchPackages$1() {
        return ((IterableOnceOps)this.schema.additionalTraversalsPackages().map((Function1 & Serializable)packageName -> new StringBuilder(36).append(".registerAdditionalSearchPackage(\"").append((String)packageName).append("\")").toString())).mkString("");
    }

    private static final String $anonfun$6() {
        return "";
    }

    private final void writeConstantsFile$1(Buffer results$1, better.files.File baseDir$1, String className, Seq constants) {
        String constantsSource = ((IterableOnceOps)constants.map((Function1 & Serializable)constant -> {
            String documentation = (String)constant.documentation().filter((Function1 & Serializable)_$3 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$3))).map((Function1 & Serializable)comment -> new StringBuilder(7).append("/** ").append((String)comment).append(" */").toString()).getOrElse(CodeGen::$anonfun$6);
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(26).append(documentation).append("\n           |").append(constant.source()).append("\n           |").toString()));
        })).mkString(System.lineSeparator());
        String allConstantsSetType = constantsSource.contains("PropertyKey") ? "PropertyKey<?>" : "String";
        String allConstantsBody = ((IterableOnceOps)constants.map((Function1 & Serializable)constant -> new StringBuilder(6).append("add(").append(constant.name()).append(");").toString())).mkString(System.lineSeparator());
        String allConstantsSet = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(99).append("\n           |public static Set<").append(allConstantsSetType).append("> ALL = new HashSet<").append(allConstantsSetType).append(">() {{\n           |").append(allConstantsBody).append("\n           |}};\n           |").toString()));
        String string = new StringBuilder(5).append(className).append(".java").toString();
        boolean bl = baseDir$1.createChild$default$2();
        boolean bl2 = baseDir$1.createChild$default$3();
        better.files.File file = baseDir$1.createChild(string, bl, bl2, baseDir$1.createChild$default$4(string, bl, bl2), baseDir$1.createChild$default$5(string, bl, bl2));
        String string2 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(275).append("package ").append(this.basePackage()).append(";\n           |\n           |import overflowdb.*;\n           |\n           |import java.util.Collection;\n           |import java.util.HashSet;\n           |import java.util.Set;\n           |\n           |public class ").append(className).append(" {\n           |\n           |").append(constantsSource).append("\n           |").append(allConstantsSet).append("\n           |}").toString()));
        better.files.File file2 = file.write(string2, file.write$default$2(string2), file.write$default$3(string2));
        results$1.append((Object)file2);
    }

    private static final String propertyBasedFieldAccessors$1(Seq properties) {
        return ((IterableOnceOps)properties.map((Function1 & Serializable)property -> {
            String string;
            String name = property.name();
            String nameCamelCase = Helpers$.MODULE$.camelCase(name);
            String tpe = Helpers$.MODULE$.getCompleteType((Property<?>)property);
            Property.Cardinality cardinality = property.cardinality();
            if (cardinality instanceof Property.Cardinality.One) {
                Property.Cardinality.One one = Property$Cardinality$One$.MODULE$.unapply((Property.Cardinality.One)cardinality);
                Property.Default default_ = one._1();
                string = new StringBuilder(36).append("def ").append(nameCamelCase).append(": ").append(tpe).append(" = property(\"").append(name).append("\").asInstanceOf[").append(tpe).append("]").toString();
            } else if (Property$Cardinality$ZeroOrOne$.MODULE$.equals(cardinality)) {
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(44).append("def ").append(nameCamelCase).append(": ").append(tpe).append(" = Option(property(\"").append(name).append("\")).asInstanceOf[").append(tpe).append("]").toString()));
            } else if (Property$Cardinality$List$.MODULE$.equals(cardinality)) {
                String returnType = new StringBuilder(12).append("IndexedSeq[").append(Helpers$.MODULE$.typeFor(property)).append("]").toString();
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(578).append("def ").append(nameCamelCase).append(": ").append(tpe).append(" = {\n                 |  property(\"").append(name).append("\") match {\n                 |    case null => collection.immutable.ArraySeq.empty\n                 |    case arr: Array[_] if arr.isEmpty => collection.immutable.ArraySeq.empty\n                 |    case arr: Array[_] => scala.collection.immutable.ArraySeq.unsafeWrapArray(arr).asInstanceOf[").append(returnType).append("]\n                 |    case iterable: IterableOnce[_] => iterable.iterator.to(IndexedSeq).asInstanceOf[").append(returnType).append("]\n                 |    case jList: java.util.List[_] => jList.asScala.to(IndexedSeq).asInstanceOf[").append(returnType).append("]\n                 |  }\n                 |}").toString()));
            } else {
                throw new MatchError((Object)cardinality);
            }
            return string;
        })).mkString(System.lineSeparator());
    }

    private static final String generateEdgeSource$1(String staticHeader$1, EdgeType edgeType, Seq properties) {
        String edgeClassName = edgeType.className();
        Seq propertyNames = (Seq)properties.map((Function1 & Serializable)_$4 -> _$4.className());
        String propertyNameDefs = ((IterableOnceOps)properties.map((Function1 & Serializable)p -> new StringBuilder(10).append("val ").append(p.className()).append(" = \"").append(p.name()).append("\" ").toString())).mkString(System.lineSeparator());
        String propertyDefinitions = ((IterableOnceOps)properties.map((Function1 & Serializable)p -> Helpers$.MODULE$.propertyKeyDef(p.name(), Helpers$.MODULE$.typeFor(p), p.cardinality()))).mkString(System.lineSeparator());
        String companionObject = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(825).append("object ").append(edgeClassName).append(" {\n           |  val Label = \"").append(edgeType.name()).append("\"\n           |\n           |  object PropertyNames {\n           |    ").append(propertyNameDefs).append("\n           |    val all: Set[String] = Set(").append(propertyNames.mkString(", ")).append(")\n           |    val allAsJava: java.util.Set[String] = all.asJava\n           |  }\n           |\n           |  object Properties {\n           |    ").append(propertyDefinitions).append("\n           |  }\n           |\n           |  object PropertyDefaults {\n           |    ").append(Helpers$.MODULE$.propertyDefaultCases(properties)).append("\n           |  }\n           |\n           |  val layoutInformation = new EdgeLayoutInformation(Label, PropertyNames.allAsJava)\n           |\n           |  val factory = new EdgeFactory[").append(edgeClassName).append("] {\n           |    override val forLabel = ").append(edgeClassName).append(".Label\n           |\n           |    override def createEdge(graph: Graph, outNode: NodeRef[NodeDb], inNode: NodeRef[NodeDb]) =\n           |      new ").append(edgeClassName).append("(graph, outNode, inNode)\n           |  }\n           |}\n           |").toString()));
        String propertyDefaultValues = Helpers$.MODULE$.propertyDefaultValueImpl(new StringBuilder(17).append(edgeClassName).append(".PropertyDefaults").toString(), properties);
        String classImpl = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(258).append("class ").append(edgeClassName).append("(_graph: Graph, _outNode: NodeRef[NodeDb], _inNode: NodeRef[NodeDb])\n           |extends Edge(_graph, ").append(edgeClassName).append(".Label, _outNode, _inNode, ").append(edgeClassName).append(".PropertyNames.allAsJava) {\n           |\n           |  ").append(CodeGen.propertyBasedFieldAccessors$1(properties)).append("\n           |\n           |  ").append(propertyDefaultValues).append("\n           |\n           |}\n           |").toString()));
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(33).append(staticHeader$1).append("\n         |").append(companionObject).append("\n         |").append(classImpl).append("\n         |").toString()));
    }

    private static final String $anonfun$25(Enumeration.Value direction$4, EdgeType edge$2, AbstractNodeType neighbor$1) {
        return new StringBuilder(4).append("_").append(Helpers$.MODULE$.camelCase(neighbor$1.name())).append("Via").append(StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(edge$2.className()))).append(Helpers$.MODULE$.camelCaseCaps(direction$4.toString())).toString();
    }

    private static final String $anonfun$24$$anonfun$1$$anonfun$1() {
        return "";
    }

    private final String abstractEdgeAccessors$1(NodeBaseType nodeBaseType, Enumeration.Value direction) {
        return ((IterableOnceOps)nodeBaseType.edges(direction).groupBy((Function1 & Serializable)_$6 -> _$6.viaEdge()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            EdgeType edge = (EdgeType)tuple2._1();
            Seq neighbors = (Seq)tuple2._2();
            String edgeAccessorName = this.neighborAccessorNameForEdge(edge, direction);
            String neighborNodesType = "_ <: StoredNode";
            String genericEdgeAccessor = new StringBuilder(38).append("def ").append(edgeAccessorName).append(": overflowdb.traversal.Traversal[").append(neighborNodesType).append("]").toString();
            String specificNodeAccessors = ((IterableOnceOps)((SeqOps)neighbors.flatMap((Function1 & Serializable)adjacentNode -> {
                AbstractNodeType neighbor2 = adjacentNode.neighbor();
                Set entireNodeHierarchy = (Set)neighbor2.subtypes((Set<AbstractNodeType>)this.schema.allNodeTypes().toSet()).$plus$plus((IterableOnce)neighbor2.extendzRecursively().$colon$plus((Object)neighbor2));
                return (IterableOnce)entireNodeHierarchy.map((Function1 & Serializable)neighbor -> {
                    String accessorName = (String)adjacentNode.customStepName().getOrElse(() -> CodeGen.$anonfun$25(direction, edge, neighbor));
                    String accessorImpl0 = new StringBuilder(13).append(edgeAccessorName).append(".collectAll[").append(neighbor.className()).append("]").toString();
                    EdgeType.Cardinality cardinality = adjacentNode.cardinality();
                    EdgeType.Cardinality cardinality2 = cardinality;
                    String accessorImpl1 = EdgeType$Cardinality$One$.MODULE$.equals(cardinality2) ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(286).append("try { ").append(accessorImpl0).append(".next() } catch {\n                     |  case e: java.util.NoSuchElementException =>\n                     |    throw new overflowdb.SchemaViolationException(\"").append(direction).append(" edge with label ").append(adjacentNode.viaEdge().name()).append(" to an adjacent ").append(neighbor.name()).append(" is mandatory, but not defined for this ").append(nodeBaseType.name()).append(" node with id=\" + id, e)\n                     |}").toString())) : (EdgeType$Cardinality$ZeroOrOne$.MODULE$.equals(cardinality2) ? new StringBuilder(13).append(accessorImpl0).append(".nextOption()").toString() : accessorImpl0);
                    return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(144).append("/** ").append(adjacentNode.customStepDoc().getOrElse(CodeGen::$anonfun$24$$anonfun$1$$anonfun$1)).append("\n                 |  * Traverse to ").append(neighbor.name()).append(" via ").append(adjacentNode.viaEdge().name()).append(" ").append(direction).append(" edge.\n                 |  */ ").append(Helpers$.MODULE$.docAnnotationMaybe(adjacentNode.customStepDoc())).append("\n                 |def ").append(accessorName).append(": ").append(Helpers$.MODULE$.fullScalaType((AbstractNodeType)neighbor, cardinality)).append(" =\n                 |  ").append(accessorImpl1).append("\n                 |  ").toString()));
                });
            })).distinct()).mkString(System.lineSeparator());
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(30).append(genericEdgeAccessor).append("\n             |\n             |").append(specificNodeAccessors).toString()));
        })).mkString(System.lineSeparator());
    }

    private final String generateNodeBaseTypeSource$1(NodeBaseType nodeBaseType) {
        SeqOps seqOps;
        String className = nodeBaseType.className();
        Seq<Property<?>> properties = nodeBaseType.properties();
        String mixinsForPropertyAccessorsReadOnly = ((IterableOnceOps)nodeBaseType.properties().map((Function1 & Serializable)property -> new StringBuilder(8).append("with Has").append(property.className()).toString())).mkString(" ");
        String mixinsForBaseTypes = ((IterableOnceOps)nodeBaseType.extendz().map((Function1 & Serializable)baseTrait -> new StringBuilder(5).append("with ").append(baseTrait.className()).toString())).mkString(" ");
        String mixinsForPropertyAccessorsMutable = ((IterableOnceOps)nodeBaseType.properties().map((Function1 & Serializable)property -> new StringBuilder(15).append("with Has").append(property.className()).append("Mutable").toString())).mkString(" ");
        String mixinForBaseTypesNew = ((IterableOnceOps)nodeBaseType.extendz().map((Function1 & Serializable)baseTrait -> new StringBuilder(8).append("with ").append(baseTrait.className()).append("New").toString())).mkString(" ");
        String mixinsForBaseTypes2 = ((IterableOnceOps)nodeBaseType.extendz().map((Function1 & Serializable)baseTrait -> new StringBuilder(9).append("with ").append(baseTrait.className()).append("Base").toString())).mkString(" ");
        String mixinsForMarkerTraits = ((IterableOnceOps)nodeBaseType.markerTraits().map((Function1 & Serializable)x$1 -> {
            String string;
            MarkerTrait markerTrait = x$1;
            if (markerTrait == null) {
                throw new MatchError((Object)markerTrait);
            }
            MarkerTrait markerTrait2 = MarkerTrait$.MODULE$.unapply(markerTrait);
            String name = string = markerTrait2._1();
            return new StringBuilder(5).append("with ").append(name).toString();
        })).mkString(" ");
        Seq propertyNames = (Seq)nodeBaseType.properties().map((Function1 & Serializable)_$7 -> _$7.name());
        String propertyNameDefs = ((IterableOnceOps)propertyNames.map((Function1 & Serializable)name -> new StringBuilder(10).append("val ").append(Helpers$.MODULE$.camelCaseCaps((String)name)).append(" = \"").append((String)name).append("\" ").toString())).mkString(System.lineSeparator());
        String propertyDefinitions = ((IterableOnceOps)properties.map((Function1 & Serializable)p -> Helpers$.MODULE$.propertyKeyDef(p.name(), Helpers$.MODULE$.typeFor(p), p.cardinality()))).mkString(System.lineSeparator());
        Seq seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{nodeBaseType.outEdges(), nodeBaseType.inEdges()})).map((Function1 & Serializable)edges -> ((IterableOnceOps)((IterableOps)((SeqOps)edges.map((Function1 & Serializable)_$8 -> _$8.viaEdge().name())).sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)string -> Helpers$.MODULE$.quote((String)string))).mkString(","));
        if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq), 2) != 0) {
            throw new MatchError((Object)seq);
        }
        String string = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
        String string2 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 1);
        String outEdgeNames = string;
        String inEdgeNames = string2;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)outEdgeNames, (Object)inEdgeNames);
        String outEdgeNames2 = (String)tuple2._1();
        String inEdgeNames2 = (String)tuple2._2();
        String companionObject = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(472).append("object ").append(className).append(" {\n           |  object PropertyNames {\n           |    ").append(propertyNameDefs).append("\n           |    val all: Set[String] = Set(").append(((IterableOnceOps)propertyNames.map((Function1 & Serializable)snakeCase -> Helpers$.MODULE$.camelCaseCaps((String)snakeCase))).mkString(", ")).append(")\n           |  }\n           |\n           |  object Properties {\n           |    ").append(propertyDefinitions).append("\n           |  }\n           |\n           |  object PropertyDefaults {\n           |    ").append(Helpers$.MODULE$.propertyDefaultCases(properties)).append("\n           |  }\n           |\n           |  object Edges {\n           |    val Out: Array[String] = Array(").append(outEdgeNames2).append(")\n           |    val In: Array[String] = Array(").append(inEdgeNames2).append(")\n           |  }\n           |\n           |}").toString()));
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(289).append("package ").append(this.nodesPackage()).append("\n         |\n         |").append(companionObject).append("\n         |\n         |trait ").append(className).append("Base extends AbstractNode\n         |").append(mixinsForPropertyAccessorsReadOnly).append("\n         |").append(mixinsForBaseTypes2).append("\n         |").append(mixinsForMarkerTraits).append("\n         |\n         |trait ").append(className).append("New extends NewNode\n         |").append(mixinsForPropertyAccessorsMutable).append("\n         |").append(mixinForBaseTypesNew).append("\n         |\n         |trait ").append(className).append(" extends StoredNode with ").append(className).append("Base\n         |").append(mixinsForBaseTypes).append(" {\n         |").append(this.abstractEdgeAccessors$1(nodeBaseType, Direction$.MODULE$.OUT())).append("\n         |").append(this.abstractEdgeAccessors$1(nodeBaseType, Direction$.MODULE$.IN())).append("\n         |}").toString()));
    }

    private static final int nextOffsetPos$1(IntRef _currOffsetPos$1) {
        int n;
        _currOffsetPos$1.elem = n = _currOffsetPos$1.elem + 1;
        return _currOffsetPos$1.elem;
    }

    private final CodeGen$AjacentNodeWithInheritanceStatus$3$ AjacentNodeWithInheritanceStatus$lzyINIT1$1(LazyRef AjacentNodeWithInheritanceStatus$lzy1$1) {
        CodeGen$AjacentNodeWithInheritanceStatus$3$ codeGen$AjacentNodeWithInheritanceStatus$3$;
        LazyRef lazyRef = AjacentNodeWithInheritanceStatus$lzy1$1;
        synchronized (lazyRef) {
            codeGen$AjacentNodeWithInheritanceStatus$3$ = (CodeGen$AjacentNodeWithInheritanceStatus$3$)(AjacentNodeWithInheritanceStatus$lzy1$1.initialized() ? AjacentNodeWithInheritanceStatus$lzy1$1.value() : AjacentNodeWithInheritanceStatus$lzy1$1.initialize((Object)new CodeGen$AjacentNodeWithInheritanceStatus$3$(this)));
        }
        return codeGen$AjacentNodeWithInheritanceStatus$3$;
    }

    private final CodeGen$AjacentNodeWithInheritanceStatus$3$ AjacentNodeWithInheritanceStatus$2(LazyRef AjacentNodeWithInheritanceStatus$lzy1$2) {
        return (CodeGen$AjacentNodeWithInheritanceStatus$3$)(AjacentNodeWithInheritanceStatus$lzy1$2.initialized() ? AjacentNodeWithInheritanceStatus$lzy1$2.value() : this.AjacentNodeWithInheritanceStatus$lzyINIT1$1(AjacentNodeWithInheritanceStatus$lzy1$2));
    }

    private final Seq adjacentNodesWithInheritanceStatus$1(NodeType nodeType$4, LazyRef AjacentNodeWithInheritanceStatus$lzy1$3, Function1 adjacentNodes) {
        private class Overflowdb_codegen_CodeGen$AjacentNodeWithInheritanceStatus$1
        implements Product,
        Serializable {
            private final AdjacentNode adjacentNode;
            private final boolean isInherited;
            private final /* synthetic */ CodeGen $outer;

            public Overflowdb_codegen_CodeGen$AjacentNodeWithInheritanceStatus$1(CodeGen $outer, AdjacentNode adjacentNode, boolean isInherited) {
                this.adjacentNode = adjacentNode;
                this.isInherited = isInherited;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.adjacentNode()));
                n = Statics.mix((int)n, (int)(this.isInherited() ? 1231 : 1237));
                return Statics.finalizeHash((int)n, (int)2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Overflowdb_codegen_CodeGen$AjacentNodeWithInheritanceStatus$1)) return false;
                Overflowdb_codegen_CodeGen$AjacentNodeWithInheritanceStatus$1 var3_3 = (Overflowdb_codegen_CodeGen$AjacentNodeWithInheritanceStatus$1)object;
                if (this.isInherited() != var3_3.isInherited()) return false;
                AdjacentNode adjacentNode = this.adjacentNode();
                AdjacentNode adjacentNode2 = var3_3.adjacentNode();
                if (adjacentNode == null) {
                    if (adjacentNode2 != null) {
                        return false;
                    }
                } else if (!((Object)adjacentNode).equals(adjacentNode2)) return false;
                if (!var3_3.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Overflowdb_codegen_CodeGen$AjacentNodeWithInheritanceStatus$1;
            }

            public int productArity() {
                return 2;
            }

            public String productPrefix() {
                return "AjacentNodeWithInheritanceStatus";
            }

            public Object productElement(int n) {
                Serializable serializable;
                int n2 = n;
                if (0 == n2) {
                    serializable = this._1();
                } else if (1 == n2) {
                    serializable = BoxesRunTime.boxToBoolean((boolean)this._2());
                } else {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return serializable;
            }

            public String productElementName(int n) {
                String string;
                int n2 = n;
                if (0 == n2) {
                    string = "adjacentNode";
                } else if (1 == n2) {
                    string = "isInherited";
                } else {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return string;
            }

            public AdjacentNode adjacentNode() {
                return this.adjacentNode;
            }

            public boolean isInherited() {
                return this.isInherited;
            }

            public Overflowdb_codegen_CodeGen$AjacentNodeWithInheritanceStatus$1 copy(AdjacentNode adjacentNode, boolean isInherited) {
                return new Overflowdb_codegen_CodeGen$AjacentNodeWithInheritanceStatus$1(this.$outer, adjacentNode, isInherited);
            }

            public AdjacentNode copy$default$1() {
                return this.adjacentNode();
            }

            public boolean copy$default$2() {
                return this.isInherited();
            }

            public AdjacentNode _1() {
                return this.adjacentNode();
            }

            public boolean _2() {
                return this.isInherited();
            }

            public final /* synthetic */ CodeGen overflowdb$codegen$CodeGen$_$_$_$AjacentNodeWithInheritanceStatus$$$outer() {
                return this.$outer;
            }
        }
        Seq inherited = (Seq)((IterableOps)nodeType$4.extendzRecursively().flatMap(adjacentNodes)).map((Function1 & Serializable)_$11 -> this.AjacentNodeWithInheritanceStatus$2(AjacentNodeWithInheritanceStatus$lzy1$3).apply((AdjacentNode)_$11, true));
        Set inheritedLookup = ((IterableOnceOps)((IterableOps)inherited.map((Function1 & Serializable)_$12 -> _$12.adjacentNode())).map((Function1 & Serializable)adjacentNode -> Tuple2$.MODULE$.apply((Object)adjacentNode.viaEdge(), (Object)adjacentNode.neighbor()))).toSet();
        Seq direct = (Seq)((IterableOps)adjacentNodes.apply((Object)nodeType$4)).map((Function1 & Serializable)adjacentNode -> {
            boolean isInherited = inheritedLookup.contains((Object)Tuple2$.MODULE$.apply((Object)adjacentNode.viaEdge(), (Object)adjacentNode.neighbor()));
            return this.AjacentNodeWithInheritanceStatus$2(AjacentNodeWithInheritanceStatus$lzy1$3).apply((AdjacentNode)adjacentNode, isInherited);
        });
        return (Seq)((SeqOps)direct.$plus$plus((IterableOnce)inherited)).distinct();
    }

    private final Seq createNeighborInfos$1(IntRef _currOffsetPos$3, LazyRef AjacentNodeWithInheritanceStatus$lzy1$8, Seq neighborContexts, Enumeration.Value direction) {
        return ((IterableOnceOps)neighborContexts.groupBy((Function1 & Serializable)_$13 -> _$13.adjacentNode().viaEdge()).map((Function1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            EdgeType edge = (EdgeType)tuple2._1();
            Seq neighborContexts = (Seq)tuple2._2();
            Seq neighborInfoForNodes = (Seq)neighborContexts.map((Function1 & Serializable)x$1 -> {
                Overflowdb_codegen_CodeGen$AjacentNodeWithInheritanceStatus$1 var5_5 = x$1;
                if (var5_5 == null) {
                    throw new MatchError((Object)var5_5);
                }
                Overflowdb_codegen_CodeGen$AjacentNodeWithInheritanceStatus$1 var6_6 = this.AjacentNodeWithInheritanceStatus$2(AjacentNodeWithInheritanceStatus$lzy1$8).unapply(var5_5);
                AdjacentNode adjacentNode = var6_6._1();
                boolean bl = var6_6._2();
                AdjacentNode adjacentNode2 = adjacentNode;
                boolean isInherited = bl;
                return NeighborInfoForNode$.MODULE$.apply(adjacentNode2.neighbor(), edge, direction, adjacentNode2.cardinality(), isInherited, adjacentNode2.customStepName(), adjacentNode2.customStepDoc());
            });
            return NeighborInfoForEdge$.MODULE$.apply(edge, (Seq<NeighborInfoForNode>)neighborInfoForNodes, CodeGen.nextOffsetPos$1(_currOffsetPos$3));
        })).toSeq();
    }

    private final String toLayoutInformationEntry$1(Seq neighborInfos) {
        return ((IterableOnceOps)((IterableOps)neighborInfos.sortBy((Function1 & Serializable)_$18 -> _$18.offsetPosition(), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)neighborInfo -> {
            String edgeClass = neighborInfo.edge().className();
            return new StringBuilder(19).append(this.edgesPackage()).append(".").append(edgeClass).append(".layoutInformation").toString();
        })).mkString(new StringBuilder(1).append(",").append(System.lineSeparator()).toString());
    }

    private static final int nextIdx$1(IntRef currIndex$1) {
        int n;
        currIndex$1.elem = n = currIndex$1.elem + 1;
        return currIndex$1.elem;
    }

    public static final String overflowdb$codegen$CodeGen$$anon$1$$_$applyOrElse$$anonfun$1() {
        return "";
    }

    /*
     * Unable to fully structure code
     */
    private static final String caseEntry$1(String name, String accessorName, Property.Cardinality cardinality, String baseType) {
        block4: {
            var5_4 = cardinality;
            if (!(var5_4 instanceof Property.Cardinality.One)) break block4;
            var6_5 = Property$Cardinality$One$.MODULE$.unapply((Property.Cardinality.One)var5_4);
            var7_6 = var6_5._1();
            ** GOTO lbl-1000
        }
        if (Property$Cardinality$ZeroOrOne$.MODULE$.equals(var5_4)) lbl-1000:
        // 2 sources

        {
            v0 = new StringBuilder(20).append("value.asInstanceOf[").append(baseType).append("]").toString();
        } else if (Property$Cardinality$List$.MODULE$.equals(var5_4)) {
            v0 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(1134).append("value match {\n                 |  case null => collection.immutable.ArraySeq.empty\n                 |  case singleValue: ").append(baseType).append(" => collection.immutable.ArraySeq(singleValue)\n                 |  case coll: IterableOnce[Any] if coll.iterator.isEmpty => collection.immutable.ArraySeq.empty\n                 |  case arr: Array[_] if arr.isEmpty => collection.immutable.ArraySeq.empty\n                 |  case arr: Array[_] => collection.immutable.ArraySeq.unsafeWrapArray(arr).asInstanceOf[IndexedSeq[").append(baseType).append("]]\n                 |  case jCollection: java.lang.Iterable[_]  =>\n                 |    if (jCollection.iterator.hasNext) {\n                 |      collection.immutable.ArraySeq.unsafeWrapArray(\n                 |        jCollection.asInstanceOf[java.util.Collection[").append(baseType).append("]].iterator.asScala.toArray)\n                 |    } else collection.immutable.ArraySeq.empty\n                 |  case iter: Iterable[_] =>\n                 |    if(iter.nonEmpty) {\n                 |      collection.immutable.ArraySeq.unsafeWrapArray(iter.asInstanceOf[Iterable[").append(baseType).append("]].toArray)\n                 |    } else collection.immutable.ArraySeq.empty\n                 |}").toString()));
        } else {
            throw new MatchError((Object)var5_4);
        }
        setter = v0;
        return new StringBuilder(21).append("|case \"").append(name).append("\" => this._").append(accessorName).append(" = ").append(setter).toString();
    }

    private static final String propertyBasedFields$1(String className$1, Seq properties) {
        return ((IterableOnceOps)properties.map((Function1 & Serializable)property -> {
            Tuple4 tuple4;
            String publicName = Helpers$.MODULE$.camelCase(property.name());
            String fieldName = new StringBuilder(1).append("_").append(publicName).toString();
            String valueType = Helpers$.MODULE$.typeFor(property);
            Property.Cardinality cardinality = property.cardinality();
            if (cardinality instanceof Property.Cardinality.One) {
                Property.Cardinality.One one = Property$Cardinality$One$.MODULE$.unapply((Property.Cardinality.One)cardinality);
                Property.Default default_ = one._1();
                tuple4 = Tuple4$.MODULE$.apply((Object)valueType, (Object)valueType, (Object)fieldName, (Object)new StringBuilder(18).append(className$1).append(".PropertyDefaults.").append(property.className()).toString());
            } else if (Property$Cardinality$ZeroOrOne$.MODULE$.equals(cardinality)) {
                tuple4 = Tuple4$.MODULE$.apply((Object)new StringBuilder(8).append("Option[").append(valueType).append("]").toString(), (Object)valueType, (Object)new StringBuilder(8).append("Option(").append(fieldName).append(")").toString(), (Object)"null");
            } else if (Property$Cardinality$List$.MODULE$.equals(cardinality)) {
                tuple4 = Tuple4$.MODULE$.apply((Object)new StringBuilder(12).append("IndexedSeq[").append(valueType).append("]").toString(), (Object)new StringBuilder(12).append("IndexedSeq[").append(valueType).append("]").toString(), (Object)fieldName, (Object)"collection.immutable.ArraySeq.empty");
            } else {
                throw new MatchError((Object)cardinality);
            }
            Tuple4 tuple42 = tuple4;
            String publicType = (String)tuple42._1();
            String tpeForField = (String)tuple42._2();
            String fieldAccessor = (String)tuple42._3();
            String defaultValue = (String)tuple42._4();
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(41).append("private var ").append(fieldName).append(": ").append(tpeForField).append(" = ").append(defaultValue).append("\n             |def ").append(publicName).append(": ").append(publicType).append(" = ").append(fieldAccessor).toString()));
        })).mkString(System.lineSeparator());
    }

    private final String generateNodeSource$1(String staticHeader$3, NodeType nodeType) {
        SeqOps seqOps;
        Seq<Property<?>> properties = nodeType.properties();
        Seq propertyNames = (Seq)((SeqOps)((IterableOps)properties.map((Function1 & Serializable)_$9 -> _$9.name())).$plus$plus((IterableOnce)nodeType.containedNodes().map((Function1 & Serializable)_$10 -> _$10.localName()))).distinct();
        String propertyNameDefs = ((IterableOnceOps)propertyNames.map((Function1 & Serializable)name -> new StringBuilder(10).append("val ").append(Helpers$.MODULE$.camelCaseCaps((String)name)).append(" = \"").append((String)name).append("\" ").toString())).mkString(System.lineSeparator());
        String propertyDefs = ((IterableOnceOps)properties.map((Function1 & Serializable)p -> Helpers$.MODULE$.propertyKeyDef(p.name(), Helpers$.MODULE$.typeFor(p), p.cardinality()))).mkString(System.lineSeparator());
        String propertyDefsForContainedNodes = ((IterableOnceOps)nodeType.containedNodes().map((Function1 & Serializable)containedNode -> Helpers$.MODULE$.propertyKeyDef(containedNode.localName(), containedNode.nodeType().className(), containedNode.cardinality()))).mkString(System.lineSeparator());
        LazyRef lazyRef = new LazyRef();
        IntRef _currOffsetPos = IntRef.create((int)-1);
        Seq neighborOutInfos = this.createNeighborInfos$1(_currOffsetPos, lazyRef, this.adjacentNodesWithInheritanceStatus$1(nodeType, lazyRef, (Function1 & Serializable)_$14 -> _$14.outEdges()), Direction$.MODULE$.OUT());
        Seq neighborInInfos = this.createNeighborInfos$1(_currOffsetPos, lazyRef, this.adjacentNodesWithInheritanceStatus$1(nodeType, lazyRef, (Function1 & Serializable)_$15 -> _$15.inEdges()), Direction$.MODULE$.IN());
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)neighborOutInfos, (Object)neighborInInfos);
        Seq neighborOutInfos2 = (Seq)tuple2._1();
        Seq neighborInInfos2 = (Seq)tuple2._2();
        Seq neighborInfos2 = (Seq)((IterableOps)neighborOutInfos2.map((Function1 & Serializable)_$16 -> Tuple2$.MODULE$.apply(_$16, (Object)Direction$.MODULE$.OUT()))).$plus$plus((IterableOnce)neighborInInfos2.map((Function1 & Serializable)_$17 -> Tuple2$.MODULE$.apply(_$17, (Object)Direction$.MODULE$.IN())));
        List list = ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{neighborOutInfos2, neighborInInfos2}))).map((Function1 & Serializable)neighborInfos -> this.toLayoutInformationEntry$1((Seq)neighborInfos));
        if (list == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list), 2) != 0) {
            throw new MatchError((Object)list);
        }
        String string = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
        String string2 = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 1);
        String outEdgeLayouts = string;
        String inEdgeLayouts = string2;
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)outEdgeLayouts, (Object)inEdgeLayouts);
        String outEdgeLayouts2 = (String)tuple22._1();
        String inEdgeLayouts2 = (String)tuple22._2();
        String className = nodeType.className();
        String classNameDb = nodeType.classNameDb();
        String companionObject = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(1240).append("object ").append(className).append(" {\n           |  def apply(graph: Graph, id: Long) = new ").append(className).append("(graph, id)\n           |\n           |  val Label = \"").append(nodeType.name()).append("\"\n           |\n           |  object PropertyNames {\n           |    ").append(propertyNameDefs).append("\n           |    val all: Set[String] = Set(").append(((IterableOnceOps)propertyNames.map((Function1 & Serializable)snakeCase -> Helpers$.MODULE$.camelCaseCaps((String)snakeCase))).mkString(", ")).append(")\n           |    val allAsJava: java.util.Set[String] = all.asJava\n           |  }\n           |\n           |  object Properties {\n           |    ").append(propertyDefs).append("\n           |    ").append(propertyDefsForContainedNodes).append("\n           |  }\n           |\n           |  object PropertyDefaults {\n           |    ").append(Helpers$.MODULE$.propertyDefaultCases(properties)).append("\n           |  }\n           |\n           |  val layoutInformation = new NodeLayoutInformation(\n           |    Label,\n           |    PropertyNames.allAsJava,\n           |    List(").append(outEdgeLayouts2).append(").asJava,\n           |    List(").append(inEdgeLayouts2).append(").asJava)\n           |\n           |\n           |  object Edges {\n           |    val Out: Array[String] = Array(").append(Helpers$.MODULE$.quoted((Iterable<String>)((Iterable)((SeqOps)neighborOutInfos2.map((Function1 & Serializable)_$19 -> _$19.edge().name())).sorted((Ordering)Ordering.String$.MODULE$))).mkString(",")).append(")\n           |    val In: Array[String] = Array(").append(Helpers$.MODULE$.quoted((Iterable<String>)((Iterable)((SeqOps)neighborInInfos2.map((Function1 & Serializable)_$20 -> _$20.edge().name())).sorted((Ordering)Ordering.String$.MODULE$))).mkString(",")).append(")\n           |  }\n           |\n           |  val factory = new NodeFactory[").append(classNameDb).append("] {\n           |    override val forLabel = ").append(className).append(".Label\n           |\n           |    override def createNode(ref: NodeRef[").append(classNameDb).append("]) =\n           |      new ").append(classNameDb).append("(ref.asInstanceOf[NodeRef[NodeDb]])\n           |\n           |    override def createNodeRef(graph: Graph, id: Long) = ").append(className).append("(graph, id)\n           |  }\n           |}\n           |").toString()));
        String mixinsForExtendedNodes = ((IterableOnceOps)nodeType.extendz().map((Function1 & Serializable)traitName -> new StringBuilder(5).append("with ").append(traitName.className()).toString())).mkString(" ");
        String mixinsForExtendedNodesBase = ((IterableOnceOps)nodeType.extendz().map((Function1 & Serializable)traitName -> new StringBuilder(9).append("with ").append(traitName.className()).append("Base").toString())).mkString(" ");
        String mixinsForMarkerTraits = ((IterableOnceOps)nodeType.markerTraits().map((Function1 & Serializable)x$1 -> {
            String string;
            MarkerTrait markerTrait = x$1;
            if (markerTrait == null) {
                throw new MatchError((Object)markerTrait);
            }
            MarkerTrait markerTrait2 = MarkerTrait$.MODULE$.unapply(markerTrait);
            String name = string = markerTrait2._1();
            return new StringBuilder(5).append("with ").append(name).toString();
        })).mkString(" ");
        String propertyBasedTraits = ((IterableOnceOps)properties.map((Function1 & Serializable)p -> new StringBuilder(8).append("with Has").append(p.className()).toString())).mkString(" ");
        String putKeysImpl = ((IterableOnceOps)properties.map((Function1 & Serializable)key -> {
            String string;
            String memberName = Helpers$.MODULE$.camelCase(key.name());
            Property.Cardinality cardinality = key.cardinality();
            if (cardinality instanceof Property.Cardinality.One) {
                Property.Cardinality.One one = Property$Cardinality$One$.MODULE$.unapply((Property.Cardinality.One)cardinality);
                Property.Default default_ = one._1();
                string = new StringBuilder(20).append("properties.put(\"").append(key.name()).append("\", ").append(memberName).append(")").toString();
            } else if (Property$Cardinality$ZeroOrOne$.MODULE$.equals(cardinality)) {
                string = new StringBuilder(43).append(memberName).append(".map { value => properties.put(\"").append(key.name()).append("\", value) }").toString();
            } else if (Property$Cardinality$List$.MODULE$.equals(cardinality)) {
                string = new StringBuilder(63).append("if (this._").append(memberName).append(" != null && this._").append(memberName).append(".nonEmpty) { properties.put(\"").append(key.name()).append("\", ").append(memberName).append(") }").toString();
            } else {
                throw new MatchError((Object)cardinality);
            }
            return string;
        })).mkString(System.lineSeparator());
        String putContainedNodesImpl = ((IterableOnceOps)nodeType.containedNodes().map((Function1 & Serializable)cnt -> {
            String string;
            String memberName = cnt.localName();
            Property.Cardinality cardinality = cnt.cardinality();
            if (cardinality instanceof Property.Cardinality.One) {
                Property.Cardinality.One one = Property$Cardinality$One$.MODULE$.unapply((Property.Cardinality.One)cardinality);
                Property.Default default_ = one._1();
                string = new StringBuilder(26).append("properties.put(\"").append(memberName).append("\", this._").append(memberName).append(")").toString();
            } else if (Property$Cardinality$ZeroOrOne$.MODULE$.equals(cardinality)) {
                string = new StringBuilder(43).append(memberName).append(".map { value => properties.put(\"").append(memberName).append("\", value) }").toString();
            } else if (Property$Cardinality$List$.MODULE$.equals(cardinality)) {
                string = new StringBuilder(68).append("if (this._").append(memberName).append(" != null && this._").append(memberName).append(".nonEmpty) { properties.put(\"").append(memberName).append("\", this.").append(memberName).append(") }").toString();
            } else {
                throw new MatchError((Object)cardinality);
            }
            return string;
        })).mkString(System.lineSeparator());
        String propertiesMapImpl = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(136).append("{\n           |  val properties = new java.util.HashMap[String, Any]\n           |  ").append(putKeysImpl).append("\n           |  ").append(putContainedNodesImpl).append("\n           |  properties\n           |}").toString()));
        String putKeysImpl2 = ((IterableOnceOps)properties.map((Function1 & Serializable)key -> {
            String string;
            String memberName = Helpers$.MODULE$.camelCase(key.name());
            Property.Cardinality cardinality = key.cardinality();
            if (cardinality instanceof Property.Cardinality.One) {
                Property.Default default_;
                Property.Cardinality.One one = Property$Cardinality$One$.MODULE$.unapply((Property.Cardinality.One)cardinality);
                Property.Default default_2 = default_ = one._1();
                String isDefaultValueImpl = Helpers$.MODULE$.defaultValueCheckImpl(memberName, default_2);
                string = new StringBuilder(33).append("if (!(").append(isDefaultValueImpl).append(")) { properties.put(\"").append(key.name()).append("\", ").append(memberName).append(") }").toString();
            } else if (Property$Cardinality$ZeroOrOne$.MODULE$.equals(cardinality)) {
                string = new StringBuilder(43).append(memberName).append(".map { value => properties.put(\"").append(key.name()).append("\", value) }").toString();
            } else if (Property$Cardinality$List$.MODULE$.equals(cardinality)) {
                string = new StringBuilder(63).append("if (this._").append(memberName).append(" != null && this._").append(memberName).append(".nonEmpty) { properties.put(\"").append(key.name()).append("\", ").append(memberName).append(") }").toString();
            } else {
                throw new MatchError((Object)cardinality);
            }
            return string;
        })).mkString(System.lineSeparator());
        String putContainedNodesImpl2 = ((IterableOnceOps)nodeType.containedNodes().map((Function1 & Serializable)cnt -> {
            String string;
            String memberName = cnt.localName();
            Property.Cardinality cardinality = cnt.cardinality();
            if (cardinality instanceof Property.Cardinality.One) {
                Property.Default default_;
                Property.Cardinality.One one = Property$Cardinality$One$.MODULE$.unapply((Property.Cardinality.One)cardinality);
                Property.Default default_2 = default_ = one._1();
                String isDefaultValueImpl = Helpers$.MODULE$.defaultValueCheckImpl(new StringBuilder(6).append("this._").append(memberName).toString(), default_2);
                string = new StringBuilder(39).append("if (!(").append(isDefaultValueImpl).append(")) { properties.put(\"").append(memberName).append("\", this._").append(memberName).append(") }").toString();
            } else if (Property$Cardinality$ZeroOrOne$.MODULE$.equals(cardinality)) {
                string = new StringBuilder(43).append(memberName).append(".map { value => properties.put(\"").append(memberName).append("\", value) }").toString();
            } else if (Property$Cardinality$List$.MODULE$.equals(cardinality)) {
                string = new StringBuilder(68).append("if (this._").append(memberName).append(" != null && this._").append(memberName).append(".nonEmpty) { properties.put(\"").append(memberName).append("\", this.").append(memberName).append(") }").toString();
            } else {
                throw new MatchError((Object)cardinality);
            }
            return string;
        })).mkString(System.lineSeparator());
        String propertiesMapForStorageImpl = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(136).append("{\n           |  val properties = new java.util.HashMap[String, Any]\n           |  ").append(putKeysImpl2).append("\n           |  ").append(putContainedNodesImpl2).append("\n           |  properties\n           |}").toString()));
        String newNodeCasted = new StringBuilder(25).append("newNode.asInstanceOf[New").append(nodeType.className()).append("]").toString();
        Seq lines = (Seq)properties.map((Function1 & Serializable)key -> {
            String string;
            String memberName = Helpers$.MODULE$.camelCase(key.name());
            Property.Cardinality cardinality = key.cardinality();
            if (cardinality instanceof Property.Cardinality.One) {
                Property.Cardinality.One one = Property$Cardinality$One$.MODULE$.unapply((Property.Cardinality.One)cardinality);
                Property.Default default_ = one._1();
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(10).append("this._").append(memberName).append(" = ").append(newNodeCasted).append(".").append(memberName).toString()));
            } else if (Property$Cardinality$ZeroOrOne$.MODULE$.equals(cardinality)) {
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(17).append("this._").append(memberName).append(" = ").append(newNodeCasted).append(".").append(memberName).append(".orNull").toString()));
            } else if (Property$Cardinality$List$.MODULE$.equals(cardinality)) {
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(66).append("this._").append(memberName).append(" = if (").append(newNodeCasted).append(".").append(memberName).append(" != null) ").append(newNodeCasted).append(".").append(memberName).append(" else collection.immutable.ArraySeq.empty").toString()));
            } else {
                throw new MatchError((Object)cardinality);
            }
            return string;
        });
        String initKeysImpl = lines.mkString(System.lineSeparator());
        String initRefsImpl = ((IterableOnceOps)nodeType.containedNodes().map((Function1 & Serializable)containedNode -> {
            String string;
            String memberName = containedNode.localName();
            String containedNodeType = containedNode.nodeType().className();
            Property.Cardinality cardinality = containedNode.cardinality();
            if (cardinality instanceof Property.Cardinality.One) {
                Property.Cardinality.One one = Property$Cardinality$One$.MODULE$.unapply((Property.Cardinality.One)cardinality);
                Property.Default default_ = one._1();
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(300).append("this._").append(memberName).append(" = ").append(newNodeCasted).append(".").append(memberName).append(" match {\n                   |  case null => null\n                   |  case newNode: NewNode => mapping(newNode).asInstanceOf[").append(containedNodeType).append("]\n                   |  case oldNode: StoredNode => oldNode.asInstanceOf[").append(containedNodeType).append("]\n                   |  case _ => throw new MatchError(\"unreachable\")\n                   |}").toString()));
            } else if (Property$Cardinality$ZeroOrOne$.MODULE$.equals(cardinality)) {
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(317).append("this._").append(memberName).append(" = ").append(newNodeCasted).append(".").append(memberName).append(" match {\n                   |  case null | None => null\n                   |  case Some(newNode:NewNode) => mapping(newNode).asInstanceOf[").append(containedNodeType).append("]\n                   |  case Some(oldNode:StoredNode) => oldNode.asInstanceOf[").append(containedNodeType).append("]\n                   |  case _ => throw new MatchError(\"unreachable\")\n                   |}").toString()));
            } else if (Property$Cardinality$List$.MODULE$.equals(cardinality)) {
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(716).append("this._").append(memberName).append(" =\n                   |  if (").append(newNodeCasted).append(".").append(memberName).append(" == null || ").append(newNodeCasted).append(".").append(memberName).append(".isEmpty) {\n                   |    collection.immutable.ArraySeq.empty\n                   |  } else {\n                   |    collection.immutable.ArraySeq.unsafeWrapArray(\n                   |      ").append(newNodeCasted).append(".").append(memberName).append(".map {\n                   |        case null => throw new NullPointerException(\"NullPointers forbidden in contained nodes\")\n                   |        case newNode:NewNode => mapping(newNode).asInstanceOf[").append(containedNodeType).append("]\n                   |        case oldNode:StoredNode => oldNode.asInstanceOf[").append(containedNodeType).append("]\n                   |        case _ => throw new MatchError(\"unreachable\")\n                   |      }.toArray\n                   |    )\n                   |  }\n                   |").toString()));
            } else {
                throw new MatchError((Object)cardinality);
            }
            return string;
        })).mkString(System.lineSeparator());
        String registerFullName = !((SeqOps)properties.map((Function1 & Serializable)_$21 -> _$21.name())).contains((Object)"FULL_NAME") ? "" : new StringBuilder(65).append("graph.indexManager.putIfIndexed(\"FULL_NAME\", ").append(newNodeCasted).append(".fullName, this.ref)").toString();
        String fromNew = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(142).append("override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode):Unit = {\n           |  ").append(initKeysImpl).append("\n           |  ").append(initRefsImpl).append("\n           |  ").append(registerFullName).append("\n           |}").toString()));
        String containedNodesAsMembers = ((IterableOnceOps)nodeType.containedNodes().map((Function1 & Serializable)containedNode -> {
            String string;
            String containedNodeType = containedNode.nodeType().className();
            Property.Cardinality cardinality = containedNode.cardinality();
            if (cardinality instanceof Property.Cardinality.One) {
                Property.Default default_;
                Property.Cardinality.One one = Property$Cardinality$One$.MODULE$.unapply((Property.Cardinality.One)cardinality);
                Property.Default default_2 = default_ = one._1();
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(96).append("\n                   |private var _").append(containedNode.localName()).append(": ").append(containedNodeType).append(" = ").append(Helpers$.MODULE$.defaultValueImpl(default_2)).append("\n                   |def ").append(containedNode.localName()).append(": ").append(containedNodeType).append(" = this._").append(containedNode.localName()).append("\n                   |").toString()));
            } else if (Property$Cardinality$ZeroOrOne$.MODULE$.equals(cardinality)) {
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(116).append("\n                   |private var _").append(containedNode.localName()).append(": ").append(containedNodeType).append(" = null\n                   |def ").append(containedNode.localName()).append(": Option[").append(containedNodeType).append("] = Option(this._").append(containedNode.localName()).append(")\n                   |").toString()));
            } else if (Property$Cardinality$List$.MODULE$.equals(cardinality)) {
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(155).append("\n                   |private var _").append(containedNode.localName()).append(": IndexedSeq[").append(containedNodeType).append("] = collection.immutable.ArraySeq.empty\n                   |def ").append(containedNode.localName()).append(": IndexedSeq[").append(containedNodeType).append("] = this._").append(containedNode.localName()).append("\n                   |").toString()));
            } else {
                throw new MatchError((Object)cardinality);
            }
            return string;
        })).mkString(System.lineSeparator());
        IntRef currIndex = IntRef.create((int)-1);
        ProductElement forId = ProductElement$.MODULE$.apply("id", "id", CodeGen.nextIdx$1(currIndex));
        Seq forKeys = (Seq)properties.map((Function1 & Serializable)key -> {
            String name = Helpers$.MODULE$.camelCase(key.name());
            return ProductElement$.MODULE$.apply(name, name, CodeGen.nextIdx$1(currIndex));
        });
        Seq forContainedNodes = (Seq)nodeType.containedNodes().map((Function1 & Serializable)containedNode -> ProductElement$.MODULE$.apply(containedNode.localName(), containedNode.localName(), CodeGen.nextIdx$1(currIndex)));
        Seq productElements = (Seq)((SeqOps)forKeys.$plus$plus((IterableOnce)forContainedNodes)).$plus$colon((Object)forId);
        String productElementLabels = ((IterableOnceOps)productElements.map((Function1 & Serializable)x$1 -> {
            ProductElement productElement = x$1;
            if (productElement == null) {
                throw new MatchError((Object)productElement);
            }
            ProductElement productElement2 = ProductElement$.MODULE$.unapply(productElement);
            String string = productElement2._1();
            String string2 = productElement2._2();
            int n = productElement2._3();
            String name = string;
            int index = n;
            return new StringBuilder(12).append("case ").append(index).append(" => \"").append(name).append("\" ").toString();
        })).mkString(System.lineSeparator());
        String productElementAccessors = ((IterableOnceOps)productElements.map((Function1 & Serializable)x$1 -> {
            ProductElement productElement = x$1;
            if (productElement == null) {
                throw new MatchError((Object)productElement);
            }
            ProductElement productElement2 = ProductElement$.MODULE$.unapply(productElement);
            String string = productElement2._1();
            String string2 = productElement2._2();
            int n = productElement2._3();
            String accessorSrc = string2;
            int index = n;
            return new StringBuilder(9).append("case ").append(index).append(" => ").append(accessorSrc).toString();
        })).mkString(System.lineSeparator());
        String abstractContainedNodeAccessors = ((IterableOnceOps)nodeType.containedNodes().map((Function1 & Serializable)containedNode -> new StringBuilder(6).append("def ").append(containedNode.localName()).append(": ").append(Helpers$.MODULE$.getCompleteType((ContainedNode)containedNode)).toString())).mkString(System.lineSeparator());
        String delegatingContainedNodeAccessors = ((IterableOnceOps)nodeType.containedNodes().map((Function1 & Serializable)containedNode -> {
            String string;
            Property.Cardinality cardinality = containedNode.cardinality();
            if (cardinality instanceof Property.Cardinality.One) {
                Property.Cardinality.One one = Property$Cardinality$One$.MODULE$.unapply((Property.Cardinality.One)cardinality);
                Property.Default default_ = one._1();
                string = new StringBuilder(15).append("def ").append(containedNode.localName()).append(": ").append(containedNode.nodeType().className()).append(" = get().").append(containedNode.localName()).toString();
            } else if (Property$Cardinality$ZeroOrOne$.MODULE$.equals(cardinality)) {
                string = new StringBuilder(23).append("def ").append(containedNode.localName()).append(": Option[").append(containedNode.nodeType().className()).append("] = get().").append(containedNode.localName()).toString();
            } else if (Property$Cardinality$List$.MODULE$.equals(cardinality)) {
                string = new StringBuilder(48).append("def ").append(containedNode.localName()).append(": collection.immutable.IndexedSeq[").append(containedNode.nodeType().className()).append("] = get().").append(containedNode.localName()).toString();
            } else {
                throw new MatchError((Object)cardinality);
            }
            String src = string;
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(26).append(Helpers$.MODULE$.docAnnotationMaybe(containedNode.comment())).append("\n           |").append(src).append("\n           |").toString()));
        })).mkString(System.lineSeparator());
        String nodeBaseImpl = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(163).append("trait ").append(className).append("Base extends AbstractNode ").append(mixinsForExtendedNodesBase).append(" ").append(mixinsForMarkerTraits).append(" ").append(propertyBasedTraits).append(" {\n           |  def asStored : StoredNode = this.asInstanceOf[StoredNode]\n           |\n           |  ").append(abstractContainedNodeAccessors).append("\n           |}\n           |").toString()));
        String neighborAccessorDelegators = ((IterableOnceOps)neighborInfos2.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            NeighborInfoForEdge neighborInfo = (NeighborInfoForEdge)tuple2._1();
            Enumeration.Value direction = (Enumeration.Value)tuple2._2();
            String edgeAccessorName = this.neighborAccessorNameForEdge(neighborInfo.edge(), direction);
            String nodeDelegators = ((IterableOnceOps)neighborInfo.nodeInfos().collect((PartialFunction)new Serializable(direction){
                private final Enumeration.Value direction$8;
                {
                    this.direction$8 = direction$11;
                }

                public final boolean isDefinedAt(NeighborInfoForNode x) {
                    NeighborInfoForNode neighborInfoForNode = x;
                    NeighborInfoForNode neighborNodeInfo = neighborInfoForNode;
                    return !neighborNodeInfo.isInherited();
                }

                public final Object applyOrElse(NeighborInfoForNode x, Function1 function1) {
                    Object object;
                    NeighborInfoForNode neighborInfoForNode = x;
                    NeighborInfoForNode neighborNodeInfo = neighborInfoForNode;
                    if (!neighborNodeInfo.isInherited()) {
                        String accessorNameForNode = Helpers$.MODULE$.accessorName(neighborNodeInfo);
                        object = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(104).append("/** ").append(neighborNodeInfo.customStepDoc().getOrElse(CodeGen::overflowdb$codegen$CodeGen$$anon$1$$_$applyOrElse$$anonfun$1)).append("\n               |  * Traverse to ").append(neighborNodeInfo.neighborNode().name()).append(" via ").append(neighborNodeInfo.edge().name()).append(" ").append(this.direction$8).append(" edge.\n               |  */  ").append(Helpers$.MODULE$.docAnnotationMaybe(neighborNodeInfo.customStepDoc())).append("\n               |def ").append(accessorNameForNode).append(": ").append(neighborNodeInfo.returnType()).append(" = get().").append(accessorNameForNode).toString()));
                    } else {
                        object = function1.apply((Object)x);
                    }
                    return object;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{overflowdb$codegen$CodeGen$$anon$1$$_$applyOrElse$$anonfun$1()}, serializedLambda);
                }
            })).mkString(System.lineSeparator());
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(123).append("def ").append(edgeAccessorName).append(": overflowdb.traversal.Traversal[").append(neighborInfo.deriveNeighborNodeType()).append("] = get().").append(edgeAccessorName).append("\n           |override def _").append(edgeAccessorName).append(" = get()._").append(edgeAccessorName).append("\n           |\n           |").append(nodeDelegators).append("\n           |").toString()));
        })).mkString(System.lineSeparator());
        String propertyDelegators = ((IterableOnceOps)properties.map((Function1 & Serializable)key -> {
            String name = Helpers$.MODULE$.camelCase(key.name());
            return new StringBuilder(24).append("override def ").append(name).append(": ").append(Helpers$.MODULE$.getCompleteType((Property<?>)key)).append(" = get().").append(name).toString();
        })).mkString(System.lineSeparator());
        String propertyDefaultValues = Helpers$.MODULE$.propertyDefaultValueImpl(new StringBuilder(17).append(className).append(".PropertyDefaults").toString(), properties);
        String nodeRefImpl = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(932).append("class ").append(className).append("(graph: Graph, id: Long) extends NodeRef[").append(classNameDb).append("](graph, id)\n           |  with ").append(className).append("Base\n           |  with StoredNode\n           |  ").append(mixinsForExtendedNodes).append(" {\n           |  ").append(propertyDelegators).append("\n           |  ").append(propertyDefaultValues).append("\n           |  ").append(delegatingContainedNodeAccessors).append("\n           |    ").append(neighborAccessorDelegators).append("\n           |\n           |    override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)\n           |    override def canEqual(that: Any): Boolean = get.canEqual(that)\n           |    override def label: String = {\n           |      ").append(className).append(".Label\n           |    }\n           |\n           |    override def productElementLabel(n: Int): String =\n           |      n match {\n           |        ").append(productElementLabels).append("\n           |      }\n           |\n           |    override def productElement(n: Int): Any =\n           |      n match {\n           |        ").append(productElementAccessors).append("\n           |      }\n           |\n           |    override def productPrefix = \"").append(className).append("\"\n           |    override def productArity = ").append(productElements.size()).append("\n           |}\n           |").toString()));
        String neighborAccessors = ((IterableOnceOps)neighborInfos2.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            NeighborInfoForEdge neighborInfo = (NeighborInfoForEdge)tuple2._1();
            Enumeration.Value direction = (Enumeration.Value)tuple2._2();
            String edgeAccessorName = this.neighborAccessorNameForEdge(neighborInfo.edge(), direction);
            String neighborType = neighborInfo.deriveNeighborNodeType();
            int offsetPosition = neighborInfo.offsetPosition();
            String nodeAccessors = ((IterableOnceOps)neighborInfo.nodeInfos().collect((PartialFunction)new Serializable(nodeType, direction, edgeAccessorName){
                private final NodeType nodeType$5;
                private final Enumeration.Value direction$9;
                private final String edgeAccessorName$3;
                {
                    this.nodeType$5 = nodeType$8;
                    this.direction$9 = direction$12;
                    this.edgeAccessorName$3 = edgeAccessorName$4;
                }

                public final boolean isDefinedAt(NeighborInfoForNode x) {
                    NeighborInfoForNode neighborInfoForNode = x;
                    NeighborInfoForNode neighborNodeInfo = neighborInfoForNode;
                    return !neighborNodeInfo.isInherited();
                }

                public final Object applyOrElse(NeighborInfoForNode x, Function1 function1) {
                    Object object;
                    NeighborInfoForNode neighborInfoForNode = x;
                    NeighborInfoForNode neighborNodeInfo = neighborInfoForNode;
                    if (!neighborNodeInfo.isInherited()) {
                        String accessorImpl0 = new StringBuilder(13).append(this.edgeAccessorName$3).append(".collectAll[").append(neighborNodeInfo.neighborNode().className()).append("]").toString();
                        EdgeType.Cardinality cardinality = neighborNodeInfo.consolidatedCardinality();
                        String accessorImpl1 = EdgeType$Cardinality$One$.MODULE$.equals(cardinality) ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(280).append("try { ").append(accessorImpl0).append(".next() } catch {\n                   |  case e: java.util.NoSuchElementException =>\n                   |    throw new overflowdb.SchemaViolationException(\"").append(this.direction$9).append(" edge with label ").append(neighborNodeInfo.edge().name()).append(" to an adjacent ").append(neighborNodeInfo.neighborNode().name()).append(" is mandatory, but not defined for this ").append(this.nodeType$5.name()).append(" node with id=\" + id, e)\n                   |}").toString())) : (EdgeType$Cardinality$ZeroOrOne$.MODULE$.equals(cardinality) ? new StringBuilder(13).append(accessorImpl0).append(".nextOption()").toString() : accessorImpl0);
                        object = new StringBuilder(9).append("def ").append(Helpers$.MODULE$.accessorName(neighborNodeInfo)).append(": ").append(neighborNodeInfo.returnType()).append(" = ").append(accessorImpl1).toString();
                    } else {
                        object = function1.apply((Object)x);
                    }
                    return object;
                }
            })).mkString(System.lineSeparator());
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(215).append("def ").append(edgeAccessorName).append(": overflowdb.traversal.Traversal[").append(neighborType).append("] = overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[").append(neighborType).append("](").append(offsetPosition).append("))\n           |override def _").append(edgeAccessorName).append(" = createAdjacentNodeIteratorByOffSet[StoredNode](").append(offsetPosition).append(")\n           |").append(nodeAccessors).append("\n           |").toString()));
        })).mkString(System.lineSeparator());
        String forKeys2 = ((IterableOnceOps)properties.map((Function1 & Serializable)p -> CodeGen.caseEntry$1(p.name(), Helpers$.MODULE$.camelCase(p.name()), p.cardinality(), Helpers$.MODULE$.typeFor(p)))).mkString(System.lineSeparator());
        String forContainedNodes2 = ((IterableOnceOps)nodeType.containedNodes().map((Function1 & Serializable)containedNode -> CodeGen.caseEntry$1(containedNode.localName(), containedNode.localName(), containedNode.cardinality(), containedNode.nodeType().className()))).mkString(System.lineSeparator());
        String updateSpecificPropertyImpl = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(255).append("override protected def updateSpecificProperty(key:String, value: Object): Unit = {\n           |  key match {\n           |  ").append(forKeys2).append("\n           |  ").append(forContainedNodes2).append("\n           |    case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)\n           |  }\n           |}").toString()));
        String forKeys3 = ((IterableOnceOps)properties.map((Function1 & Serializable)key -> new StringBuilder(24).append("|      case \"").append(key.name()).append("\" => this._").append(Helpers$.MODULE$.camelCase(key.name())).toString())).mkString(System.lineSeparator());
        String forContainedKeys = ((IterableOnceOps)nodeType.containedNodes().map((Function1 & Serializable)containedNode -> {
            String name = containedNode.localName();
            return new StringBuilder(24).append("|      case \"").append(name).append("\" => this._").append(name).toString();
        })).mkString(System.lineSeparator());
        String propertyImpl = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(163).append("override def property(key:String): Any = {\n           |  key match {\n           |    ").append(forKeys3).append("\n           |    ").append(forContainedKeys).append("\n           |    case _ => null\n           |  }\n           |}").toString()));
        String classImpl = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(1724).append("class ").append(classNameDb).append("(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode\n           |  ").append(mixinsForExtendedNodes).append(" with ").append(className).append("Base {\n           |\n           |  override def layoutInformation: NodeLayoutInformation = ").append(className).append(".layoutInformation\n           |\n           |  ").append(CodeGen.propertyBasedFields$1(className, properties)).append("\n           |\n           |  ").append(containedNodesAsMembers).append("\n           |\n           |  /** faster than the default implementation */\n           |  override def propertiesMap: java.util.Map[String, Any] =\n           |    ").append(propertiesMapImpl).append("\n           |\n           |  /** faster than the default implementation */\n           |  override def propertiesMapForStorage: java.util.Map[String, Any] =\n           |    ").append(propertiesMapForStorageImpl).append("\n           |\n           |\n           |  ").append(neighborAccessors).append("\n           |\n           |  override def label: String = {\n           |    ").append(className).append(".Label\n           |  }\n           |\n           |  override def productElementLabel(n: Int): String =\n           |    n match {\n           |      ").append(productElementLabels).append("\n           |    }\n           |\n           |  override def productElement(n: Int): Any =\n           |    n match {\n           |      ").append(productElementAccessors).append("\n           |    }\n           |\n           |  override def productPrefix = \"").append(className).append("\"\n           |  override def productArity = ").append(productElements.size()).append("\n           |\n           |  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[").append(classNameDb).append("]\n           |\n           |  ").append(propertyImpl).append("\n           |\n           |").append(updateSpecificPropertyImpl).append("\n           |\n           |  override def removeSpecificProperty(key: String): Unit =\n           |    this.updateSpecificProperty(key, null)\n           |\n           |override def _initializeFromDetached(data: overflowdb.DetachedNodeData, mapper: java.util.function.Function[overflowdb.DetachedNodeData, Node]) =\n           |    fromNewNode(data.asInstanceOf[NewNode], nn=>mapper.apply(nn).asInstanceOf[StoredNode])\n           |\n           |  ").append(fromNew).append("\n           |\n           |}").toString()));
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(55).append(staticHeader$3).append("\n         |").append(companionObject).append("\n         |").append(nodeBaseImpl).append("\n         |").append(nodeRefImpl).append("\n         |").append(classImpl).append("\n         |").toString()));
    }

    private static final String implicitForNodeType$1(String name) {
        String traversalName = new StringBuilder(15).append(name).append("TraversalExtGen").toString();
        return new StringBuilder(84).append("implicit def to").append(traversalName).append("[NodeType <: ").append(name).append("](trav: IterableOnce[NodeType]): ").append(traversalName).append("[NodeType] = new ").append(traversalName).append("(trav)").toString();
    }

    private final String nodeTraversalImplicits$lzyINIT1$1(LazyRef nodeTraversalImplicits$lzy1$1) {
        String string;
        LazyRef lazyRef = nodeTraversalImplicits$lzy1$1;
        synchronized (lazyRef) {
            Object object;
            if (nodeTraversalImplicits$lzy1$1.initialized()) {
                object = nodeTraversalImplicits$lzy1$1.value();
            } else {
                String implicitsForNodeTraversals = ((IterableOnceOps)((IterableOps)((SeqOps)this.schema.nodeTypes().map((Function1 & Serializable)_$22 -> _$22.className())).sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)name -> CodeGen.implicitForNodeType$1(name))).mkString(System.lineSeparator());
                String implicitsForNodeBaseTypeTraversals = ((IterableOnceOps)((IterableOps)((SeqOps)this.schema.nodeBaseTypes().map((Function1 & Serializable)_$23 -> _$23.className())).sorted((Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)name -> CodeGen.implicitForNodeType$1(name))).mkString(System.lineSeparator());
                object = nodeTraversalImplicits$lzy1$1.initialize((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(304).append("package ").append(this.traversalsPackage()).append("\n         |\n         |import ").append(this.nodesPackage()).append("._\n         |\n         |trait NodeTraversalImplicits extends NodeBaseTypeTraversalImplicits {\n         |  ").append(implicitsForNodeTraversals).append("\n         |}\n         |\n         |// lower priority implicits for base types\n         |trait NodeBaseTypeTraversalImplicits {\n         |  ").append(implicitsForNodeBaseTypeTraversals).append("\n         |}\n         |").toString())));
            }
            string = (String)object;
        }
        return string;
    }

    private final String nodeTraversalImplicits$1(LazyRef nodeTraversalImplicits$lzy1$2) {
        return (String)(nodeTraversalImplicits$lzy1$2.initialized() ? nodeTraversalImplicits$lzy1$2.value() : this.nodeTraversalImplicits$lzyINIT1$1(nodeTraversalImplicits$lzy1$2));
    }

    private static final String generateCustomStepNameTraversals$1$$anonfun$1$$anonfun$3$$anonfun$1() {
        return "";
    }

    private static final Seq generateCustomStepNameTraversals$1(AbstractNodeType nodeType) {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{Direction$.MODULE$.IN(), Direction$.MODULE$.OUT()})).flatMap((Function1 & Serializable)direction -> (IterableOnce)((IterableOps)nodeType.edges((Enumeration.Value)direction).sortBy((Function1 & Serializable)_$24 -> _$24.customStepName(), Ordering$.MODULE$.Option((Ordering)Ordering.String$.MODULE$))).withFilter((Function1 & Serializable)x$1 -> {
            AdjacentNode adjacentNode = x$1;
            if (adjacentNode == null) return false;
            AdjacentNode adjacentNode2 = AdjacentNode$.MODULE$.unapply(adjacentNode);
            EdgeType edgeType = adjacentNode2._1();
            AbstractNodeType abstractNodeType = adjacentNode2._2();
            EdgeType.Cardinality cardinality = adjacentNode2._3();
            Option<String> option = adjacentNode2._4();
            Option<String> option2 = adjacentNode2._5();
            EdgeType viaEdge = edgeType;
            AbstractNodeType neighbor = abstractNodeType;
            EdgeType.Cardinality cardinality2 = cardinality;
            if (!(option instanceof Some)) return false;
            String customStepName = (String)((Some)option).value();
            Option<String> customStepDoc = option2;
            return true;
        }).map((Function1 & Serializable)x$1 -> {
            String string;
            AdjacentNode adjacentNode = x$1;
            if (adjacentNode == null) throw new MatchError((Object)adjacentNode);
            AdjacentNode adjacentNode2 = AdjacentNode$.MODULE$.unapply(adjacentNode);
            EdgeType edgeType = adjacentNode2._1();
            AbstractNodeType abstractNodeType = adjacentNode2._2();
            EdgeType.Cardinality cardinality = adjacentNode2._3();
            Option<String> option = adjacentNode2._4();
            Option<String> option2 = adjacentNode2._5();
            EdgeType viaEdge = edgeType;
            AbstractNodeType neighbor = abstractNodeType;
            EdgeType.Cardinality cardinality2 = cardinality;
            if (!(option instanceof Some)) throw new MatchError((Object)adjacentNode);
            String customStepName = (String)((Some)option).value();
            Option<String> customStepDoc = option2;
            EdgeType.Cardinality cardinality3 = cardinality2;
            if (EdgeType$Cardinality$One$.MODULE$.equals(cardinality3)) {
                string = "map";
            } else {
                if (!EdgeType$Cardinality$ZeroOrOne$.MODULE$.equals(cardinality3) && !EdgeType$Cardinality$List$.MODULE$.equals(cardinality3)) throw new MatchError((Object)cardinality3);
                string = "flatMap";
            }
            String mapOrFlatMap = string;
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(137).append("/** ").append(customStepDoc.getOrElse(CodeGen::generateCustomStepNameTraversals$1$$anonfun$1$$anonfun$3$$anonfun$1)).append("\n           |  * Traverse to ").append(neighbor.name()).append(" via ").append(viaEdge.name()).append(" ").append(direction).append(" edge.\n           |  */ ").append(Helpers$.MODULE$.docAnnotationMaybe(customStepDoc)).append("\n           |def ").append(customStepName).append(": Traversal[").append(neighbor.className()).append("] =\n           |  traversal.").append(mapOrFlatMap).append("(_.").append(customStepName).append(")\n           |").toString()));
        }));
    }

    /*
     * Unable to fully structure code
     */
    private static final /* synthetic */ String generatePropertyTraversals$1$$anonfun$1(Property property) {
        block13: {
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block12: {
                                nameCamelCase = Helpers$.MODULE$.camelCase(property.name());
                                baseType = Helpers$.MODULE$.typeFor(property);
                                cardinality = property.cardinality();
                                var5_4 = cardinality;
                                if (var5_4 instanceof Property.Cardinality.One) {
                                    var6_5 = Property$Cardinality$One$.MODULE$.unapply((Property.Cardinality.One)var5_4);
                                    var7_6 = var6_5._1();
                                    v0 = "map";
                                } else if (Property$Cardinality$ZeroOrOne$.MODULE$.equals(var5_4) || Property$Cardinality$List$.MODULE$.equals(var5_4)) {
                                    v0 = "flatMap";
                                } else {
                                    throw new MatchError((Object)var5_4);
                                }
                                mapOrFlatMap = v0;
                                filterStepsForSingleString = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(2135).append("/**\n             |  * Traverse to nodes where the ").append(nameCamelCase).append(" matches the regular expression `value`\n             |  * */\n             |def ").append(nameCamelCase).append("(pattern: ").append(baseType).append("): Traversal[NodeType] = {\n             |  if(!Misc.isRegex(pattern)){\n             |    traversal.filter{node => node.").append(nameCamelCase).append(" == pattern}\n             |  } else {\n             |    overflowdb.traversal.filter.StringPropertyFilter.regexp(traversal)(_.").append(nameCamelCase).append(", pattern)\n             |  }\n             |}\n             |\n             |/**\n             |  * Traverse to nodes where the ").append(nameCamelCase).append(" matches at least one of the regular expressions in `values`\n             |  * */\n             |def ").append(nameCamelCase).append("(patterns: ").append(baseType).append("*): Traversal[NodeType] =\n             |  overflowdb.traversal.filter.StringPropertyFilter.regexpMultiple(traversal)(_.").append(nameCamelCase).append(", patterns)\n             |\n             |/**\n             |  * Traverse to nodes where ").append(nameCamelCase).append(" matches `value` exactly.\n             |  * */\n             |def ").append(nameCamelCase).append("Exact(value: ").append(baseType).append("): Traversal[NodeType] =\n             |  traversal.filter{node => node.").append(nameCamelCase).append(" == value}\n             |\n             |/**\n             |  * Traverse to nodes where ").append(nameCamelCase).append(" matches one of the elements in `values` exactly.\n             |  * */\n             |def ").append(nameCamelCase).append("Exact(values: ").append(baseType).append("*): Traversal[NodeType] = {\n             |  val vset = values.to(Set)\n             |  traversal.filter{node => vset.contains(node.").append(nameCamelCase).append(")}\n             |}\n             |\n             |/**\n             |  * Traverse to nodes where ").append(nameCamelCase).append(" does not match the regular expression `value`.\n             |  * */\n             |def ").append(nameCamelCase).append("Not(pattern: ").append(baseType).append("): Traversal[NodeType] = {\n             |  if(!Misc.isRegex(pattern)){\n             |    traversal.filter{node => node.").append(nameCamelCase).append(" != pattern}\n             |  } else {\n             |    overflowdb.traversal.filter.StringPropertyFilter.regexpNot(traversal)(_.").append(nameCamelCase).append(", pattern)\n             |  }\n             |}\n             |\n             |/**\n             |  * Traverse to nodes where ").append(nameCamelCase).append(" does not match any of the regular expressions in `values`.\n             |  * */\n             |def ").append(nameCamelCase).append("Not(patterns: ").append(baseType).append("*): Traversal[NodeType] = {\n             |    overflowdb.traversal.filter.StringPropertyFilter.regexpNotMultiple(traversal)(_.").append(nameCamelCase).append(", patterns)\n             | }\n             |").toString()));
                                filterStepsForOptionalString = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(2341).append("/**\n             |  * Traverse to nodes where the ").append(nameCamelCase).append(" matches the regular expression `value`\n             |  * */\n             |def ").append(nameCamelCase).append("(pattern: ").append(baseType).append("): Traversal[NodeType] = {\n             |  if(!Misc.isRegex(pattern)){\n             |    traversal.filter{node => node.").append(nameCamelCase).append(".isDefined && node.").append(nameCamelCase).append(".get == pattern}\n             |  } else {\n             |    overflowdb.traversal.filter.StringPropertyFilter.regexp(traversal.filter(_.").append(nameCamelCase).append(".isDefined))(_.").append(nameCamelCase).append(".get, pattern)\n             |  }\n             |}\n             |\n             |/**\n             |  * Traverse to nodes where the ").append(nameCamelCase).append(" matches at least one of the regular expressions in `values`\n             |  * */\n             |def ").append(nameCamelCase).append("(patterns: ").append(baseType).append("*): Traversal[NodeType] = {\n             |  overflowdb.traversal.filter.StringPropertyFilter.regexpMultiple(traversal.filter(_.").append(nameCamelCase).append(".isDefined))(_.").append(nameCamelCase).append(".get, patterns)\n             |}\n             |\n             |/**\n             |  * Traverse to nodes where ").append(nameCamelCase).append(" matches `value` exactly.\n             |  * */\n             |def ").append(nameCamelCase).append("Exact(value: ").append(baseType).append("): Traversal[NodeType] =\n             |  traversal.filter{node => node.").append(nameCamelCase).append(".isDefined && node.").append(nameCamelCase).append(".get == value}\n             |\n             |/**\n             |  * Traverse to nodes where ").append(nameCamelCase).append(" matches one of the elements in `values` exactly.\n             |  * */\n             |def ").append(nameCamelCase).append("Exact(values: ").append(baseType).append("*): Traversal[NodeType] = {\n             |  val vset = values.to(Set)\n             |  traversal.filter{node => node.").append(nameCamelCase).append(".isDefined && vset.contains(node.").append(nameCamelCase).append(".get)}\n             |}\n             |\n             |/**\n             |  * Traverse to nodes where ").append(nameCamelCase).append(" does not match the regular expression `value`.\n             |  * */\n             |def ").append(nameCamelCase).append("Not(pattern: ").append(baseType).append("): Traversal[NodeType] = {\n             |  if(!Misc.isRegex(pattern)){\n             |    traversal.filter{node => node.").append(nameCamelCase).append(".isEmpty || node.").append(nameCamelCase).append(".get != pattern}\n             |  } else {\n             |    overflowdb.traversal.filter.StringPropertyFilter.regexpNot(traversal.filter(_.").append(nameCamelCase).append(".isDefined))(_.").append(nameCamelCase).append(".get, pattern)\n             |  }\n             |}\n             |\n             |/**\n             |  * Traverse to nodes where ").append(nameCamelCase).append(" does not match any of the regular expressions in `values`.\n             |  * */\n             |def ").append(nameCamelCase).append("Not(patterns: ").append(baseType).append("*): Traversal[NodeType] = {\n             |  overflowdb.traversal.filter.StringPropertyFilter.regexpNotMultiple(traversal.filter(_.").append(nameCamelCase).append(".isDefined))(_.").append(nameCamelCase).append(".get, patterns)\n             | }\n             |").toString()));
                                filterStepsForSingleBoolean = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(440).append("/**\n             |  * Traverse to nodes where the ").append(nameCamelCase).append(" equals the given `value`\n             |  * */\n             |def ").append(nameCamelCase).append("(value: ").append(baseType).append("): Traversal[NodeType] =\n             |  traversal.filter{_.").append(nameCamelCase).append(" == value}\n             |\n             |/**\n             |  * Traverse to nodes where ").append(nameCamelCase).append(" is not equal to the given `value`.\n             |  * */\n             |def ").append(nameCamelCase).append("Not(value: ").append(baseType).append("): Traversal[NodeType] =\n             |  traversal.filter{_.").append(nameCamelCase).append(" != value}\n             |").toString()));
                                filterStepsForOptionalBoolean = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(509).append("/**\n             |  * Traverse to nodes where the ").append(nameCamelCase).append(" equals the given `value`\n             |  * */\n             |def ").append(nameCamelCase).append("(value: ").append(baseType).append("): Traversal[NodeType] =\n             |  traversal.filter{node => node.").append(nameCamelCase).append(".isDefined && node.").append(nameCamelCase).append(".get == value}\n             |\n             |/**\n             |  * Traverse to nodes where ").append(nameCamelCase).append(" is not equal to the given `value`.\n             |  * */\n             |def ").append(nameCamelCase).append("Not(value: ").append(baseType).append("): Traversal[NodeType] =\n             |  traversal.filter{node => !node.").append(nameCamelCase).append(".isDefined || node.").append(nameCamelCase).append(".get == value}\n             |").toString()));
                                filterStepsForSingleInt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(2023).append("/**\n             |  * Traverse to nodes where the ").append(nameCamelCase).append(" equals the given `value`\n             |  * */\n             |def ").append(nameCamelCase).append("(value: ").append(baseType).append("): Traversal[NodeType] =\n             |  traversal.filter{_.").append(nameCamelCase).append(" == value}\n             |\n             |/**\n             |  * Traverse to nodes where the ").append(nameCamelCase).append(" equals at least one of the given `values`\n             |  * */\n             |def ").append(nameCamelCase).append("(values: ").append(baseType).append("*): Traversal[NodeType] = {\n             |  val vset = values.toSet\n             |  traversal.filter{node => vset.contains(node.").append(nameCamelCase).append(")}\n             |}\n             |\n             |/**\n             |  * Traverse to nodes where the ").append(nameCamelCase).append(" is greater than the given `value`\n             |  * */\n             |def ").append(nameCamelCase).append("Gt(value: ").append(baseType).append("): Traversal[NodeType] =\n             |  traversal.filter{_.").append(nameCamelCase).append(" > value}\n             |\n             |/**\n             |  * Traverse to nodes where the ").append(nameCamelCase).append(" is greater than or equal the given `value`\n             |  * */\n             |def ").append(nameCamelCase).append("Gte(value: ").append(baseType).append("): Traversal[NodeType] =\n             |  traversal.filter{_.").append(nameCamelCase).append(" >= value}\n             |\n             |/**\n             |  * Traverse to nodes where the ").append(nameCamelCase).append(" is less than the given `value`\n             |  * */\n             |def ").append(nameCamelCase).append("Lt(value: ").append(baseType).append("): Traversal[NodeType] =\n             |  traversal.filter{_.").append(nameCamelCase).append(" < value}\n             |\n             |/**\n             |  * Traverse to nodes where the ").append(nameCamelCase).append(" is less than or equal the given `value`\n             |  * */\n             |def ").append(nameCamelCase).append("Lte(value: ").append(baseType).append("): Traversal[NodeType] =\n             |  traversal.filter{_.").append(nameCamelCase).append(" <= value}\n             |\n             |/**\n             |  * Traverse to nodes where ").append(nameCamelCase).append(" is not equal to the given `value`.\n             |  * */\n             |def ").append(nameCamelCase).append("Not(value: ").append(baseType).append("): Traversal[NodeType] =\n             |  traversal.filter{_.").append(nameCamelCase).append(" != value}\n             |\n             |/**\n             |  * Traverse to nodes where ").append(nameCamelCase).append(" is not equal to any of the given `values`.\n             |  * */\n             |def ").append(nameCamelCase).append("Not(values: ").append(baseType).append("*): Traversal[NodeType] = {\n             |  val vset = values.toSet\n             |  traversal.filter{node => !vset.contains(node.").append(nameCamelCase).append(")}\n             |}\n             |").toString()));
                                filterStepsForOptionalInt = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(2275).append("/**\n             |  * Traverse to nodes where the ").append(nameCamelCase).append(" equals the given `value`\n             |  * */\n             |def ").append(nameCamelCase).append("(value: ").append(baseType).append("): Traversal[NodeType] =\n             |  traversal.filter{node => node.").append(nameCamelCase).append(".isDefined && node.").append(nameCamelCase).append(".get == value}\n             |\n             |/**\n             |  * Traverse to nodes where the ").append(nameCamelCase).append(" equals at least one of the given `values`\n             |  * */\n             |def ").append(nameCamelCase).append("(values: ").append(baseType).append("*): Traversal[NodeType] = {\n             |  val vset = values.toSet\n             |  traversal.filter{node => node.").append(nameCamelCase).append(".isDefined && vset.contains(node.").append(nameCamelCase).append(".get)}\n             |}\n             |\n             |/**\n             |  * Traverse to nodes where the ").append(nameCamelCase).append(" is greater than the given `value`\n             |  * */\n             |def ").append(nameCamelCase).append("Gt(value: ").append(baseType).append("): Traversal[NodeType] =\n             |  traversal.filter{node => node.").append(nameCamelCase).append(".isDefined && node.").append(nameCamelCase).append(".get > value}\n             |\n             |/**\n             |  * Traverse to nodes where the ").append(nameCamelCase).append(" is greater than or equal the given `value`\n             |  * */\n             |def ").append(nameCamelCase).append("Gte(value: ").append(baseType).append("): Traversal[NodeType] =\n             |  traversal.filter{node => node.").append(nameCamelCase).append(".isDefined && node.").append(nameCamelCase).append(".get >= value}\n             |\n             |/**\n             |  * Traverse to nodes where the ").append(nameCamelCase).append(" is less than the given `value`\n             |  * */\n             |def ").append(nameCamelCase).append("Lt(value: ").append(baseType).append("): Traversal[NodeType] =\n             |  traversal.filter{node => node.").append(nameCamelCase).append(".isDefined && node.").append(nameCamelCase).append(".get < value}\n             |\n             |/**\n             |  * Traverse to nodes where the ").append(nameCamelCase).append(" is less than or equal the given `value`\n             |  * */\n             |def ").append(nameCamelCase).append("Lte(value: ").append(baseType).append("): Traversal[NodeType] =\n             |  traversal.filter{node => node.").append(nameCamelCase).append(".isDefined && node.").append(nameCamelCase).append(".get <= value}\n             |\n             |/**\n             |  * Traverse to nodes where ").append(nameCamelCase).append(" is not equal to the given `value`.\n             |  * */\n             |def ").append(nameCamelCase).append("Not(value: ").append(baseType).append("): Traversal[NodeType] =\n             |  traversal.filter{node => !node.").append(nameCamelCase).append(".isDefined || node.").append(nameCamelCase).append(".get != value}\n             |\n             |/**\n             |  * Traverse to nodes where ").append(nameCamelCase).append(" is not equal to any of the given `values`.\n             |  * */\n             |def ").append(nameCamelCase).append("Not(values: ").append(baseType).append("*): Traversal[NodeType] = {\n             |  val vset = values.toSet\n             |  traversal.filter{node => !node.").append(nameCamelCase).append(".isDefined || !vset.contains(node.").append(nameCamelCase).append(".get)}\n             |}\n             |").toString()));
                                filterStepsGenericSingle = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(1076).append("/**\n             |  * Traverse to nodes where the ").append(nameCamelCase).append(" equals the given `value`\n             |  * */\n             |def ").append(nameCamelCase).append("(value: ").append(baseType).append("): Traversal[NodeType] =\n             |  traversal.filter{_.").append(nameCamelCase).append(" == value}\n             |\n             |/**\n             |  * Traverse to nodes where the ").append(nameCamelCase).append(" equals at least one of the given `values`\n             |  * */\n             |def ").append(nameCamelCase).append("(values: ").append(baseType).append("*): Traversal[NodeType] = {\n             |  val vset = values.toSet\n             |  traversal.filter{node => !vset.contains(node.").append(nameCamelCase).append(")}\n             |}\n             |\n             |/**\n             |  * Traverse to nodes where ").append(nameCamelCase).append(" is not equal to the given `value`.\n             |  * */\n             |def ").append(nameCamelCase).append("Not(value: ").append(baseType).append("): Traversal[NodeType] =\n             |  traversal.filter{_.").append(nameCamelCase).append(" != value}\n             |\n             |/**\n             |  * Traverse to nodes where ").append(nameCamelCase).append(" is not equal to any of the given `values`.\n             |  * */\n             |def ").append(nameCamelCase).append("Not(values: ").append(baseType).append("*): Traversal[NodeType] = {\n             |  val vset = values.toSet\n             |  traversal.filter{node => !vset.contains(node.").append(nameCamelCase).append(")}\n             |}\n             |").toString()));
                                filterStepsGenericOption = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(1192).append("/**\n             |  * Traverse to nodes where the ").append(nameCamelCase).append(" equals the given `value`\n             |  * */\n             |def ").append(nameCamelCase).append("(value: ").append(baseType).append("): Traversal[NodeType] =\n             |  traversal.filter{node => node.").append(nameCamelCase).append(".isDefined && node.").append(nameCamelCase).append(".get == value}\n             |\n             |/**\n             |  * Traverse to nodes where the ").append(nameCamelCase).append(" equals at least one of the given `values`\n             |  * */\n             |def ").append(nameCamelCase).append("(values: ").append(baseType).append("*): Traversal[NodeType] = {\n             |  val vset = values.toSet\n             |  traversal.filter{node => node.").append(nameCamelCase).append(".isDefined && !vset.contains(node.").append(nameCamelCase).append(".get)}\n             |}\n             |\n             |/**\n             |  * Traverse to nodes where ").append(nameCamelCase).append(" is not equal to the given `value`.\n             |  * */\n             |def ").append(nameCamelCase).append("Not(value: ").append(baseType).append("): Traversal[NodeType] =\n             |  traversal.filter{node => !node.").append(nameCamelCase).append(".isDefined || node.").append(nameCamelCase).append(".get != value}\n             |\n             |/**\n             |  * Traverse to nodes where ").append(nameCamelCase).append(" is not equal to any of the given `values`.\n             |  * */\n             |def ").append(nameCamelCase).append("Not(values: ").append(baseType).append("*): Traversal[NodeType] = {\n             |  val vset = values.toSet\n             |  traversal.filter{node => !node.").append(nameCamelCase).append(".isDefined || !vset.contains(node.").append(nameCamelCase).append(".get)}\n             |}\n             |").toString()));
                                var17_16 = Tuple2$.MODULE$.apply((Object)cardinality, property.valueType());
                                if (var17_16 == null) ** GOTO lbl-1000
                                var18_17 = (Property.Cardinality)var17_16._1();
                                var19_18 = (Property.ValueType)var17_16._2();
                                if (!Property$Cardinality$List$.MODULE$.equals(var18_17)) break block12;
                                v1 = "";
                                break block13;
                            }
                            if (!(var18_17 instanceof Property.Cardinality.One)) break block14;
                            var20_19 = Property$Cardinality$One$.MODULE$.unapply((Property.Cardinality.One)var18_17);
                            var21_20 = var20_19._1();
                            if (!Property$ValueType$String$.MODULE$.equals(var19_18)) break block14;
                            v1 = filterStepsForSingleString;
                            break block13;
                        }
                        if (!Property$Cardinality$ZeroOrOne$.MODULE$.equals(var18_17) || !Property$ValueType$String$.MODULE$.equals(var19_18)) break block15;
                        v1 = filterStepsForOptionalString;
                        break block13;
                    }
                    if (!(var18_17 instanceof Property.Cardinality.One)) break block16;
                    var22_21 = Property$Cardinality$One$.MODULE$.unapply((Property.Cardinality.One)var18_17);
                    var23_22 = var22_21._1();
                    if (!Property$ValueType$Boolean$.MODULE$.equals(var19_18)) break block16;
                    v1 = filterStepsForSingleBoolean;
                    break block13;
                }
                if (!Property$Cardinality$ZeroOrOne$.MODULE$.equals(var18_17) || !Property$ValueType$Boolean$.MODULE$.equals(var19_18)) break block17;
                v1 = filterStepsForOptionalBoolean;
                break block13;
            }
            if (!(var18_17 instanceof Property.Cardinality.One)) ** GOTO lbl-1000
            var24_23 = Property$Cardinality$One$.MODULE$.unapply((Property.Cardinality.One)var18_17);
            var25_24 = var24_23._1();
            if (Property$ValueType$Int$.MODULE$.equals(var19_18)) {
                v1 = filterStepsForSingleInt;
            } else if (Property$Cardinality$ZeroOrOne$.MODULE$.equals(var18_17) && Property$ValueType$Int$.MODULE$.equals(var19_18)) {
                v1 = filterStepsForOptionalInt;
            } else if (var18_17 instanceof Property.Cardinality.One) {
                var26_25 = Property$Cardinality$One$.MODULE$.unapply((Property.Cardinality.One)var18_17);
                var27_26 = var26_25._1();
                v1 = filterStepsGenericSingle;
            } else if (Property$Cardinality$ZeroOrOne$.MODULE$.equals(var18_17)) {
                v1 = filterStepsGenericOption;
            } else lbl-1000:
            // 2 sources

            {
                v1 = "";
            }
        }
        filterSteps = v1;
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(128).append("/** Traverse to ").append(nameCamelCase).append(" property */\n           |def ").append(nameCamelCase).append(": Traversal[").append(baseType).append("] =\n           |  traversal.").append(mapOrFlatMap).append("(_.").append(nameCamelCase).append(")\n           |\n           |").append(filterSteps).append("\n           |").toString()));
    }

    private static final Seq generatePropertyTraversals$1(Seq properties) {
        return (Seq)properties.map(CodeGen::generatePropertyTraversals$1$$anonfun$1);
    }

    private final String generateNodeTraversalExt$1(AbstractNodeType nodeType) {
        Seq customStepNameTraversals = CodeGen.generateCustomStepNameTraversals$1(nodeType);
        Seq propertyTraversals = CodeGen.generatePropertyTraversals$1(nodeType.properties());
        String className = nodeType.className();
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(297).append("package ").append(this.traversalsPackage()).append("\n         |\n         |import overflowdb.traversal._\n         |import ").append(this.nodesPackage()).append("._\n         |\n         |/** Traversal steps for ").append(className).append(" */\n         |class ").append(className).append("TraversalExtGen[NodeType <: ").append(className).append("](val traversal: IterableOnce[NodeType]) extends AnyVal {\n         |\n         |").append(customStepNameTraversals.mkString(System.lineSeparator())).append("\n         |\n         |").append(propertyTraversals.mkString(System.lineSeparator())).append("\n         |\n         |}").toString()));
    }

    private final CodeGen$FieldDescription$3$ FieldDescription$lzyINIT1$1(LazyRef FieldDescription$lzy1$1) {
        CodeGen$FieldDescription$3$ codeGen$FieldDescription$3$;
        LazyRef lazyRef = FieldDescription$lzy1$1;
        synchronized (lazyRef) {
            codeGen$FieldDescription$3$ = (CodeGen$FieldDescription$3$)(FieldDescription$lzy1$1.initialized() ? FieldDescription$lzy1$1.value() : FieldDescription$lzy1$1.initialize((Object)new CodeGen$FieldDescription$3$(this)));
        }
        return codeGen$FieldDescription$3$;
    }

    private final CodeGen$FieldDescription$3$ FieldDescription$2(LazyRef FieldDescription$lzy1$2) {
        return (CodeGen$FieldDescription$3$)(FieldDescription$lzy1$2.initialized() ? FieldDescription$lzy1$2.value() : this.FieldDescription$lzyINIT1$1(FieldDescription$lzy1$2));
    }

    private final String generateNewNodeSource$1(NodeType nodeType, Seq properties) {
        private class Overflowdb_codegen_CodeGen$FieldDescription$1
        implements Product,
        Serializable {
            private final String name;
            private final String valueType;
            private final String fullType;
            private final Property.Cardinality cardinality;
            private final /* synthetic */ CodeGen $outer;

            public Overflowdb_codegen_CodeGen$FieldDescription$1(CodeGen $outer, String name, String valueType, String fullType, Property.Cardinality cardinality) {
                this.name = name;
                this.valueType = valueType;
                this.fullType = fullType;
                this.cardinality = cardinality;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Overflowdb_codegen_CodeGen$FieldDescription$1)) return false;
                Overflowdb_codegen_CodeGen$FieldDescription$1 var3_3 = (Overflowdb_codegen_CodeGen$FieldDescription$1)object;
                String string = this.name();
                String string2 = var3_3.name();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                String string3 = this.valueType();
                String string4 = var3_3.valueType();
                if (string3 == null) {
                    if (string4 != null) {
                        return false;
                    }
                } else if (!string3.equals(string4)) return false;
                String string5 = this.fullType();
                String string6 = var3_3.fullType();
                if (string5 == null) {
                    if (string6 != null) {
                        return false;
                    }
                } else if (!string5.equals(string6)) return false;
                Property.Cardinality cardinality = this.cardinality();
                Property.Cardinality cardinality2 = var3_3.cardinality();
                if (cardinality == null) {
                    if (cardinality2 != null) {
                        return false;
                    }
                } else if (!cardinality.equals(cardinality2)) return false;
                if (!var3_3.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Overflowdb_codegen_CodeGen$FieldDescription$1;
            }

            public int productArity() {
                return 4;
            }

            public String productPrefix() {
                return "FieldDescription";
            }

            public Object productElement(int n) {
                Object object;
                int n2 = n;
                switch (n2) {
                    case 0: {
                        object = this._1();
                        break;
                    }
                    case 1: {
                        object = this._2();
                        break;
                    }
                    case 2: {
                        object = this._3();
                        break;
                    }
                    case 3: {
                        object = this._4();
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                    }
                }
                return object;
            }

            public String productElementName(int n) {
                String string;
                int n2 = n;
                switch (n2) {
                    case 0: {
                        string = "name";
                        break;
                    }
                    case 1: {
                        string = "valueType";
                        break;
                    }
                    case 2: {
                        string = "fullType";
                        break;
                    }
                    case 3: {
                        string = "cardinality";
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                    }
                }
                return string;
            }

            public String name() {
                return this.name;
            }

            public String valueType() {
                return this.valueType;
            }

            public String fullType() {
                return this.fullType;
            }

            public Property.Cardinality cardinality() {
                return this.cardinality;
            }

            public Overflowdb_codegen_CodeGen$FieldDescription$1 copy(String name, String valueType, String fullType, Property.Cardinality cardinality) {
                return new Overflowdb_codegen_CodeGen$FieldDescription$1(this.$outer, name, valueType, fullType, cardinality);
            }

            public String copy$default$1() {
                return this.name();
            }

            public String copy$default$2() {
                return this.valueType();
            }

            public String copy$default$3() {
                return this.fullType();
            }

            public Property.Cardinality copy$default$4() {
                return this.cardinality();
            }

            public String _1() {
                return this.name();
            }

            public String _2() {
                return this.valueType();
            }

            public String _3() {
                return this.fullType();
            }

            public Property.Cardinality _4() {
                return this.cardinality();
            }

            public final /* synthetic */ CodeGen overflowdb$codegen$CodeGen$_$_$FieldDescription$$$outer() {
                return this.$outer;
            }
        }
        LazyRef lazyRef = new LazyRef();
        ArrayBuffer fieldDescriptions = ArrayBuffer$.MODULE$.empty();
        properties.foreach((Function1 & Serializable)property -> (ArrayBuffer)fieldDescriptions.$plus$eq((Object)this.FieldDescription$2(lazyRef).apply(Helpers$.MODULE$.camelCase(property.name()), Helpers$.MODULE$.typeFor(property), Helpers$.MODULE$.getCompleteType((Property<?>)property), property.cardinality())));
        nodeType.containedNodes().foreach((Function1 & Serializable)containedNode -> (ArrayBuffer)fieldDescriptions.$plus$eq((Object)this.FieldDescription$2(lazyRef).apply(containedNode.localName(), Helpers$.MODULE$.typeFor((ContainedNode)containedNode), Helpers$.MODULE$.getCompleteType((ContainedNode)containedNode), containedNode.cardinality())));
        String memberVariables = ((IterableOnceOps)((StrictOptimizedIterableOps)fieldDescriptions.reverse()).map((Function1 & Serializable)x$1 -> {
            String string;
            Overflowdb_codegen_CodeGen$FieldDescription$1 var3_3 = x$1;
            if (var3_3 == null) throw new MatchError((Object)var3_3);
            Overflowdb_codegen_CodeGen$FieldDescription$1 var4_4 = this.FieldDescription$2(lazyRef).unapply(var3_3);
            String string2 = var4_4._1();
            String string3 = var4_4._2();
            String string4 = var4_4._3();
            Property.Cardinality cardinality = var4_4._4();
            String name = string2;
            String fullType = string4;
            Property.Cardinality cardinality2 = cardinality;
            Property.Cardinality cardinality3 = cardinality2;
            if (cardinality3 instanceof Property.Cardinality.One) {
                Property.Default default_;
                Property.Cardinality.One one = Property$Cardinality$One$.MODULE$.unapply((Property.Cardinality.One)cardinality3);
                Property.Default default_2 = default_ = one._1();
                string = Helpers$.MODULE$.defaultValueImpl(default_2);
            } else if (Property$Cardinality$ZeroOrOne$.MODULE$.equals(cardinality3)) {
                string = "None";
            } else {
                if (!Property$Cardinality$List$.MODULE$.equals(cardinality3)) throw new MatchError((Object)cardinality3);
                string = "collection.immutable.ArraySeq.empty";
            }
            String defaultValue = string;
            return new StringBuilder(9).append("var ").append(name).append(": ").append(fullType).append(" = ").append(defaultValue).toString();
        })).mkString(", ");
        Seq putKeysImpl = (Seq)properties.map((Function1 & Serializable)key -> {
            String string;
            String memberName = Helpers$.MODULE$.camelCase(key.name());
            Property.Cardinality cardinality = key.cardinality();
            if (cardinality instanceof Property.Cardinality.One) {
                Property.Default default_;
                Property.Cardinality.One one = Property$Cardinality$One$.MODULE$.unapply((Property.Cardinality.One)cardinality);
                Property.Default default_2 = default_ = one._1();
                String isDefaultValueImpl = Helpers$.MODULE$.defaultValueCheckImpl(memberName, default_2);
                string = new StringBuilder(26).append("if (!(").append(isDefaultValueImpl).append(")) { res += \"").append(key.name()).append("\" -> ").append(memberName).append(" }").toString();
            } else if (Property$Cardinality$ZeroOrOne$.MODULE$.equals(cardinality)) {
                string = new StringBuilder(36).append(memberName).append(".map { value => res += \"").append(key.name()).append("\" -> value }").toString();
            } else if (Property$Cardinality$List$.MODULE$.equals(cardinality)) {
                string = new StringBuilder(44).append("if (").append(memberName).append(" != null && ").append(memberName).append(".nonEmpty) { res += \"").append(key.name()).append("\" -> ").append(memberName).append(" }").toString();
            } else {
                throw new MatchError((Object)cardinality);
            }
            return string;
        });
        Seq putRefsImpl = (Seq)nodeType.containedNodes().map((Function1 & Serializable)key -> {
            String string;
            String memberName = key.localName();
            Property.Cardinality cardinality = key.cardinality();
            if (cardinality instanceof Property.Cardinality.One) {
                Property.Default default_;
                Property.Cardinality.One one = Property$Cardinality$One$.MODULE$.unapply((Property.Cardinality.One)cardinality);
                Property.Default default_2 = default_ = one._1();
                String isDefaultValueImpl = Helpers$.MODULE$.defaultValueCheckImpl(memberName, default_2);
                string = new StringBuilder(26).append("if (!(").append(isDefaultValueImpl).append(")) { res += \"").append(memberName).append("\" -> ").append(memberName).append(" }").toString();
            } else if (Property$Cardinality$ZeroOrOne$.MODULE$.equals(cardinality)) {
                string = new StringBuilder(36).append(memberName).append(".map { value => res += \"").append(memberName).append("\" -> value }").toString();
            } else if (Property$Cardinality$List$.MODULE$.equals(cardinality)) {
                string = new StringBuilder(44).append("if (").append(memberName).append(" != null && ").append(memberName).append(".nonEmpty) { res += \"").append(memberName).append("\" -> ").append(memberName).append(" }").toString();
            } else {
                throw new MatchError((Object)cardinality);
            }
            return string;
        });
        Seq lines = (Seq)putKeysImpl.$plus$plus((IterableOnce)putRefsImpl);
        String propertiesImpl = lines.nonEmpty() ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(65).append("var res = Map[String, Any]()\n               |").append(lines.mkString(System.lineSeparator())).append("\n               |res").toString())) : "Map.empty";
        String propertiesMapImpl = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(72).append("override def properties: Map[String, Any] = {\n           |").append(propertiesImpl).append("\n           |}").toString()));
        String nodeClassName = nodeType.className();
        String mixins = ((IterableOnceOps)nodeType.extendz().map((Function1 & Serializable)baseType -> new StringBuilder(8).append("with ").append(baseType.className()).append("New").toString())).mkString(" ");
        String propertySettersImpl = ((IterableOnceOps)fieldDescriptions.map((Function1 & Serializable)x$1 -> {
            String string;
            Overflowdb_codegen_CodeGen$FieldDescription$1 var3_3 = x$1;
            if (var3_3 == null) throw new MatchError((Object)var3_3);
            Overflowdb_codegen_CodeGen$FieldDescription$1 var4_4 = this.FieldDescription$2(lazyRef).unapply(var3_3);
            String string2 = var4_4._1();
            String string3 = var4_4._2();
            String string4 = var4_4._3();
            Property.Cardinality cardinality = var4_4._4();
            String name = string2;
            String valueType = string3;
            Property.Cardinality cardinality2 = cardinality;
            Property.Cardinality cardinality3 = cardinality2;
            if (cardinality3 instanceof Property.Cardinality.One) {
                Property.Cardinality.One one = Property$Cardinality$One$.MODULE$.unapply((Property.Cardinality.One)cardinality3);
                Property.Default default_ = one._1();
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(126).append("def ").append(name).append("(value: ").append(valueType).append("): this.type = {\n                 |  this.").append(name).append(" = value\n                 |  this\n                 |}\n                 |").toString()));
                return string;
            } else if (Property$Cardinality$ZeroOrOne$.MODULE$.equals(cardinality3)) {
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(221).append("def ").append(name).append("(value: ").append(valueType).append("): this.type = {\n                 |  this.").append(name).append(" = Option(value)\n                 |  this\n                 |}\n                 |\n                 |def ").append(name).append("(value: Option[").append(valueType).append("]): this.type = ").append(name).append("(value.orNull)\n                 |").toString()));
                return string;
            } else {
                if (!Property$Cardinality$List$.MODULE$.equals(cardinality3)) throw new MatchError((Object)cardinality3);
                string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(183).append("def ").append(name).append("(value: IterableOnce[").append(valueType).append("]): this.type = {\n                 |  this.").append(name).append(" = value.iterator.to(collection.immutable.ArraySeq)\n                 |  this\n                 |}\n                 |").toString()));
            }
            return string;
        })).mkString(System.lineSeparator());
        String copyFieldsImpl = ((IterableOnceOps)fieldDescriptions.map((Function1 & Serializable)field -> {
            String memberName = field.name();
            return new StringBuilder(20).append("newInstance.").append(memberName).append(" = this.").append(memberName).toString();
        })).mkString(System.lineSeparator());
        String classNameNewNode = new StringBuilder(3).append("New").append(nodeClassName).toString();
        ArrayBuffer productElements = (ArrayBuffer)((StrictOptimizedIterableOps)fieldDescriptions.reverse()).zipWithIndex();
        String productElementAccessors = ((IterableOnceOps)productElements.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Overflowdb_codegen_CodeGen$FieldDescription$1 fieldDescription = (Overflowdb_codegen_CodeGen$FieldDescription$1)tuple2._1();
            int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
            return new StringBuilder(14).append("case ").append(index).append(" => this.").append(fieldDescription.name()).toString();
        })).mkString(System.lineSeparator());
        String productElementNames = ((IterableOnceOps)productElements.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Overflowdb_codegen_CodeGen$FieldDescription$1 fieldDescription = (Overflowdb_codegen_CodeGen$FieldDescription$1)tuple2._1();
            int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
            return new StringBuilder(11).append("case ").append(index).append(" => \"").append(fieldDescription.name()).append("\"").toString();
        })).mkString(System.lineSeparator());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(980).append("object ").append(classNameNewNode).append(" {\n         |  def apply(): ").append(classNameNewNode).append(" = new ").append(classNameNewNode).append("\n         |}\n         |\n         |class ").append(classNameNewNode).append("(").append(memberVariables).append(")\n         |  extends NewNode with ").append(nodeClassName).append("Base ").append(mixins).append(" {\n         |\n         |  type StoredType = ").append(nodeClassName).append("\n         |\n         |  override def label: String = \"").append(nodeType.name()).append("\"\n         |\n         |  override def copy: this.type = {\n         |    val newInstance = new New").append(nodeClassName).append("\n         |    ").append(copyFieldsImpl).append("\n         |    newInstance.asInstanceOf[this.type]\n         |  }\n         |\n         |  ").append(propertySettersImpl).append("\n         |\n         |  ").append(propertiesMapImpl).append("\n         |\n         |  override def productElement(n: Int): Any =\n         |    n match {\n         |      ").append(productElementAccessors).append("\n         |      case _ => null\n         |    }\n         |\n         |  override def productElementName(n: Int): String =\n         |    n match {\n         |      ").append(productElementNames).append("\n         |      case _ => \"\"\n         |    }\n         |\n         |  override def productPrefix = \"").append(classNameNewNode).append("\"\n         |  override def productArity = ").append(fieldDescriptions.size()).append("\n         |\n         |  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[").append(classNameNewNode).append("]\n         |}\n         |").toString()));
    }

    public static class ConstantContext
    implements Product,
    Serializable {
        private final String name;
        private final String source;
        private final Option documentation;

        public static ConstantContext apply(String string, String string2, Option<String> option) {
            return CodeGen$ConstantContext$.MODULE$.apply(string, string2, option);
        }

        public static ConstantContext fromProduct(Product product) {
            return CodeGen$ConstantContext$.MODULE$.fromProduct(product);
        }

        public static ConstantContext unapply(ConstantContext constantContext) {
            return CodeGen$ConstantContext$.MODULE$.unapply(constantContext);
        }

        public ConstantContext(String name, String source, Option<String> documentation) {
            this.name = name;
            this.source = source;
            this.documentation = documentation;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ConstantContext)) return false;
            ConstantContext constantContext = (ConstantContext)object;
            String string = this.name();
            String string2 = constantContext.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.source();
            String string4 = constantContext.source();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<String> option = this.documentation();
            Option<String> option2 = constantContext.documentation();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!constantContext.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ConstantContext;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "ConstantContext";
        }

        public Object productElement(int n) {
            Option<String> option;
            int n2 = n;
            switch (n2) {
                case 0: {
                    option = this._1();
                    break;
                }
                case 1: {
                    option = this._2();
                    break;
                }
                case 2: {
                    option = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return option;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "name";
                    break;
                }
                case 1: {
                    string = "source";
                    break;
                }
                case 2: {
                    string = "documentation";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public String name() {
            return this.name;
        }

        public String source() {
            return this.source;
        }

        public Option<String> documentation() {
            return this.documentation;
        }

        public ConstantContext copy(String name, String source, Option<String> documentation) {
            return new ConstantContext(name, source, documentation);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.source();
        }

        public Option<String> copy$default$3() {
            return this.documentation();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.source();
        }

        public Option<String> _3() {
            return this.documentation();
        }
    }
}

