/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.cpgloading.neo4j;

import io.shiftleft.cpgloading.ProtoToCpgBase;
import io.shiftleft.proto.cpg.Cpg;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jGraph;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class ProtoToCpg
extends ProtoToCpgBase {
    public ProtoToCpg(String dbPath) {
        super((Graph)Neo4jGraph.open((Configuration)ProtoToCpg.buildConfig(dbPath)));
    }

    private static Configuration buildConfig(String dbPath) {
        BaseConfiguration config = new BaseConfiguration();
        config.setProperty("gremlin.neo4j.directory", (Object)dbPath);
        config.setProperty("gremlin.neo4j.metaProperties", (Object)true);
        config.setProperty("gremlin.neo4j.multiProperties", (Object)true);
        return config;
    }

    public void addNodes(Cpg.CpgStruct protoCpg) {
        for (Cpg.CpgStruct.Node protoNode : protoCpg.getNodeList()) {
            Vertex node;
            if (this.elementImportCounter % 1000 == 0) {
                long millisSinceLastBatch = System.currentTimeMillis() - this.lastStart;
                this.lastStart = System.currentTimeMillis();
                System.out.println("importing node " + this.elementImportCounter + "; millis since last batch: " + millisSinceLastBatch);
            }
            if (this.elementImportCounter % 10000 == 0) {
                this.commit();
            }
            ++this.elementImportCounter;
            try {
                node = this.graph.addVertex(new Object[]{T.label, protoNode.getType().name()});
                this.keyToVertexId.put(protoNode.getKey(), node.id());
            }
            catch (IllegalArgumentException exception) {
                this.logger.warn("Failed to insert a vertex", (Throwable)exception);
                continue;
            }
            for (Cpg.CpgStruct.Node.Property property : protoNode.getPropertyList()) {
                this.addPropertyToElement((Element)node, property.getName().name(), property.getValue());
            }
        }
    }
}

